#include "USBMSD_RAMFS.h"

USBMSD_RAMFS::USBMSD_RAMFS(RAMFileSystem* ramfs, uint16_t vendor_id, uint16_t product_id, uint16_t product_release) :
    USBMSD(vendor_id, product_id, product_release)
{
  this->ramfs = ramfs;
}

int USBMSD_RAMFS::disk_read(uint8_t * data, uint64_t block, uint8_t count)
{
  return ramfs->disk_nread(data, block, count);
}

int USBMSD_RAMFS::disk_write(const uint8_t * data, uint64_t block, uint8_t count)
{
  return ramfs->disk_nwrite(data, block, count);
}

int USBMSD_RAMFS::disk_initialize() {
  return ramfs->disk_initialize();
}

uint64_t USBMSD_RAMFS::disk_sectors() {
  return ramfs->disk_sectors();
}

uint64_t USBMSD_RAMFS::disk_size() {
  return ramfs->disk_size();
}

int USBMSD_RAMFS::disk_status() {
  return ramfs->disk_status();
}


