#ifndef RAMFILESYSTEM_H
#define RAMFILESYSTEM_H

#include "mbed.h"
#include "FATFileSystem.h"
#include "sdram.h"
#include <stdint.h>

/** Creates a FAT file system in SDRAM
 *
 * @code
 * #include "mbed.h"
 * #include "RAMFileSystem.h"
 *
 * RAMFileSystem ramfs(0xA0000000, 4*1024*1024, "ram"); // 4MB of ram starting at 0xA...
 *  
 * int main() {
 *     sdram_init();
 *
 *     FILE *fp = fopen("/ram/myfile.txt", "w");
 *     fprintf(fp, "Hello World!\n");
 *     fclose(fp);
 * }
 * @endcode
 */
class RAMFileSystem : public FATFileSystem {
public:

    /** Create the File System in RAM
     *
     * @param addr Start of memory to use for file system
     * @param size Number of bytes to use for file system
     * @param name The name used to access the virtual filesystem
     */
    RAMFileSystem(uint32_t addr, uint32_t size, const char* name);
    virtual int disk_initialize();
    virtual int disk_status();
    virtual int disk_read(uint8_t * buffer, uint64_t sector);
    virtual int disk_write(const uint8_t * buffer, uint64_t sector);
    virtual int disk_sync();
    virtual uint64_t disk_sectors();

    uint64_t disk_size();
    int disk_nread(uint8_t * buffer, uint64_t sector, uint8_t count);
    int disk_nwrite(const uint8_t * buffer, uint64_t sector, uint8_t count);

protected:

    uint32_t memStart;
    uint32_t memSize;
    int status;
};

#endif

