
/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "QSPIFileSystem.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

#define DESIRED_SIZE_IN_MB  (8)

/******************************************************************************
 * Local variables
 *****************************************************************************/

QSPIFileSystem qspifs("qspi");

/******************************************************************************
 * Local functions
 *****************************************************************************/

/******************************************************************************
 * Main function
 *****************************************************************************/

int main() {

    printf("\nQSPI FS formatter\n");
    printf("Will format QSPI as %d MB file system\n", DESIRED_SIZE_IN_MB);

    int err = qspifs.format(DESIRED_SIZE_IN_MB);  
    if (err == 0) {
        printf("Successfully formatted!\n");
    } else {
        printf("Failed to format. Got error %d\n", err);
    }
}
