/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "LcdController.h"
#include "EaLcdBoard.h"
#include "MandelbDemo.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/


// Translates a 24-bit RGB color to RGB565
#define TRANSLATE24BIT_TO_RGB565(c)    ((((c) & 0x00ff0000) >> 19) |        \
                                 ((((c) & 0x0000ff00) >> 5) & 0x000007e0) | \
                                 ((((c) & 0x000000ff) << 8) & 0x0000f800))

/******************************************************************************
 * Local variables
 *****************************************************************************/

static const MandelbDemo::Coord_t missedPixels[] = {
    {124, 124, 1, 0},
    {121, 123, 4, 0},
    {123, 121, 4, 0},
    {120, 121, 6, 0},
    {121, 120, 6, 0},
    {119, 119, 8, 0},
    {116, 122, 9, 0},
    {117, 120, 9, 0},
    {120, 117, 9, 0},
    {122, 116, 9, 0},
    {116, 118, 11, 0},
    {118, 116, 11, 0},
    {114, 119, 12, 0},
    {119, 114, 12, 0},
    {115, 116, 13, 0},
    {116, 115, 13, 0},
    {113, 117, 14, 0},
    {117, 113, 14, 0},
    {114, 114, 15, 0},
    {109, 121, 16, 0},
    {112, 115, 16, 0},
    {115, 112, 16, 0},
    {121, 109, 16, 0},
    {109, 118, 17, 0},
    {110, 116, 17, 0},
    {116, 110, 17, 0},
    {118, 109, 17, 0},
    {111, 113, 18, 0},
    {112, 112, 18, 0},
    {113, 111, 18, 0},
    {109, 114, 19, 0},
    {114, 109, 19, 0},
    {110, 111, 20, 0},
    {111, 110, 20, 0},
    {106, 115, 21, 0},
    {108, 112, 21, 0},
    {112, 108, 21, 0},
    {115, 106, 21, 0},
    {104, 117, 22, 0},
    {106, 113, 22, 0},
    {109, 109, 22, 0},
    {113, 106, 22, 0},
    {117, 104, 22, 0},
    {107, 110, 23, 0},
    {110, 107, 23, 0},
    {105, 111, 24, 0},
    {111, 105, 24, 0},
    {100, 120, 25, 0},
    {102, 114, 25, 0},
    {103, 112, 25, 0},
    {106, 108, 25, 0},
    {107, 107, 25, 0},
    {108, 106, 25, 0},
    {112, 103, 25, 0},
    {114, 102, 25, 0},
    {120, 100, 25, 0},
    {104, 109, 26, 0},
    {109, 104, 26, 0},
    {99, 116, 27, 0},
    {102, 110, 27, 0},
    {105, 106, 27, 0},
    {106, 105, 27, 0},
    {110, 102, 27, 0},
    {116, 99, 27, 0},
    {103, 107, 28, 0},
    {107, 103, 28, 0},
    {99, 111, 29, 0},
    {101, 108, 29, 0},
    {108, 101, 29, 0},
    {111, 99, 29, 0},
    {97, 113, 30, 0},
    {99, 109, 30, 0},
    {102, 105, 30, 0},
    {103, 104, 30, 0},
    {104, 103, 30, 0},
    {105, 102, 30, 0},
    {109, 99, 30, 0},
    {113, 97, 30, 0},
    {100, 106, 31, 0},
    {106, 100, 31, 0},
    {98, 107, 32, 0},
    {101, 103, 32, 0},
    {102, 102, 32, 0},
    {103, 101, 32, 0},
    {107, 98, 32, 0},
    {95, 110, 33, 0},
    {99, 104, 33, 0},
    {104, 99, 33, 0},
    {110, 95, 33, 0},
    {92, 115, 34, 0},
    {95, 108, 34, 0},
    {97, 105, 34, 0},
    {105, 97, 34, 0},
    {108, 95, 34, 0},
    {115, 92, 34, 0},
    {92, 112, 35, 0},
    {95, 106, 35, 0},
    {98, 102, 35, 0},
    {99, 101, 35, 0},
    {100, 100, 35, 0},
    {101, 99, 35, 0},
    {102, 98, 35, 0},
    {106, 95, 35, 0},
    {112, 92, 35, 0},
    {89, 119, 36, 0},
    {96, 103, 36, 0},
    {103, 96, 36, 0},
    {119, 89, 36, 0},
    {94, 104, 37, 0},
    {97, 100, 37, 0},
    {98, 99, 37, 0},
    {99, 98, 37, 0},
    {100, 97, 37, 0},
    {104, 94, 37, 0},
    {90, 109, 38, 0},
    {91, 107, 38, 0},
    {95, 101, 38, 0},
    {101, 95, 38, 0},
    {107, 91, 38, 0},
    {109, 90, 38, 0},
    {91, 105, 39, 0},
    {93, 102, 39, 0},
    {96, 98, 39, 0},
    {97, 97, 39, 0},
    {98, 96, 39, 0},
    {102, 93, 39, 0},
    {105, 91, 39, 0},
    {87, 111, 40, 0},
    {91, 103, 40, 0},
    {94, 99, 40, 0},
    {99, 94, 40, 0},
    {103, 91, 40, 0},
    {111, 87, 40, 0},
    {85, 114, 41, 0},
    {92, 100, 41, 0},
    {100, 92, 41, 0},
    {114, 85, 41, 0},
    {87, 106, 42, 0},
    {88, 104, 42, 0},
    {90, 101, 42, 0},
    {93, 97, 42, 0},
    {94, 96, 42, 0},
    {95, 95, 42, 0},
    {96, 94, 42, 0},
    {97, 93, 42, 0},
    {101, 90, 42, 0},
    {104, 88, 42, 0},
    {106, 87, 42, 0},
    {85, 108, 43, 0},
    {88, 102, 43, 0},
    {91, 98, 43, 0},
    {98, 91, 43, 0},
    {102, 88, 43, 0},
    {108, 85, 43, 0},
    {89, 99, 44, 0},
    {92, 95, 44, 0},
    {93, 94, 44, 0},
    {94, 93, 44, 0},
    {95, 92, 44, 0},
    {99, 89, 44, 0},
    {87, 100, 45, 0},
    {90, 96, 45, 0},
    {96, 90, 45, 0},
    {100, 87, 45, 0},
    {81, 110, 46, 0},
    {83, 105, 46, 0},
    {84, 103, 46, 0},
    {88, 97, 46, 0},
    {97, 88, 46, 0},
    {103, 84, 46, 0},
    {105, 83, 46, 0},
    {110, 81, 46, 0},
    {84, 101, 47, 0},
    {86, 98, 47, 0},
    {89, 94, 47, 0},
    {90, 93, 47, 0},
    {91, 92, 47, 0},
    {92, 91, 47, 0},
    {93, 90, 47, 0},
    {94, 89, 47, 0},
    {98, 86, 47, 0},
    {101, 84, 47, 0},
    {78, 113, 48, 0},
    {80, 107, 48, 0},
    {84, 99, 48, 0},
    {87, 95, 48, 0},
    {95, 87, 48, 0},
    {99, 84, 48, 0},
    {107, 80, 48, 0},
    {113, 78, 48, 0},
    {76, 118, 49, 0},
    {85, 96, 49, 0},
    {88, 92, 49, 0},
    {89, 91, 49, 0},
    {90, 90, 49, 0},
    {91, 89, 49, 0},
    {92, 88, 49, 0},
    {96, 85, 49, 0},
    {118, 76, 49, 0},
    {80, 102, 50, 0},
    {83, 97, 50, 0},
    {86, 93, 50, 0},
    {93, 86, 50, 0},
    {97, 83, 50, 0},
    {102, 80, 50, 0},
    {78, 104, 51, 0},
    {80, 100, 51, 0},
    {84, 94, 51, 0},
    {88, 89, 51, 0},
    {89, 88, 51, 0},
    {94, 84, 51, 0},
    {100, 80, 51, 0},
    {104, 78, 51, 0},
    {75, 109, 52, 0},
    {80, 98, 52, 0},
    {82, 95, 52, 0},
    {85, 91, 52, 0},
    {86, 90, 52, 0},
    {90, 86, 52, 0},
    {91, 85, 52, 0},
    {95, 82, 52, 0},
    {98, 80, 52, 0},
    {109, 75, 52, 0},
    {75, 106, 53, 0},
    {80, 96, 53, 0},
    {83, 92, 53, 0},
    {92, 83, 53, 0},
    {96, 80, 53, 0},
    {106, 75, 53, 0},
    {81, 93, 54, 0},
    {84, 89, 54, 0},
    {85, 88, 54, 0},
    {86, 87, 54, 0},
    {87, 86, 54, 0},
    {88, 85, 54, 0},
    {89, 84, 54, 0},
    {93, 81, 54, 0},
    {75, 101, 55, 0},
    {76, 99, 55, 0},
    {79, 94, 55, 0},
    {82, 90, 55, 0},
    {90, 82, 55, 0},
    {94, 79, 55, 0},
    {99, 76, 55, 0},
    {101, 75, 55, 0},
    {73, 103, 56, 0},
    {76, 97, 56, 0},
    {80, 91, 56, 0},
    {84, 86, 56, 0},
    {85, 85, 56, 0},
    {86, 84, 56, 0},
    {91, 80, 56, 0},
    {97, 76, 56, 0},
    {103, 73, 56, 0},
    {69, 112, 57, 0},
    {76, 95, 57, 0},
    {78, 92, 57, 0},
    {81, 88, 57, 0},
    {82, 87, 57, 0},
    {87, 82, 57, 0},
    {88, 81, 57, 0},
    {92, 78, 57, 0},
    {95, 76, 57, 0},
    {112, 69, 57, 0},
    {70, 105, 58, 0},
    {76, 93, 58, 0},
    {79, 89, 58, 0},
    {89, 79, 58, 0},
    {93, 76, 58, 0},
    {105, 70, 58, 0},
    {68, 108, 59, 0},
    {71, 100, 59, 0},
    {72, 98, 59, 0},
    {73, 96, 59, 0},
    {77, 90, 59, 0},
    {80, 86, 59, 0},
    {81, 85, 59, 0},
    {82, 84, 59, 0},
    {83, 83, 59, 0},
    {84, 82, 59, 0},
    {85, 81, 59, 0},
    {86, 80, 59, 0},
    {90, 77, 59, 0},
    {96, 73, 59, 0},
    {98, 72, 59, 0},
    {100, 71, 59, 0},
    {108, 68, 59, 0},
    {73, 94, 60, 0},
    {75, 91, 60, 0},
    {78, 87, 60, 0},
    {87, 78, 60, 0},
    {91, 75, 60, 0},
    {94, 73, 60, 0},
    {68, 102, 61, 0},
    {76, 88, 61, 0},
    {79, 84, 61, 0},
    {80, 83, 61, 0},
    {81, 82, 61, 0},
    {82, 81, 61, 0},
    {83, 80, 61, 0},
    {84, 79, 61, 0},
    {88, 76, 61, 0},
    {102, 68, 61, 0},
    {72, 92, 62, 0},
    {74, 89, 62, 0},
    {77, 85, 62, 0},
    {85, 77, 62, 0},
    {89, 74, 62, 0},
    {92, 72, 62, 0},
    {68, 97, 63, 0},
    {69, 95, 63, 0},
    {72, 90, 63, 0},
    {75, 86, 63, 0},
    {80, 80, 63, 0},
    {86, 75, 63, 0},
    {90, 72, 63, 0},
    {95, 69, 63, 0},
    {97, 68, 63, 0},
    {61, 117, 64, 0},
    {64, 104, 64, 0},
    {66, 99, 64, 0},
    {69, 93, 64, 0},
    {73, 87, 64, 0},
    {76, 83, 64, 0},
    {77, 82, 64, 0},
    {78, 81, 64, 0},
    {81, 78, 64, 0},
    {82, 77, 64, 0},
    {83, 76, 64, 0},
    {87, 73, 64, 0},
    {93, 69, 64, 0},
    {99, 66, 64, 0},
    {104, 64, 64, 0},
    {117, 61, 64, 0},
    {69, 91, 65, 0},
    {71, 88, 65, 0},
    {74, 84, 65, 0},
    {84, 74, 65, 0},
    {88, 71, 65, 0},
    {91, 69, 65, 0},
    {60, 111, 66, 0},
    {61, 107, 66, 0},
    {63, 101, 66, 0},
    {69, 89, 66, 0},
    {72, 85, 66, 0},
    {75, 81, 66, 0},
    {76, 80, 66, 0},
    {77, 79, 66, 0},
    {78, 78, 66, 0},
    {79, 77, 66, 0},
    {80, 76, 66, 0},
    {81, 75, 66, 0},
    {85, 72, 66, 0},
    {89, 69, 66, 0},
    {101, 63, 66, 0},
    {107, 61, 66, 0},
    {111, 60, 66, 0},
    {64, 96, 67, 0},
    {65, 94, 67, 0},
    {70, 86, 67, 0},
    {73, 82, 67, 0},
    {82, 73, 67, 0},
    {86, 70, 67, 0},
    {94, 65, 67, 0},
    {96, 64, 67, 0},
    {65, 92, 68, 0},
    {68, 87, 68, 0},
    {71, 83, 68, 0},
    {75, 78, 68, 0},
    {76, 77, 68, 0},
    {77, 76, 68, 0},
    {78, 75, 68, 0},
    {83, 71, 68, 0},
    {87, 68, 68, 0},
    {92, 65, 68, 0},
    {61, 98, 69, 0},
    {65, 90, 69, 0},
    {69, 84, 69, 0},
    {72, 80, 69, 0},
    {73, 79, 69, 0},
    {79, 73, 69, 0},
    {80, 72, 69, 0},
    {84, 69, 69, 0},
    {90, 65, 69, 0},
    {98, 61, 69, 0},
    {58, 103, 70, 0},
    {65, 88, 70, 0},
    {67, 85, 70, 0},
    {70, 81, 70, 0},
    {81, 70, 70, 0},
    {85, 67, 70, 0},
    {88, 65, 70, 0},
    {103, 58, 70, 0},
    {58, 100, 71, 0},
    {65, 86, 71, 0},
    {68, 82, 71, 0},
    {71, 78, 71, 0},
    {72, 77, 71, 0},
    {73, 76, 71, 0},
    {74, 75, 71, 0},
    {75, 74, 71, 0},
    {76, 73, 71, 0},
    {77, 72, 71, 0},
    {78, 71, 71, 0},
    {82, 68, 71, 0},
    {86, 65, 71, 0},
    {100, 58, 71, 0},
    {59, 95, 72, 0},
    {60, 93, 72, 0},
    {61, 91, 72, 0},
    {62, 89, 72, 0},
    {66, 83, 72, 0},
    {69, 79, 72, 0},
    {79, 69, 72, 0},
    {83, 66, 72, 0},
    {89, 62, 72, 0},
    {91, 61, 72, 0},
    {93, 60, 72, 0},
    {95, 59, 72, 0},
    {54, 106, 73, 0},
    {64, 84, 73, 0},
    {67, 80, 73, 0},
    {71, 75, 73, 0},
    {72, 74, 73, 0},
    {73, 73, 73, 0},
    {74, 72, 73, 0},
    {75, 71, 73, 0},
    {80, 67, 73, 0},
    {84, 64, 73, 0},
    {106, 54, 73, 0},
    {56, 97, 74, 0},
    {61, 87, 74, 0},
    {65, 81, 74, 0},
    {68, 77, 74, 0},
    {69, 76, 74, 0},
    {76, 69, 74, 0},
    {77, 68, 74, 0},
    {81, 65, 74, 0},
    {87, 61, 74, 0},
    {97, 56, 74, 0},
    {51, 110, 75, 0},
    {61, 85, 75, 0},
    {63, 82, 75, 0},
    {66, 78, 75, 0},
    {78, 66, 75, 0},
    {82, 63, 75, 0},
    {85, 61, 75, 0},
    {110, 51, 75, 0},
    {56, 92, 76, 0},
    {57, 90, 76, 0},
    {58, 88, 76, 0},
    {61, 83, 76, 0},
    {64, 79, 76, 0},
    {67, 75, 76, 0},
    {68, 74, 76, 0},
    {69, 73, 76, 0},
    {70, 72, 76, 0},
    {71, 71, 76, 0},
    {72, 70, 76, 0},
    {73, 69, 76, 0},
    {74, 68, 76, 0},
    {75, 67, 76, 0},
    {79, 64, 76, 0},
    {83, 61, 76, 0},
    {88, 58, 76, 0},
    {90, 57, 76, 0},
    {92, 56, 76, 0},
    {51, 102, 77, 0},
    {52, 99, 77, 0},
    {54, 94, 77, 0},
    {58, 86, 77, 0},
    {62, 80, 77, 0},
    {65, 76, 77, 0},
    {76, 65, 77, 0},
    {80, 62, 77, 0},
    {86, 58, 77, 0},
    {94, 54, 77, 0},
    {99, 52, 77, 0},
    {102, 51, 77, 0},
    {58, 84, 78, 0},
    {60, 81, 78, 0},
    {63, 77, 78, 0},
    {67, 72, 78, 0},
    {68, 71, 78, 0},
    {69, 70, 78, 0},
    {70, 69, 78, 0},
    {71, 68, 78, 0},
    {72, 67, 78, 0},
    {77, 63, 78, 0},
    {81, 60, 78, 0},
    {84, 58, 78, 0},
    {51, 96, 79, 0},
    {61, 78, 79, 0},
    {64, 74, 79, 0},
    {65, 73, 79, 0},
    {73, 65, 79, 0},
    {74, 64, 79, 0},
    {78, 61, 79, 0},
    {96, 51, 79, 0},
    {52, 91, 80, 0},
    {53, 89, 80, 0},
    {54, 87, 80, 0},
    {57, 82, 80, 0},
    {59, 79, 80, 0},
    {62, 75, 80, 0},
    {67, 69, 80, 0},
    {68, 68, 80, 0},
    {69, 67, 80, 0},
    {75, 62, 80, 0},
    {79, 59, 80, 0},
    {82, 57, 80, 0},
    {87, 54, 80, 0},
    {89, 53, 80, 0},
    {91, 52, 80, 0},
    {44, 116, 81, 0},
    {46, 105, 81, 0},
    {54, 85, 81, 0},
    {57, 80, 81, 0},
    {60, 76, 81, 0},
    {63, 72, 81, 0},
    {64, 71, 81, 0},
    {65, 70, 81, 0},
    {70, 65, 81, 0},
    {71, 64, 81, 0},
    {72, 63, 81, 0},
    {76, 60, 81, 0},
    {80, 57, 81, 0},
    {85, 54, 81, 0},
    {105, 46, 81, 0},
    {116, 44, 81, 0},
    {49, 93, 82, 0},
    {54, 83, 82, 0},
    {58, 77, 82, 0},
    {61, 73, 82, 0},
    {73, 61, 82, 0},
    {77, 58, 82, 0},
    {83, 54, 82, 0},
    {93, 49, 82, 0},
    {46, 98, 83, 0},
    {54, 81, 83, 0},
    {56, 78, 83, 0},
    {59, 74, 83, 0},
    {63, 69, 83, 0},
    {64, 68, 83, 0},
    {65, 67, 83, 0},
    {66, 66, 83, 0},
    {67, 65, 83, 0},
    {68, 64, 83, 0},
    {69, 63, 83, 0},
    {74, 59, 83, 0},
    {78, 56, 83, 0},
    {81, 54, 83, 0},
    {98, 46, 83, 0},
    {44, 101, 84, 0},
    {46, 95, 84, 0},
    {49, 88, 84, 0},
    {50, 86, 84, 0},
    {57, 75, 84, 0},
    {60, 71, 84, 0},
    {61, 70, 84, 0},
    {70, 61, 84, 0},
    {71, 60, 84, 0},
    {75, 57, 84, 0},
    {86, 50, 84, 0},
    {88, 49, 84, 0},
    {95, 46, 84, 0},
    {101, 44, 84, 0},
    {47, 90, 85, 0},
    {50, 84, 85, 0},
    {53, 79, 85, 0},
    {55, 76, 85, 0},
    {58, 72, 85, 0},
    {63, 66, 85, 0},
    {64, 65, 85, 0},
    {65, 64, 85, 0},
    {66, 63, 85, 0},
    {72, 58, 85, 0},
    {76, 55, 85, 0},
    {79, 53, 85, 0},
    {84, 50, 85, 0},
    {90, 47, 85, 0},
    {40, 109, 86, 0},
    {50, 82, 86, 0},
    {53, 77, 86, 0},
    {56, 73, 86, 0},
    {59, 69, 86, 0},
    {60, 68, 86, 0},
    {61, 67, 86, 0},
    {67, 61, 86, 0},
    {68, 60, 86, 0},
    {69, 59, 86, 0},
    {73, 56, 86, 0},
    {77, 53, 86, 0},
    {82, 50, 86, 0},
    {109, 40, 86, 0},
    {44, 92, 87, 0},
    {50, 80, 87, 0},
    {54, 74, 87, 0},
    {57, 70, 87, 0},
    {70, 57, 87, 0},
    {74, 54, 87, 0},
    {80, 50, 87, 0},
    {92, 44, 87, 0},
    {46, 85, 88, 0},
    {50, 78, 88, 0},
    {52, 75, 88, 0},
    {55, 71, 88, 0},
    {58, 67, 88, 0},
    {59, 66, 88, 0},
    {60, 65, 88, 0},
    {61, 64, 88, 0},
    {62, 63, 88, 0},
    {63, 62, 88, 0},
    {64, 61, 88, 0},
    {65, 60, 88, 0},
    {66, 59, 88, 0},
    {67, 58, 88, 0},
    {71, 55, 88, 0},
    {75, 52, 88, 0},
    {78, 50, 88, 0},
    {85, 46, 88, 0},
    {38, 104, 89, 0},
    {40, 97, 89, 0},
    {44, 87, 89, 0},
    {46, 83, 89, 0},
    {47, 81, 89, 0},
    {53, 72, 89, 0},
    {56, 68, 89, 0},
    {68, 56, 89, 0},
    {72, 53, 89, 0},
    {81, 47, 89, 0},
    {83, 46, 89, 0},
    {87, 44, 89, 0},
    {97, 40, 89, 0},
    {104, 38, 89, 0},
    {40, 94, 90, 0},
    {42, 89, 90, 0},
    {47, 79, 90, 0},
    {49, 76, 90, 0},
    {51, 73, 90, 0},
    {54, 69, 90, 0},
    {58, 64, 90, 0},
    {59, 63, 90, 0},
    {60, 62, 90, 0},
    {61, 61, 90, 0},
    {62, 60, 90, 0},
    {63, 59, 90, 0},
    {64, 58, 90, 0},
    {69, 54, 90, 0},
    {73, 51, 90, 0},
    {76, 49, 90, 0},
    {79, 47, 90, 0},
    {89, 42, 90, 0},
    {94, 40, 90, 0},
    {37, 100, 91, 0},
    {49, 74, 91, 0},
    {52, 70, 91, 0},
    {55, 66, 91, 0},
    {56, 65, 91, 0},
    {65, 56, 91, 0},
    {66, 55, 91, 0},
    {70, 52, 91, 0},
    {74, 49, 91, 0},
    {100, 37, 91, 0},
    {39, 91, 92, 0},
    {46, 77, 92, 0},
    {50, 71, 92, 0},
    {53, 67, 92, 0},
    {59, 60, 92, 0},
    {60, 59, 92, 0},
    {67, 53, 92, 0},
    {71, 50, 92, 0},
    {77, 46, 92, 0},
    {91, 39, 92, 0},
    {40, 86, 93, 0},
    {41, 84, 93, 0},
    {42, 82, 93, 0},
    {43, 80, 93, 0},
    {46, 75, 93, 0},
    {48, 72, 93, 0},
    {51, 68, 93, 0},
    {54, 64, 93, 0},
    {55, 63, 93, 0},
    {56, 62, 93, 0},
    {57, 61, 93, 0},
    {61, 57, 93, 0},
    {62, 56, 93, 0},
    {63, 55, 93, 0},
    {64, 54, 93, 0},
    {68, 51, 93, 0},
    {72, 48, 93, 0},
    {75, 46, 93, 0},
    {80, 43, 93, 0},
    {82, 42, 93, 0},
    {84, 41, 93, 0},
    {86, 40, 93, 0},
    {43, 78, 94, 0},
    {46, 73, 94, 0},
    {49, 69, 94, 0},
    {52, 65, 94, 0},
    {65, 52, 94, 0},
    {69, 49, 94, 0},
    {73, 46, 94, 0},
    {78, 43, 94, 0},
    {34, 96, 95, 0},
    {35, 93, 95, 0},
    {37, 88, 95, 0},
    {43, 76, 95, 0},
    {47, 70, 95, 0},
    {50, 66, 95, 0},
    {54, 61, 95, 0},
    {55, 60, 95, 0},
    {56, 59, 95, 0},
    {57, 58, 95, 0},
    {58, 57, 95, 0},
    {59, 56, 95, 0},
    {60, 55, 95, 0},
    {61, 54, 95, 0},
    {66, 50, 95, 0},
    {70, 47, 95, 0},
    {76, 43, 95, 0},
    {88, 37, 95, 0},
    {93, 35, 95, 0},
    {96, 34, 95, 0},
    {43, 74, 96, 0},
    {45, 71, 96, 0},
    {48, 67, 96, 0},
    {51, 63, 96, 0},
    {52, 62, 96, 0},
    {62, 52, 96, 0},
    {63, 51, 96, 0},
    {67, 48, 96, 0},
    {71, 45, 96, 0},
    {74, 43, 96, 0},
    {29, 108, 97, 0},
    {34, 90, 97, 0},
    {37, 83, 97, 0},
    {38, 81, 97, 0},
    {39, 79, 97, 0},
    {46, 68, 97, 0},
    {49, 64, 97, 0},
    {54, 58, 97, 0},
    {55, 57, 97, 0},
    {56, 56, 97, 0},
    {57, 55, 97, 0},
    {58, 54, 97, 0},
    {64, 49, 97, 0},
    {68, 46, 97, 0},
    {79, 39, 97, 0},
    {81, 38, 97, 0},
    {83, 37, 97, 0},
    {90, 34, 97, 0},
    {108, 29, 97, 0},
    {29, 103, 98, 0},
    {30, 99, 98, 0},
    {35, 85, 98, 0},
    {39, 77, 98, 0},
    {42, 72, 98, 0},
    {44, 69, 98, 0},
    {47, 65, 98, 0},
    {50, 61, 98, 0},
    {51, 60, 98, 0},
    {52, 59, 98, 0},
    {59, 52, 98, 0},
    {60, 51, 98, 0},
    {61, 50, 98, 0},
    {65, 47, 98, 0},
    {69, 44, 98, 0},
    {72, 42, 98, 0},
    {77, 39, 98, 0},
    {85, 35, 98, 0},
    {99, 30, 98, 0},
    {103, 29, 98, 0},
    {39, 75, 99, 0},
    {42, 70, 99, 0},
    {45, 66, 99, 0},
    {48, 62, 99, 0},
    {62, 48, 99, 0},
    {66, 45, 99, 0},
    {70, 42, 99, 0},
    {75, 39, 99, 0},
    {25, 115, 100, 0},
    {32, 87, 100, 0},
    {39, 73, 100, 0},
    {43, 67, 100, 0},
    {46, 63, 100, 0},
    {50, 58, 100, 0},
    {51, 57, 100, 0},
    {52, 56, 100, 0},
    {53, 55, 100, 0},
    {54, 54, 100, 0},
    {55, 53, 100, 0},
    {56, 52, 100, 0},
    {57, 51, 100, 0},
    {58, 50, 100, 0},
    {63, 46, 100, 0},
    {67, 43, 100, 0},
    {73, 39, 100, 0},
    {87, 32, 100, 0},
    {115, 25, 100, 0},
    {29, 92, 101, 0},
    {34, 80, 101, 0},
    {35, 78, 101, 0},
    {39, 71, 101, 0},
    {41, 68, 101, 0},
    {44, 64, 101, 0},
    {47, 60, 101, 0},
    {48, 59, 101, 0},
    {59, 48, 101, 0},
    {60, 47, 101, 0},
    {64, 44, 101, 0},
    {68, 41, 101, 0},
    {71, 39, 101, 0},
    {78, 35, 101, 0},
    {80, 34, 101, 0},
    {92, 29, 101, 0},
    {27, 95, 102, 0},
    {29, 89, 102, 0},
    {32, 82, 102, 0},
    {35, 76, 102, 0},
    {42, 65, 102, 0},
    {45, 61, 102, 0},
    {50, 55, 102, 0},
    {51, 54, 102, 0},
    {52, 53, 102, 0},
    {53, 52, 102, 0},
    {54, 51, 102, 0},
    {55, 50, 102, 0},
    {61, 45, 102, 0},
    {65, 42, 102, 0},
    {76, 35, 102, 0},
    {82, 32, 102, 0},
    {89, 29, 102, 0},
    {95, 27, 102, 0},
    {30, 84, 103, 0},
    {35, 74, 103, 0},
    {38, 69, 103, 0},
    {40, 66, 103, 0},
    {43, 62, 103, 0},
    {46, 58, 103, 0},
    {47, 57, 103, 0},
    {48, 56, 103, 0},
    {56, 48, 103, 0},
    {57, 47, 103, 0},
    {58, 46, 103, 0},
    {62, 43, 103, 0},
    {66, 40, 103, 0},
    {69, 38, 103, 0},
    {74, 35, 103, 0},
    {84, 30, 103, 0},
    {35, 72, 104, 0},
    {38, 67, 104, 0},
    {41, 63, 104, 0},
    {44, 59, 104, 0},
    {59, 44, 104, 0},
    {63, 41, 104, 0},
    {67, 38, 104, 0},
    {72, 35, 104, 0},
    {23, 98, 105, 0},
    {27, 86, 105, 0},
    {31, 77, 105, 0},
    {35, 70, 105, 0},
    {39, 64, 105, 0},
    {42, 60, 105, 0},
    {46, 55, 105, 0},
    {47, 54, 105, 0},
    {48, 53, 105, 0},
    {49, 52, 105, 0},
    {50, 51, 105, 0},
    {51, 50, 105, 0},
    {52, 49, 105, 0},
    {53, 48, 105, 0},
    {54, 47, 105, 0},
    {55, 46, 105, 0},
    {60, 42, 105, 0},
    {64, 39, 105, 0},
    {70, 35, 105, 0},
    {77, 31, 105, 0},
    {86, 27, 105, 0},
    {98, 23, 105, 0},
    {28, 81, 106, 0},
    {29, 79, 106, 0},
    {31, 75, 106, 0},
    {32, 73, 106, 0},
    {35, 68, 106, 0},
    {37, 65, 106, 0},
    {40, 61, 106, 0},
    {43, 57, 106, 0},
    {44, 56, 106, 0},
    {56, 44, 106, 0},
    {57, 43, 106, 0},
    {61, 40, 106, 0},
    {65, 37, 106, 0},
    {68, 35, 106, 0},
    {73, 32, 106, 0},
    {75, 31, 106, 0},
    {79, 29, 106, 0},
    {81, 28, 106, 0},
    {20, 102, 107, 0},
    {23, 91, 107, 0},
    {32, 71, 107, 0},
    {38, 62, 107, 0},
    {41, 58, 107, 0},
    {46, 52, 107, 0},
    {47, 51, 107, 0},
    {48, 50, 107, 0},
    {49, 49, 107, 0},
    {50, 48, 107, 0},
    {51, 47, 107, 0},
    {52, 46, 107, 0},
    {58, 41, 107, 0},
    {62, 38, 107, 0},
    {71, 32, 107, 0},
    {91, 23, 107, 0},
    {102, 20, 107, 0},
    {18, 107, 108, 0},
    {23, 88, 108, 0},
    {25, 83, 108, 0},
    {32, 69, 108, 0},
    {34, 66, 108, 0},
    {36, 63, 108, 0},
    {39, 59, 108, 0},
    {42, 55, 108, 0},
    {43, 54, 108, 0},
    {44, 53, 108, 0},
    {53, 44, 108, 0},
    {54, 43, 108, 0},
    {55, 42, 108, 0},
    {59, 39, 108, 0},
    {63, 36, 108, 0},
    {66, 34, 108, 0},
    {69, 32, 108, 0},
    {83, 25, 108, 0},
    {88, 23, 108, 0},
    {107, 18, 108, 0},
    {20, 94, 109, 0},
    {34, 64, 109, 0},
    {37, 60, 109, 0},
    {40, 56, 109, 0},
    {46, 49, 109, 0},
    {47, 48, 109, 0},
    {48, 47, 109, 0},
    {49, 46, 109, 0},
    {56, 40, 109, 0},
    {60, 37, 109, 0},
    {64, 34, 109, 0},
    {94, 20, 109, 0},
    {22, 85, 110, 0},
    {25, 78, 110, 0},
    {26, 76, 110, 0},
    {27, 74, 110, 0},
    {28, 72, 110, 0},
    {31, 67, 110, 0},
    {35, 61, 110, 0},
    {38, 57, 110, 0},
    {42, 52, 110, 0},
    {43, 51, 110, 0},
    {44, 50, 110, 0},
    {50, 44, 110, 0},
    {51, 43, 110, 0},
    {52, 42, 110, 0},
    {57, 38, 110, 0},
    {61, 35, 110, 0},
    {67, 31, 110, 0},
    {72, 28, 110, 0},
    {74, 27, 110, 0},
    {76, 26, 110, 0},
    {78, 25, 110, 0},
    {85, 22, 110, 0},
    {23, 80, 111, 0},
    {28, 70, 111, 0},
    {31, 65, 111, 0},
    {33, 62, 111, 0},
    {36, 58, 111, 0},
    {39, 54, 111, 0},
    {40, 53, 111, 0},
    {53, 40, 111, 0},
    {54, 39, 111, 0},
    {58, 36, 111, 0},
    {62, 33, 111, 0},
    {65, 31, 111, 0},
    {70, 28, 111, 0},
    {80, 23, 111, 0},
    {28, 68, 112, 0},
    {34, 59, 112, 0},
    {37, 55, 112, 0},
    {41, 50, 112, 0},
    {42, 49, 112, 0},
    {43, 48, 112, 0},
    {44, 47, 112, 0},
    {45, 46, 112, 0},
    {46, 45, 112, 0},
    {47, 44, 112, 0},
    {48, 43, 112, 0},
    {49, 42, 112, 0},
    {50, 41, 112, 0},
    {55, 37, 112, 0},
    {59, 34, 112, 0},
    {68, 28, 112, 0},
    {15, 97, 113, 0},
    {20, 82, 113, 0},
    {28, 66, 113, 0},
    {30, 63, 113, 0},
    {32, 60, 113, 0},
    {35, 56, 113, 0},
    {38, 52, 113, 0},
    {39, 51, 113, 0},
    {51, 39, 113, 0},
    {52, 38, 113, 0},
    {56, 35, 113, 0},
    {60, 32, 113, 0},
    {63, 30, 113, 0},
    {66, 28, 113, 0},
    {82, 20, 113, 0},
    {97, 15, 113, 0},
    {16, 90, 114, 0},
    {17, 87, 114, 0},
    {21, 77, 114, 0},
    {22, 75, 114, 0},
    {23, 73, 114, 0},
    {24, 71, 114, 0},
    {30, 61, 114, 0},
    {33, 57, 114, 0},
    {36, 53, 114, 0},
    {41, 47, 114, 0},
    {42, 46, 114, 0},
    {43, 45, 114, 0},
    {44, 44, 114, 0},
    {45, 43, 114, 0},
    {46, 42, 114, 0},
    {47, 41, 114, 0},
    {53, 36, 114, 0},
    {57, 33, 114, 0},
    {61, 30, 114, 0},
    {71, 24, 114, 0},
    {73, 23, 114, 0},
    {75, 22, 114, 0},
    {77, 21, 114, 0},
    {87, 17, 114, 0},
    {90, 16, 114, 0},
    {17, 84, 115, 0},
    {24, 69, 115, 0},
    {27, 64, 115, 0},
    {31, 58, 115, 0},
    {34, 54, 115, 0},
    {38, 49, 115, 0},
    {39, 48, 115, 0},
    {48, 39, 115, 0},
    {49, 38, 115, 0},
    {54, 34, 115, 0},
    {58, 31, 115, 0},
    {64, 27, 115, 0},
    {69, 24, 115, 0},
    {84, 17, 115, 0},
    {11, 101, 116, 0},
    {13, 93, 116, 0},
    {18, 79, 116, 0},
    {24, 67, 116, 0},
    {27, 62, 116, 0},
    {29, 59, 116, 0},
    {32, 55, 116, 0},
    {35, 51, 116, 0},
    {36, 50, 116, 0},
    {50, 36, 116, 0},
    {51, 35, 116, 0},
    {55, 32, 116, 0},
    {59, 29, 116, 0},
    {62, 27, 116, 0},
    {67, 24, 116, 0},
    {79, 18, 116, 0},
    {93, 13, 116, 0},
    {101, 11, 116, 0},
    {24, 65, 117, 0},
    {30, 56, 117, 0},
    {33, 52, 117, 0},
    {37, 47, 117, 0},
    {38, 46, 117, 0},
    {39, 45, 117, 0},
    {40, 44, 117, 0},
    {41, 43, 117, 0},
    {42, 42, 117, 0},
    {43, 41, 117, 0},
    {44, 40, 117, 0},
    {45, 39, 117, 0},
    {46, 38, 117, 0},
    {47, 37, 117, 0},
    {52, 33, 117, 0},
    {56, 30, 117, 0},
    {65, 24, 117, 0},
    {15, 81, 118, 0},
    {18, 74, 118, 0},
    {19, 72, 118, 0},
    {20, 70, 118, 0},
    {24, 63, 118, 0},
    {26, 60, 118, 0},
    {28, 57, 118, 0},
    {31, 53, 118, 0},
    {34, 49, 118, 0},
    {35, 48, 118, 0},
    {48, 35, 118, 0},
    {49, 34, 118, 0},
    {53, 31, 118, 0},
    {57, 28, 118, 0},
    {60, 26, 118, 0},
    {63, 24, 118, 0},
    {70, 20, 118, 0},
    {72, 19, 118, 0},
    {74, 18, 118, 0},
    {81, 15, 118, 0},
    {16, 76, 119, 0},
    {20, 68, 119, 0},
    {24, 61, 119, 0},
    {26, 58, 119, 0},
    {29, 54, 119, 0},
    {32, 50, 119, 0},
    {37, 44, 119, 0},
    {38, 43, 119, 0},
    {39, 42, 119, 0},
    {40, 41, 119, 0},
    {41, 40, 119, 0},
    {42, 39, 119, 0},
    {43, 38, 119, 0},
    {44, 37, 119, 0},
    {50, 32, 119, 0},
    {54, 29, 119, 0},
    {58, 26, 119, 0},
    {61, 24, 119, 0},
    {68, 20, 119, 0},
    {76, 16, 119, 0},
    {10, 89, 120, 0},
    {11, 86, 120, 0},
    {20, 66, 120, 0},
    {27, 55, 120, 0},
    {30, 51, 120, 0},
    {33, 47, 120, 0},
    {34, 46, 120, 0},
    {35, 45, 120, 0},
    {45, 35, 120, 0},
    {46, 34, 120, 0},
    {47, 33, 120, 0},
    {51, 30, 120, 0},
    {55, 27, 120, 0},
    {66, 20, 120, 0},
    {86, 11, 120, 0},
    {89, 10, 120, 0},
    {4, 114, 121, 0},
    {5, 106, 121, 0},
    {7, 96, 121, 0},
    {11, 83, 121, 0},
    {13, 78, 121, 0},
    {20, 64, 121, 0},
    {23, 59, 121, 0},
    {25, 56, 121, 0},
    {28, 52, 121, 0},
    {31, 48, 121, 0},
    {38, 40, 121, 0},
    {39, 39, 121, 0},
    {40, 38, 121, 0},
    {48, 31, 121, 0},
    {52, 28, 121, 0},
    {56, 25, 121, 0},
    {59, 23, 121, 0},
    {64, 20, 121, 0},
    {78, 13, 121, 0},
    {83, 11, 121, 0},
    {96, 7, 121, 0},
    {106, 5, 121, 0},
    {114, 4, 121, 0},
    {15, 71, 122, 0},
    {16, 69, 122, 0},
    {20, 62, 122, 0},
    {26, 53, 122, 0},
    {29, 49, 122, 0},
    {33, 44, 122, 0},
    {34, 43, 122, 0},
    {35, 42, 122, 0},
    {36, 41, 122, 0},
    {41, 36, 122, 0},
    {42, 35, 122, 0},
    {43, 34, 122, 0},
    {44, 33, 122, 0},
    {49, 29, 122, 0},
    {53, 26, 122, 0},
    {62, 20, 122, 0},
    {69, 16, 122, 0},
    {71, 15, 122, 0},
    {6, 92, 123, 0},
    {10, 80, 123, 0},
    {13, 73, 123, 0},
    {16, 67, 123, 0},
    {17, 65, 123, 0},
    {20, 60, 123, 0},
    {22, 57, 123, 0},
    {24, 54, 123, 0},
    {27, 50, 123, 0},
    {30, 46, 123, 0},
    {31, 45, 123, 0},
    {45, 31, 123, 0},
    {46, 30, 123, 0},
    {50, 27, 123, 0},
    {54, 24, 123, 0},
    {57, 22, 123, 0},
    {60, 20, 123, 0},
    {65, 17, 123, 0},
    {67, 16, 123, 0},
    {73, 13, 123, 0},
    {80, 10, 123, 0},
    {92, 6, 123, 0},
    {11, 75, 124, 0},
    {17, 63, 124, 0},
    {20, 58, 124, 0},
    {22, 55, 124, 0},
    {25, 51, 124, 0},
    {28, 47, 124, 0},
    {33, 41, 124, 0},
    {34, 40, 124, 0},
    {35, 39, 124, 0},
    {36, 38, 124, 0},
    {37, 37, 124, 0},
    {38, 36, 124, 0},
    {39, 35, 124, 0},
    {40, 34, 124, 0},
    {41, 33, 124, 0},
    {47, 28, 124, 0},
    {51, 25, 124, 0},
    {55, 22, 124, 0},
    {58, 20, 124, 0},
    {63, 17, 124, 0},
    {75, 11, 124, 0},
    {17, 61, 125, 0},
    {23, 52, 125, 0},
    {26, 48, 125, 0},
    {29, 44, 125, 0},
    {30, 43, 125, 0},
    {31, 42, 125, 0},
    {42, 31, 125, 0},
    {43, 30, 125, 0},
    {44, 29, 125, 0},
    {48, 26, 125, 0},
    {52, 23, 125, 0},
    {61, 17, 125, 0},
    {1, 100, 126, 0},
    {5, 85, 126, 0},
    {8, 77, 126, 0},
    {17, 59, 126, 0},
    {19, 56, 126, 0},
    {21, 53, 126, 0},
    {24, 49, 126, 0},
    {27, 45, 126, 0},
    {33, 38, 126, 0},
    {34, 37, 126, 0},
    {35, 36, 126, 0},
    {36, 35, 126, 0},
    {37, 34, 126, 0},
    {38, 33, 126, 0},
    {45, 27, 126, 0},
    {49, 24, 126, 0},
    {53, 21, 126, 0},
    {56, 19, 126, 0},
    {59, 17, 126, 0},
    {77, 8, 126, 0},
    {85, 5, 126, 0},
    {100, 1, 126, 0},
    {3, 88, 127, 0},
    {5, 82, 127, 0},
    {9, 72, 127, 0},
    {10, 70, 127, 0},
    {11, 68, 127, 0},
    {12, 66, 127, 0},
    {13, 64, 127, 0},
    {19, 54, 127, 0},
    {22, 50, 127, 0},
    {25, 46, 127, 0},
    {29, 41, 127, 0},
    {30, 40, 127, 0},
    {31, 39, 127, 0},
    {39, 31, 127, 0},
    {40, 30, 127, 0},
    {41, 29, 127, 0},
    {46, 25, 127, 0},
    {50, 22, 127, 0},
    {54, 19, 127, 0},
    {64, 13, 127, 0},
    {66, 12, 127, 0},
    {68, 11, 127, 0},
    {70, 10, 127, 0},
    {72, 9, 127, 0},
    {82, 5, 127, 0},
    {88, 3, 127, 0},
    {5, 79, 128, 0},
    {13, 62, 128, 0},
    {16, 57, 128, 0},
    {20, 51, 128, 0},
    {23, 47, 128, 0},
    {26, 43, 128, 0},
    {27, 42, 128, 0},
    {42, 27, 128, 0},
    {43, 26, 128, 0},
    {47, 23, 128, 0},
    {51, 20, 128, 0},
    {57, 16, 128, 0},
    {62, 13, 128, 0},
    {79, 5, 128, 0},
    {6, 74, 129, 0},
    {13, 60, 129, 0},
    {16, 55, 129, 0},
    {18, 52, 129, 0},
    {21, 48, 129, 0},
    {24, 44, 129, 0},
    {29, 38, 129, 0},
    {30, 37, 129, 0},
    {31, 36, 129, 0},
    {32, 35, 129, 0},
    {33, 34, 129, 0},
    {34, 33, 129, 0},
    {35, 32, 129, 0},
    {36, 31, 129, 0},
    {37, 30, 129, 0},
    {38, 29, 129, 0},
    {44, 24, 129, 0},
    {48, 21, 129, 0},
    {52, 18, 129, 0},
    {55, 16, 129, 0},
    {60, 13, 129, 0},
    {74, 6, 129, 0},
    {13, 58, 130, 0},
    {19, 49, 130, 0},
    {22, 45, 130, 0},
    {25, 41, 130, 0},
    {26, 40, 130, 0},
    {27, 39, 130, 0},
    {39, 27, 130, 0},
    {40, 26, 130, 0},
    {41, 25, 130, 0},
    {45, 22, 130, 0},
    {49, 19, 130, 0},
    {58, 13, 130, 0},
    {3, 76, 131, 0},
    {6, 69, 131, 0},
    {7, 67, 131, 0},
    {8, 65, 131, 0},
    {9, 63, 131, 0},
    {13, 56, 131, 0},
    {15, 53, 131, 0},
    {17, 50, 131, 0},
    {20, 46, 131, 0},
    {23, 42, 131, 0},
    {29, 35, 131, 0},
    {30, 34, 131, 0},
    {31, 33, 131, 0},
    {32, 32, 131, 0},
    {33, 31, 131, 0},
    {34, 30, 131, 0},
    {35, 29, 131, 0},
    {42, 23, 131, 0},
    {46, 20, 131, 0},
    {50, 17, 131, 0},
    {53, 15, 131, 0},
    {56, 13, 131, 0},
    {63, 9, 131, 0},
    {65, 8, 131, 0},
    {67, 7, 131, 0},
    {69, 6, 131, 0},
    {76, 3, 131, 0},
    {0, 81, 132, 1}, //
    {4, 71, 132, 0},
    {9, 61, 132, 0},
    {15, 51, 132, 0},
    {18, 47, 132, 0},
    {21, 43, 132, 0},
    {25, 38, 132, 0},
    {26, 37, 132, 0},
    {27, 36, 132, 0},
    {36, 27, 132, 0},
    {37, 26, 132, 0},
    {38, 25, 132, 0},
    {43, 21, 132, 0},
    {47, 18, 132, 0},
    {51, 15, 132, 0},
    {61, 9, 132, 0},
    {71, 4, 132, 0},
    {81, 0, 132, 1}, //
    {9, 59, 133, 0},
    {12, 54, 133, 0},
    {16, 48, 133, 0},
    {19, 44, 133, 0},
    {22, 40, 133, 0},
    {23, 39, 133, 0},
    {39, 23, 133, 0},
    {40, 22, 133, 0},
    {44, 19, 133, 0},
    {48, 16, 133, 0},
    {54, 12, 133, 0},
    {59, 9, 133, 0},
    {1, 73, 134, 0},
    {9, 57, 134, 0},
    {12, 52, 134, 0},
    {14, 49, 134, 0},
    {17, 45, 134, 0},
    {20, 41, 134, 0},
    {24, 36, 134, 0},
    {25, 35, 134, 0},
    {26, 34, 134, 0},
    {27, 33, 134, 0},
    {28, 32, 134, 0},
    {29, 31, 134, 0},
    {31, 29, 134, 0},
    {32, 28, 134, 0},
    {33, 27, 134, 0},
    {34, 26, 134, 0},
    {35, 25, 134, 0},
    {36, 24, 134, 0},
    {41, 20, 134, 0},
    {45, 17, 134, 0},
    {49, 14, 134, 0},
    {52, 12, 134, 0},
    {57, 9, 134, 0},
    {73, 1, 134, 0},
    {3, 66, 135, 0},
    {4, 64, 135, 0},
    {5, 62, 135, 0},
    {9, 55, 135, 0},
    {15, 46, 135, 0},
    {18, 42, 135, 0},
    {21, 38, 135, 0},
    {22, 37, 135, 0},
    {37, 22, 135, 0},
    {38, 21, 135, 0},
    {42, 18, 135, 0},
    {46, 15, 135, 0},
    {55, 9, 135, 0},
    {62, 5, 135, 0},
    {64, 4, 135, 0},
    {66, 3, 135, 0},
    {1, 68, 136, 0},
    {5, 60, 136, 0},
    {9, 53, 136, 0},
    {11, 50, 136, 0},
    {13, 47, 136, 0},
    {16, 43, 136, 0},
    {19, 39, 136, 0},
    {24, 33, 136, 0},
    {25, 32, 136, 0},
    {26, 31, 136, 0},
    {27, 30, 136, 0},
    {28, 29, 136, 0},
    {29, 28, 136, 0},
    {30, 27, 136, 0},
    {31, 26, 136, 0},
    {32, 25, 136, 0},
    {33, 24, 136, 0},
    {39, 19, 136, 0},
    {43, 16, 136, 0},
    {47, 13, 136, 0},
    {50, 11, 136, 0},
    {53, 9, 136, 0},
    {60, 5, 136, 0},
    {68, 1, 136, 0},
    {5, 58, 137, 0},
    {6, 56, 137, 0},
    {11, 48, 137, 0},
    {14, 44, 137, 0},
    {17, 40, 137, 0},
    {21, 35, 137, 0},
    {22, 34, 137, 0},
    {34, 22, 137, 0},
    {35, 21, 137, 0},
    {40, 17, 137, 0},
    {44, 14, 137, 0},
    {48, 11, 137, 0},
    {56, 6, 137, 0},
    {58, 5, 137, 0},
    {8, 51, 138, 0},
    {12, 45, 138, 0},
    {15, 41, 138, 0},
    {18, 37, 138, 0},
    {19, 36, 138, 0},
    {25, 29, 138, 0},
    {26, 28, 138, 0},
    {27, 27, 138, 0},
    {28, 26, 138, 0},
    {29, 25, 138, 0},
    {36, 19, 138, 0},
    {37, 18, 138, 0},
    {41, 15, 138, 0},
    {45, 12, 138, 0},
    {51, 8, 138, 0},
    {0, 63, 139, 1}, //
    {1, 61, 139, 0},
    {5, 54, 139, 0},
    {8, 49, 139, 0},
    {10, 46, 139, 0},
    {13, 42, 139, 0},
    {16, 38, 139, 0},
    {20, 33, 139, 0},
    {21, 32, 139, 0},
    {22, 31, 139, 0},
    {23, 30, 139, 0},
    {30, 23, 139, 0},
    {31, 22, 139, 0},
    {32, 21, 139, 0},
    {33, 20, 139, 0},
    {38, 16, 139, 0},
    {42, 13, 139, 0},
    {46, 10, 139, 0},
    {49, 8, 139, 0},
    {54, 5, 139, 0},
    {61, 1, 139, 0},
    {63, 0, 139, 1}, //
    {1, 59, 140, 0},
    {2, 57, 140, 0},
    {5, 52, 140, 0},
    {11, 43, 140, 0},
    {14, 39, 140, 0},
    {17, 35, 140, 0},
    {18, 34, 140, 0},
    {34, 18, 140, 0},
    {35, 17, 140, 0},
    {39, 14, 140, 0},
    {43, 11, 140, 0},
    {52, 5, 140, 0},
    {57, 2, 140, 0},
    {59, 1, 140, 0},
    {2, 55, 141, 0},
    {5, 50, 141, 0},
    {7, 47, 141, 0},
    {9, 44, 141, 0},
    {12, 40, 141, 0},
    {15, 36, 141, 0},
    {20, 30, 141, 0},
    {21, 29, 141, 0},
    {22, 28, 141, 0},
    {23, 27, 141, 0},
    {24, 26, 141, 0},
    {25, 25, 141, 0},
    {26, 24, 141, 0},
    {27, 23, 141, 0},
    {28, 22, 141, 0},
    {29, 21, 141, 0},
    {30, 20, 141, 0},
    {36, 15, 141, 0},
    {40, 12, 141, 0},
    {44, 9, 141, 0},
    {47, 7, 141, 0},
    {50, 5, 141, 0},
    {55, 2, 141, 0},
    {2, 53, 142, 0},
    {7, 45, 142, 0},
    {10, 41, 142, 0},
    {13, 37, 142, 0},
    {17, 32, 142, 0},
    {18, 31, 142, 0},
    {31, 18, 142, 0},
    {32, 17, 142, 0},
    {37, 13, 142, 0},
    {41, 10, 142, 0},
    {45, 7, 142, 0},
    {53, 2, 142, 0},
    {2, 51, 143, 0},
    {4, 48, 143, 0},
    {8, 42, 143, 0},
    {11, 38, 143, 0},
    {14, 34, 143, 0},
    {15, 33, 143, 0},
    {20, 27, 143, 0},
    {21, 26, 143, 0},
    {22, 25, 143, 0},
    {23, 24, 143, 0},
    {24, 23, 143, 0},
    {25, 22, 143, 0},
    {26, 21, 143, 0},
    {27, 20, 143, 0},
    {33, 15, 143, 0},
    {34, 14, 143, 0},
    {38, 11, 143, 0},
    {42, 8, 143, 0},
    {48, 4, 143, 0},
    {51, 2, 143, 0},
    {4, 46, 144, 0},
    {6, 43, 144, 0},
    {9, 39, 144, 0},
    {12, 35, 144, 0},
    {16, 30, 144, 0},
    {17, 29, 144, 0},
    {18, 28, 144, 0},
    {28, 18, 144, 0},
    {29, 17, 144, 0},
    {30, 16, 144, 0},
    {35, 12, 144, 0},
    {39, 9, 144, 0},
    {43, 6, 144, 0},
    {46, 4, 144, 0},
    {1, 49, 145, 0},
    {7, 40, 145, 0},
    {10, 36, 145, 0},
    {13, 32, 145, 0},
    {14, 31, 145, 0},
    {31, 14, 145, 0},
    {32, 13, 145, 0},
    {36, 10, 145, 0},
    {40, 7, 145, 0},
    {49, 1, 145, 0},
    {1, 47, 146, 0},
    {3, 44, 146, 0},
    {5, 41, 146, 0},
    {8, 37, 146, 0},
    {11, 33, 146, 0},
    {16, 27, 146, 0},
    {17, 26, 146, 0},
    {18, 25, 146, 0},
    {19, 24, 146, 0},
    {20, 23, 146, 0},
    {21, 22, 146, 0},
    {22, 21, 146, 0},
    {23, 20, 146, 0},
    {24, 19, 146, 0},
    {25, 18, 146, 0},
    {26, 17, 146, 0},
    {27, 16, 146, 0},
    {33, 11, 146, 0},
    {37, 8, 146, 0},
    {41, 5, 146, 0},
    {44, 3, 146, 0},
    {47, 1, 146, 0},
    {1, 45, 147, 0},
    {3, 42, 147, 0},
    {6, 38, 147, 0},
    {9, 34, 147, 0},
    {13, 29, 147, 0},
    {14, 28, 147, 0},
    {28, 14, 147, 0},
    {29, 13, 147, 0},
    {34, 9, 147, 0},
    {38, 6, 147, 0},
    {42, 3, 147, 0},
    {45, 1, 147, 0},
    {4, 39, 148, 0},
    {7, 35, 148, 0},
    {10, 31, 148, 0},
    {11, 30, 148, 0},
    {16, 24, 148, 0},
    {17, 23, 148, 0},
    {18, 22, 148, 0},
    {19, 21, 148, 0},
    {20, 20, 148, 0},
    {21, 19, 148, 0},
    {22, 18, 148, 0},
    {23, 17, 148, 0},
    {24, 16, 148, 0},
    {30, 11, 148, 0},
    {31, 10, 148, 0},
    {35, 7, 148, 0},
    {39, 4, 148, 0},
    {0, 43, 149, 1}, //
    {2, 40, 149, 0},
    {5, 36, 149, 0},
    {8, 32, 149, 0},
    {12, 27, 149, 0},
    {13, 26, 149, 0},
    {14, 25, 149, 0},
    {25, 14, 149, 0},
    {26, 13, 149, 0},
    {27, 12, 149, 0},
    {32, 8, 149, 0},
    {36, 5, 149, 0},
    {40, 2, 149, 0},
    {43, 0, 149, 1}, //
    {3, 37, 150, 0},
    {6, 33, 150, 0},
    {9, 29, 150, 0},
    {10, 28, 150, 0},
    {17, 20, 150, 0},
    {18, 19, 150, 0},
    {19, 18, 150, 0},
    {20, 17, 150, 0},
    {28, 10, 150, 0},
    {29, 9, 150, 0},
    {33, 6, 150, 0},
    {37, 3, 150, 0},
    {1, 38, 151, 0},
    {4, 34, 151, 0},
    {7, 30, 151, 0},
    {12, 24, 151, 0},
    {13, 23, 151, 0},
    {14, 22, 151, 0},
    {15, 21, 151, 0},
    {21, 15, 151, 0},
    {22, 14, 151, 0},
    {23, 13, 151, 0},
    {24, 12, 151, 0},
    {30, 7, 151, 0},
    {34, 4, 151, 0},
    {38, 1, 151, 0},
    {2, 35, 152, 0},
    {5, 31, 152, 0},
    {9, 26, 152, 0},
    {10, 25, 152, 0},
    {25, 10, 152, 0},
    {26, 9, 152, 0},
    {31, 5, 152, 0},
    {35, 2, 152, 0},
    {0, 36, 153, 1}, //
    {3, 32, 153, 0},
    {6, 28, 153, 0},
    {7, 27, 153, 0},
    {12, 21, 153, 0},
    {13, 20, 153, 0},
    {14, 19, 153, 0},
    {15, 18, 153, 0},
    {16, 17, 153, 0},
    {17, 16, 153, 0},
    {18, 15, 153, 0},
    {19, 14, 153, 0},
    {20, 13, 153, 0},
    {21, 12, 153, 0},
    {27, 7, 153, 0},
    {28, 6, 153, 0},
    {32, 3, 153, 0},
    {36, 0, 153, 1}, //
    {1, 33, 154, 0},
    {4, 29, 154, 0},
    {8, 24, 154, 0},
    {9, 23, 154, 0},
    {10, 22, 154, 0},
    {22, 10, 154, 0},
    {23, 9, 154, 0},
    {24, 8, 154, 0},
    {29, 4, 154, 0},
    {33, 1, 154, 0},
    {2, 30, 155, 0},
    {5, 26, 155, 0},
    {6, 25, 155, 0},
    {12, 18, 155, 0},
    {13, 17, 155, 0},
    {14, 16, 155, 0},
    {15, 15, 155, 0},
    {16, 14, 155, 0},
    {17, 13, 155, 0},
    {18, 12, 155, 0},
    {25, 6, 155, 0},
    {26, 5, 155, 0},
    {30, 2, 155, 0},
    {0, 31, 156, 1}, //
    {3, 27, 156, 0},
    {8, 21, 156, 0},
    {9, 20, 156, 0},
    {10, 19, 156, 0},
    {19, 10, 156, 0},
    {20, 9, 156, 0},
    {21, 8, 156, 0},
    {27, 3, 156, 0},
    {31, 0, 156, 1}, //
    {1, 28, 157, 0},
    {4, 24, 157, 0},
    {5, 23, 157, 0},
    {6, 22, 157, 0},
    {22, 6, 157, 0},
    {23, 5, 157, 0},
    {24, 4, 157, 0},
    {28, 1, 157, 0},
    {2, 25, 158, 0},
    {7, 19, 158, 0},
    {8, 18, 158, 0},
    {9, 17, 158, 0},
    {10, 16, 158, 0},
    {11, 15, 158, 0},
    {12, 14, 158, 0},
    {13, 13, 158, 0},
    {14, 12, 158, 0},
    {15, 11, 158, 0},
    {16, 10, 158, 0},
    {17, 9, 158, 0},
    {18, 8, 158, 0},
    {19, 7, 158, 0},
    {25, 2, 158, 0},
    {0, 26, 159, 1}, //
    {4, 21, 159, 0},
    {5, 20, 159, 0},
    {20, 5, 159, 0},
    {21, 4, 159, 0},
    {26, 0, 159, 1}, //
    {1, 23, 160, 0},
    {2, 22, 160, 0},
    {8, 15, 160, 0},
    {9, 14, 160, 0},
    {10, 13, 160, 0},
    {11, 12, 160, 0},
    {12, 11, 160, 0},
    {13, 10, 160, 0},
    {14, 9, 160, 0},
    {15, 8, 160, 0},
    {22, 2, 160, 0},
    {23, 1, 160, 0},
    {3, 19, 161, 0},
    {4, 18, 161, 0},
    {5, 17, 161, 0},
    {6, 16, 161, 0},
    {16, 6, 161, 0},
    {17, 5, 161, 0},
    {18, 4, 161, 0},
    {19, 3, 161, 0},
    {0, 21, 162, 1}, //
    {1, 20, 162, 0},
    {9, 11, 162, 0},
    {10, 10, 162, 0},
    {11, 9, 162, 0},
    {20, 1, 162, 0},
    {21, 0, 162, 1}, //
    {3, 16, 163, 0},
    {4, 15, 163, 0},
    {5, 14, 163, 0},
    {6, 13, 163, 0},
    {7, 12, 163, 0},
    {12, 7, 163, 0},
    {13, 6, 163, 0},
    {14, 5, 163, 0},
    {15, 4, 163, 0},
    {16, 3, 163, 0},
    {0, 18, 164, 1}, //
    {1, 17, 164, 0},
    {17, 1, 164, 0},
    {18, 0, 164, 1}, //
    {3, 13, 165, 0},
    {4, 12, 165, 0},
    {5, 11, 165, 0},
    {6, 10, 165, 0},
    {7, 9, 165, 0},
    {8, 8, 165, 0},
    {9, 7, 165, 0},
    {10, 6, 165, 0},
    {11, 5, 165, 0},
    {12, 4, 165, 0},
    {13, 3, 165, 0},
    {0, 15, 166, 1}, //
    {1, 14, 166, 0},
    {14, 1, 166, 0},
    {15, 0, 166, 1}, //
    {4, 9, 167, 0},
    {5, 8, 167, 0},
    {6, 7, 167, 0},
    {7, 6, 167, 0},
    {8, 5, 167, 0},
    {9, 4, 167, 0},
    {0, 12, 168, 1}, //
    {1, 11, 168, 0},
    {2, 10, 168, 0},
    {10, 2, 168, 0},
    {11, 1, 168, 0},
    {12, 0, 168, 1}, //
    {0, 9, 170, 1}, //
    {1, 8, 170, 0},
    {2, 7, 170, 0},
    {3, 6, 170, 0},
    {4, 5, 170, 0},
    {5, 4, 170, 0},
    {6, 3, 170, 0},
    {7, 2, 170, 0},
    {8, 1, 170, 0},
    {9, 0, 170, 1}, //
    {0, 6, 172, 1}, //
    {1, 5, 172, 0},
    {2, 4, 172, 0},
    {3, 3, 172, 0},
    {4, 2, 172, 0},
    {5, 1, 172, 0},
    {6, 0, 172, 1}, //
    {0, 2, 175, 1}, //
    {1, 1, 175, 0},
    {2, 0, 175, 1} //
};


/******************************************************************************
 * External variables
 *****************************************************************************/
extern EaLcdBoard lcdBoard;
extern bool abortTest;

/******************************************************************************
 * Local functions
 *****************************************************************************/

uint32_t MandelbDemo::iterate( int32_t x, int32_t y )
{
    int i;
    
    // calculate the initial real and imaginary part of z, based on the
    // pixel location and zoom and position values
    pixel_real = 1.5 * (x - MANDEL_WIDTH / 2) / (0.5 * zoom * MANDEL_WIDTH) + moveX;
    pixel_imag = (y - MANDEL_HEIGHT / 2) / (0.5 * zoom * MANDEL_HEIGHT) + moveY;
    newReal = newImag = oldReal = oldImag = 0; //these should start at 0,0

    //start the iteration process
    for (i = 0; i < MAXITERATIONS; i++) {
        // remember value of previous iteration
        oldReal = newReal;
        oldImag = newImag;
        // the actual iteration, the real and imaginary part are calculated
        newReal = oldReal * oldReal - oldImag * oldImag + pixel_real;
        newImag = 2 * oldReal * oldImag + pixel_imag;
        // if the point is outside the circle with radius 2: stop
        if ((newReal * newReal + newImag * newImag) > 4)
            break;
    } // for (i = 0
    return i;
}

 unsigned short MandelbDemo::qsqrt(unsigned long a) const
 {
    unsigned long temp;
    long e;
    unsigned long x = 0;
    if((a & 0xffff0000) != 0)
        x = 444 + a / 26743;
    else if((a & 0xff00) != 0)
        x = 21 + a / 200;
    else
        x = 1 + a / 12;
    do{
        temp = a / x;
        e = (x - temp) / 2;
        x = (x + temp) / 2;
    }
    while(e != 0);
    return (unsigned short)x;
}

void MandelbDemo::plot4points( int32_t cx, int32_t cy, int32_t x, int32_t y, int16_t color, int32_t doMandel )
{
   int16_t x0, x1, y0, y1;
   
   y0 = cy + y;
   y1 = cy - y;
   if( doMandel )
      {
      x0 = cx + x;
      x1 = cx - x;
      if ((x0>=0) && (x0<MANDEL_WIDTH) && (y0>=0) && (y0<MANDEL_HEIGHT))
         this->pFrmBuf[(x0+115) + (this->windowX*(y0+11))] = cols[iterate(x0,y0)];
      if ((x != 0) && 
          (x1>=0) && (x1<MANDEL_WIDTH) && (y0>=0) && (y0<MANDEL_HEIGHT))
         this->pFrmBuf[(x1+115) + (this->windowX*(y0+11))] = cols[iterate(x1,y0)];
      if ((y != 0) &&
          (x0>=0) && (x0<MANDEL_WIDTH) && (y1>=0) && (y1<MANDEL_HEIGHT))
         this->pFrmBuf[(x0+115) + (this->windowX*(y1+11))] = cols[iterate(x0,y1)];
      if ((x != 0 && y != 0) &&
          (x1>=0) && (x1<MANDEL_WIDTH) && (y1>=0) && (y1<MANDEL_HEIGHT))
         this->pFrmBuf[(x1+115) + (this->windowX*(y1+11))] = cols[iterate(x1,y1)];
      }
   else
      {
      x0 = cx + x;
      x1 = cx - x;
      if ((x0>=0) && (x0<MANDEL_WIDTH) && (y0>=0) && (y0<MANDEL_HEIGHT))
         this->pFrmBuf[(x0+115) + (this->windowX*(y0+11))] = color;
      if ((x != 0) && 
          (x1>=0) && (x1<MANDEL_WIDTH) && (y0>=0) && (y0<MANDEL_HEIGHT))
         this->pFrmBuf[(x1+115) + (this->windowX*(y0+11))] = color;
      if ((y != 0) &&
          (x0>=0) && (x0<MANDEL_WIDTH) && (y1>=0) && (y1<MANDEL_HEIGHT))
         this->pFrmBuf[(x0+115) + (this->windowX*(y1+11))] = color;
      if ((x != 0 && y != 0) &&
          (x1>=0) && (x1<MANDEL_WIDTH) && (y1>=0) && (y1<MANDEL_HEIGHT))
         this->pFrmBuf[(x1+115) + (this->windowX*(y1+11))] = color;
      }
}

/******************************************************************************
 * Public functions
 *****************************************************************************/
MandelbDemo::MandelbDemo(uint8_t *pFrameBuf, uint16_t dispWidth, uint16_t dispHeight) 
    : Graphics((uint16_t *)pFrameBuf, dispWidth, dispHeight)
{
    this->windowX = dispWidth;
    this->windowY = dispHeight;
    this->pFrmBuf  = (uint16_t *)pFrameBuf;
    this->pFrmBuf1 = (uint16_t *)pFrameBuf;
    this->pFrmBuf2 = (uint16_t *)((uint32_t)pFrameBuf + dispWidth*dispHeight*2);
    this->pFrmBuf3 = (uint16_t *)((uint32_t)pFrameBuf + dispWidth*dispHeight*4);
    
    this->zoom = 1;
    this->moveX = -0.74364388;
    this->moveY = 0.13182590;
    
    // Initialise the color map to be used for displaying the Mandelbrot
    int i;
    char r, b, g;
    for (i = 0; i < MAXITERATIONS / 4; i++) {
        r/*r*/ = i * 4 + 128;
        g/*g*/ = i * 4;
        b/*b*/ = 0;
        cols[i] = TRANSLATE24BIT_TO_RGB565(b + 256 * g + 256 * 256 * r);
    }
    for (i = MAXITERATIONS / 4; i < MAXITERATIONS / 2; i++) {
        r/*r*/ = 64;
        g/*g*/ = 255;
        b/*b*/ = 4 * i;
        cols[i] = TRANSLATE24BIT_TO_RGB565(b + 256 * g + 256 * 256 * r);
    }
    for (i = MAXITERATIONS / 2; i < MAXITERATIONS * 3 / 4; i++) {
        r/*r*/ = 64;
        g/*g*/ = 255 - 4 * i;
        b/*b*/ = 255;
        cols[i] = TRANSLATE24BIT_TO_RGB565(b + 256 * g + 256 * 256 * r);
    }
    for (i = MAXITERATIONS * 3 / 4; i < MAXITERATIONS; i++) {
        r/*r*/ = 64;
        g/*g*/ = 0;
        b/*b*/ = 255 - 4 * i;
        cols[i] = TRANSLATE24BIT_TO_RGB565(b + 256 * g + 256 * 256 * r);
    }
    cols[MAXITERATIONS] = 0;
}

void MandelbDemo::run(uint32_t loops, uint32_t delayMs)
{
  printf("MandelbDemo, %d loops, %dms delay\n", loops, delayMs);
  
    //update framebuffer
    setFrameBuffer(this->pFrmBuf);
    lcdBoard.setFrameBuffer((uint32_t)this->pFrmBuf);
    memset((void*)(pFrmBuf), 0, this->windowX * this->windowY * 2);

#if 0

    for (x = 0; x < (MANDEL_WIDTH*3/2); x++) {
        put_circle(125,125, UPDATE_ZONE_COLOR, x+1, false);
    }
    for(int r = 1; r<250*3/2; r++)
    for(int x =0; x<=MANDEL_WIDTH/2; x++)
    {
        for(int y =0; y<=MANDEL_WIDTH/2; y++)
        {
            if ((this->pFrmBuf[(x+115) + (this->windowX*(y+11))] == 0) && ((int)sqrtf((125-x)*(125-x)+(125-y)*(125-y)) == r))
                printf("\n{%d, %d, %d, 0},", x,y, (int)sqrtf((125-x)*(125-x)+(125-y)*(125-y)));
        }
    }
#endif


    zoom = 1; // Start off with zoom level set to 1



        do {
#if 1       
            uint16_t idx;
            uint16_t dx,dy;
            idx = 0;
            for (int x = 0; x < (MANDEL_WIDTH*3/2); x++) {
                put_circle(125,125, 0, x+1, true);

                //handle missed pixels
                while((missedPixels[idx].rr <= x+1) && (idx<(sizeof(missedPixels)/sizeof(Coord_t))))
                {
                    dx = 125 - missedPixels[idx].xx;
                    dy = 125 - missedPixels[idx].yy;
//                    if ((125+dx)>=250) printf("\n%d dx+ %d,%d,%d", idx,missedPixels[idx].xx, missedPixels[idx].yy, missedPixels[idx].skip);
//                    if ((125+dy)>=250) printf("\n%d dy+ %d,%d,%d", idx,missedPixels[idx].xx, missedPixels[idx].yy, missedPixels[idx].skip);
                    
                    if ((125+dx)<250)
                        this->pFrmBuf[(125+dx+115) + (this->windowX*(125-dy+11))] = cols[iterate(125+dx, 125-dy)];

                    if (((125+dx)<250) && ((125+dy)<250))
                        this->pFrmBuf[(125+dx+115) + (this->windowX*(125+dy+11))] = cols[iterate(125+dx, 125+dy)];

                    if ((125+dy)<250)
                        this->pFrmBuf[(125-dx+115) + (this->windowX*(125+dy+11))] = cols[iterate(125-dx, 125+dy)];

                    this->pFrmBuf[(125-dx+115) + (this->windowX*(125-dy+11))] = cols[iterate(125-dx, 125-dy)];
                    idx++;
                }
                put_circle(125,125, UPDATE_ZONE_COLOR, x+4, false);
            }

#else
            //loop through every pixel
            for (x = 0; x < MANDEL_WIDTH; x++) {
                for (y = 0; y < MANDEL_HEIGHT; y++) {
                    // calculate the initial real and imaginary part of z, based on the
                    // pixel location and zoom and position values
                    pixel_real = 1.5 * (x - MANDEL_WIDTH / 2) / (0.5 * zoom * MANDEL_WIDTH) + moveX;
                    pixel_imag = (y - MANDEL_HEIGHT / 2) / (0.5 * zoom * MANDEL_HEIGHT) + moveY;
                    newReal = newImag = oldReal = oldImag = 0; //these should start at 0,0

                    //start the iteration process
                    for (i = 0; i < MAXITERATIONS; i++) {
                        // remember value of previous iteration
                        oldReal = newReal;
                        oldImag = newImag;
                        // the actual iteration, the real and imaginary part are calculated
                        newReal = oldReal * oldReal - oldImag * oldImag + pixel_real;
                        newImag = 2 * oldReal * oldImag + pixel_imag;
                        // if the point is outside the circle with radius 2: stop
                        if ((newReal * newReal + newImag * newImag) > 4)
                            break;
                    } // for (i = 0

                    // Get color mapping for this pixel
                    color = cols[i];

                    // Store pixel into line buffer
this->pFrmBuf[(x+115) + (this->windowX*(y+11))] = color;
                } // for (y = 0
            } // for (x = 0.....
#endif

            // Zoom in
            zoom = zoom * 2;
            
            if (abortTest) {
                return;
            }            

        } while (zoom < 65536);


#if 0



        do {
            uint16_t idx;
            uint16_t dx,dy;
            idx = 0;
            for (int x = 0; x < 45; x++) {
                put_circle(125,125, 0, x+1, true);

                //handle missed pixels
                while((missedPixels[idx].rr <= x+1) && (idx<(sizeof(missedPixels)/sizeof(Coord_t))))
                {
                    dx = 125 - missedPixels[idx].xx;
                    dy = 125 - missedPixels[idx].yy;
                    
                    this->pFrmBuf[(125+dx+115) + (this->windowX*(125-dy+11))] = cols[iterate(125+dx, 125-dy)];
                    this->pFrmBuf[(125+dx+115) + (this->windowX*(125+dy+11))] = cols[iterate(125+dx, 125+dy)];
                    this->pFrmBuf[(125-dx+115) + (this->windowX*(125+dy+11))] = cols[iterate(125-dx, 125+dy)];
                    this->pFrmBuf[(125-dx+115) + (this->windowX*(125-dy+11))] = cols[iterate(125-dx, 125-dy)];
                    idx++;
                }
//                put_circle(125,125, UPDATE_ZONE_COLOR, x+4, false);
            }

            // Zoom in
            zoom = zoom * 1.05;

        } while (zoom < 65536*1.1*1.1);
#endif


   wait_ms(1000);
   memset((void*)(pFrmBuf), 0, this->windowX * this->windowY * 2);
}

