
#ifndef MANDELBDEMO_H
#define MANDELBDEMO_H

#include "Graphics.h"
#include "GFXFb.h"

class MandelbDemo : public Graphics {
public:

    typedef struct
    {
        uint8_t xx;
        uint8_t yy;
        uint8_t rr;
        uint8_t skip;
    } Coord_t;
    
    /** Set the address of the frame buffer to use.
     *
     *  It is the content of the frame buffer that is shown on the
     *  display. All the drawing on the frame buffer can be done
     *  'offline' and whenever it should be shown this function
     *  can be called with the address of the offline frame buffer.
     *
     *  @param pFrameBuf  Pointer to the frame buffer, which must be
     *                    3 times as big as the frame size (for tripple
     *                    buffering).
     *         dispWidth  The width of the display (in pixels).
     *         dispHeight The height of the display (in pixels).
     *         loops      Number of loops in the demo code.
     *         delayMs    Delay in milliseconds between schreen updates.
     *
     *  @returns
     *       none
     */
    MandelbDemo(uint8_t *pFrameBuf, uint16_t dispWidth, uint16_t dispHeight);
    
    void run(uint32_t loops, uint32_t delayMs);

protected:
    virtual void plot4points( int32_t cx, int32_t cy, int32_t x, int32_t y, int16_t color, int32_t doMandel );
    
private:

    enum Constants {
        UPDATE_ZONE_COLOR  = 0x39e7, //DARK_GRAY

        // Width and Height of Mandelbrot (which will be a square)
        MANDEL_WIDTH    = 250,
        MANDEL_HEIGHT   = MANDEL_WIDTH,
        
        // Number of iterations before the Mandelbrot function stops
        MAXITERATIONS  = 256
    };
    
    int32_t windowX;
    int32_t windowY;
    uint16_t *pFrmBuf;
    uint16_t *pFrmBuf1;
    uint16_t *pFrmBuf2;
    uint16_t *pFrmBuf3;
    
    //Graphics graphics;

    // Color mapping array
    uint16_t cols[MAXITERATIONS + 1];
    
    // Color of pixel to be plotted
    uint32_t color;

    // real and imaginary part of the pixel p
    float pixel_real;
    float pixel_imag;

    //real and imaginary parts of new and old z
    float newReal;
    float newImag;
    float oldReal;
    float oldImag;

    // Zoom and position within image
    float zoom;
    float moveX;
    float moveY;

    // For loop counters
//    int x;
//    int y;

    uint32_t iterate( int32_t x, int32_t y );
 
    unsigned short qsqrt(unsigned long a) const;
};

#endif /* MANDELBDEMO_H */

