
#ifndef CUBEDEMO_H
#define CUBEDEMO_H

#include "Graphics.h"
#include "GFXFb.h"

class CubeDemo {
public:

    /** Set the address of the frame buffer to use.
     *
     *  It is the content of the frame buffer that is shown on the
     *  display. All the drawing on the frame buffer can be done
     *  'offline' and whenever it should be shown this function
     *  can be called with the address of the offline frame buffer.
     *
     *  @param pFrameBuf  Pointer to the frame buffer, which must be
     *                    3 times as big as the frame size (for tripple
     *                    buffering).
     *         dispWidth  The width of the display (in pixels).
     *         dispHeight The height of the display (in pixels).
     *         loops      Number of loops in the demo code.
     *         delayMs    Delay in milliseconds between schreen updates.
     *
     *  @returns
     *       none
     */
    CubeDemo(uint8_t *pFrameBuf, uint16_t dispWidth, uint16_t dispHeight);
    ~CubeDemo();
    
    void run(uint32_t loops, uint32_t delayMs);


private:
    enum Constants {
        BACKGROUND_COLOR = BLACK,
        SMALL_CIRCLE_FRONT_COLOR = WHITE,

        LENS     = 256,
        X_OFFSET = 240, //120,
        Y_OFFSET = 130
    };

    typedef struct
    {
        uint32_t  w;
        uint32_t  h;
        void *pixels;
    } Surface_t;

    typedef struct
    {
        int x;
        int y;
    } Coord2D_t;

    typedef struct 
    { 
      int32_t x;  //normal 3d coords 
      int32_t y;
      int32_t z; 
      int32_t xr; //rotated coords
      int32_t yr;
      int32_t zr;
      int32_t scrx; //translated and projected 3d points
      int32_t scry;
    } tPoint3d; 
    
    typedef struct 
    {
      int32_t p1;  //vertex
      int32_t p2;
      int32_t p3;
      int32_t u1;  //texture coords
      int32_t v1;
      int32_t u2;
      int32_t v2;
      int32_t u3;
      int32_t v3;  
    } tPoly;
    
    typedef struct 
    {
      int32_t x;
      int32_t y;
      int32_t z;
    } tVector;
    
    int32_t windowX;
    int32_t windowY;
    uint16_t *pFrmBuf;
    uint16_t *pFrmBuf1;
    uint16_t *pFrmBuf2;
    uint16_t *pFrmBuf3;
    
    Graphics graphics;
    
    Surface_t sourcePicture1;
    Surface_t sourcePicture2;
    Surface_t activeFrame;

    int32_t rx;
    int32_t ry;
    int32_t rx_;
    int32_t ry_;
    uint8_t mode;

    tPoint3d cubeModel[8];
    tPoly    cubePoly[12];

    uint32_t camX;
    uint32_t camY;
    uint32_t camZ;
    
    void plot4points( int32_t cx, int32_t cy, int32_t x, int32_t y, int16_t color, int32_t Filled );
    void plot8points( int32_t cx, int32_t cy, int32_t x, int32_t y, int16_t color, int32_t Filled );
    void put_circle( int32_t cx, int32_t cy, int16_t color, int32_t radius, int32_t Filled );
    int32_t swim_abs(int32_t v1);
    void put_line(int32_t x1, int32_t y1, int32_t x2, int32_t y2, int16_t color);
    
    int32_t sgn(int32_t val) const;
    short icosine(short x) const;
    short isine(short x) const;
    short _cos(short y) const;
    short _sin(short y) const;

    void TriangleProjectFast(Surface_t *SrcRP_p, Surface_t *DstRP_p, Coord2D_t *SrcCoords_p,  Coord2D_t *DstCoords_p);
    void CpPixel16Fast(int xSrc, int ySrc, int x, int y, Surface_t *SrcRP_p, Surface_t *DstRP_p);

    void drawCubeZ(Surface_t *pSourcePicture, uint8_t shades);
    void rotateAndProject(uint16_t rotX, uint16_t rotY, uint16_t rotZ);
    void createCubeModel(uint32_t radius);

    unsigned decodePNG(const unsigned char* pIn, size_t insize, Surface_t* pOut);


    void initialize();
    void render(uint32_t idx);
};


#endif /* CUBEDEMO_H */

