
#include "mbed.h"
#include "Image.h"

#include "bmp.h"
#include "lodepng.h"

int Image::decode(const unsigned char* pDataIn, unsigned int sizeIn, ImageData_t* pDataOut)
{
  Image::Type type = imageType(pDataIn, sizeIn);
  int result = -1;
  switch (type)
  {
    case BMP:
    {
      struct BMPHeader* hdr = (struct BMPHeader *) pDataIn;
      pDataOut->pixels = (uint16_t*)malloc(hdr->width * hdr->height * 2);
      if (pDataOut->pixels != NULL)
      {
        unsigned char error = BMP_Decode((void*)pDataIn, (unsigned char*)pDataOut->pixels, hdr->width, hdr->height, 24);
        if (error == 0)
        {
          pDataOut->width = hdr->width;
          pDataOut->height = hdr->height;
          return 0;
        }
        free(pDataOut->pixels);
      }
    }
    break;
      
    case PNG:
    {
      unsigned char* pTmp;
      unsigned error = lodepng_decode24(&pTmp, &pDataOut->width, &pDataOut->height, pDataIn, sizeIn);
      if (error == 0)
      {
        int x, y;
        uint16_t* pConverted;
        uint8_t r;
        uint8_t g;
        uint8_t b;
        int off = 0;
    
        pDataOut->pixels = (uint16_t*)malloc(pDataOut->width * pDataOut->height * 2);
        if (pDataOut->pixels != NULL)
        {
            pConverted = pDataOut->pixels;
        
            for (y = 0; y < pDataOut->height; y++) {
              for (x = 0; x < pDataOut->width; x++) {
                r = pTmp[off    ];
                g = pTmp[off + 1];
                b = pTmp[off + 2];
                *pConverted = (((unsigned short)r & 0xF8) << 8) |
                               (((unsigned short)g & 0xFC) << 3) |
                               (((unsigned short)b & 0xF8) >> 3);
                pConverted++;
                off += 3;
              }
            }
        }
        free(pTmp);
        return 0;
      }
    }
    break;
    
    default:
      break;
  }
  
  pDataOut->pixels = NULL;
  pDataOut->width = 0;
  pDataOut->height = 0;
  return result;
}

Image::Type Image::imageType(const unsigned char* pDataIn, unsigned int sizeIn)
{
  if (sizeIn > 4)
  {
    if (pDataIn[0] == 0x89 && pDataIn[1] == 'P' && pDataIn[2] == 'N' && pDataIn[3] == 'G')
    {
      return PNG;
    }
  }
  if (BMP_IsValid((void*)pDataIn))
  {
    return BMP;
  }
  return UNKNOWN;
}


