#include "mbed.h"
#include "EM027BS013.h"
#include "image_data.h"

/* The following macros makes it easier to specify all the 12 arguments to the
 * EM027BS013 constructor:
 */
 
/*
 * LPC4088QSB_SEC
 * --------------
 * Embedded Artists' LPC4088 QuickStart Board + LPC4088 QSB Base Board. 
 * The display module should be connected using the 14-pos serial expansion
 * connector on the base board.
 */
#define LPC4088QSB_SEC   p13,p11,p12,p14,p10,p9,p20,p19,p37,p38,p17,p18

/*
 * LPC4088QSB_ARDUINO
 * ------------------
 * Embedded Artists' LPC4088 QuickStart Board + LPC4088 QSB Base Board. 
 * The display module should be connected with jumper cables between the
 * Arduino pinlist on the base board and the 14-pos connector (J3) on the
 * display module like this:
 *
 * Arduino    Display
 *   
 *   GND        J3-1
 *   AREF       J3-2
 *   D13        J3-3
 *   D11        J3-4
 *   D12        J3-5
 *   D10        J3-6
 *   D0         J3-7
 *   D1         J3-8
 *   SCL        J3-9
 *   SDA        J3-10
 *   D9         J3-11
 *   D6         J3-12
 *   D7         J3-13
 *   D8         J3-14
 */
#define LPC4088QSB_ARDUINO   D13,D11,D12,D10,D0,D1,P1_31,P1_30,D9,D6,D7,D8

/*
 * LPC11U68_ARDUINO
 * ----------------
 * Connections for the LPCXpresso11U68 board. 
 * The display module should be connected with jumper cables between the
 * Arduino pinlist on the LPCXpresso board and the 14-pos connector (J3) on the
 * display module like this:
 *
 * Arduino    Display
 *   
 *   GND        J3-1
 *   AREF       J3-2
 *   D13        J3-3
 *   D11        J3-4
 *   D12        J3-5
 *   D10        J3-6
 *   D0         J3-7
 *   D1         J3-8
 *   SCL        J3-9
 *   SDA        J3-10
 *   D9         J3-11
 *   D6         J3-12
 *   D7         J3-13
 *   D8         J3-14
 */
#define LPC11U68_ARDUINO   D13,D11,D12,D10,D0,D1,SCL,SDA,D9,D6,D7,D8

/*
 * LPC1549_ARDUINO
 * ---------------
 * Connections for the LPCXpresso1549 board. 
 * The display module should be connected with jumper cables between the
 * Arduino pinlist on the LPCXpresso board and the 14-pos connector (J3) on the
 * display module like this:
 *
 * Arduino    Display
 *   
 *   GND        J3-1
 *   AREF       J3-2
 *   D13        J3-3
 *   D11        J3-4
 *   D12        J3-5
 *   D10        J3-6
 *   D0         J3-7
 *   D1         J3-8
 *   SCL        J3-9
 *   SDA        J3-10
 *   D9         J3-11
 *   D6         J3-12
 *   D7         J3-13
 *   D8         J3-14
 */
#define LPC1549_ARDUINO   D13,D11,D12,D10,D0,D1,SCL,SDA,D9,D6,D7,D8

/*
 * LPC768_MBED
 * -----------
 * Connections for the mbed LPC1768 module. 
 * The display module should be connected with jumper cables between the
 * pinlist on the mbed board and the 14-pos connector (J3) on the
 * display module like this:
 *
 *   Mbed      Display
 *   
 *   GND        J3-1
 *   VOUT       J3-2
 *   p7         J3-3
 *   p5         J3-4
 *   p6         J3-5
 *   p8         J3-6
 *   p13        J3-7
 *   p10        J3-8
 *   p27        J3-9
 *   p28        J3-10
 *   p26        J3-11
 *   p12        J3-12
 *   p9         J3-13
 *   p11        J3-14
 */
#define LPC1768_MBED   p7,p5,p6,p8,p13,p10,p27,p28,p26,p12,p9,p11


EM027BS013 epaper(LPC1768_MBED);

int main() {
    while(1) {
        epaper.drawImage((uint8_t*)&image_array_270_ea);
        wait(5);
        epaper.drawImage((uint8_t*)&image_array_270_text);
        wait(5);
        epaper.drawImage((uint8_t*)&image_array_270_1);
        wait(5);
        epaper.drawImage((uint8_t*)&image_array_270_2);
        wait(5);
    }
}
