#include "mbed.h"
#include "EaEpaper.h"
#include "Arial28x28.h"
#include "Arial12x12.h"
#include "font_big.h"

EaEpaper epaper(p17,          // PWR_CTRL
                p9,           // BORDER
                p18,          // DISCHARGE
                p38,          // RESET_DISP
                p10,          // BUSY
                p14,          // SSEL
                p37,          // PWM
                p11,p12,p13,  // MOSI,MISO,SCLK
                p19,p20);     // SDA,SDL 

int main() {

    epaper.cls();
    
    epaper.set_font((unsigned char*) Arial28x28);  // select the font
    epaper.locate(5,20);
    epaper.printf("Hello Mbed");
    
    epaper.rect(3,15,150,50,1);
     
    epaper.set_font((unsigned char*) Arial12x12);
    epaper.locate(5,60);
    epaper.printf("small Font");
    epaper.set_font((unsigned char*) Neu42x35);
    epaper.locate(5,70);
    epaper.printf("big Font");
    
    epaper.write_disp(); // update screen
    
    wait(5);
    epaper.fillcircle(180,30,22,1);
    epaper.circle(160,150,20,1);
    
    epaper.write_disp(); // update screen    

    return 0;    
}