/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap converter for emWin V5.16.                           *
*        Compiled Jun  4 2012, 15:48:30                              *
*        (C) 1998 - 2010 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: black_coffee                                          *
* Dimensions:  80 * 58                                               *
* NumColors:   248                                                   *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR Colorsblack_coffee[] = {
     0xFFFFFF,0x000000,0x93A4C9,0x0B0A19
    ,0x92A2C5,0xD7D9E9,0xC6CCE3,0x8DA1C7
    ,0x9AACD2,0x9AAACC,0xB3BCD6,0x8A9DC3
    ,0xA3B2D2,0xCCD1E4,0x110D1A,0x869BC1
    ,0x060824,0x98A6CB,0x909EC3,0x13111A
    ,0xBBC3DC,0xCCD3EA,0x95AAD1,0xE4E7F7
    ,0x162A54,0x9AA5C5,0x95A8CE,0xBBC5E2
    ,0xE4E4EC,0x9BA8C6,0xA2ACC8,0x667AA6
    ,0x364A75,0xAAB5D3,0x14244A,0x253964
    ,0xABBADA,0x02010B,0xA5B0CB,0x131424
    ,0x586B95,0x7C91B9,0x0B1019,0x1C325B
    ,0xC3CBDD,0xD4DBF2,0xDDE0EC,0xBDC8E2
    ,0xC1C5DA,0xA0AED3,0xB5C0DB,0xC9CCDB
    ,0x081944,0x687699,0x7A8BB3,0x8C9EC8
    ,0xB3C3E3,0xC8D4F3,0xDADDF0,0x0C1123
    ,0x36456B,0x8C9CBD,0x08173C,0x6B82A9
    ,0x6787C6,0x909FCB,0xA2B3D9,0xBDC8DB
    ,0x2C426B,0x577AB5,0x7694CA,0xAAB2CB
    ,0xD2D4DB,0xC5D0E0,0x455479,0x445884
    ,0x56658A,0x48629A,0x5775A8,0x758BB3
    ,0x8395B5,0x85A5DB,0xDEE0F2,0x010C33
    ,0x101D46,0x3C517A,0x5B719A,0x7384AC
    ,0x7B8CB9,0x8499BE,0x939CB7,0x9CB0D5
    ,0xBCC1D3,0xDBE4FC,0x0C2455,0x7488AD
    ,0x7599D6,0x93A6D1,0x9DB2DA,0xBBCAEA
    ,0xE9F3FE,0x0D224A,0x465C95,0x4A67A5
    ,0x6382BA,0x7184B1,0x8B95B5,0xADB9D3
    ,0xBCC1CD,0xE0DEEB,0x100C24,0x23355C
    ,0x3E548B,0x4D628B,0x7B8BAA,0x728BBA
    ,0x95A1BB,0x9AA4BB,0xA6AAB9,0xB5BBCB
    ,0xACB4D9,0xB5C0D6,0x647AB6,0x6C89BD
    ,0x8394BA,0x9BAFD8,0xC4C9D3,0xCDD1DC
    ,0xF7F6FC,0x080207,0x192237,0x212A4D
    ,0x162A65,0x293C75,0x414C75,0x636C8C
    ,0x576EA9,0x5B82BA,0x7282A3,0x6382B4
    ,0x828AAA,0x8C9AB5,0x9CA2B5,0xB0B4BD
    ,0x869CD6,0xB2B4C1,0xB9BBC5,0x89AAE3
    ,0xC5D2EC,0xD5E2FD,0x13090A,0x201E29
    ,0x25222D,0x2A4478,0x464868,0x2A4886
    ,0x2D5294,0x555F84,0x737EA6,0x5D7DC9
    ,0x7988A4,0x7F86A8,0x5D89C5,0x818EB9
    ,0xADB1BD,0xA6B1C5,0xA9B1C6,0xB9BDC9
    ,0xA6B8D5,0x98B8F3,0xB8BFE1,0xC2C5D2
    ,0xC9CCD4,0xC5D0DF,0xCED8EE,0xDCE8FF
    ,0x212332,0x061A56,0x373848,0x363859
    ,0x082763,0x1D3465,0x1B3C79,0x3F4359
    ,0x5C6477,0x344B86,0x26528A,0x2D4E99
    ,0x3D5EA9,0x3861A1,0x71798F,0x4C74A9
    ,0x4D7AB8,0x7D84A6,0x7688A5,0x6D85B3
    ,0x6F8BB7,0x768CC0,0x6890C4,0x8293AA
    ,0x9497A4,0x858BB0,0x9BA1AC,0x8FA1BF
    ,0x94A1B7,0x9EA8BF,0xA3B0BD,0xB1B8BD
    ,0xAEB8CF,0xB4B9C5,0xB4B6CB,0x91AFE5
    ,0xADB5E0,0xADBBE4,0xAEC0DE,0xB6C4E9
    ,0xC2C5CD,0xD1CEDB,0xCED1D6,0xD2D3D5
    ,0xD1DDFB,0xDDE0E5,0xD7E0F4,0x0A0A0D
    ,0x000E45,0x2B3144,0x413E4B,0x484554
    ,0x6E767F,0x1E4385,0x747C9A,0x4568B2
    ,0x6C85B8,0x638BBF,0x6E9ED2,0x8A8794
    ,0x89919A,0x888EB3,0xABB2B7,0x829DCC
    ,0x99A7DB,0x99B9EE,0xADC0E6,0xBFD0EE
    ,0xA4C2F7,0xBFCDF2,0xC5C9CC,0xDADBDD
};

static GUI_CONST_STORAGE GUI_LOGPALETTE Palblack_coffee = {
  248,  /* number of entries */
  1,    /* Has transparency */
  &Colorsblack_coffee[0]
};

static GUI_CONST_STORAGE unsigned char acblack_coffee[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDD, 0x48, 0xAC, 0x7E, 0xAB, 0x33, 0x6C, 0x6C, 0x6C, 
        0x7E, 0xAC, 0x7E, 0xDA, 0xF6, 0x7F, 0x7F, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x63, 0x38, 0xD5, 0x42, 0x42, 0x08, 0x16, 0x41, 0x41, 0x37, 0x61, 0x37, 0x0B, 
        0x41, 0x0B, 0x0B, 0x41, 0x02, 0x1A, 0x5B, 0x0C, 0x24, 0x38, 0x32, 0x2F, 0x94, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDB, 0xDB, 0xCF, 0xEE, 0x8E, 0xC8, 0x72, 0x8A, 0x57, 0x57, 0x36, 0xA1, 0x58, 0x36, 0x58, 0x58, 0x58, 0x58, 0x36, 
        0x36, 0xA3, 0xA3, 0xA3, 0x36, 0x4F, 0x57, 0x5F, 0xA1, 0xA0, 0x72, 0xC7, 0xC7, 0xCC, 0x26, 0x77, 0x5C, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE, 0x79, 0x08, 0x7C, 0x58, 0xC3, 0x8B, 0x45, 0x3F, 0x4F, 0x68, 0x68, 0x7A, 0x60, 0x51, 0x93, 0x90, 0x60, 0xD3, 0x60, 0xF4, 
        0xD3, 0xA9, 0x51, 0x8B, 0x68, 0x7A, 0x45, 0x46, 0x40, 0x40, 0x89, 0x68, 0x68, 0x73, 0xC4, 0x58, 0x16, 0x26, 0x0A, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x48, 0x47, 0x5A, 0x5F, 0x3F, 0x1F, 0x1F, 0x3F, 0x8B, 0x69, 0x37, 0x45, 0x68, 0x93, 0x4E, 0x90, 0x46, 0x45, 0x4E, 0x51, 0xF1, 0x8B, 
        0x46, 0x4D, 0x51, 0x68, 0x67, 0x4D, 0x40, 0x60, 0x45, 0x60, 0x40, 0x40, 0x7B, 0x7B, 0x7B, 0x4F, 0x4F, 0x8C, 0x1D, 0xD2, 0x33, 0xDD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0C, 0x3D, 0x69, 0x1F, 0x7A, 0x45, 0x45, 0x40, 0x45, 0x4D, 0x89, 0x45, 0xF0, 0x69, 0x1F, 0x65, 0x1F, 0x18, 0x22, 0x9E, 0x35, 0x86, 0x3C, 
        0x23, 0x54, 0x20, 0x4C, 0x95, 0xE8, 0x66, 0xB9, 0x51, 0x66, 0x4D, 0x67, 0x9F, 0xA2, 0x60, 0x46, 0x46, 0x73, 0x73, 0x36, 0x07, 0x6B, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA4, 0x72, 0x35, 0x1F, 0x7A, 0x7A, 0xC5, 0xA9, 0xC0, 0xA9, 0x9B, 0xBA, 0x99, 0x23, 0x88, 0x10, 0x70, 0x87, 0x4B, 0xD4, 0x53, 0x54, 0x53, 0x10, 
        0x10, 0x10, 0x54, 0x10, 0x28, 0xE0, 0xB5, 0x84, 0x5E, 0xB1, 0x84, 0xBD, 0xE5, 0x9C, 0x60, 0x93, 0x46, 0x46, 0x29, 0x29, 0x4F, 0xCD, 0x6B, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x09, 0x72, 0x1F, 0x1F, 0x4E, 0x45, 0xA2, 0xC0, 0x88, 0x4D, 0x20, 0x18, 0xB3, 0x9A, 0xB0, 0x03, 0x10, 0x03, 0x03, 0x25, 0x81, 0x97, 0x98, 0x25, 0x03, 
        0x25, 0x03, 0x25, 0xB2, 0x27, 0x10, 0x10, 0x3C, 0x4A, 0x53, 0x20, 0x18, 0x84, 0x90, 0x67, 0x67, 0x40, 0x93, 0x46, 0x46, 0x40, 0xC4, 0x46, 0x0A, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x0A, 0xC2, 0x35, 0x1F, 0x3F, 0x51, 0xBF, 0x9C, 0xBD, 0x5E, 0x4D, 0x18, 0x34, 0x6E, 0x6E, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x81, 0x01, 0x01, 
        0x01, 0x25, 0x25, 0x25, 0x25, 0x03, 0x10, 0x10, 0x4A, 0x4B, 0x23, 0x85, 0x34, 0x9B, 0x66, 0xB6, 0x67, 0x45, 0xC6, 0x40, 0x90, 0x29, 0x73, 0x1E, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x35, 0x1F, 0x1F, 0x89, 0x4E, 0x65, 0x2B, 0x3B, 0x03, 0x03, 0x01, 0x81, 0x25, 0x03, 0x03, 0x25, 0x03, 0x03, 0x03, 0x03, 0x03, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x13, 0x27, 0x2A, 0x03, 0x3B, 0x03, 0x03, 0x03, 0x03, 0x03, 0xB2, 0x86, 0x10, 0x58, 0x4B, 0x85, 0x99, 0x88, 0x84, 0xB4, 0x70, 0x40, 0x40, 0x7B, 0xEF, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x36, 0x35, 0x4E, 0xC5, 0xB6, 0xB4, 0x10, 0x10, 0x25, 0x25, 0x01, 0x01, 0x25, 0x0E, 0x03, 0x10, 0x10, 0x03, 0x03, 0x10, 0x27, 0x03, 0x0E, 0x0E, 0x13, 0x03, 0x0E, 
        0x0E, 0x03, 0x03, 0x03, 0x03, 0x2A, 0x2A, 0x13, 0x0E, 0x10, 0x25, 0xB3, 0x4C, 0x20, 0x23, 0x70, 0x66, 0x85, 0x67, 0x9B, 0x67, 0x9C, 0x60, 0x51, 0xC3, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDA, 0x4E, 0x4E, 0x4E, 0x73, 0x83, 0x35, 0x03, 0x03, 0x81, 0x01, 0x96, 0x13, 0x0E, 0x13, 0x03, 0x13, 0x03, 0x03, 0x27, 0x13, 0x03, 0x13, 0x0E, 0x13, 0x0E, 0x13, 0x0E, 
        0x27, 0x0E, 0x0E, 0x13, 0x13, 0x03, 0x13, 0x2A, 0x03, 0x2A, 0x03, 0x03, 0x03, 0x9D, 0x9E, 0x23, 0x20, 0xB9, 0x18, 0x66, 0x7B, 0xBC, 0xE7, 0xC6, 0xE9, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x4D, 0x56, 0x4E, 0x10, 0x10, 0x53, 0x03, 0x03, 0x0E, 0x13, 0x13, 0x96, 0x13, 0x96, 0x13, 0x03, 0x03, 0x03, 0x0E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x13, 0x03, 
        0x0E, 0x03, 0x0E, 0x03, 0x03, 0x13, 0x03, 0x13, 0x2A, 0x27, 0x2A, 0x3E, 0x10, 0x9D, 0x3C, 0x20, 0x23, 0x34, 0x70, 0x66, 0x88, 0x40, 0xBB, 0xBF, 0x51, 0xCC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x56, 0x22, 0x10, 0x03, 0x3B, 0x0E, 0x0E, 0x03, 0x0E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x2A, 0x03, 0x03, 0x03, 0x13, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x03, 0x27, 0x03, 0x2A, 0x3B, 0x82, 0x3C, 0x10, 0x1F, 0x23, 0x4B, 0x66, 0x20, 0x4D, 0x9F, 0x9F, 0x89, 0xEA, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x56, 0x56, 0x3E, 0x10, 0x03, 0x03, 0x0E, 0x0E, 0x0E, 0x0E, 0x03, 0x10, 0x03, 0x10, 0x03, 0x03, 0x03, 0x03, 0x2A, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x10, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x10, 0x03, 0x03, 0x3B, 0x82, 0x10, 0xB8, 0x4C, 0x4C, 0x55, 0x4B, 0x28, 0x23, 0xB1, 0x85, 0xBC, 0xBB, 0xBA, 0xA2, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x2D, 0xB8, 0x3B, 0x03, 0x3B, 0x03, 0x03, 0x0E, 0x0E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x10, 0x03, 0x03, 0x13, 0x03, 0x03, 0x03, 0x03, 0x2A, 0x03, 0x03, 0x03, 0x10, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x03, 0x6E, 0x10, 0x03, 0x6F, 0x55, 0x55, 0x4A, 0x65, 0x9A, 0x6F, 0x23, 0xAF, 0x1F, 0x4B, 0x53, 0x4A, 0xA0, 0x8D, 0x17, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x5C, 0x05, 0x17, 0x27, 0x27, 0x03, 0x3B, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x0E, 0x03, 0x03, 0x03, 0x10, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x2A, 0x03, 0x03, 
        0x2A, 0x03, 0x03, 0x2A, 0x10, 0x13, 0xDF, 0x03, 0x03, 0x10, 0x22, 0xB7, 0x3C, 0x4A, 0x4C, 0x4C, 0x83, 0x22, 0x4A, 0x4D, 0x5E, 0x53, 0x0B, 0x64, 0x95, 0x5C, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2D, 0x00, 0x5D, 0x39, 0x05, 0x0D, 0x14, 0x15, 0x06, 0x06, 0x39, 0x06, 0x1E, 0x6A, 0x1D, 0x06, 0x64, 0x82, 0x3B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x13, 0x03, 0x03, 0x6E, 0x10, 0x03, 0x03, 0x13, 0x10, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x0E, 0x10, 0x03, 0x0E, 0x03, 0x03, 0x13, 0x10, 0x10, 0x3E, 0x3C, 0x70, 0x71, 0x53, 0x20, 0x35, 0x3C, 0x86, 0x54, 0x18, 0x28, 0x4A, 0x5D, 0x5D, 0x0A, 0x5C, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0x63, 0x1E, 0x5A, 0x19, 0x1E, 0x75, 0x75, 0x19, 0x09, 0x08, 0x31, 0x5A, 0x5A, 0xD0, 0x0A, 0x06, 0x17, 0x05, 0x03, 0x27, 0x27, 0x03, 0x13, 0x0E, 0x03, 0x0E, 0x03, 0x27, 0x03, 0x03, 0x03, 0x0E, 0x10, 0x03, 0x03, 0x03, 0x6E, 0x03, 0x0E, 0x10, 
        0x03, 0x03, 0x0E, 0x6E, 0x03, 0x2A, 0x03, 0x03, 0x27, 0x83, 0x35, 0x28, 0x20, 0x70, 0x65, 0x10, 0x54, 0x18, 0x28, 0x23, 0x1F, 0xDC, 0xF5, 0x21, 0x6B, 0x2C, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x48, 0x42, 0x59, 0xCE, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCA, 0x50, 0x04, 0x8D, 0x1D, 0x32, 0x74, 0x0A, 0x6B, 0x95, 0x5D, 0x8E, 0x27, 0xB0, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x2A, 0x03, 0x03, 0x03, 0x13, 0x03, 0x03, 0x03, 0x35, 0x87, 0x20, 0x28, 0x36, 0x69, 0x9D, 0x3E, 0xE6, 0x87, 0x64, 0x2D, 0x38, 0x0C, 0x21, 0x1B, 0xAB, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x92, 0x07, 0x0F, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x04, 0x3D, 0x09, 0x32, 0x5A, 0x21, 0x26, 0x0A, 0x0A, 0x05, 0x5D, 0x91, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x13, 0x03, 0x03, 0x03, 0x2A, 0x13, 0x13, 0x13, 0x03, 0x2A, 
        0x13, 0x03, 0x13, 0x03, 0x0E, 0x13, 0x13, 0x03, 0x03, 0x35, 0x87, 0x23, 0x3C, 0xF2, 0x57, 0x83, 0x6A, 0x17, 0x06, 0x1B, 0x1E, 0x09, 0x24, 0x21, 0x0A, 0x30, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x91, 0x4F, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8E, 0x6A, 0x26, 0xD5, 0x3D, 0x26, 0x21, 0x1D, 0x1E, 0x47, 0x79, 0x15, 0x17, 0x64, 0xE1, 0x3B, 0x03, 0x3B, 0x3B, 0x03, 0x0E, 0x03, 0x0E, 0x0E, 0x03, 0x0E, 0x03, 0x03, 0x03, 0x13, 
        0x03, 0x03, 0x0E, 0x03, 0x03, 0x03, 0x03, 0x3B, 0xB7, 0x9A, 0x86, 0x3C, 0x1F, 0x4C, 0x64, 0xAF, 0x39, 0x32, 0x47, 0x19, 0x47, 0x0C, 0x09, 0x0A, 0x0A, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x76, 0x58, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x1D, 0x0C, 0x38, 0x3D, 0x0C, 0x09, 0x26, 0x1D, 0x1E, 0x75, 0x1E, 0x1E, 0x76, 0x1E, 0xA6, 0x0A, 0x2C, 0x2D, 0x6D, 0x17, 0x17, 0x80, 0x80, 0xD9, 0xEB, 0xE2, 0x98, 0x97, 0x98, 
        0x97, 0xE3, 0xC8, 0x33, 0x80, 0x80, 0x17, 0x17, 0x5D, 0x06, 0x38, 0x08, 0x31, 0x09, 0x04, 0x1E, 0x19, 0x1E, 0x1E, 0x1E, 0x1E, 0x0C, 0x0C, 0x0A, 0x14, 0x33, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x76, 0x29, 0x4F, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x05, 0x38, 0x04, 0x0C, 0x26, 0x09, 0x26, 0x09, 0x1D, 0x1D, 0x04, 0x19, 0x1D, 0x19, 0x19, 0x1D, 0x09, 0x11, 0x1D, 0x0C, 0x24, 0x38, 0x2F, 0x63, 0xF3, 0x39, 0x39, 0x39, 
        0x39, 0x39, 0x06, 0x38, 0x38, 0x78, 0x31, 0x11, 0x02, 0x02, 0x04, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x09, 0x11, 0x08, 0x26, 0x0C, 0x21, 0x14, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0x0F, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x63, 0x04, 0x6B, 0x0C, 0x1E, 0x09, 0x1D, 0x1D, 0x1D, 0x1D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 
        0xCB, 0x07, 0x07, 0x04, 0x04, 0x04, 0x12, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x02, 0x02, 0x02, 0x08, 0x61, 0x08, 0x0C, 0x6B, 0x0A, 0x14, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0x07, 0x07, 0xCE, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x2F, 0x04, 0x0C, 0x31, 0x31, 0x09, 0x09, 0x09, 0x1A, 0x04, 0x04, 0x04, 0x02, 0x04, 0x04, 0x12, 0x04, 0x12, 0x12, 0x04, 0x04, 0x12, 0x3D, 0x0B, 0x3D, 0x3D, 0x0B, 
        0x12, 0x12, 0x04, 0x04, 0x04, 0x37, 0x41, 0x02, 0x02, 0x12, 0x12, 0x19, 0x19, 0x19, 0x19, 0x02, 0x02, 0x02, 0x16, 0x08, 0x08, 0x26, 0x0C, 0x0A, 0x0A, 0x0D, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x07, 0xA5, 0x05, 0x00, 0x00, 0x00, 0x00, 0x80, 0x1C, 0x17, 0x1C, 0x1C, 0x1C, 0xAE, 0x1D, 0x24, 0x26, 0x0C, 0x26, 0x1A, 0x1A, 0x1D, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x04, 0x12, 0x0B, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x04, 0x04, 0x41, 0x02, 0x07, 0x07, 0x02, 0x04, 0x19, 0x11, 0x19, 0x19, 0x02, 0x02, 0x1A, 0x08, 0x08, 0x08, 0x0C, 0x24, 0x14, 0x14, 0x05, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0x26, 0x47, 0x47, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x1C, 0x17, 0x17, 0x1C, 0x1C, 0x94, 0x1D, 0x0A, 0x0C, 0x0C, 0x0C, 0x09, 0x09, 0x09, 0x09, 0x11, 0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x12, 0x3D, 0x12, 0x04, 0x04, 0x04, 0x04, 0x04, 0x19, 0x19, 0x19, 0x19, 0x04, 0x04, 0x09, 0x09, 0x1E, 0x21, 0x21, 0x21, 0x0A, 0x1B, 0x05, 0x3A, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x19, 0x77, 0x0A, 0x92, 0x1C, 0x1C, 0x1C, 0x17, 0x1C, 0x17, 0x05, 0x1C, 0x17, 0x1B, 0x04, 0x24, 0x21, 0x0C, 0x0C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x74, 0x1D, 0x04, 0x74, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x19, 0x19, 0x04, 0x04, 0x04, 0x1D, 0x19, 0x19, 0x1E, 0x19, 0x09, 0x09, 0x09, 0x09, 0x31, 0x21, 0x0C, 0x78, 0x32, 0x1B, 0x06, 0x05, 0x05, 0x6D, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x0C, 0xD6, 0x14, 0x49, 0x17, 0x52, 0x17, 0x17, 0x05, 0x1C, 0x94, 0x1E, 0x24, 0x21, 0x0C, 0x0C, 0x26, 0x09, 0x09, 0x09, 0x1D, 0x19, 0x1D, 0x09, 0x1D, 0x19, 0x11, 0x11, 0x02, 0x04, 0x04, 0x04, 0x04, 0x02, 0x12, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x12, 0x12, 0x19, 0x04, 0x04, 0x04, 0x02, 0x07, 0x11, 0x02, 0x02, 0x02, 0x61, 0x61, 0x1A, 0x08, 0x26, 0x21, 0x0C, 0x24, 0x1B, 0x1B, 0x06, 0x15, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xA8, 0x24, 0x43, 0x2F, 0x30, 0x52, 0x1C, 0x1C, 0x1C, 0x05, 0x39, 0x1E, 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x09, 0x09, 0x09, 0x1D, 0x09, 0x1D, 0x1D, 0x19, 0x02, 0x41, 0x04, 0x04, 0x12, 0x12, 0x02, 0x02, 0x02, 0x12, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x19, 0x19, 0x04, 0x02, 0x02, 0x07, 0x02, 0x08, 0x02, 0x61, 0x61, 0x51, 0x09, 0x08, 0x31, 0x21, 0x21, 0x24, 0x1B, 0x0A, 0x06, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0xA5, 0x79, 0x2F, 0x43, 0x14, 0x14, 0x15, 0x2D, 0x2D, 0x39, 0x09, 0x04, 0x42, 0x0C, 0x0C, 0x08, 0x08, 0x09, 0x09, 0x11, 0x11, 0x09, 0x09, 0x11, 0x04, 0x02, 0x11, 0x02, 0x02, 0x02, 0x02, 0x02, 0x12, 0x12, 0x02, 0x04, 
        0x12, 0x02, 0x04, 0x41, 0x12, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x11, 0x02, 0x11, 0x09, 0x09, 0x1E, 0x08, 0x0C, 0x0C, 0xA8, 0x24, 0x21, 0x0A, 0x06, 0x0D, 0x06, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2E, 0x2D, 0xDE, 0x74, 0x0A, 0x14, 0x06, 0x2F, 0x14, 0xD0, 0x26, 0x24, 0x02, 0xCB, 0x1D, 0x0C, 0x08, 0x31, 0x11, 0x08, 0x09, 0x09, 0x11, 0x11, 0x04, 0x04, 0x19, 0x11, 0x02, 0x04, 0x04, 0x04, 0x04, 0x12, 0x02, 0x02, 0x02, 0x41, 
        0x04, 0x12, 0x41, 0x04, 0x04, 0x12, 0x04, 0x04, 0x04, 0x11, 0x02, 0x11, 0x11, 0x11, 0x11, 0x11, 0x09, 0x09, 0x08, 0x0C, 0x0C, 0x24, 0x0C, 0x0A, 0x32, 0x14, 0x06, 0x0D, 0x0D, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x15, 0x05, 0x1E, 0x26, 0x0A, 0x2F, 0x2F, 0x1B, 0x0C, 0x07, 0x07, 0x0B, 0x02, 0x09, 0x31, 0x42, 0x31, 0x09, 0x09, 0x11, 0x02, 0x02, 0x11, 0x02, 0x02, 0x02, 0x02, 0x04, 0x41, 0x02, 0x12, 0x02, 0x02, 0x02, 0x02, 0x04, 
        0x12, 0x02, 0x04, 0x04, 0x02, 0x02, 0x04, 0x04, 0x02, 0x02, 0x11, 0x02, 0x02, 0x02, 0x02, 0x1A, 0x09, 0x08, 0x31, 0x08, 0x0C, 0x09, 0x0C, 0x24, 0x0A, 0x14, 0x2C, 0x0D, 0x15, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x33, 0x2C, 0x06, 0x0D, 0x06, 0x39, 0x2D, 0x5A, 0x09, 0x24, 0x24, 0x32, 0x09, 0x5F, 0x04, 0x0B, 0x08, 0x09, 0x04, 0x31, 0x08, 0x09, 0x11, 0x11, 0x11, 0x02, 0x11, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x04, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x12, 0x02, 0x11, 0x04, 0x02, 0x02, 0x11, 0x02, 0x02, 0x09, 0x08, 0x09, 0x08, 0x08, 0x08, 0x31, 0x08, 0x08, 0x42, 0x24, 0x24, 0x14, 0x1B, 0x33, 0x0D, 0x05, 0x05, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x0A, 0x6B, 0x24, 0x38, 0x38, 0xD7, 0xD7, 0xAA, 0x7C, 0x02, 0x07, 0x16, 0x36, 0x36, 0x07, 0x08, 0x08, 0x02, 0x02, 0x11, 0x11, 0x11, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x07, 0x07, 0x02, 0x02, 0x04, 0x41, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x02, 0x02, 0x02, 0x02, 0x11, 0x02, 0x08, 0x02, 0x02, 0x02, 0x08, 0x08, 0x08, 0x09, 0x42, 0x0C, 0x24, 0x0C, 0x0A, 0x06, 0x30, 0x06, 0x06, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x79, 0xA5, 0x74, 0x3D, 0x3D, 0x04, 0x11, 0x08, 0x42, 0x42, 0x31, 0xD4, 0x37, 0x4F, 0x29, 0x29, 0x1A, 0x16, 0x08, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x07, 0x04, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1A, 0x1A, 0x02, 0x02, 0x02, 0x02, 0x11, 0x09, 0x08, 0x08, 0x08, 0x5B, 0x04, 0x0C, 0x0A, 0x32, 0x06, 0x06, 0x05, 0x15, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0x2C, 0x26, 0x8D, 0x29, 0x50, 0x50, 0x59, 0x59, 0x07, 0x0B, 0x37, 0x61, 0x0F, 0x69, 0x0F, 0x7D, 0x08, 0x1A, 0x02, 0x02, 0x07, 0x07, 0x07, 0x07, 0x02, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02, 0x07, 0x07, 0x07, 0x02, 0x02, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x1A, 0x08, 0x08, 0x7D, 0x61, 0x50, 0x09, 0x0A, 0x0A, 0x2C, 0x06, 0x0D, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x05, 0x2F, 0x32, 0x09, 0x50, 0x36, 0x72, 0x5F, 0x5F, 0x29, 0x36, 0x4F, 0x73, 0x69, 0x3F, 0x37, 0x7D, 0x02, 0x16, 0x02, 0x02, 0x07, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x07, 0x02, 0x07, 0x07, 0x07, 0x02, 0x07, 0x07, 0x02, 0x02, 
        0x07, 0x07, 0x02, 0x07, 0x02, 0x07, 0x07, 0x02, 0x02, 0x02, 0x02, 0x07, 0x07, 0x02, 0x07, 0x02, 0x02, 0x02, 0x1A, 0x1A, 0x08, 0x62, 0x3F, 0x59, 0x11, 0x21, 0x14, 0x30, 0x0D, 0x0D, 0x05, 0x05, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x05, 0x0D, 0x14, 0x26, 0x8D, 0x72, 0xC2, 0x3F, 0x3F, 0x1F, 0x35, 0x1F, 0x35, 0x71, 0x42, 0x08, 0x08, 0x02, 0x07, 0x0B, 0x0B, 0x0B, 0x02, 0x37, 0x0F, 0x0F, 0x0B, 0x0B, 0x0B, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0B, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02, 0x07, 0x02, 0x0B, 0x16, 0x02, 0x1A, 0x5B, 0x16, 0x28, 0x1F, 0xC9, 0x02, 0x21, 0x0A, 0x30, 0x06, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x52, 0x52, 0x2D, 0x2D, 0x15, 0x2F, 0xA8, 0x04, 0x29, 0x3F, 0x1F, 0x1F, 0x56, 0x28, 0x28, 0x20, 0x42, 0x08, 0x16, 0x07, 0x37, 0x51, 0x0B, 0x0F, 0x07, 0x07, 0x07, 0x07, 0x0F, 0x0F, 0x0F, 0x07, 0x0F, 0x59, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x02, 0x07, 0x07, 0x02, 0x02, 0x02, 0x16, 0x62, 0x5B, 0x28, 0x28, 0x1F, 0x29, 0x02, 0x0A, 0x1B, 0x06, 0x15, 0x05, 0x05, 0x05, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x48, 0x1C, 0x17, 0x2E, 0x17, 0x17, 0x52, 0x05, 0x05, 0x0D, 0x5C, 0x77, 0x1D, 0x6A, 0xC1, 0x35, 0x20, 0x3C, 0x23, 0x62, 0x62, 0x16, 0x02, 0x37, 0x07, 0x07, 0x0B, 0x0B, 0x0B, 0x0F, 0x0F, 0x0F, 0x0F, 0x59, 0x0F, 0x0B, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x02, 0x07, 0x07, 0x07, 0x07, 0x16, 0x07, 0x7D, 0x16, 0x16, 0x28, 0x20, 0x71, 0x1F, 0x50, 0x09, 0x0A, 0x14, 0x06, 0x06, 0x0D, 0x3A, 0x17, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x48, 0x17, 0x05, 0x05, 0x2E, 0x52, 0x3A, 0x2D, 0x3A, 0x2D, 0x05, 0x63, 0x38, 0x42, 0x04, 0x36, 0x4C, 0x44, 0x6F, 0x18, 0x07, 0x7D, 0x16, 0x16, 0x02, 0x02, 0x02, 0x0B, 0x0F, 0x0F, 0x07, 0x0F, 0x0F, 0x0F, 0x59, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0B, 0x0B, 0x0F, 0x02, 0x0B, 0x02, 0x02, 0x1A, 0x5B, 0x08, 0x62, 0x62, 0x0F, 0x2B, 0x44, 0x44, 0x20, 0x4C, 0x3F, 0x3D, 0x09, 0x14, 0x06, 0x0D, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xD8, 0x2E, 0x2E, 0x2E, 0x2E, 0x1C, 0x1C, 0x1C, 0x05, 0x05, 0x05, 0x15, 0x30, 0x0A, 0x1E, 0x3D, 0x8A, 0x4A, 0x44, 0x18, 0x2B, 0x6F, 0x16, 0x08, 0x5B, 0x1A, 0x02, 0x02, 0x02, 0x07, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0F, 0x0F, 
        0x0B, 0x0B, 0x0F, 0x0B, 0x07, 0x1A, 0x02, 0x02, 0x02, 0x08, 0x08, 0x08, 0x16, 0x16, 0x7C, 0x20, 0x2B, 0x23, 0x44, 0x20, 0x55, 0x28, 0x5F, 0x04, 0x0C, 0x32, 0x06, 0x05, 0x05, 0x05, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x05, 0x2E, 0x2E, 0x2E, 0x2E, 0x6D, 0x1C, 0x6D, 0x6D, 0x15, 0x06, 0x1B, 0x0A, 0x02, 0x50, 0x1F, 0x20, 0x23, 0x18, 0x65, 0x34, 0x28, 0x0F, 0x5B, 0x5B, 0x1A, 0x16, 0x1A, 0x1A, 0x1A, 0x02, 0x07, 0x02, 0x07, 0x07, 0x07, 
        0x07, 0x02, 0x07, 0x07, 0x16, 0x1A, 0x08, 0x16, 0x62, 0x62, 0x08, 0x08, 0x59, 0x28, 0x34, 0x18, 0x2B, 0x23, 0x44, 0x20, 0x4D, 0x8A, 0x0B, 0x0C, 0x0A, 0x06, 0x06, 0x05, 0x3A, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x05, 0x05, 0x05, 0x1C, 0x05, 0x2E, 0x2E, 0x05, 0x05, 0x05, 0x33, 0x06, 0x14, 0x0C, 0x0C, 0x29, 0x56, 0x20, 0xB5, 0x18, 0x5E, 0x22, 0x34, 0x4A, 0x50, 0x02, 0x08, 0x08, 0x16, 0x08, 0x08, 0x1A, 0x16, 0x08, 0x16, 0x1A, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x08, 0x08, 0x08, 0x1A, 0x7C, 0x57, 0x20, 0x34, 0x22, 0x18, 0x2B, 0x23, 0x44, 0x55, 0x4B, 0x3F, 0x0B, 0x08, 0x24, 0x0A, 0x06, 0x15, 0x05, 0x05, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0x6D, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x05, 0x0D, 0x05, 0x0D, 0x06, 0x06, 0x38, 0x24, 0x16, 0x29, 0x4E, 0x20, 0x2B, 0x18, 0x22, 0x22, 0x22, 0x82, 0x53, 0x4A, 0x4F, 0x7C, 0x0B, 0x1A, 0x08, 0x08, 0x1A, 0x08, 0x16, 
        0x1A, 0x16, 0x16, 0x1A, 0x07, 0x0B, 0x29, 0x5F, 0x20, 0x3E, 0x22, 0x65, 0x18, 0x18, 0x23, 0x6F, 0x44, 0x20, 0x28, 0x1F, 0x46, 0x09, 0x24, 0x38, 0x63, 0x0D, 0x15, 0x05, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2D, 0x0D, 0x05, 0x05, 0x05, 0x0D, 0x2C, 0x30, 0x0A, 0x47, 0x5A, 0x8A, 0x71, 0x3C, 0x2B, 0x5E, 0x5E, 0x65, 0x22, 0x34, 0x22, 0x3E, 0x53, 0x22, 0x20, 0x35, 0x9E, 0x57, 0x57, 
        0x57, 0x1F, 0x28, 0x20, 0x22, 0x3E, 0x22, 0x22, 0x22, 0x18, 0x18, 0x22, 0x18, 0x2B, 0x23, 0x44, 0x4B, 0x56, 0x29, 0x07, 0x31, 0x0A, 0x30, 0x2C, 0x06, 0x0D, 0x3A, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCF, 0x48, 0x2E, 0x0D, 0xDE, 0xAE, 0x05, 0x05, 0x48, 0x7F, 0x0D, 0x06, 0x0D, 0x2F, 0x1B, 0x0C, 0x1D, 0x36, 0x56, 0x55, 0x23, 0x2B, 0x5E, 0x22, 0x54, 0x54, 0x54, 0x3E, 0x3E, 0x3E, 0x3E, 0x34, 0x34, 0x34, 
        0x3E, 0x34, 0x22, 0x22, 0x34, 0x54, 0x22, 0x22, 0x34, 0x22, 0x18, 0x18, 0x23, 0x44, 0x55, 0x4C, 0x5F, 0x59, 0x1A, 0x5B, 0xD6, 0x5C, 0x06, 0x06, 0x05, 0x05, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0D, 0x05, 0x0D, 0x15, 0x05, 0x3A, 0x06, 0x06, 0x0D, 0x15, 0x06, 0x06, 0x06, 0x06, 0x14, 0x0A, 0x26, 0x75, 0xA0, 0xBE, 0x71, 0x3C, 0x23, 0x2B, 0x2B, 0x2B, 0x18, 0x18, 0x18, 0x18, 0x18, 
        0x18, 0x18, 0x5E, 0x18, 0x18, 0x18, 0x2B, 0x2B, 0x23, 0x20, 0x4B, 0x28, 0x1F, 0x50, 0x07, 0x26, 0x21, 0x14, 0x06, 0x06, 0x06, 0x15, 0x0D, 0x15, 0x05, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x7E, 0x52, 0x7F, 0x06, 0x0D, 0x05, 0x3A, 0x06, 0x05, 0x06, 0x06, 0x15, 0x06, 0x06, 0x14, 0x14, 0x32, 0x21, 0x1D, 0x29, 0x29, 0x3F, 0x56, 0x71, 0x55, 0x3C, 0x44, 0x23, 0x2B, 0x18, 
        0x2B, 0x2B, 0x6F, 0x23, 0x99, 0x55, 0x4B, 0x28, 0x1F, 0x69, 0x29, 0x0B, 0x08, 0x0C, 0x24, 0x1B, 0x1B, 0x06, 0x06, 0x06, 0x06, 0x0D, 0x15, 0x05, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xA7, 0x33, 0x15, 0x15, 0x15, 0x06, 0x05, 0x05, 0x06, 0x0D, 0x06, 0x0D, 0x0D, 0x0D, 0x0D, 0x06, 0x2C, 0x30, 0x0A, 0x21, 0x47, 0x1E, 0x19, 0x5A, 0x6A, 0x6A, 0x8C, 0x8C, 0xC1, 
        0xA1, 0x8C, 0xC9, 0xED, 0x6A, 0x5A, 0x74, 0xCD, 0x1E, 0x47, 0x0A, 0x0A, 0x14, 0x30, 0x30, 0x30, 0x06, 0x06, 0x33, 0x05, 0x05, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA4, 0x30, 0x0D, 0x2D, 0x06, 0x06, 0x06, 0x2C, 0x15, 0x06, 0x06, 0x06, 0x0D, 0x0D, 0x0D, 0x06, 0x06, 0x06, 0x63, 0x1B, 0x1B, 0xAA, 0x0A, 0x0A, 0x0A, 0x78, 0x21, 0x21, 
        0x21, 0x78, 0x78, 0x78, 0x21, 0x0A, 0x0A, 0x14, 0x14, 0x43, 0x43, 0x2C, 0x06, 0x30, 0x06, 0x05, 0x0D, 0x05, 0xD9, 0x33, 0xAC, 0x5C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0x92, 0x33, 0x05, 0x05, 0x30, 0x0A, 0x0A, 0x5C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x2C, 0x06, 0x0D, 0x49, 0x49, 0x49, 0x43, 0x43, 0x43, 0x43, 0x43, 
        0x43, 0x14, 0x43, 0x43, 0x2C, 0x1B, 0x06, 0x06, 0x06, 0x1B, 0x06, 0x2F, 0x06, 0x06, 0x06, 0x1B, 0x14, 0x1B, 0x0A, 0x06, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAB, 0x76, 0x6C, 0x2C, 0x05, 0x06, 0x30, 0x0A, 0x0A, 0x0A, 0x1B, 0x1B, 0x63, 0x06, 0x2C, 0xAD, 0xAD, 0x49, 0x0D, 0x49, 0x06, 0xAD, 0x49, 0x49, 
        0x49, 0x2C, 0x2C, 0x06, 0x49, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x2F, 0x14, 0x32, 0x0A, 0x32, 0x32, 0x39, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x8F, 0x33, 0x0D, 0x05, 0x05, 0x06, 0x0A, 0x14, 0x0A, 0x79, 0x79, 0x14, 0x14, 0x14, 0x2F, 0x32, 0x2F, 0x1B, 0x1B, 0x1B, 
        0x2F, 0x06, 0x1B, 0x1B, 0x06, 0x1B, 0x1B, 0x1B, 0xAA, 0x0A, 0x14, 0x0A, 0x0A, 0x49, 0x05, 0x05, 0x33, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0xBE, 0x14, 0x1E, 0xA6, 0x0A, 0x0A, 0x14, 0x15, 0x15, 0x5D, 0x5D, 0x5D, 0x17, 0x17, 
        0x17, 0x17, 0x17, 0xAF, 0x2D, 0x39, 0x0A, 0x0A, 0x21, 0x47, 0x47, 0x76, 0x8E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xA4, 0x92, 0xA7, 0x6C, 0x5C, 0xA7, 0x77, 
        0xD1, 0x77, 0x6C, 0x8F, 0xCA, 0xEC, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmblack_coffee = {
  80, /* XSize */
  58, /* YSize */
  80, /* BytesPerLine */
  8, /* BitsPerPixel */
  acblack_coffee,  /* Pointer to picture data (indices) */
  &Palblack_coffee   /* Pointer to palette */
};

/* *** End of file *** */
