/*********************************************************************
*                                                                    *
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                                                                    *
**********************************************************************
*                                                                    *
* C-file generated by:                                               *
*                                                                    *
*        GUI_Builder for emWin version 5.14                          *
*        Compiled Jan 12 2012, 10:28:50                              *
*        (c) 2011 Segger Microcontroller GmbH & Co. KG               *
*                                                                    *
**********************************************************************
*                                                                    *
*        Internet: www.segger.com  Support: support@segger.com       *
*                                                                    *
**********************************************************************
*/

// USER START (Optionally insert additional includes)
#include "DIALOG.h"
#include "BlueboardPOS.h"
#include <stdio.h>
// USER END



/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

#define ID_FRAMEWIN_0   (GUI_ID_USER + 0x00)
#define ID_BUTTON_0   (GUI_ID_USER + 0x01)
#define ID_TEXT_0   (GUI_ID_USER + 0x02)

// USER START (Optionally insert additional defines)
// USER END

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

// USER START (Optionally insert additional static data)
// USER END

/*********************************************************************
*
*       _aDialogCreate
*/
static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { FRAMEWIN_CreateIndirect, "SwipeCard", ID_FRAMEWIN_0, 100, 75, 400, 155, 0, 100, 0 },
  { BUTTON_CreateIndirect, "CancelButton", ID_BUTTON_0, 160, 70, 80, 40, 0, 0, 0 },
  { TEXT_CreateIndirect, "Text", ID_TEXT_0, 0, 15, 390, 50, 0, 100, 0 },
  // USER START (Optionally insert additional widgets)
  // USER END
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/

// USER START (Optionally insert additional static code)
// USER END

/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  WM_HWIN hItem;
  int Id, NCode;
  // USER START (Optionally insert additional variables)
  // USER END

  switch (pMsg->MsgId) {
  case WM_INIT_DIALOG:
    //
    // Initialization of 'SwipeCard'
    //
    hItem = pMsg->hWin;
    FRAMEWIN_SetText(hItem, "");
    //
    // Initialization of 'CancelButton'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
    BUTTON_SetText(hItem, "Cancel");
    //
    // Initialization of 'Text'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_0);
    TEXT_SetText(hItem, "Swipe Card ...");
    TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
    TEXT_SetFont(hItem, GUI_FONT_32B_ASCII);
    // USER START (Optionally insert additional code for further widget initialization)
    // USER END
    break;
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);
    NCode = pMsg->Data.v;
    switch(Id) {
    case ID_BUTTON_0: // Notifications sent by 'CancelButton'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
                RFID_Cancelled = 1;
              FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_LIGHTGRAY);
                hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_0);
                TEXT_SetText(hItem, "Swipe Card ...");
                hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
                BUTTON_SetText(hItem, "Cancel");
                ShowLastWindow();
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    // USER START (Optionally insert additional code for further Ids)
    // USER END
    }
    break;
  // USER START (Optionally insert additional message handling)
  // USER END
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       CreateSwipeCard
*/
WM_HWIN CreateSwipeCard(void);
WM_HWIN CreateSwipeCard(void) {
  WM_HWIN hWin;

  hWin = GUI_CreateDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), &_cbDialog, WM_HBKWIN, 100, 75);
  return hWin;
}

// USER START (Optionally insert additional public code)
void Callback(WM_MESSAGE * pMsg);
void Callback(WM_MESSAGE * pMsg)
{
    WM_HWIN hItem;
    char string[20];
    
    switch (pMsg->MsgId) {
    case WM_USER_RFID_Load_OK:
        sprintf(string, "Credit: $%d.%02d", Credit/100, Credit%100);
        FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_GREEN);
    TEXT_SetText(pMsg->hWin, string);
    hItem = WM_GetDialogItem(hWinSwipeCard, ID_BUTTON_0);
        BUTTON_SetText(hItem, "OK");
        break;
    case WM_USER_RFID_Store_OK:
        FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_GREEN);
    TEXT_SetText(pMsg->hWin, "Checkout successful!");
      hItem = WM_GetDialogItem(hWinSwipeCard, ID_BUTTON_0);
        BUTTON_SetText(hItem, "OK");
        break;
    case WM_USER_RFID_Credit_Low:
        FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_RED);
    TEXT_SetText(pMsg->hWin, "Insufficient credit!");
      hItem = WM_GetDialogItem(hWinSwipeCard, ID_BUTTON_0);
        BUTTON_SetText(hItem, "OK");
        break;
    case WM_USER_RFID_Error:
        FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_RED);
    TEXT_SetText(pMsg->hWin, "Error!");
      hItem = WM_GetDialogItem(hWinSwipeCard, ID_BUTTON_0);
        BUTTON_SetText(hItem, "OK");
        break;
    case WM_USER_RFID_Reset_OK:
        FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_GREEN);
    TEXT_SetText(pMsg->hWin, "Card initialized at $0");
        hItem = WM_GetDialogItem(hWinSwipeCard, ID_BUTTON_0);
        BUTTON_SetText(hItem, "OK");
        break;
    case WM_USER_RFID_Increment_OK:
        FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_GREEN);
    TEXT_SetText(pMsg->hWin, "+$10");
      hItem = WM_GetDialogItem(hWinSwipeCard, ID_BUTTON_0);
        BUTTON_SetText(hItem, "OK");
        break;
    case WM_USER_RFID_Swipe:
        FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_LIGHTGRAY);
        TEXT_SetText(pMsg->hWin, "Swipe Card ...");
        hItem = WM_GetDialogItem(hWinSwipeCard, ID_BUTTON_0);
        BUTTON_SetText(hItem, "Cancel");
        break;
    case WM_USER_RFID_INIT_ERR:
        FRAMEWIN_SetClientColor(hWinSwipeCard, GUI_RED);
        TEXT_SetText(pMsg->hWin, "Error initializing CLRC663!");
        hItem = WM_GetDialogItem(hWinSwipeCard, ID_BUTTON_0);
        BUTTON_SetText(hItem, "OK");
        break;
    default:
        TEXT_Callback(pMsg);
    }
}

WM_HWIN GetCallbackHandle(void);
WM_HWIN GetCallbackHandle(void)
{
    WM_HWIN hItem;
    
    hItem = WM_GetDialogItem(hWinSwipeCard, ID_TEXT_0);
    WM_SetCallback(hItem, Callback);
    return hItem;
}
// USER END

/*************************** End of file ****************************/
