
/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "sdram.h"

#include "EwGuiImpl.h"



/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/


/******************************************************************************
 * Local variables
 *****************************************************************************/


/******************************************************************************
 * Local functions
 *****************************************************************************/

static EwGuiImpl* gui = NULL;

static void pollTouch() {
    if (gui == NULL) return;

    gui->execTouch();
}

/******************************************************************************
 * Main function
 *****************************************************************************/

int main (void) {

    Ticker ticker;
    
    // Frame buffer is put in SDRAM
    if (sdram_init() == 1) {
        printf("Failed to initialize SDRAM\n");
        return 1;
    }


    // instantiate and initialize GUI
    gui = new EwGuiImpl();

    // calibrate touch screen
    gui->calibrate();
    
    ticker.attach(&pollTouch, 0.05);


    MainTask();

    // application loop running the UI and checking for touch events
    while(1) {
        gui->exec();
        //gui.execTouch();
    }


}
