/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap converter for emWin V5.16.                           *
*        Compiled Jun  4 2012, 15:48:30                              *
*        (C) 1998 - 2010 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: danish                                                *
* Dimensions:  63 * 58                                               *
* NumColors:   250                                                   *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR Colorsdanish[] = {
     0xFFFFFF,0x000000,0x2C57CD,0x2D6AE6
    ,0x2747A7,0x2737AB,0x318AD3,0x3766B8
    ,0x1637A6,0x285BE5,0x5093E9,0x6C8FD0
    ,0x3658A7,0x2856B7,0x3558B7,0x1A57D0
    ,0x2855A8,0x2748B7,0x3767C8,0x253997
    ,0x6E95EC,0x3449A8,0x2967C7,0x30A9EA
    ,0x173797,0x274699,0x4668B7,0x2666D8
    ,0x6EACED,0x1A69CF,0x8D92AD,0x3668D6
    ,0x3191E8,0x3774C7,0x51AFEB,0x1A45A6
    ,0x2865B7,0x909298,0xACACB3,0x6A76AE
    ,0x163589,0x29559B,0x1C57E3,0xA8B7D7
    ,0x3865A8,0x3778B9,0x4569C5,0x194497
    ,0x374A98,0x385698,0x2977D7,0x4775C7
    ,0x4886D7,0x172897,0x445AB7,0x4775B7
    ,0x3878D5,0xC8C7D6,0x4567A9,0x467AD8
    ,0x2FA6D6,0x4EA6D9,0xC5C9E6,0xEBE5E9
    ,0x344AB7,0x465795,0x596798,0x4659A7
    ,0x5789DA,0xA9B8E6,0xB8C5D8,0x486397
    ,0x5377C8,0x92CBFA,0xB8C6E8,0xA8C5FB
    ,0x152887,0x284788,0x697695,0x4B78E8
    ,0x71A9DA,0xD8D7E5,0x5867B6,0x5676B5
    ,0x465AC3,0x5678D4,0x3988B8,0x24289A
    ,0x344888,0x1C45B7,0x5A7597,0x5875A8
    ,0x5696D7,0x96ABF6,0x87B7FC,0x96B6F9
    ,0x092988,0x1487D7,0x4896D7,0xA4AAC7
    ,0xB8B8C8,0xB5BAE4,0x6D737B,0x0C2A95
    ,0x063A95,0x273988,0x1A4687,0x38538A
    ,0x1767B7,0x566688,0x5568A6,0x1F62E6
    ,0x5369C6,0x4B8AB6,0x7584A7,0x98A7C3
    ,0x8797EB,0xA9B7FB,0xB5C6F5,0xC8C7C8
    ,0x012877,0x151C86,0x063489,0x1958B8
    ,0x485885,0x2677C8,0x1FA4E8,0x5FC0F5
    ,0x75C8F6,0x99A6B8,0x8999C6,0x889ADB
    ,0x9AAAD3,0xA1A7F9,0x475879,0x565C75
    ,0x34389A,0x424888,0x75778C,0x4667D1
    ,0x7887B4,0x4687C9,0xA5ABE8,0xC3BAD3
    ,0xD2E7FF,0x353874,0x384B76,0x576375
    ,0x09469D,0x0A48A7,0x1A55A8,0x2B69AD
    ,0x3671A8,0x496787,0x6678D0,0x7896B6
    ,0x5984C8,0x5799C7,0x9498C2,0x89ABCC
    ,0xA9B8C7,0x88ACE7,0x98B5E8,0x85A9FC
    ,0xB2B9F8,0xA8C7EC,0xC7D7F8,0x0A3575
    ,0x292E77,0x444676,0x2D528C,0x2B71B1
    ,0x55589A,0x67748C,0x686E97,0x5A6CD2
    ,0x4896CB,0xA09FB5,0xABA5D2,0xB2ABDA
    ,0xB3BBD3,0xD4CEDF,0xD5C8E8,0xC6C6F5
    ,0xE3DBEA,0x27385D,0x031D72,0x1D2B7B
    ,0x123079,0x29336D,0x23377B,0x3B4C69
    ,0x3C5377,0x434A5D,0x454C60,0x4D5463
    ,0x252B87,0x3A388F,0x105997,0x004EB2
    ,0x646A8C,0x767D95,0x474FAA,0x414EB6
    ,0x505BB2,0x677CEF,0x73869C,0x6C86BA
    ,0x9AA2A8,0xC1BDBC,0x818CCA,0x979ED3
    ,0x92B6D9,0x96A7E5,0xB1C5CE,0xACC1DC
    ,0xA8D2FE,0xB1DCFF,0xD8D5D8,0xE6E5DB
    ,0xC7D5E3,0xD9DAF1,0xE3DFF0,0xDBE2E3
    ,0x1D366D,0x282E6C,0x323F6B,0x2B407C
    ,0x6A5F70,0x3D6193,0x0D59B1,0x2C78AD
    ,0x635F8E,0x4E7399,0x535DA7,0x6982A0
    ,0x7E91AB,0x1D99E3,0xA09B9D,0xA6A99F
    ,0x8987DE,0x8CA3D6,0xB1ABF1,0xACC0C9
    ,0xBAD3ED,0xD4CFCE,0xD6D6C9,0xCAD2DA
    ,0xDECEF0,0xC9E6FF
};

static GUI_CONST_STORAGE GUI_LOGPALETTE Paldanish = {
  250,  /* number of entries */
  1,    /* Has transparency */
  &Colorsdanish[0]
};

static GUI_CONST_STORAGE unsigned char acdanish[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAD, 0xB9, 0xC0, 0x86, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6B, 0x07, 0x2F, 0x19, 0x7A, 0x78, 0x9C, 0x94, 0x21, 0x31, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x6B, 0x18, 0x23, 0x0D, 0x19, 0x78, 0x0C, 0x24, 0x6C, 0x31, 0x3A, 0xC1, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xDC, 0x46, 0xA3, 0x6A, 0x67, 0x0E, 0x07, 0x0D, 0x78, 0x48, 0x62, 0x24, 0x1A, 0x19, 0x4C, 0x28, 0x58, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x77, 0x39, 0x46, 0xA0, 0x0C, 0x0C, 0x0E, 0x04, 0x12, 0x24, 0xA7, 0x53, 0x8D, 0x2D, 0x0C, 0x2F, 0xBA, 0x19, 0x58, 0xE0, 0xE4, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x45, 0x73, 0x2B, 0x73, 0x2F, 0x19, 0x10, 0x2F, 0x23, 0x8B, 0x29, 0x33, 0xAB, 0xE7, 0x41, 0x69, 0xBD, 0x91, 0x81, 0x26, 0x39, 
        0x39, 0x39, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x2B, 0xEB, 0x92, 0x2B, 0x2B, 0x1E, 0x0C, 0x0C, 0x33, 0x10, 0x23, 0x1F, 0x07, 0x29, 0x06, 0x56, 0xBE, 0x58, 0x8E, 0x45, 0x81, 0x81, 0x46, 
        0x39, 0xD6, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0xA5, 0xD4, 0x07, 0x10, 0x41, 0x5D, 0x46, 0xAD, 0x31, 0xF9, 0x07, 0x55, 0x18, 0x07, 0x16, 0x0A, 0x37, 0xA7, 0xB1, 0x51, 0xA1, 0x5B, 0x91, 0xAC, 0x39, 
        0x64, 0xBC, 0x0C, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x3E, 0xE9, 0x71, 0x10, 0x2C, 0x58, 0x75, 0x63, 0x3E, 0x47, 0x0B, 0x28, 0x18, 0x0D, 0x0D, 0x32, 0x03, 0x98, 0x0B, 0x46, 0x26, 0x31, 0x6B, 0x27, 0xF2, 0x8F, 
        0x26, 0x4D, 0x30, 0x6D, 0x8C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x93, 0xF3, 0x5D, 0x41, 0x19, 0x0E, 0x0D, 0x0D, 0x63, 0x3E, 0x28, 0x36, 0x33, 0x18, 0x14, 0x07, 0x12, 0x16, 0x48, 0x37, 0x63, 0x65, 0x2E, 0x0E, 0x5D, 0x36, 0x25, 0x51, 0x5F, 
        0x19, 0x07, 0x10, 0x04, 0x18, 0x6B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0xD6, 0x46, 0x5F, 0x3A, 0x05, 0x19, 0x23, 0x60, 0x3E, 0x64, 0x13, 0x30, 0x07, 0x33, 0x04, 0x10, 0x02, 0x16, 0x48, 0x14, 0xA6, 0x87, 0x12, 0x0C, 0x9A, 0x13, 0x39, 0x8F, 0x19, 
        0x43, 0x07, 0x23, 0x04, 0x40, 0xE3, 0x4D, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0xC1, 0xA0, 0x5D, 0x0B, 0x40, 0x05, 0x08, 0x08, 0x30, 0x0B, 0xA4, 0x89, 0x08, 0x02, 0x54, 0x11, 0x04, 0xA3, 0x24, 0x0A, 0x63, 0x3E, 0x34, 0x24, 0x36, 0x04, 0x53, 0x30, 0xA6, 0x2B, 0x1A, 
        0x10, 0x04, 0x18, 0x18, 0x0E, 0x13, 0x13, 0xA8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xC2, 0x2B, 0x46, 0x43, 0x88, 0x35, 0x05, 0x60, 0x02, 0x3A, 0x5F, 0xD3, 0x91, 0x05, 0x40, 0x40, 0x04, 0x0C, 0x2E, 0x34, 0x07, 0x4A, 0x72, 0x12, 0x12, 0x5F, 0x13, 0x3A, 0x5D, 0x4A, 0x6D, 0x0C, 
        0x2E, 0x04, 0x04, 0x07, 0x68, 0x4C, 0x70, 0x30, 0x30, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC9, 0xB4, 0xA1, 0x5B, 0x98, 0x98, 0x31, 0x28, 0x36, 0x15, 0xA9, 0x8F, 0x05, 0x57, 0x02, 0x05, 0x08, 0x02, 0x05, 0x11, 0xEA, 0x75, 0x96, 0x16, 0x8B, 0x02, 0x0D, 0x11, 0xAE, 0x65, 0x50, 0x2C, 0x21, 
        0x33, 0x04, 0x04, 0x30, 0xC5, 0x4C, 0x13, 0x30, 0x28, 0x31, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x9F, 0x63, 0x73, 0x47, 0x4D, 0x9D, 0x50, 0x4B, 0x0B, 0x13, 0x13, 0xB2, 0xB3, 0x05, 0x05, 0x05, 0x05, 0x02, 0x08, 0x08, 0x54, 0x74, 0x27, 0x12, 0x24, 0x1F, 0x11, 0x02, 0x0D, 0x45, 0x65, 0x2C, 0x3A, 0x10, 
        0x21, 0x04, 0x28, 0xBA, 0xBB, 0x57, 0x70, 0x28, 0xBC, 0x4D, 0x31, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x4D, 0x64, 0x77, 0x0B, 0xBE, 0x6A, 0x2C, 0x70, 0x04, 0x40, 0x04, 0xC5, 0x69, 0x8E, 0x27, 0x05, 0x05, 0x05, 0x05, 0x02, 0x08, 0x1A, 0x14, 0x44, 0x12, 0x1B, 0x32, 0x0D, 0x02, 0x10, 0x1A, 0x65, 0x9E, 0x02, 0x11, 0x08, 
        0x08, 0xA8, 0x15, 0x30, 0x69, 0xE2, 0x72, 0x77, 0xDA, 0xD7, 0xBF, 0x0C, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x63, 0xC2, 0x3A, 0x0B, 0x39, 0x64, 0x58, 0x43, 0x49, 0x2C, 0x60, 0x4B, 0x04, 0x05, 0x69, 0x74, 0xD5, 0x89, 0x40, 0x11, 0x11, 0x02, 0x59, 0x09, 0x0B, 0x14, 0x14, 0x44, 0x0A, 0x03, 0x38, 0x16, 0x2E, 0x5F, 0x65, 0x4E, 0x02, 0x08, 0x02, 
        0x18, 0xCC, 0x88, 0x5D, 0x74, 0x76, 0xA6, 0x3F, 0x3F, 0xF4, 0x2B, 0x19, 0x0C, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x44, 0x10, 0x93, 0x3E, 0x45, 0x42, 0x04, 0x18, 0x1A, 0x52, 0x23, 0x67, 0x23, 0x08, 0x1E, 0xB3, 0x23, 0x02, 0x08, 0x11, 0x02, 0x0F, 0x48, 0x14, 0x0B, 0x9C, 0x06, 0x06, 0x20, 0x22, 0x38, 0x7D, 0x72, 0x4A, 0x75, 0x54, 0x54, 0xAF, 0x78, 
        0x04, 0x31, 0x69, 0x64, 0x51, 0x3F, 0x3F, 0xDB, 0x3F, 0xDF, 0x46, 0x0E, 0x15, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x77, 0x0D, 0x23, 0x64, 0x39, 0x8C, 0x27, 0x04, 0x14, 0x28, 0x15, 0x02, 0x40, 0x11, 0x08, 0xB3, 0xB2, 0x59, 0x0D, 0x02, 0x02, 0x02, 0x1F, 0x0B, 0x14, 0x0B, 0x9D, 0x7D, 0x7D, 0x06, 0x1D, 0x06, 0x7D, 0x2B, 0x2B, 0x15, 0x05, 0x15, 0x05, 0x55, 
        0x44, 0x0C, 0x5D, 0x51, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xDA, 0x39, 0x0E, 0x13, 0xE5, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x90, 0x5A, 0x27, 0x65, 0x4A, 0x9E, 0x4B, 0x28, 0x11, 0x02, 0x36, 0x13, 0x4C, 0x19, 0xCA, 0x74, 0x74, 0x36, 0x1D, 0x1D, 0x12, 0x21, 0x1B, 0x03, 0x1F, 0x4F, 0x3B, 0x3B, 0x34, 0x44, 0x4B, 0x0B, 0x06, 0x21, 0x1C, 0x2C, 0x02, 0x02, 0x12, 0x0D, 0x1A, 
        0x1A, 0xB5, 0x51, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xB6, 0x5E, 0xAA, 0x15, 0x13, 0x29, 0x29, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x9F, 0x99, 0x9E, 0x65, 0xB4, 0x87, 0x19, 0x28, 0x59, 0x02, 0x36, 0x15, 0xA6, 0x15, 0xCC, 0x74, 0x14, 0x36, 0x1D, 0x1B, 0x0A, 0x33, 0x38, 0x1B, 0x12, 0x1F, 0x21, 0x0A, 0x07, 0x44, 0x0B, 0xA2, 0x62, 0x62, 0x14, 0x2D, 0x03, 0x38, 0x16, 0x1F, 0x1A, 
        0x5F, 0xB8, 0xB8, 0x51, 0xDD, 0xDE, 0xB8, 0xF8, 0x1E, 0x6E, 0x53, 0x13, 0x60, 0x29, 0x28, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x27, 0xBD, 0x39, 0x39, 0x1A, 0x15, 0x04, 0x60, 0x08, 0x02, 0x5A, 0x90, 0x36, 0x54, 0x82, 0x82, 0x0D, 0x1F, 0x32, 0x06, 0x0A, 0x32, 0x03, 0x32, 0x03, 0x03, 0x09, 0x0F, 0x03, 0x1F, 0x09, 0x14, 0x0B, 0x1C, 0x44, 0x44, 0x20, 0x38, 0x21, 0x33, 0xB5, 
        0x51, 0xDD, 0xB6, 0xA4, 0x8E, 0xB5, 0xF5, 0x70, 0x28, 0x67, 0x04, 0x68, 0x7A, 0x68, 0x78, 0x43, 0x9A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x92, 0xD4, 0x8F, 0x26, 0x13, 0x15, 0x0E, 0x12, 0x0D, 0x02, 0x8C, 0x90, 0x14, 0x70, 0x90, 0x27, 0x12, 0x1F, 0xE6, 0x06, 0x20, 0x7B, 0x1D, 0x32, 0x03, 0x1B, 0x0F, 0x03, 0x02, 0x0F, 0x02, 0x09, 0x37, 0x0B, 0x0A, 0x5C, 0x0A, 0x03, 0x33, 0x1C, 0x51, 
        0x51, 0xB6, 0x8F, 0x41, 0x27, 0x77, 0x77, 0x52, 0x1A, 0x8B, 0x2E, 0x24, 0x12, 0x1A, 0x2F, 0x43, 0x15, 0x26, 0x00, 0x00, 0x00,
  0x73, 0x46, 0x2B, 0x0B, 0x10, 0x12, 0x07, 0x2D, 0xB0, 0x8D, 0x9D, 0x32, 0x24, 0x1A, 0x0B, 0x14, 0x2C, 0x02, 0x02, 0x07, 0x5E, 0x03, 0x02, 0x0F, 0x03, 0x02, 0x03, 0x1C, 0x03, 0x09, 0x09, 0x09, 0x09, 0x1D, 0x1B, 0x0B, 0x0A, 0x3D, 0x06, 0x8C, 0x76, 0x3E, 
        0xB7, 0xA3, 0x07, 0x2C, 0x4B, 0x3E, 0x2B, 0x0E, 0x11, 0x54, 0x40, 0x02, 0x02, 0x11, 0x11, 0x0C, 0x0C, 0x66, 0x00, 0x00, 0x00,
  0xBF, 0x2B, 0x63, 0x10, 0x78, 0x68, 0x10, 0x8D, 0x50, 0x5C, 0x56, 0x34, 0x16, 0x2D, 0x1C, 0x0B, 0x2D, 0x02, 0x12, 0x24, 0x14, 0x02, 0x1F, 0x09, 0x6F, 0x1B, 0x5E, 0x0F, 0x03, 0x09, 0x03, 0x09, 0x09, 0x03, 0x1D, 0x8D, 0x1C, 0x3D, 0x06, 0x45, 0x76, 0x3E, 
        0x63, 0x9C, 0x3A, 0x6A, 0x2C, 0x4A, 0x72, 0x11, 0x0E, 0x67, 0x35, 0x08, 0x02, 0x08, 0x02, 0x04, 0x0C, 0x66, 0x26, 0x00, 0x00,
  0x46, 0x83, 0x41, 0x0E, 0x04, 0x68, 0x95, 0x12, 0x23, 0x4C, 0x35, 0x58, 0x0B, 0x0B, 0x07, 0x0D, 0x02, 0x37, 0x0B, 0x14, 0x2E, 0x09, 0x0F, 0x2A, 0x03, 0x09, 0x09, 0x14, 0x12, 0x09, 0x03, 0x09, 0x2A, 0x02, 0x03, 0x1F, 0x0A, 0x50, 0x0B, 0x4A, 0x2B, 0x14, 
        0x2D, 0x55, 0x60, 0xA8, 0x0B, 0x84, 0x41, 0x29, 0x19, 0x2F, 0x2F, 0x28, 0x19, 0x08, 0x08, 0x11, 0x02, 0x10, 0x07, 0xF6, 0x00,
  0xA0, 0x0B, 0x43, 0x02, 0x40, 0x16, 0x02, 0x02, 0x0D, 0xCB, 0x54, 0x27, 0x83, 0x48, 0x1A, 0x02, 0x1F, 0x5E, 0x1C, 0x55, 0x0E, 0x2A, 0x09, 0x2A, 0x09, 0x03, 0x03, 0xD9, 0x12, 0x09, 0x03, 0x03, 0x03, 0x03, 0x0F, 0x1F, 0x03, 0x50, 0x5F, 0x4A, 0xB2, 0x2D, 
        0x50, 0x04, 0x18, 0x58, 0x85, 0xD3, 0x69, 0x2C, 0x53, 0x33, 0x0C, 0x0E, 0x10, 0x2E, 0x12, 0x11, 0x08, 0x07, 0x07, 0x26, 0x00,
  0x81, 0x04, 0x33, 0x10, 0x12, 0x12, 0x55, 0x3B, 0x3B, 0x31, 0x4D, 0x2B, 0x84, 0x08, 0x08, 0x21, 0x0A, 0x1C, 0x1A, 0x02, 0x02, 0x6F, 0x2A, 0x2A, 0x2A, 0x1D, 0x03, 0x2A, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1B, 0x03, 0x16, 0x02, 0x82, 0xA5, 0x1C, 0x62, 0x02, 
        0x08, 0x10, 0x23, 0xA9, 0x3E, 0x7A, 0x0E, 0x21, 0x2D, 0x56, 0x71, 0x06, 0xAB, 0x56, 0x56, 0x06, 0x6C, 0x0D, 0x10, 0x25, 0x51,
  0x81, 0x2F, 0x18, 0x23, 0x23, 0x0D, 0x08, 0x04, 0x23, 0x53, 0x0B, 0x84, 0x86, 0x08, 0x02, 0x3B, 0x0A, 0x07, 0x07, 0x02, 0x09, 0x03, 0x03, 0x6F, 0x03, 0x1D, 0x03, 0x03, 0x2A, 0x2A, 0x6F, 0x03, 0x03, 0x03, 0x0F, 0x16, 0x02, 0x9B, 0xA5, 0x0A, 0x0A, 0x1F, 
        0x02, 0x3B, 0x14, 0x1E, 0x76, 0x2F, 0x07, 0x37, 0x2D, 0x71, 0x71, 0x2D, 0x97, 0x56, 0xB0, 0x06, 0x06, 0x07, 0x24, 0x25, 0x39,
  0x5A, 0x07, 0x2F, 0x04, 0x0E, 0x0E, 0x14, 0x07, 0x0D, 0x42, 0x75, 0x0B, 0x0C, 0x0C, 0x48, 0x0B, 0x71, 0x0E, 0x02, 0x0F, 0x09, 0x6F, 0x03, 0x03, 0x03, 0x1B, 0x0F, 0x2A, 0x03, 0x02, 0x09, 0x03, 0x2A, 0x02, 0x03, 0x1D, 0x0F, 0x49, 0xA1, 0x1C, 0x34, 0x1C, 
        0x06, 0x05, 0x05, 0x84, 0x45, 0x16, 0x38, 0x1D, 0x1B, 0x2D, 0x21, 0x22, 0x56, 0x06, 0x56, 0x3C, 0x62, 0x20, 0x6C, 0x27, 0x2B,
  0x99, 0x10, 0x28, 0x04, 0x04, 0x68, 0x0D, 0x0D, 0x0E, 0x83, 0x45, 0x13, 0x0C, 0x70, 0x14, 0x5C, 0x2C, 0x12, 0x0D, 0x03, 0x1B, 0x0F, 0x03, 0x09, 0x2A, 0x0A, 0x0F, 0x09, 0x2A, 0x03, 0x09, 0x03, 0x0F, 0x03, 0x09, 0x0F, 0x0F, 0x0B, 0x0B, 0x1C, 0x22, 0x24, 
        0x16, 0x11, 0x05, 0x45, 0x7C, 0x21, 0x0F, 0x0F, 0x0F, 0x97, 0x2D, 0x06, 0x61, 0x06, 0x06, 0x3D, 0x3C, 0x0A, 0x7B, 0xC8, 0x1E,
  0x6D, 0x6A, 0x29, 0x07, 0x04, 0x0E, 0x0E, 0x2C, 0x3A, 0x4B, 0x0B, 0x3A, 0x53, 0x14, 0x37, 0x16, 0x1B, 0x1D, 0x0F, 0x1B, 0x03, 0x03, 0x09, 0x02, 0x09, 0x15, 0xCD, 0x1F, 0x1F, 0x0F, 0x09, 0x03, 0x03, 0x09, 0x09, 0x12, 0x3B, 0xB0, 0x06, 0x22, 0x62, 0x02, 
        0x08, 0x54, 0x15, 0x1C, 0x2C, 0x16, 0x6C, 0x40, 0x18, 0x10, 0x2E, 0x10, 0x5C, 0x06, 0x06, 0x06, 0x06, 0x03, 0x1D, 0xAC, 0x83,
  0xAD, 0x0C, 0xAA, 0x04, 0x23, 0x10, 0x07, 0x1A, 0x14, 0xA2, 0xCF, 0x9C, 0x5E, 0x37, 0x1A, 0x32, 0x32, 0x03, 0x1B, 0x32, 0x32, 0x09, 0x09, 0x02, 0x03, 0x85, 0x85, 0x3B, 0x4F, 0x03, 0x0F, 0x03, 0x03, 0x09, 0x02, 0x12, 0x0A, 0x0A, 0x3D, 0x0A, 0x6C, 0x08, 
        0x0D, 0x40, 0xAF, 0x29, 0x37, 0x6C, 0x7B, 0x18, 0x55, 0x67, 0x04, 0x16, 0x94, 0x06, 0x3C, 0x06, 0x06, 0x1D, 0x0F, 0x42, 0xD2,
  0x66, 0x29, 0x07, 0x10, 0x24, 0x2E, 0x02, 0x7C, 0x45, 0x9B, 0x5B, 0xA5, 0x9F, 0x02, 0x1F, 0x21, 0x06, 0x34, 0x16, 0x09, 0x03, 0x03, 0x03, 0x2D, 0x49, 0x0A, 0x1F, 0xA3, 0x4F, 0x02, 0x1B, 0x03, 0x03, 0x6F, 0x03, 0x2E, 0x14, 0x5C, 0x22, 0x0A, 0x24, 0x16, 
        0x12, 0x5B, 0x4B, 0x16, 0x1F, 0x48, 0x04, 0x85, 0x88, 0x43, 0xCA, 0x2C, 0x1A, 0x18, 0x2E, 0x21, 0x38, 0x16, 0x16, 0x27, 0xD2,
  0x00, 0x29, 0xC6, 0x96, 0x24, 0x8B, 0x11, 0x4E, 0x45, 0x47, 0x4B, 0x45, 0x72, 0x02, 0x16, 0x6C, 0x34, 0x38, 0x3B, 0x2A, 0x03, 0x03, 0x0F, 0x2D, 0x1C, 0x0F, 0x02, 0x02, 0x4F, 0x02, 0x03, 0x1D, 0x1D, 0x6F, 0x2A, 0x2E, 0x14, 0x22, 0x44, 0x21, 0x06, 0x12, 
        0x38, 0xA2, 0x73, 0x16, 0x95, 0x0E, 0x4B, 0xC4, 0xF0, 0x4C, 0x13, 0x13, 0x1A, 0x0E, 0x23, 0x94, 0x0D, 0x38, 0x0F, 0x41, 0x27,
  0x00, 0x1A, 0x0C, 0x2F, 0x2F, 0x11, 0x0D, 0x4A, 0x9F, 0xB4, 0x46, 0x10, 0x2E, 0x21, 0x16, 0xAB, 0x21, 0x06, 0x06, 0x38, 0x16, 0x09, 0x2A, 0x0F, 0x09, 0x5E, 0x03, 0x02, 0x03, 0x1B, 0x1B, 0x03, 0x03, 0x03, 0x1B, 0x34, 0x1C, 0x20, 0x1D, 0x4F, 0x1F, 0x52, 
        0x43, 0x1C, 0x07, 0x37, 0xD9, 0x12, 0x0D, 0xAF, 0x35, 0x2E, 0x04, 0x15, 0x55, 0x11, 0x11, 0x02, 0x05, 0x10, 0x2F, 0x89, 0x1E,
  0x00, 0x37, 0x29, 0x0E, 0x07, 0x04, 0x55, 0xD7, 0x86, 0xDC, 0xCE, 0x18, 0x5F, 0x38, 0x24, 0x0A, 0x06, 0x06, 0x06, 0x0A, 0x38, 0x03, 0x2A, 0x03, 0x0F, 0x03, 0x1B, 0x02, 0x09, 0x1B, 0x02, 0x1B, 0x1B, 0x1B, 0x0A, 0x0A, 0x06, 0x06, 0x61, 0x59, 0x08, 0x0C, 
        0x75, 0x33, 0x33, 0x4B, 0x29, 0x94, 0x24, 0x08, 0x0E, 0x08, 0x19, 0x36, 0x15, 0x02, 0x02, 0x08, 0x08, 0x18, 0x19, 0x27, 0x1E,
  0x00, 0x6D, 0x99, 0x07, 0x04, 0x53, 0x4B, 0x73, 0x4A, 0x75, 0x6B, 0x40, 0x04, 0x34, 0x21, 0x0D, 0x38, 0x1D, 0x32, 0x20, 0x0A, 0x1D, 0x1D, 0x1B, 0x1B, 0x54, 0x02, 0x09, 0x02, 0x0F, 0x0F, 0x16, 0x16, 0x32, 0x32, 0x06, 0x32, 0x1F, 0x0F, 0x7B, 0x11, 0x82, 
        0x4A, 0x1A, 0x2E, 0x0E, 0x18, 0x05, 0x35, 0x48, 0x19, 0x04, 0x18, 0x67, 0x04, 0x13, 0x15, 0x04, 0x2F, 0x42, 0x42, 0x8A, 0x1E,
  0x00, 0x9B, 0x5A, 0x10, 0x07, 0x6B, 0xA2, 0xEC, 0x4A, 0x47, 0x5B, 0x40, 0x0E, 0x07, 0x2D, 0x16, 0x0D, 0xC7, 0x1D, 0x1D, 0x38, 0x20, 0x22, 0x22, 0x03, 0x4F, 0x02, 0x09, 0x02, 0x2A, 0x03, 0x4F, 0x0A, 0x32, 0x06, 0x06, 0x7D, 0x02, 0x02, 0x11, 0x02, 0x4A, 
        0x8C, 0x5E, 0x10, 0x04, 0x02, 0x15, 0x60, 0x36, 0xBB, 0x04, 0x0E, 0x04, 0x35, 0x4C, 0x1A, 0x2F, 0x07, 0x4E, 0x82, 0x1E, 0x26,
  0x00, 0x00, 0x25, 0x37, 0x3A, 0x82, 0x72, 0x46, 0x81, 0x04, 0x02, 0x23, 0x59, 0x07, 0x23, 0x3B, 0x0D, 0x59, 0x02, 0x0A, 0x20, 0x1C, 0x5E, 0x22, 0x0A, 0x5C, 0x5C, 0x5B, 0xD8, 0x20, 0x20, 0x06, 0x20, 0x4F, 0x03, 0x02, 0x0F, 0x11, 0x11, 0x30, 0x41, 0xA1, 
        0x76, 0x35, 0x05, 0x57, 0x88, 0x05, 0x05, 0x08, 0x08, 0x05, 0x19, 0x1A, 0x29, 0x6A, 0x6A, 0x30, 0x52, 0x8A, 0x1E, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2C, 0x37, 0x65, 0xA9, 0x46, 0x87, 0x02, 0x67, 0x08, 0x08, 0x10, 0x24, 0x4F, 0x23, 0x4F, 0x14, 0x0A, 0x06, 0x1C, 0x9D, 0x3D, 0x1C, 0x22, 0x14, 0xD8, 0x49, 0x20, 0x20, 0x61, 0x1D, 0x0F, 0x0F, 0x02, 0x11, 0x08, 0x05, 0x0B, 0x74, 0x4D, 
        0x0B, 0x05, 0x57, 0x88, 0x79, 0x05, 0x57, 0x79, 0x05, 0x4C, 0x0E, 0x4D, 0x48, 0x31, 0x29, 0x69, 0x43, 0x1E, 0x26, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x66, 0xC3, 0x3E, 0x3E, 0x8E, 0x89, 0x18, 0x18, 0x4D, 0x29, 0x35, 0x08, 0x68, 0x21, 0x7D, 0x0A, 0x0B, 0x49, 0x06, 0x3D, 0x3D, 0x3D, 0x49, 0x49, 0x80, 0x80, 0x20, 0x03, 0x1F, 0x02, 0x02, 0x02, 0x05, 0x02, 0x27, 0x52, 0x1E, 0x2B, 0x05, 
        0x05, 0x05, 0xCD, 0x13, 0x05, 0x13, 0x54, 0x19, 0x13, 0x7A, 0x28, 0x0C, 0x0C, 0x47, 0x7C, 0xB9, 0x4E, 0x25, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x66, 0x3E, 0x39, 0xAC, 0xE1, 0x04, 0x04, 0x0B, 0x4B, 0x0E, 0x11, 0x3B, 0x3B, 0x1C, 0x0A, 0x49, 0x44, 0x06, 0x22, 0x80, 0x22, 0x50, 0x49, 0x50, 0x3D, 0x03, 0x1D, 0x0F, 0x0F, 0x59, 0x59, 0x05, 0x85, 0x90, 0xF1, 0x42, 0xA4, 0x05, 
        0x05, 0x02, 0x05, 0x35, 0x35, 0x13, 0x70, 0x4C, 0x19, 0x19, 0x19, 0x0C, 0x31, 0x47, 0x0B, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x25, 0x4E, 0x99, 0x3A, 0x29, 0x15, 0x15, 0x0D, 0x8B, 0x1A, 0x48, 0x20, 0x0A, 0x5E, 0x0B, 0x1C, 0x3C, 0x3C, 0x3C, 0x7F, 0x7F, 0x17, 0x3C, 0x17, 0x61, 0x03, 0x02, 0x0D, 0x02, 0x07, 0x07, 0x2F, 0x0D, 0x18, 0x05, 0x8E, 0x91, 0x35, 
        0x79, 0x05, 0x05, 0x05, 0x57, 0x15, 0x79, 0x13, 0x30, 0x7C, 0x42, 0x25, 0x1E, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x5A, 0x31, 0x19, 0x30, 0x19, 0x08, 0x23, 0x0E, 0x0B, 0x0A, 0x03, 0x37, 0x49, 0x56, 0x3D, 0x3C, 0x17, 0x7F, 0x7F, 0x3C, 0x17, 0x17, 0x20, 0x20, 0x03, 0x1F, 0x14, 0x14, 0x29, 0x24, 0x97, 0x05, 0x18, 0xB7, 0x89, 0x05, 
        0x05, 0x05, 0x79, 0x79, 0x35, 0x35, 0x15, 0x43, 0x15, 0x27, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x53, 0x47, 0x10, 0x10, 0x0C, 0x11, 0x48, 0x55, 0x0A, 0x8D, 0x49, 0x71, 0x3C, 0x22, 0x3D, 0x3C, 0x49, 0x80, 0x17, 0x17, 0x17, 0x20, 0x12, 0x7B, 0x33, 0x33, 0x02, 0x08, 0x13, 0x04, 0x83, 0x52, 0x1C, 0x28, 0xC4, 
        0x57, 0x4C, 0x05, 0x15, 0x13, 0x58, 0x41, 0x8A, 0x1E, 0xB1, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x31, 0x10, 0x07, 0x0E, 0x04, 0x0B, 0x04, 0x5C, 0x24, 0x80, 0x71, 0x22, 0x22, 0x7F, 0x22, 0x3D, 0x50, 0x17, 0x3C, 0x17, 0x3C, 0x0A, 0x08, 0x96, 0x0D, 0x2E, 0x57, 0x18, 0x04, 0x30, 0x5D, 0x18, 0x18, 0x36, 
        0x57, 0x13, 0x15, 0x52, 0x19, 0x41, 0x6E, 0x25, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x4E, 0x2C, 0x29, 0x7A, 0x12, 0x34, 0x21, 0x43, 0xA4, 0x96, 0x0A, 0x3D, 0x7F, 0x17, 0x7E, 0x17, 0x17, 0x17, 0x7E, 0x22, 0x17, 0x0A, 0x95, 0x0E, 0x44, 0x0E, 0x60, 0x4C, 0xCB, 0x92, 0x76, 0x04, 0x04, 0x28, 
        0x13, 0x2C, 0x29, 0x7C, 0x7C, 0x25, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x2C, 0x98, 0x7A, 0x21, 0x3B, 0x34, 0x27, 0x85, 0x2D, 0x34, 0x22, 0x22, 0x7E, 0x61, 0x61, 0x20, 0x7E, 0x17, 0x17, 0x22, 0x0A, 0x0D, 0x33, 0x10, 0x0E, 0x19, 0x13, 0x13, 0x42, 0x84, 0x0E, 0x04, 0x15, 
        0x15, 0x0C, 0x0C, 0x27, 0x9B, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0xCE, 0xA7, 0x37, 0x56, 0x34, 0xD5, 0x41, 0x97, 0x06, 0x3D, 0x1C, 0x20, 0x61, 0x09, 0x03, 0x7E, 0x17, 0x3C, 0x17, 0x34, 0x7B, 0x36, 0x5D, 0x12, 0x0D, 0x35, 0x11, 0x84, 0x92, 0x2E, 0x0D, 0x6E, 
        0x5B, 0x93, 0x8A, 0x25, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x6A, 0x0C, 0x2D, 0xC6, 0x75, 0x42, 0x5C, 0x44, 0x50, 0x80, 0x17, 0xED, 0x03, 0x0A, 0x17, 0x7E, 0x17, 0x61, 0x21, 0x95, 0x0C, 0x36, 0x59, 0x12, 0x11, 0x08, 0x76, 0x42, 0x07, 0x12, 0x47, 
        0x47, 0xC9, 0x1E, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x5A, 0x44, 0x07, 0x14, 0x24, 0xE8, 0x3E, 0x62, 0x06, 0x20, 0x20, 0x17, 0x22, 0x17, 0x22, 0x0A, 0x1B, 0x02, 0x35, 0x12, 0x0D, 0x0D, 0x04, 0x6B, 0x6E, 0x50, 0xAA, 0x6E, 0x52, 0x25, 
        0x25, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x37, 0x1A, 0x21, 0x07, 0xB7, 0x9E, 0x2D, 0x62, 0x06, 0x17, 0x20, 0x17, 0x17, 0x17, 0x03, 0xC7, 0x11, 0x05, 0x02, 0x11, 0x0E, 0x23, 0x41, 0x45, 0x31, 0x31, 0x43, 0x0B, 0x1E, 
        0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x6D, 0x6E, 0x6E, 0x5F, 0x31, 0x0C, 0x3B, 0x34, 0x0A, 0x1C, 0x1C, 0x4F, 0x16, 0x2E, 0x30, 0x18, 0x0E, 0x11, 0x04, 0x28, 0x04, 0x42, 0x45, 0x6D, 0xC8, 0xEE, 0xEF, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x9A, 0x9A, 0x5B, 0x53, 0x2F, 0x10, 0x24, 0x34, 0x14, 0x33, 0x1B, 0x0F, 0x19, 0x13, 0x18, 0x15, 0x08, 0x02, 0x15, 0x13, 0xAE, 0x42, 0xAE, 0x1E, 0x26, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x6D, 0x5B, 0x41, 0x30, 0x1A, 0x0C, 0x0C, 0x4D, 0x4D, 0x28, 0x30, 0x04, 0x10, 0x0C, 0x0C, 0x27, 0x27, 0x1E, 0x25, 0x26, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x3A, 0x52, 0x52, 0x1A, 0x0C, 0x31, 0x3A, 0x36, 0x1A, 0x48, 0x55, 0x0C, 0x07, 0x47, 0xCF, 0xD0, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x77, 0xD1, 0x26, 0x26, 0x25, 0x8A, 0x25, 0xB1, 0x25, 0x25, 0x66, 0x25, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmdanish = {
  63, /* XSize */
  58, /* YSize */
  63, /* BytesPerLine */
  8, /* BitsPerPixel */
  acdanish,  /* Pointer to picture data (indices) */
  &Paldanish   /* Pointer to palette */
};

/* *** End of file *** */
