/*********************************************************************
*                SEGGER MICROCONTROLLER GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 2003-2012     SEGGER Microcontroller GmbH & Co KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

----------------------------------------------------------------------
File    : Main.c
Purpose : Calls hardware initialization and application.
--------  END-OF-HEADER  ---------------------------------------------
*/
#include <stdio.h>
#ifndef _WINDOWS
//AR #include "lpc_i2c.h"
//AR #include "lpc_pinsel.h"
//AR #include "CLRC663.h"
#endif
#include "emwin/DIALOG.h"
#include "BlueboardPOS.h"
#include <stdlib.h>

#ifdef __CROSSWORKS_ARM
extern void __low_level_init(); // hwconf.c
#endif

WM_HWIN hWinOrderEntry;         /* Main dialog */
WM_HWIN hWinSwipeCard;          /* Dialog display when user must swipe Mifare card */
WM_HWIN hWinLastWindow;         /* Saves which windows was displayed last */
WM_HWIN hWinCurrentWindow;  /* Current displayed window */
WM_HWIN hWinCallBack;               /* Used for callback */

uint32_t Credit;                        /* Credit on card */
uint8_t RFID_Cancelled;         /* Flag, set it user hit Cancel button of SwipeCard dialog before card was swiped */

void ShowWindow(WM_HWIN window)
{
    hWinLastWindow = hWinCurrentWindow;
    hWinCurrentWindow = window;

    WM_HideWindow(hWinOrderEntry);
    WM_HideWindow(hWinSwipeCard);
    WM_ShowWindow(window);
}

void ShowLastWindow(void)
{
    ShowWindow(hWinLastWindow);
}

void MainTask(void);  // Defined in SEGGERDEMO.c
void displayTotal(WM_HWIN hWin);
WM_HWIN GetCallbackHandle(void);


/*********************************************************************
*
*       main()
*/
void MainTask(void);
void MainTask(void)
{
    uint32_t Buttons;
    uint32_t PrevButtons = 0;
    uint32_t IncVal = 1000;
    uint32_t InitVal = 0;
    
  GUI_Init();

    /* Set skinning */
  BUTTON_SetDefaultSkin   (BUTTON_SKIN_FLEX);
  CHECKBOX_SetDefaultSkin (CHECKBOX_SKIN_FLEX);
  DROPDOWN_SetDefaultSkin (DROPDOWN_SKIN_FLEX);
  FRAMEWIN_SetDefaultSkin (FRAMEWIN_SKIN_FLEX);
  HEADER_SetDefaultSkin   (HEADER_SKIN_FLEX);
  PROGBAR_SetDefaultSkin  (PROGBAR_SKIN_FLEX);
  RADIO_SetDefaultSkin    (RADIO_SKIN_FLEX);
  SCROLLBAR_SetDefaultSkin(SCROLLBAR_SKIN_FLEX);
  SLIDER_SetDefaultSkin   (SLIDER_SKIN_FLEX);
  //
  // Set some further defaults
  //
  WIDGET_SetDefaultEffect(&WIDGET_Effect_3D);
  FRAMEWIN_SetDefaultFont(GUI_FONT_20_ASCII);
  FRAMEWIN_SetDefaultTextAlign(GUI_TA_HCENTER);

    /* Create windows */
  hWinOrderEntry = CreateOrderEntry();
    hWinSwipeCard = CreateSwipeCard();
    WM_EnableMemdev(hWinOrderEntry);
    hWinCallBack = GetCallbackHandle();

  ShowWindow(hWinOrderEntry);

#if 0 // AR  

#ifndef _WINDOWS
    if(InitCLRC663())
    {
        WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_INIT_ERR);
        ShowWindow(hWinSwipeCard);
    }
#endif      /* _WINDOWS */
    while(1) {
#ifndef _WINDOWS
        /* Check if any of the joystick buttons has been pressed */
        Buttons = LPC_GPIO2->PIN;
        if(!(Buttons & (1<<22)) && (PrevButtons & (1<<22)))
        {
                if(!MifareExecute(InitCard_CMD, &InitVal))
                {
                    WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Reset_OK);
                    ShowWindow(hWinSwipeCard);
                    GUI_Delay(500);
                    WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Swipe);
                    ShowLastWindow();
                }
        }
        if(!(Buttons & (1<<27)) && (PrevButtons & (1<<27)))
        {
            if(!MifareExecute(IncCredit_CMD, &IncVal))
            {
                WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Increment_OK);
                ShowWindow(hWinSwipeCard);
                GUI_Delay(500);
                WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Swipe);
                ShowLastWindow();
            }
        }
        
        PrevButtons = Buttons;
#endif      /* _WINDOWS */
    GUI_Delay(10);
  }
  
#endif // AR  
  
}
