/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap converter for emWin V5.16.                           *
*        Compiled Jun  4 2012, 15:48:30                              *
*        (C) 1998 - 2010 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: newspaper                                             *
* Dimensions:  77 * 74                                               *
* NumColors:   246                                                   *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR Colorsnewspaper[] = {
     0xFFFFFF,0x000000,0x0A0400,0xEAE2DA
    ,0xD2C9BB,0xFDFDFC,0xE3DED9,0xE5E0DA
    ,0xCDC5BA,0xE4DDD5,0xA99A85,0xCBC4B5
    ,0xEAE1D5,0xD1C6B9,0xAA9A7C,0xD3C9B4
    ,0xB29D84,0xB4A387,0x120600,0xCDC8BA
    ,0xD1C6B5,0x120900,0xE9DED4,0xDCDBDB
    ,0x1A0B00,0xDCCCB3,0xEBD3AB,0x9A9488
    ,0x0D0901,0xDACCBA,0x000109,0xFEFDF5
    ,0xE9DEDB,0xE6E1D5,0xCDC8B5,0xF4FBFE
    ,0xE4CDAC,0xD3CBC1,0xEAE4E1,0xCBC6C3
    ,0xF3E2C8,0x191307,0xE4D1AC,0x220C00
    ,0xDDD9D4,0xECDBC2,0xB4A897,0xC5BAA8
    ,0xDBCAAD,0xE3D2BB,0xF2E4D4,0xDBD5CC
    ,0xE2DACD,0xF1DCC5,0xB19B7C,0xB4ACA4
    ,0xC6B499,0xF2D3AB,0xE2D2B4,0xE4DAC3
    ,0xE3DEE1,0xE4E1E1,0xBAB3A8,0xEBD2A3
    ,0xF1D4A4,0x2C1200,0xB3A07E,0x898888
    ,0xE8CDAB,0xF5DCB9,0x1A1717,0xA8A498
    ,0xEBD2B3,0xDBD5D2,0xF4F4F4,0x0D0C0C
    ,0x241C14,0x2B2824,0x575553,0x797675
    ,0xC3BDB6,0xE5CDA4,0xE2CDB2,0xDBD3C3
    ,0xF1E5D8,0x746959,0x676666,0x928C85
    ,0xA79C91,0xACA085,0x332A1B,0x898278
    ,0x979695,0xABA8A5,0xC3C1B3,0xEBDABD
    ,0xDCDCE2,0x231301,0x311400,0x393635
    ,0x474239,0x77726B,0xC5C2BB,0xF1D8A3
    ,0xEAE1C9,0x1A0700,0x312A25,0x3C3324
    ,0x42392B,0x544C44,0x635C57,0x746B63
    ,0x837A6C,0xCDC1A8,0xD8C7B9,0xEACEB2
    ,0xD0C4C3,0xE3D5C2,0x140D0B,0x0C1111
    ,0x2B0E00,0x241A0D,0x433E39,0x696258
    ,0x857D72,0xAEA07E,0xB8B9B6,0xC0AE95
    ,0xECD19D,0xDAD2BD,0xE0CCB8,0xE5D9BD
    ,0xDEE0DB,0xF2E8DC,0xF4F4FB,0x0F100C
    ,0x292114,0x1E1F21,0x2C2D32,0x4D4C4B
    ,0x575148,0x645648,0x696E71,0x938A7E
    ,0x9C937D,0xB9B19C,0xC1A685,0xD4BC99
    ,0xD5CCAF,0xDAC6B2,0xDCD0B5,0xD7D3BE
    ,0xE9D4BB,0xDACDC4,0xD5D2CD,0xDDDBCB
    ,0xD4D2D2,0xD6D6DB,0xE0D7CF,0xE9DCCB
    ,0xE9DDE0,0xEDE9E4,0xF9F7FD,0x262316
    ,0x2A2219,0x3B342E,0x464646,0x494241
    ,0x514E50,0x5D5C63,0x726D6E,0x837E7D
    ,0xA6865E,0x9A8964,0xB39D76,0xB89A7D
    ,0xB6A177,0xCCB388,0xBEC0BA,0xE4C898
    ,0xF6D79E,0xD3C1A7,0xD2C4AC,0xDCC6AA
    ,0xF2CEA7,0xF9DAA4,0xFED9A9,0xECD9B5
    ,0xF1E0BF,0xD5CEC8,0xDDD9C4,0xE8D7C9
    ,0xFFFCCD,0xEFEAD7,0xEEE8DE,0xF6E8D3
    ,0xE2E4ED,0xF7EAE6,0xFDF4EE,0xE3ECF1
    ,0x0D0708,0x21170F,0x3C2201,0x21201C
    ,0x2C2F1A,0x3A3017,0x161F24,0x473309
    ,0x513F29,0x6F5430,0x46454C,0x796549
    ,0x79715E,0x6C747B,0x8B704B,0x84705A
    ,0xAB926D,0xC4A67B,0xCDAE7B,0xA0A2B1
    ,0xAFAAB1,0xB4AFB0,0xAFB3B3,0xDBC194
    ,0xF1CC9C,0xDFC5A4,0xDFD8BB,0xE8C4A0
    ,0xF8D3A3,0xF2D9AE,0xBBBEC0,0xD1C3C8
    ,0xCBCFD6,0xDACCD1,0xE0CECA,0xE1D4D0
    ,0xFFF1C7,0xFFF1CC,0xF8E7DB,0xD7D7E2
    ,0xD6D8E7,0xDEE0E0,0xFFFFE7,0xF3F0ED
    ,0xFFF8EC,0xEDF4F9
};

static GUI_CONST_STORAGE GUI_LOGPALETTE Palnewspaper = {
  246,  /* number of entries */
  1,    /* Has transparency */
  &Colorsnewspaper[0]
};

static GUI_CONST_STORAGE unsigned char acnewspaper[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x24, 0x24, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xB9, 0x30, 0x30, 0x24, 0x30, 0x02, 0x02, 0x24, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0xBF, 0x72, 0x3F, 0x1A, 0x80, 0xDA, 0x18, 0x18, 0x2B, 0x2B, 0x02, 0x02, 0x2B, 0x24, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x51, 0x51, 0x1A, 0x2A, 0x1A, 0x01, 0x02, 0x1E, 0x01, 0x02, 0x02, 0x1E, 0x01, 0xDC, 0x01, 0x01, 0x01, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x75, 0x1D, 0x24, 0x24, 
        0x1A, 0xD8, 0x41, 0x2B, 0x61, 0x18, 0x01, 0x01, 0x01, 0x1E, 0x49, 0x06, 0x60, 0xEF, 0x3C, 0xC4, 0x89, 0x01, 0x41, 0x67, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x51, 0x3A, 0x3A, 0x14, 0x04, 0x01, 0x01, 
        0x01, 0x01, 0x1E, 0x01, 0x01, 0x02, 0x5B, 0xC2, 0x0C, 0x0C, 0x03, 0x20, 0x03, 0x09, 0x20, 0x1F, 0x05, 0x02, 0x01, 0x01, 0x30, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBC, 0x2A, 0x2A, 0x2A, 0x1A, 0xB0, 0x18, 0x18, 0x12, 0x12, 0x01, 0x01, 
        0x1E, 0x01, 0x17, 0x60, 0x17, 0x84, 0x21, 0x0C, 0x0C, 0x0C, 0x16, 0x05, 0x1F, 0x05, 0x05, 0x05, 0x1F, 0x05, 0x1E, 0x01, 0x18, 0x2A, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x3F, 0x51, 0x1A, 0x25, 0xA4, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x03, 
        0x0C, 0x09, 0x03, 0x21, 0x03, 0x03, 0x3C, 0x05, 0x05, 0x05, 0x23, 0x23, 0x05, 0x1C, 0x23, 0x23, 0x05, 0x05, 0x23, 0x01, 0x02, 0x02, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x3A, 0x1A, 0x1A, 0x51, 0x51, 0x61, 0x2B, 0x02, 0x02, 0x02, 0x01, 0x01, 0x1E, 0x17, 0x17, 0x07, 0x09, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0xA2, 0x1E, 0xD5, 0x01, 0x02, 0x23, 0x23, 0x05, 0x05, 0x23, 0x23, 0x02, 0x02, 0x51, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x19, 0x3A, 0x08, 0xA5, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x01, 0x4B, 0x03, 0x20, 0x0C, 0x54, 0x34, 0x03, 0x07, 0x06, 0x3D, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1E, 0xD2, 0x05, 0x1E, 0x23, 0x23, 0x23, 0x23, 0x18, 0xF2, 0x1F, 0x06, 0x16, 0x20, 0x33, 0x02, 0x18, 0x19, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x19, 0x24, 0x24, 0x1A, 0xAE, 0x18, 0x18, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x03, 0x3D, 0x20, 0x20, 0x03, 0x16, 0x16, 0x85, 0xF4, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0xAA, 0x01, 0x05, 0x05, 0xA9, 0x05, 0x8A, 0x01, 0x86, 0x23, 0x23, 0xF5, 0x68, 0x28, 0x07, 0x03, 0x03, 0x03, 0x07, 0x02, 0x69, 0x18, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x1A, 0x2A, 0x2A, 0x14, 0x8D, 0x1C, 0x02, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4C, 0x32, 0x16, 0x03, 0x06, 0x60, 0x17, 0x0C, 0x09, 0x07, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xA7, 
        0x01, 0x01, 0x01, 0x05, 0x23, 0x23, 0x05, 0x1F, 0x1F, 0x02, 0x02, 0x02, 0x01, 0x01, 0xDB, 0xF0, 0x0C, 0x09, 0x26, 0x20, 0x03, 0x09, 0x01, 0x01, 0xDF, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x3A, 0x39, 0x3F, 0x1A, 0x41, 0x18, 0x2B, 0x12, 0x15, 0x01, 0x02, 0x01, 0xA8, 0x17, 0x06, 0x16, 0x09, 0x03, 0x32, 0x06, 0x03, 0x60, 0x05, 0x1F, 0x1F, 0x05, 0x1F, 0x05, 0x05, 0x77, 0x01, 0x01, 0x01, 0x1F, 0x05, 
        0x1F, 0x47, 0x01, 0x01, 0x23, 0xC7, 0x0C, 0x85, 0x21, 0x0C, 0x02, 0x02, 0x01, 0x01, 0x1E, 0x1E, 0x4C, 0x03, 0x20, 0x20, 0x16, 0x03, 0x17, 0x01, 0x41, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x44, 0x73, 0x1A, 0x44, 0x0F, 0xCD, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x3C, 0x06, 0x07, 0x4A, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 0x4E, 0x1F, 
        0x05, 0x05, 0x01, 0x02, 0x01, 0x07, 0x17, 0x27, 0x20, 0x06, 0x16, 0x54, 0x16, 0x3E, 0x01, 0x01, 0x01, 0x07, 0x09, 0x03, 0x06, 0x07, 0x20, 0x02, 0x01, 0x4F, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1A, 0xD1, 0x15, 0x15, 0x01, 0x01, 0x1E, 0x8E, 0x3C, 0x3C, 0x03, 0x03, 0x03, 0x16, 0x0C, 0x0C, 0x03, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x27, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 0x8E, 
        0x17, 0x17, 0x3D, 0xAA, 0x02, 0x02, 0x3D, 0x63, 0xA0, 0x26, 0x4C, 0x32, 0x03, 0x16, 0x21, 0x21, 0x01, 0x17, 0x0C, 0x21, 0x06, 0x06, 0x03, 0x09, 0x02, 0x02, 0x3F, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xB3, 0x62, 0x01, 0x4F, 0x07, 0x06, 0x54, 0x32, 0x3D, 0x17, 0x17, 0x4A, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x06, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x06, 0x03, 0x02, 0x02, 
        0x57, 0x07, 0x06, 0x06, 0x1C, 0x01, 0x01, 0x02, 0x07, 0x06, 0x09, 0x6D, 0x06, 0x26, 0x03, 0x03, 0x02, 0x09, 0x07, 0x03, 0x03, 0x03, 0x17, 0x3C, 0x01, 0x01, 0xD9, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xB3, 0x01, 0x01, 0x2C, 0x17, 0x54, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x4A, 0x3D, 0x02, 0x06, 0x07, 0x06, 0x07, 0x06, 0x03, 0x02, 
        0x01, 0x37, 0x06, 0x03, 0x06, 0x29, 0x02, 0x01, 0x03, 0x03, 0x09, 0x15, 0x02, 0x02, 0x02, 0x6D, 0x03, 0x03, 0x21, 0x07, 0x0C, 0x0C, 0x60, 0x60, 0x06, 0x02, 0x78, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x55, 0x15, 0x1E, 0x23, 0x05, 0x1F, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x56, 0x05, 0x05, 0x05, 0x49, 0x01, 0x01, 0x06, 0x01, 0x1C, 0x17, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 
        0x02, 0x02, 0x09, 0x06, 0x07, 0x3D, 0x1B, 0x02, 0x26, 0x49, 0x03, 0x09, 0x07, 0x07, 0x03, 0x06, 0x07, 0x07, 0x2C, 0x07, 0x06, 0x05, 0x1F, 0x09, 0x03, 0x02, 0x15, 0x79, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x12, 0x01, 0x1E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x26, 0x4D, 0x06, 0x2C, 0x07, 0x01, 0x01, 0x46, 0x26, 0x49, 0x4D, 0x06, 0x06, 0x5B, 0x06, 0x03, 0x06, 
        0x07, 0x02, 0x03, 0x07, 0x06, 0x07, 0x06, 0x76, 0x06, 0x26, 0x07, 0x06, 0x06, 0x03, 0x2C, 0x07, 0xA1, 0x1F, 0x05, 0x01, 0x4B, 0x06, 0x1C, 0x07, 0x03, 0x03, 0x02, 0x02, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xD0, 0x02, 0x02, 0xAB, 0x05, 0x05, 0x1F, 0x05, 0x05, 0x05, 0x01, 0x65, 0x02, 0x01, 0x1C, 0x01, 0x07, 0x01, 0x06, 0x03, 0x07, 0x03, 0x01, 0x01, 0x26, 0x07, 0x06, 0x06, 0x03, 0x02, 0x03, 0x06, 0x09, 
        0x03, 0x03, 0x06, 0x03, 0x03, 0x06, 0x03, 0x07, 0x06, 0x06, 0x06, 0x07, 0xF3, 0x05, 0x4D, 0x01, 0x4F, 0x01, 0x1F, 0x17, 0x5C, 0x01, 0x5D, 0x03, 0x16, 0x09, 0x1E, 0x01, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x10, 0x69, 0x02, 0x02, 0x02, 0x05, 0x05, 0x05, 0x05, 0x26, 0x07, 0xA6, 0x06, 0x3C, 0x5B, 0x01, 0x02, 0x01, 0x02, 0x02, 0x26, 0x09, 0x06, 0x01, 0x02, 0x01, 0x06, 0x03, 0x09, 0x76, 0x02, 0x09, 0x03, 0x03, 
        0x06, 0x06, 0x03, 0x03, 0x06, 0x03, 0x06, 0x07, 0x05, 0x3E, 0x01, 0x46, 0x01, 0x05, 0x6A, 0x05, 0x50, 0x56, 0x63, 0x43, 0x9C, 0x5D, 0x1F, 0xC6, 0x03, 0x03, 0xE8, 0x01, 0x78, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x02, 0x01, 0x2F, 0x18, 0x01, 0x1E, 0x03, 0x07, 0x07, 0x07, 0x06, 0x03, 0x4D, 0x06, 0x06, 0x03, 0x29, 0x02, 0x02, 0x02, 0x09, 0x26, 0x07, 0x08, 0x02, 0x02, 0x03, 0x37, 0x02, 0x57, 0x03, 0x03, 0x2C, 0x03, 
        0x03, 0x09, 0x03, 0x06, 0x03, 0x03, 0x03, 0x06, 0x06, 0x3D, 0x66, 0x02, 0x57, 0x63, 0x4D, 0xA6, 0x4A, 0x4E, 0x01, 0x01, 0x01, 0x4B, 0x86, 0x05, 0x07, 0x07, 0x06, 0x01, 0x18, 0x3A, 0x3B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xEA, 0x40, 0x62, 0x01, 0x02, 0x0A, 0x0A, 0x01, 0x01, 0x07, 0x07, 0x07, 0x07, 0x06, 0x06, 0x02, 0x06, 0x06, 0x06, 0x26, 0x06, 0x02, 0x02, 0x02, 0x16, 0x06, 0x4E, 0x01, 0x09, 0x06, 0x03, 0x06, 0x16, 0x03, 0x03, 0x03, 0x09, 
        0x09, 0x03, 0x06, 0x02, 0x02, 0x06, 0x09, 0x03, 0x07, 0x05, 0xA1, 0x01, 0x3D, 0x05, 0x05, 0x4A, 0x05, 0x4F, 0x05, 0x01, 0x4A, 0x01, 0x01, 0x01, 0x05, 0x06, 0x06, 0x76, 0x18, 0x42, 0x1D, 0x00, 0x00, 0x00, 0x00,
  0xB4, 0xB4, 0x1A, 0xC0, 0x00, 0x1A, 0x77, 0x01, 0x18, 0x0A, 0x11, 0x3B, 0x55, 0x12, 0x02, 0x07, 0x07, 0x07, 0x03, 0x06, 0x26, 0x02, 0x06, 0x03, 0x03, 0x06, 0x16, 0x03, 0x02, 0x03, 0x03, 0x09, 0x06, 0x07, 0x09, 0x07, 0x03, 0x07, 0x03, 0x09, 0x03, 0x50, 
        0x02, 0x4D, 0x06, 0x03, 0x03, 0x03, 0x06, 0x06, 0x07, 0x26, 0x01, 0x4D, 0x01, 0x4E, 0x01, 0x46, 0x1E, 0x01, 0x77, 0xE6, 0x43, 0x05, 0x1E, 0x05, 0x23, 0x17, 0x54, 0x03, 0x02, 0x01, 0x44, 0x00, 0x00, 0x00, 0x00,
  0xB9, 0x62, 0xB1, 0x39, 0x1A, 0xAC, 0x01, 0x01, 0x0E, 0x28, 0x81, 0x0A, 0x0A, 0x12, 0x02, 0x08, 0x09, 0x09, 0x03, 0x06, 0x06, 0x02, 0x09, 0x09, 0x07, 0x03, 0x03, 0x03, 0x03, 0x09, 0x06, 0x09, 0x03, 0x20, 0x03, 0x09, 0x03, 0x09, 0x02, 0x12, 0x09, 0x03, 
        0x09, 0x0C, 0x03, 0x06, 0x1B, 0x02, 0x43, 0x03, 0x17, 0x07, 0x05, 0x64, 0x05, 0x5D, 0x43, 0x23, 0x01, 0x89, 0x01, 0x05, 0x8B, 0x01, 0xC4, 0x86, 0x77, 0xF1, 0x16, 0x0C, 0x01, 0x02, 0x1A, 0x45, 0x00, 0x00, 0x00,
  0x04, 0x02, 0x01, 0x01, 0x02, 0x01, 0x02, 0x9B, 0x34, 0x0A, 0x10, 0x10, 0x35, 0x10, 0x02, 0x02, 0x03, 0x03, 0x03, 0x09, 0x6E, 0x33, 0x06, 0x03, 0x03, 0x06, 0x03, 0x09, 0x16, 0x03, 0x03, 0x07, 0x09, 0x09, 0x07, 0x03, 0x07, 0x03, 0x09, 0x07, 0x09, 0x03, 
        0x25, 0x02, 0x4E, 0x06, 0x20, 0x03, 0x03, 0x03, 0x07, 0x07, 0x05, 0x4D, 0x05, 0x5D, 0x23, 0x56, 0x05, 0x01, 0x56, 0x01, 0x01, 0x87, 0x4B, 0x1E, 0x01, 0x05, 0x21, 0x0C, 0x76, 0x01, 0xCF, 0x1A, 0x00, 0x00, 0x00,
  0x04, 0x15, 0x01, 0x01, 0x01, 0x01, 0x02, 0x47, 0x0A, 0x0A, 0x10, 0x28, 0x10, 0x10, 0x12, 0x02, 0x25, 0x16, 0x09, 0x03, 0x09, 0x09, 0x03, 0x07, 0x06, 0x03, 0x03, 0x03, 0x20, 0x16, 0x06, 0x58, 0x02, 0xA5, 0x21, 0x09, 0x09, 0x09, 0x03, 0x6F, 0x02, 0x47, 
        0x07, 0x06, 0x2C, 0x03, 0x03, 0x16, 0x02, 0x02, 0x06, 0x07, 0x07, 0x01, 0x01, 0x05, 0x43, 0x05, 0x46, 0x4A, 0x01, 0x8A, 0x01, 0x01, 0x01, 0x05, 0x01, 0x89, 0x07, 0x21, 0x06, 0x02, 0x2B, 0x51, 0x00, 0x00, 0x00,
  0x44, 0xCA, 0x02, 0x8A, 0x10, 0x10, 0x10, 0x0A, 0x0A, 0x34, 0xE2, 0x90, 0x0A, 0x81, 0x1B, 0x02, 0x02, 0x03, 0x03, 0x09, 0x03, 0x03, 0x06, 0x06, 0x03, 0x03, 0x09, 0x9A, 0x02, 0xA4, 0x09, 0x03, 0x06, 0x03, 0x06, 0x03, 0x09, 0x09, 0x09, 0x21, 0x07, 0x07, 
        0x06, 0x03, 0x02, 0x02, 0x03, 0x09, 0x03, 0x03, 0x07, 0x07, 0x07, 0x05, 0x56, 0x05, 0x56, 0x23, 0x05, 0x05, 0x01, 0x5D, 0x05, 0x4B, 0x05, 0x7E, 0x7A, 0xDD, 0x3D, 0x17, 0x03, 0x02, 0x15, 0x0F, 0x00, 0x00, 0x00,
  0x48, 0x93, 0x01, 0x02, 0x10, 0x0A, 0x0A, 0x11, 0x75, 0x2E, 0x0A, 0x0A, 0xBE, 0x47, 0x0A, 0x02, 0x02, 0x03, 0x03, 0x09, 0x03, 0x07, 0x03, 0x03, 0x57, 0x02, 0x37, 0x03, 0x03, 0x06, 0x03, 0x03, 0x03, 0x12, 0x02, 0x07, 0x03, 0x09, 0x06, 0x06, 0x09, 0x02, 
        0x02, 0x06, 0x06, 0x06, 0x09, 0x54, 0x06, 0x7B, 0x01, 0x43, 0x07, 0x05, 0x01, 0x4A, 0x05, 0x43, 0x4E, 0x4B, 0x4F, 0x7E, 0x86, 0x05, 0x01, 0x01, 0x01, 0x05, 0x05, 0x07, 0x03, 0x02, 0x15, 0x04, 0x04, 0x00, 0x00,
  0x45, 0x44, 0x02, 0x01, 0x0A, 0x36, 0x3B, 0x3B, 0x38, 0x0E, 0x7D, 0x83, 0xAF, 0x10, 0x1B, 0x0A, 0x02, 0x02, 0x03, 0x03, 0x07, 0x09, 0x57, 0x06, 0x09, 0x06, 0x06, 0x03, 0x06, 0x29, 0x02, 0x49, 0x09, 0x03, 0x03, 0x09, 0x07, 0x03, 0x4F, 0x49, 0x07, 0x03, 
        0x07, 0x06, 0x07, 0x06, 0x02, 0x6F, 0x06, 0x03, 0xA1, 0x09, 0x17, 0x07, 0x05, 0x01, 0x4B, 0x56, 0x01, 0x05, 0xA2, 0x01, 0x01, 0x01, 0x02, 0x02, 0x01, 0x05, 0x05, 0x9D, 0x0C, 0x8F, 0x01, 0x01, 0x2A, 0x00, 0x00,
  0x00, 0x45, 0x01, 0x01, 0x11, 0x5F, 0x3B, 0x59, 0x0A, 0x0E, 0x28, 0xB1, 0x36, 0x92, 0x9E, 0x1B, 0x02, 0x12, 0x09, 0x0C, 0x03, 0x03, 0x09, 0x26, 0x07, 0x6E, 0x01, 0x5C, 0x06, 0x07, 0x20, 0x03, 0x03, 0x03, 0x02, 0x02, 0x09, 0x03, 0x03, 0x09, 0x03, 0x07, 
        0x01, 0x4C, 0x06, 0x07, 0x03, 0x16, 0x03, 0x03, 0x46, 0x1C, 0x9A, 0x07, 0x05, 0x8B, 0x01, 0x4E, 0x05, 0x01, 0x4B, 0x05, 0xDE, 0x01, 0x02, 0x02, 0x01, 0xCB, 0x4E, 0x05, 0x13, 0x04, 0x01, 0x01, 0x48, 0x00, 0x00,
  0x00, 0x73, 0x01, 0x01, 0x11, 0x5F, 0x42, 0x42, 0x1B, 0x53, 0x11, 0xAF, 0x91, 0x3B, 0x36, 0x0E, 0x6E, 0x02, 0x01, 0x07, 0x0C, 0x0C, 0x49, 0x01, 0x06, 0x07, 0x09, 0x0C, 0x03, 0x09, 0x33, 0x02, 0x7A, 0x20, 0x16, 0x03, 0x16, 0x03, 0x06, 0x29, 0x65, 0x09, 
        0x03, 0x03, 0x03, 0x06, 0x03, 0x01, 0x01, 0x26, 0x06, 0x09, 0x26, 0x06, 0x4A, 0xC5, 0x46, 0x01, 0x4B, 0x7E, 0x1E, 0x01, 0x5C, 0x4A, 0x4F, 0x37, 0x4F, 0x47, 0x05, 0xC6, 0x08, 0x0B, 0x01, 0x01, 0x40, 0x00, 0x00,
  0x00, 0x44, 0x01, 0x01, 0x0E, 0x2E, 0x42, 0x42, 0xBE, 0x0A, 0x10, 0x10, 0x31, 0x0A, 0x42, 0xBC, 0x5C, 0x02, 0x01, 0x06, 0x03, 0x0C, 0x07, 0x07, 0x06, 0x06, 0x34, 0x02, 0x15, 0x03, 0x20, 0x03, 0x16, 0x03, 0x09, 0x6E, 0x15, 0x20, 0x03, 0x03, 0x09, 0x03, 
        0x07, 0x63, 0x02, 0x37, 0x07, 0x03, 0x03, 0x06, 0x07, 0x66, 0x02, 0x06, 0x06, 0x17, 0x43, 0x01, 0x43, 0x05, 0x01, 0x05, 0xC7, 0xA2, 0x46, 0x02, 0x87, 0x4D, 0x05, 0xC5, 0x04, 0x04, 0x01, 0x01, 0xBA, 0xB8, 0x00,
  0x00, 0x52, 0x88, 0x12, 0x61, 0x0A, 0x0E, 0x19, 0x2D, 0x11, 0x10, 0x35, 0x0E, 0x59, 0x3A, 0x0E, 0x1B, 0x02, 0x02, 0x02, 0x09, 0x03, 0x09, 0x5D, 0x02, 0x7A, 0x06, 0x03, 0x03, 0x09, 0x09, 0x03, 0x02, 0x02, 0x03, 0x06, 0x07, 0x06, 0x0C, 0x09, 0x1C, 0x02, 
        0x09, 0x03, 0x03, 0x06, 0x06, 0x07, 0x1B, 0x02, 0x37, 0x09, 0x09, 0x06, 0x06, 0x1F, 0x05, 0x01, 0x05, 0x1F, 0x05, 0x05, 0x1F, 0xA3, 0x1F, 0x03, 0x27, 0x13, 0x0D, 0x0D, 0x13, 0x13, 0x3E, 0x01, 0xD3, 0x24, 0x00,
  0x00, 0x82, 0x53, 0x02, 0x15, 0x0A, 0x83, 0x31, 0x0A, 0x0E, 0x35, 0x0A, 0x0A, 0x83, 0x11, 0x0E, 0x34, 0x1B, 0x02, 0x01, 0x85, 0x09, 0x03, 0x03, 0x06, 0x06, 0x03, 0x49, 0x6F, 0x02, 0x7E, 0x06, 0x03, 0x03, 0x06, 0x20, 0x09, 0x33, 0x07, 0x03, 0x03, 0x07, 
        0x09, 0x09, 0x06, 0x02, 0x01, 0x07, 0x06, 0x06, 0x03, 0x09, 0x03, 0x02, 0x03, 0x03, 0x02, 0x29, 0x01, 0x50, 0x1F, 0x25, 0x13, 0x08, 0x04, 0x04, 0x5E, 0x08, 0x25, 0x08, 0x08, 0x08, 0xBD, 0x01, 0x2B, 0x48, 0x00,
  0x00, 0x00, 0x24, 0x2B, 0x02, 0x0A, 0x83, 0x59, 0x36, 0x45, 0x58, 0x10, 0xB6, 0x11, 0x11, 0x38, 0x2E, 0x0A, 0x02, 0x1C, 0x06, 0x07, 0x0C, 0x0C, 0xBD, 0x01, 0xAB, 0x06, 0x16, 0x03, 0x06, 0x3C, 0x26, 0x46, 0x01, 0x09, 0x07, 0x2C, 0x07, 0x06, 0x06, 0x02, 
        0x1C, 0x06, 0x03, 0x09, 0x07, 0x06, 0x03, 0x6F, 0x02, 0x37, 0x33, 0x04, 0x04, 0x04, 0x0C, 0x04, 0x04, 0x13, 0x04, 0x0B, 0x13, 0x22, 0x13, 0x04, 0x04, 0x04, 0x08, 0x0D, 0x21, 0x21, 0x07, 0x01, 0x69, 0x19, 0x00,
  0x00, 0x00, 0x52, 0x2B, 0x02, 0x1B, 0x0E, 0x0A, 0x10, 0xB7, 0x0A, 0x0A, 0x31, 0x0A, 0x0E, 0x2D, 0x0A, 0x0A, 0x1B, 0x02, 0x02, 0x03, 0x0C, 0x03, 0x06, 0x06, 0x06, 0x06, 0x03, 0x16, 0x01, 0x02, 0x06, 0x06, 0x03, 0x07, 0x06, 0x03, 0x07, 0x09, 0x07, 0x03, 
        0x03, 0x09, 0x03, 0x09, 0x63, 0x02, 0x27, 0x09, 0x25, 0x0B, 0x0B, 0x04, 0x58, 0x0B, 0x0B, 0x0D, 0x22, 0x0B, 0x04, 0x04, 0x22, 0x22, 0x0B, 0x22, 0x0B, 0x0C, 0x03, 0x18, 0x07, 0x09, 0x03, 0x01, 0x18, 0x19, 0x00,
  0x00, 0x00, 0x39, 0xAC, 0x01, 0x8B, 0x42, 0x0E, 0x35, 0x10, 0x0A, 0x35, 0x0E, 0x59, 0x2D, 0x0E, 0x0A, 0x2D, 0x0A, 0x02, 0x02, 0x06, 0x0C, 0x03, 0x06, 0x26, 0x01, 0x01, 0x03, 0x16, 0x06, 0x3C, 0x07, 0x06, 0x57, 0x02, 0x65, 0x09, 0x21, 0xC2, 0x09, 0x03, 
        0x08, 0x02, 0x57, 0x0C, 0x33, 0x08, 0x04, 0x08, 0x0B, 0x02, 0x6C, 0x0B, 0x04, 0x1D, 0x14, 0x04, 0x04, 0x1D, 0x0B, 0x04, 0x08, 0x03, 0x07, 0x65, 0x15, 0x2F, 0x03, 0x0C, 0x0C, 0x04, 0x14, 0x18, 0x12, 0x0F, 0x1D,
  0x00, 0x00, 0x39, 0x39, 0x01, 0x01, 0x7D, 0xBB, 0x11, 0x10, 0xB5, 0x38, 0x0A, 0x71, 0x11, 0x0A, 0x30, 0x11, 0x1B, 0x02, 0x02, 0x46, 0x0C, 0x0C, 0x07, 0x09, 0x3C, 0x3C, 0x16, 0x03, 0x06, 0xA7, 0x02, 0x50, 0x06, 0x06, 0x03, 0x09, 0x03, 0x21, 0x0C, 0x03, 
        0x09, 0x0C, 0x08, 0x08, 0x08, 0x5D, 0x02, 0x6E, 0x0D, 0x08, 0x0D, 0x04, 0x0F, 0x08, 0x0D, 0x14, 0x04, 0x13, 0x53, 0x0C, 0x7B, 0x02, 0x13, 0x2C, 0x0C, 0x0C, 0x04, 0x13, 0x55, 0x13, 0x04, 0x12, 0x15, 0x55, 0x1D,
  0x00, 0x00, 0x00, 0x48, 0x01, 0x01, 0x7D, 0x3A, 0x0A, 0x58, 0x48, 0x36, 0x2E, 0x0F, 0x0A, 0x38, 0x38, 0x0E, 0x1D, 0x0A, 0x02, 0x02, 0x03, 0x0C, 0x03, 0x06, 0x07, 0x9C, 0x02, 0x7C, 0x20, 0x03, 0x03, 0x09, 0x03, 0x33, 0x15, 0x29, 0x0C, 0x0C, 0x34, 0x08, 
        0x08, 0x0B, 0x02, 0x15, 0x08, 0x04, 0x08, 0x04, 0x08, 0x0D, 0x15, 0x02, 0x04, 0x0B, 0x04, 0x03, 0x0C, 0x02, 0x29, 0x34, 0x09, 0x03, 0x2C, 0x66, 0x0D, 0x12, 0x29, 0x13, 0x04, 0x0B, 0x95, 0x2F, 0x02, 0x1C, 0x3A,
  0x00, 0x00, 0x00, 0x44, 0x01, 0x01, 0xAD, 0x0E, 0x0A, 0x32, 0x36, 0x11, 0x31, 0x11, 0x0A, 0x2D, 0x0E, 0x11, 0x91, 0x0A, 0x02, 0x02, 0x03, 0x09, 0x03, 0x03, 0x17, 0x3D, 0x03, 0x16, 0x03, 0x16, 0x29, 0x15, 0x34, 0x03, 0x0C, 0x08, 0x04, 0x04, 0x0B, 0x0B, 
        0x0B, 0x0D, 0x04, 0x0D, 0x04, 0x0B, 0x2E, 0x02, 0x1B, 0x0B, 0x0B, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x16, 0x85, 0x66, 0x6A, 0x01, 0x5E, 0x72, 0x0D, 0x08, 0x08, 0x13, 0x08, 0x1D, 0x95, 0x02, 0x02, 0x19,
  0x00, 0x00, 0x00, 0x99, 0x71, 0x15, 0x02, 0x0A, 0x7F, 0x10, 0x10, 0x38, 0x0A, 0x0A, 0x31, 0x0A, 0x0E, 0x5F, 0x0A, 0x0A, 0x12, 0x02, 0x1C, 0x03, 0x06, 0x07, 0x03, 0x09, 0x0C, 0x02, 0x02, 0x03, 0x16, 0x0C, 0x53, 0x0B, 0x04, 0x5A, 0x02, 0x2F, 0x04, 0x14, 
        0x04, 0x04, 0x14, 0x70, 0x02, 0x3E, 0x13, 0x04, 0x0B, 0x03, 0x09, 0x5B, 0x1C, 0x2E, 0x0C, 0x0C, 0x09, 0x08, 0x4C, 0x02, 0x0D, 0x04, 0x0B, 0x99, 0x0D, 0x0D, 0x88, 0x02, 0x0B, 0x04, 0x14, 0x04, 0x01, 0x01, 0x19,
  0x00, 0x00, 0x00, 0x00, 0x19, 0x15, 0x1C, 0x0A, 0x75, 0x10, 0x11, 0x52, 0x0E, 0x11, 0x2F, 0x0A, 0x30, 0x36, 0x0A, 0x28, 0x1B, 0x02, 0x02, 0x09, 0x03, 0x09, 0x09, 0x33, 0x21, 0x03, 0x0C, 0x04, 0x08, 0x2E, 0x02, 0x70, 0x0B, 0x13, 0x04, 0x0B, 0x0D, 0x04, 
        0x0D, 0x5A, 0x53, 0x0D, 0x08, 0x08, 0x0C, 0x03, 0x02, 0x12, 0x0C, 0x0C, 0x0C, 0x09, 0x25, 0x08, 0x2F, 0x25, 0x08, 0x08, 0x0D, 0x0B, 0x2E, 0x02, 0x8D, 0x72, 0x08, 0x08, 0x08, 0x08, 0x04, 0x1D, 0x01, 0x01, 0x3A,
  0x00, 0x00, 0x00, 0x00, 0x2A, 0x2B, 0x01, 0x5C, 0x10, 0x10, 0x2D, 0x0A, 0x10, 0x35, 0x0A, 0x0E, 0x35, 0x0E, 0x10, 0x30, 0x0A, 0x12, 0x01, 0x07, 0x09, 0x03, 0xC3, 0x0C, 0x25, 0x08, 0x70, 0x02, 0x58, 0x0B, 0x04, 0x13, 0x0D, 0x04, 0x5B, 0x02, 0x04, 0x04, 
        0x08, 0x08, 0x50, 0x03, 0x03, 0x02, 0x4C, 0x03, 0x0C, 0x03, 0x03, 0x08, 0x08, 0x02, 0x04, 0x08, 0x08, 0x08, 0x08, 0x47, 0x02, 0x7B, 0x14, 0x14, 0x0D, 0x04, 0x0B, 0x70, 0x02, 0x08, 0x14, 0x04, 0x01, 0x01, 0x19,
  0x00, 0x00, 0x00, 0x00, 0x2A, 0xAD, 0x02, 0x01, 0x0E, 0x45, 0x0A, 0x0A, 0x5F, 0x10, 0x0A, 0x2D, 0x0E, 0x11, 0x28, 0x0E, 0x0A, 0x6D, 0x01, 0x64, 0x03, 0x08, 0x04, 0x1B, 0x4C, 0x08, 0x08, 0x0B, 0x04, 0x04, 0x08, 0x02, 0x02, 0x08, 0x0B, 0x04, 0x08, 0x0B, 
        0x03, 0x03, 0x15, 0x0C, 0x03, 0x03, 0x0C, 0x0C, 0x5E, 0x6B, 0x02, 0x13, 0x13, 0x0B, 0x0B, 0x08, 0x04, 0x15, 0x04, 0x08, 0x0B, 0x04, 0x1D, 0x04, 0x12, 0x79, 0x04, 0x0B, 0x08, 0x08, 0x04, 0x14, 0x01, 0x01, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x02, 0x11, 0x11, 0x0A, 0x11, 0x10, 0x10, 0x38, 0x11, 0x0A, 0x3A, 0x36, 0x11, 0x04, 0x11, 0x01, 0x01, 0x04, 0x08, 0x0F, 0x0F, 0x27, 0x08, 0x0B, 0x64, 0x02, 0x47, 0x04, 0x04, 0x08, 0x04, 0x33, 0x55, 0x02, 0x03, 
        0x03, 0x09, 0x20, 0x03, 0x25, 0x3E, 0x02, 0x7B, 0x25, 0x25, 0x0B, 0x04, 0x08, 0x0A, 0x12, 0x04, 0x04, 0x14, 0x04, 0x0F, 0x4E, 0x01, 0x37, 0x04, 0x08, 0x08, 0x0B, 0x0B, 0x6C, 0x02, 0x19, 0x04, 0x01, 0x01, 0x44,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x02, 0x01, 0x11, 0x0E, 0x0A, 0x3B, 0x0E, 0x10, 0x2D, 0x0A, 0x10, 0x28, 0x0E, 0x11, 0x3B, 0x1B, 0x01, 0x02, 0x08, 0x13, 0x0F, 0x0F, 0x46, 0x02, 0x2F, 0x0B, 0x04, 0x04, 0x0B, 0x0B, 0x8C, 0x02, 0x9B, 0x03, 0x0C, 0x0C, 
        0x03, 0x03, 0x47, 0x12, 0x7C, 0x08, 0x08, 0x27, 0x08, 0x66, 0x47, 0x02, 0x8C, 0x5E, 0x04, 0x0B, 0x04, 0x55, 0x12, 0x2F, 0xB2, 0x13, 0x04, 0x0D, 0x08, 0x64, 0x02, 0x0B, 0x0D, 0x0D, 0x04, 0x14, 0x01, 0x01, 0x1A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x19, 0x18, 0x02, 0x1B, 0x68, 0x0E, 0x10, 0x35, 0x42, 0x0E, 0x2D, 0x11, 0x0A, 0x3B, 0xAE, 0xB0, 0x1C, 0x02, 0x8C, 0x13, 0x0D, 0x08, 0x04, 0x04, 0x08, 0x27, 0x27, 0x02, 0x7A, 0x06, 0x09, 0x03, 0x03, 0x09, 0x53, 0x2F, 
        0x0F, 0x0F, 0x22, 0x04, 0x08, 0x08, 0x25, 0x02, 0x1C, 0x08, 0x0D, 0x0D, 0x0D, 0x04, 0x0B, 0x0B, 0x0B, 0x04, 0x0B, 0x13, 0x74, 0x08, 0x01, 0x63, 0x04, 0x0F, 0x08, 0x08, 0x72, 0x0A, 0x3E, 0x22, 0x02, 0x01, 0x39,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x18, 0x02, 0x1B, 0x0E, 0x7D, 0x68, 0x10, 0x0E, 0x5F, 0x0A, 0x0A, 0x3B, 0x0A, 0x92, 0x51, 0x1B, 0x02, 0x01, 0x08, 0x25, 0x0D, 0x04, 0x3E, 0x02, 0x6D, 0x07, 0x06, 0x06, 0x03, 0x03, 0x9E, 0x02, 0x6A, 0x0B, 0x08, 
        0x97, 0x04, 0x71, 0x0F, 0x29, 0x01, 0x04, 0x13, 0x0D, 0x0D, 0x04, 0x0D, 0x18, 0x12, 0x08, 0x0D, 0x04, 0x0B, 0x13, 0x1C, 0x5A, 0x08, 0x27, 0x27, 0x0B, 0x04, 0x3E, 0x02, 0x8D, 0x82, 0x14, 0x0F, 0x01, 0x02, 0x45,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x62, 0x02, 0x02, 0x59, 0x38, 0x0E, 0x11, 0x38, 0x36, 0x0A, 0x11, 0x2E, 0x0E, 0x0E, 0x31, 0x0A, 0x02, 0x01, 0x27, 0x34, 0x0C, 0xC1, 0x0C, 0x0C, 0x21, 0x03, 0x16, 0x29, 0x02, 0x08, 0x08, 0x08, 0x04, 0x08, 0x04, 
        0x0B, 0x0F, 0x97, 0x0F, 0x08, 0x04, 0x13, 0x0D, 0x5B, 0x02, 0x37, 0x04, 0x04, 0x0D, 0x14, 0x0D, 0x0F, 0x0F, 0x0F, 0x0F, 0x0D, 0x04, 0x66, 0x29, 0x15, 0x94, 0x14, 0x0D, 0x08, 0x5E, 0x13, 0x13, 0x01, 0x01, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB7, 0x01, 0x01, 0x59, 0x71, 0x11, 0x7F, 0x30, 0x0E, 0x59, 0x2D, 0x0A, 0x0A, 0x45, 0x10, 0x58, 0x02, 0x01, 0x07, 0x0C, 0x03, 0x34, 0x0C, 0x0C, 0x02, 0x8F, 0x08, 0x0B, 0x0D, 0x08, 0x08, 0x7C, 0x02, 0x5B, 0x08, 
        0x04, 0x08, 0x14, 0x04, 0x04, 0x15, 0x02, 0x08, 0x04, 0x25, 0x08, 0x08, 0x0B, 0x02, 0x6C, 0x14, 0x14, 0x1D, 0x0F, 0x19, 0x12, 0x18, 0x22, 0x13, 0x96, 0x94, 0x0D, 0x37, 0x01, 0x47, 0x13, 0x0B, 0x01, 0x01, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x18, 0x15, 0x90, 0x1B, 0x7F, 0x2D, 0x36, 0x11, 0xBF, 0x0A, 0x0A, 0x2D, 0x38, 0x0A, 0x0A, 0x61, 0x01, 0x65, 0x03, 0x54, 0x0B, 0x59, 0x0B, 0x04, 0x0B, 0x13, 0x08, 0x1B, 0x02, 0x70, 0x08, 0x04, 0x04, 0x04, 
        0x14, 0x04, 0x0D, 0x12, 0x14, 0x04, 0x14, 0x0F, 0x22, 0x0B, 0x1C, 0x29, 0x13, 0x13, 0x0B, 0x08, 0x04, 0x0B, 0x15, 0x0D, 0x04, 0x1D, 0x13, 0x22, 0x0B, 0x15, 0x57, 0x0F, 0x22, 0x04, 0x08, 0x25, 0x01, 0x01, 0x52,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x19, 0x15, 0x02, 0x0A, 0xB5, 0x10, 0x0E, 0x2D, 0x0A, 0x11, 0x31, 0x31, 0x0E, 0x0A, 0x9F, 0x0A, 0x01, 0x01, 0x0D, 0x08, 0x13, 0x13, 0x0B, 0x0B, 0x15, 0x15, 0x0B, 0x0B, 0x08, 0x08, 0x04, 0x08, 0x12, 0x79, 
        0x04, 0x04, 0x14, 0x0B, 0x1D, 0x14, 0xD4, 0x15, 0x3E, 0x22, 0x22, 0x0B, 0x13, 0x22, 0x29, 0x1C, 0x0B, 0x04, 0x5E, 0x08, 0x04, 0x6B, 0x1C, 0x0B, 0x0B, 0x13, 0x14, 0x04, 0x04, 0x02, 0x18, 0x20, 0x01, 0x01, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x41, 0x01, 0x5C, 0x10, 0x10, 0x35, 0x36, 0x0A, 0x91, 0x38, 0x36, 0x0A, 0x2D, 0x31, 0x0A, 0x01, 0x01, 0x14, 0x14, 0x04, 0x22, 0x15, 0x04, 0x0B, 0x22, 0x0B, 0x25, 0x04, 0x02, 0x29, 0x04, 0x0D, 0x04, 
        0x0B, 0x14, 0x1D, 0x14, 0x02, 0x2E, 0x0B, 0x0B, 0x04, 0x0B, 0x04, 0x88, 0x1C, 0x0B, 0x04, 0x04, 0x0B, 0x04, 0x37, 0x02, 0x14, 0x1D, 0x04, 0x04, 0x27, 0x50, 0x1C, 0x02, 0x16, 0xEE, 0x3D, 0x17, 0x02, 0x01, 0x19,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x3F, 0x01, 0x01, 0x10, 0x98, 0x0E, 0x10, 0x31, 0x2D, 0x0E, 0x0E, 0x19, 0x2F, 0x10, 0x0A, 0x01, 0x01, 0x04, 0x0D, 0x22, 0x04, 0x0B, 0x22, 0x04, 0x1B, 0x15, 0x3E, 0x13, 0x08, 0x04, 0x0B, 0x0D, 0x64, 
        0x12, 0x04, 0x14, 0x04, 0x04, 0x0D, 0x08, 0x0B, 0x12, 0x6B, 0x0B, 0x04, 0x0B, 0x04, 0x13, 0x0A, 0x25, 0x08, 0x08, 0x04, 0x19, 0x19, 0x2E, 0x02, 0xA9, 0x26, 0x2C, 0x07, 0x32, 0x32, 0x17, 0xA8, 0x02, 0x01, 0x19,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x12, 0x12, 0x0A, 0x0A, 0x0A, 0x5F, 0x10, 0x0A, 0x42, 0x28, 0x2D, 0x0E, 0x10, 0x42, 0x15, 0x01, 0x14, 0x0D, 0x0F, 0x0F, 0x12, 0x12, 0x0D, 0x0B, 0x04, 0x0D, 0x0D, 0x2F, 0x02, 0x15, 0x0B, 0x0F, 
        0x14, 0x0F, 0x0F, 0x0F, 0x6A, 0x02, 0x08, 0x08, 0x0D, 0x0D, 0x1D, 0x04, 0x18, 0x12, 0x1D, 0x0D, 0x14, 0x04, 0x19, 0x4C, 0x01, 0x9D, 0x09, 0x21, 0x06, 0x03, 0x17, 0x07, 0x5C, 0x01, 0x01, 0x01, 0x2B, 0x1A, 0x3A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x1D, 0x12, 0x12, 0x0A, 0x28, 0x0A, 0x10, 0x10, 0x28, 0x11, 0x10, 0x0A, 0x0E, 0x30, 0x1B, 0x02, 0x5A, 0x14, 0x0F, 0x0F, 0x04, 0x0B, 0x04, 0x14, 0x04, 0x02, 0x29, 0x0B, 0x04, 0x04, 0x04, 0x0B, 
        0x0B, 0x04, 0x0F, 0x0F, 0x08, 0x27, 0x08, 0x74, 0x0D, 0x29, 0x12, 0x0D, 0x1D, 0x1D, 0x14, 0x72, 0x1D, 0x32, 0x54, 0x0C, 0x9D, 0x60, 0x21, 0x21, 0x03, 0x49, 0x1C, 0x01, 0x01, 0x01, 0x01, 0x01, 0xE1, 0x48, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x78, 0x01, 0x1B, 0x0E, 0x2E, 0x35, 0x28, 0x0E, 0x0A, 0x0E, 0x3A, 0x28, 0x35, 0x1B, 0x01, 0x02, 0x08, 0x1D, 0x0F, 0x0B, 0x6D, 0x12, 0x58, 0x08, 0x0D, 0x0B, 0x04, 0x04, 0x5A, 0x12, 0x14, 
        0x0F, 0x0F, 0x0B, 0x04, 0x04, 0x0B, 0x02, 0x6C, 0x50, 0x25, 0x0D, 0x74, 0x0D, 0x65, 0x02, 0x37, 0x17, 0x07, 0x17, 0x07, 0x0C, 0x09, 0x27, 0x01, 0x01, 0x01, 0x62, 0x41, 0x41, 0x67, 0x0F, 0x0F, 0x99, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x39, 0x01, 0x01, 0x0A, 0x2E, 0x10, 0x0E, 0x11, 0x30, 0x28, 0x52, 0x11, 0x11, 0x1B, 0x1C, 0x02, 0x0D, 0x0F, 0x0F, 0x0D, 0x0D, 0x0D, 0x04, 0x25, 0x3E, 0x02, 0x64, 0x04, 0x22, 0x0B, 0x04, 
        0x22, 0x2F, 0x0F, 0x0F, 0x2F, 0x04, 0x04, 0x08, 0x25, 0x0B, 0x12, 0x15, 0x03, 0x03, 0x09, 0x07, 0x07, 0x17, 0x84, 0x4F, 0x02, 0x02, 0x01, 0xC8, 0x01, 0x1E, 0x40, 0x40, 0x67, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0x15, 0x1C, 0x8F, 0x0A, 0x38, 0x35, 0x68, 0x71, 0x92, 0x0A, 0x0A, 0x10, 0x1B, 0x02, 0x02, 0x27, 0x0F, 0x19, 0x04, 0x0D, 0x50, 0x02, 0x6B, 0x0D, 0x04, 0x0B, 0x04, 0x13, 0x0A, 0x02, 
        0x55, 0x08, 0x04, 0x08, 0x0F, 0x22, 0x22, 0x6B, 0x02, 0x03, 0x2C, 0x07, 0x84, 0x84, 0x07, 0x17, 0x9A, 0x01, 0x01, 0x01, 0x18, 0x18, 0x62, 0xE3, 0xBB, 0x24, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x0F, 0x15, 0x02, 0x0A, 0x11, 0x11, 0x0A, 0x1B, 0x11, 0x11, 0x11, 0x0A, 0x0A, 0x1C, 0x01, 0x08, 0x1D, 0x14, 0x0D, 0x53, 0x0B, 0x04, 0x08, 0x0B, 0x0B, 0x15, 0x02, 0x08, 0x0B, 0x04, 
        0x08, 0x0D, 0x0D, 0x04, 0x1C, 0x5A, 0xC1, 0x68, 0x21, 0x21, 0x07, 0x2C, 0x2C, 0xB2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x19, 0xB8, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x61, 0x01, 0x02, 0x10, 0x1D, 0x34, 0x53, 0x98, 0x28, 0x75, 0x3B, 0x34, 0x02, 0x01, 0x27, 0x04, 0x0F, 0x04, 0x0B, 0x04, 0x0B, 0x79, 0x15, 0x0B, 0x04, 0x04, 0x08, 0x08, 0x08, 
        0x02, 0xC9, 0x03, 0x16, 0x20, 0x06, 0x06, 0x3C, 0x3C, 0x07, 0x2C, 0x01, 0x02, 0x02, 0x15, 0x15, 0x41, 0x93, 0x45, 0x39, 0x96, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x1A, 0x02, 0x01, 0x10, 0x0A, 0x1B, 0x0A, 0x11, 0x0E, 0x2E, 0x75, 0x09, 0x5A, 0x01, 0x56, 0x14, 0x04, 0x0F, 0x02, 0x6C, 0x04, 0x0B, 0x22, 0x04, 0x08, 0x7C, 0x02, 0x3E, 0x0C, 
        0x03, 0x03, 0x03, 0x03, 0x20, 0x20, 0xA0, 0x49, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0xB6, 0x1D, 0x73, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0xD7, 0x18, 0x87, 0x1B, 0x81, 0x53, 0x35, 0x9F, 0x11, 0x0A, 0x2F, 0x55, 0x01, 0xA3, 0x04, 0x0D, 0x04, 0x0B, 0x08, 0x13, 0x27, 0x02, 0x02, 0x17, 0x06, 0x07, 0x16, 0x03, 
        0x06, 0x20, 0x06, 0x06, 0x43, 0x01, 0x02, 0x02, 0x18, 0x18, 0x2B, 0x2A, 0x24, 0x1A, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x69, 0x01, 0xCC, 0x0A, 0x2E, 0x0A, 0x11, 0x9F, 0x2F, 0x0E, 0x0E, 0x1C, 0x1C, 0x0D, 0x0D, 0x04, 0x14, 0x6A, 0x02, 0x9C, 0x06, 0x17, 0x3D, 0x07, 0x06, 0x03, 0x09, 
        0x03, 0x2C, 0x02, 0x02, 0x01, 0x1E, 0x02, 0x01, 0x7F, 0x31, 0x1A, 0x24, 0xED, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xBA, 0x01, 0x01, 0x0E, 0x0E, 0x50, 0x2C, 0x0A, 0x16, 0x38, 0x11, 0x02, 0x01, 0x74, 0xE7, 0x08, 0x06, 0x32, 0x54, 0x28, 0x32, 0x0C, 0x0C, 0x07, 0x07, 0x27, 0x01, 
        0x02, 0x02, 0x12, 0x12, 0x41, 0x3F, 0x24, 0x48, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0x43, 0x1E, 0x2B, 0x36, 0x9B, 0x5E, 0x16, 0x58, 0x35, 0x0E, 0x02, 0x1C, 0xE9, 0xA0, 0x07, 0x03, 0x34, 0x32, 0xC3, 0x28, 0x32, 0x0C, 0x02, 0x02, 0x01, 0x01, 
        0x02, 0x02, 0x90, 0x1D, 0x3F, 0x40, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x2B, 0x02, 0x01, 0x0A, 0x1D, 0x31, 0x3B, 0x9E, 0x6F, 0x01, 0xCE, 0x32, 0x32, 0x21, 0x03, 0x07, 0x07, 0x17, 0x01, 0x02, 0x02, 0x18, 0x18, 0x2B, 0x93, 
        0x52, 0x52, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x01, 0x02, 0x12, 0x0A, 0x34, 0x3B, 0xEB, 0x4C, 0x01, 0x8E, 0x32, 0x28, 0x21, 0x1B, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x19, 0x19, 0x1A, 0x2A, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x40, 0x78, 0x01, 0x01, 0x33, 0x33, 0x16, 0x02, 0x01, 0x17, 0x17, 0x01, 0x02, 0x02, 0x12, 0x12, 0x61, 0x42, 0x24, 0x2A, 0x0F, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x01, 0x01, 0x01, 0x33, 0x33, 0x12, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x1D, 0x1D, 0x44, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x67, 0x41, 0x01, 0x01, 0x1E, 0x1E, 0x69, 0x15, 0x41, 0xD6, 0x2A, 0x24, 0x19, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x67, 0x02, 0x01, 0x1E, 0x01, 0x14, 0x31, 0x44, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x96, 0x19, 0x82, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmnewspaper = {
  77, /* XSize */
  74, /* YSize */
  77, /* BytesPerLine */
  8, /* BitsPerPixel */
  acnewspaper,  /* Pointer to picture data (indices) */
  &Palnewspaper   /* Pointer to palette */
};

/* *** End of file *** */
