/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap converter for emWin V5.16.                           *
*        Compiled Jun  4 2012, 15:48:30                              *
*        (C) 1998 - 2010 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: latte_coffee                                          *
* Dimensions:  79 * 58                                               *
* NumColors:   250                                                   *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR Colorslatte_coffee[] = {
     0xFFFFFF,0x000000,0xBBC6D3,0xE3EBF3
    ,0xC9D2DA,0xB8C2CC,0xC3CBD6,0xFAFBFC
    ,0xD4DCE4,0xDBE3EB,0xF4FAFC,0xB4BDC7
    ,0x9BA7B3,0xD2D6DC,0xEBF2FA,0xF2F5FB
    ,0xAAB8C3,0xEBF1F5,0xA2ADB7,0xA8B2BC
    ,0xE9EDF3,0xE2E9ED,0x97A2AC,0xE4EEF9
    ,0x5598E6,0xC3C6CC,0xDDE9EC,0xCAD4E2
    ,0xEAEBED,0xB2BDD2,0xD5E2EB,0x65A8F8
    ,0xDBE4F2,0xE2E5EB,0xF3F4F5,0xDAE0E5
    ,0xCDD9E3,0x8B98A5,0x96C9FD,0xB2B6BC
    ,0xE9EDF8,0x1558C8,0x69A4E8,0x85BAFA
    ,0xD4E2E6,0x4388E4,0xC5D2E1,0xE4F0F4
    ,0x3579E6,0x579CF6,0xD4E3F3,0xDDE9F2
    ,0x3678D4,0xA8D7FC,0xE2E4E6,0x023CB6
    ,0x1966D4,0x4796F7,0x75A8E7,0x929CA6
    ,0xF9F6FA,0xDCEAFD,0x1963C7,0x256BD5
    ,0x0B56C7,0x658CBC,0x72B3FC,0x88C3FD
    ,0xB3D4FF,0xD3E4FC,0xE2E5F1,0xFAF6F5
    ,0x1458BA,0x0849C3,0x4683C7,0x76ABF9
    ,0x84B3E7,0xC5CFE0,0xCAE4FE,0xE7F0EF
    ,0xE5F0F9,0x0546BC,0x377AC8,0x467BC6
    ,0x3986DA,0x669AD8,0xADC0CC,0x9DD1F8
    ,0xBCCCE3,0xD4E9F2,0xF3FCF5,0x3B85E7
    ,0x538BD5,0x5693DA,0x4C94E4,0x4289F7
    ,0x77B3ED,0xB2D9FF,0xBADCFE,0xC8D6EA
    ,0xD2DFF5,0xC2E1FE,0xEDFAFB,0x0A56B7
    ,0x1D63B4,0x0D5CD3,0x2873C7,0x4492E1
    ,0x54A4F2,0x5BA1F2,0x53A3FC,0x6CB1F5
    ,0x87929B,0x83ADE7,0x94B9E6,0xB9D2E7
    ,0xCDDCEA,0xD7ECE6,0xD9E5FB,0xD2EBFA
    ,0xDAF3FF,0x002DA8,0x0036AA,0x0245AB
    ,0x124ECB,0x1156D3,0x2B72D4,0x287BD4
    ,0x1C6AE2,0x2C78E3,0x798793,0x2A83E4
    ,0x3D91E6,0x438AD6,0x639AE5,0x58A2E4
    ,0x5AA4FB,0x65B1FF,0x6BB3FD,0x79BAFF
    ,0xA4A6AC,0x86B2D7,0xABC4D3,0xBFD0DB
    ,0x96C3E8,0xCEDDF2,0xC5DDFE,0x5D6A75
    ,0x285DB6,0x3868AB,0x2666BB,0x487CBD
    ,0x0E60C8,0x1E73D8,0x2368C8,0x3C8BF6
    ,0x3E95F7,0x458BDB,0x4B8CDB,0x678CC1
    ,0x7BB9F4,0x7EB4FF,0x71B9FE,0x7AC4FF
    ,0x91959C,0x84A6D6,0x9EBDDE,0xA1BBD7
    ,0xC2BFCC,0xACC3E2,0xCCE2ED,0xF0E9EE
    ,0xFFFCF6,0x1457AC,0x1248BF,0x3A78BA
    ,0x6C7A87,0x257ADD,0x2D7CDA,0x2564E2
    ,0x72808D,0x2980CA,0x3B81CD,0x4180D1
    ,0x4A8BD4,0x6B94C3,0x7294C4,0x78ACD7
    ,0x4C9DEC,0x4AA1EB,0x43A1FF,0x5EA8F2
    ,0x5AA8F9,0x7AB4F5,0x9EAFC5,0xA3BCDC
    ,0xA9CAF6,0xB9CEF7,0xB5DAF4,0xC4D4EE
    ,0xCFE2E7,0xD7E9E9,0xDCF1EB,0xC5EAFF
    ,0xF0EEF3,0xF2EDFC,0x42515C,0x62707D
    ,0x0E4D99,0x265EA4,0x2763AA,0x2B71BD
    ,0x707D89,0x5072A1,0x265CD3,0x2479D4
    ,0x2A7CF1,0x6E84A6,0x7190AC,0x7A96BB
    ,0x2D80DE,0x2D8BE9,0x368EF2,0x5989C8
    ,0x5291C8,0x4686D9,0x4C92DE,0x739DD7
    ,0x67A3DE,0x79ABD9,0x598EE7,0x4C94E9
    ,0x5BA0EA,0x4EA3F4,0x75B6F1,0x818F9A
    ,0x9AAFD8,0x96B2D7,0xA5C1DB,0x8FC3EE
    ,0xA4C7ED,0xB1C7E9,0xADD2EC,0xBED3FC
    ,0xBFE6FF,0xD5E0DF,0xC3DCEB,0xC2D7FF
    ,0xC9DFFF,0xCBE4F3
};

static GUI_CONST_STORAGE GUI_LOGPALETTE Pallatte_coffee = {
  250,  /* number of entries */
  1,    /* Has transparency */
  &Colorslatte_coffee[0]
};

static GUI_CONST_STORAGE unsigned char aclatte_coffee[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x45, 0x32, 0x92, 0x4E, 0x4E, 0x92, 0x4E, 0x4E, 0x4E, 0x4E, 
        0x45, 0x3D, 0x3D, 0x76, 0x75, 0x75, 0x17, 0x0A, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x3C, 0xAB, 0x21, 0x46, 0x09, 0x21, 0x91, 0x58, 0xC3, 0xA7, 0xA6, 0xC3, 0xA7, 0xEE, 0xA9, 0xA9, 
        0x58, 0xC7, 0x64, 0x76, 0xCA, 0xCA, 0x0E, 0x0E, 0xCD, 0xCD, 0x1C, 0x21, 0x5A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x66, 0x2F, 0xAA, 0x59, 0x62, 0x62, 0xEF, 0xBB, 0x18, 0xB8, 0xD7, 0xB1, 0x5B, 0xB2, 0x83, 0xDE, 0xBD, 0xBD, 0xE9, 0x6E, 
        0x88, 0xC0, 0x6F, 0xA2, 0x2B, 0x2B, 0x43, 0x57, 0x35, 0xCB, 0x78, 0x77, 0x3D, 0x59, 0x09, 0x0E, 0x00, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x11, 0xC9, 0x2C, 0xAA, 0x59, 0xA6, 0xA6, 0x4C, 0xBB, 0x1F, 0x1F, 0x39, 0x9C, 0x39, 0x84, 0x83, 0x81, 0xB5, 0x6A, 0xB5, 0x84, 
        0xBC, 0x31, 0x87, 0xE8, 0x2A, 0x2A, 0x2A, 0x2A, 0x72, 0x35, 0x4E, 0x73, 0x73, 0x77, 0x50, 0x03, 0x1C, 0x11, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x64, 0x64, 0x44, 0x72, 0x2B, 0x3A, 0xA1, 0x4B, 0x1F, 0x2D, 0x54, 0x6A, 0x54, 0x96, 0x40, 0x9B, 0x18, 0x5E, 0x38, 0x40, 0x80, 0xD8, 
        0x5E, 0x5E, 0x68, 0xD3, 0xD2, 0xD1, 0x3E, 0x6A, 0x5B, 0x9B, 0x39, 0x39, 0xBE, 0xDD, 0x54, 0xA3, 0xF4, 0x65, 0x4F, 0x0A, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x21, 0x91, 0x02, 0x8D, 0x8D, 0x71, 0x4C, 0x1F, 0x53, 0x34, 0x6C, 0x6C, 0xC0, 0x6D, 0x6C, 0x98, 0x98, 0xE7, 0x1F, 0x40, 0x69, 0x69, 0x38, 
        0x6B, 0x5E, 0xE2, 0xA3, 0x57, 0x26, 0x88, 0x5B, 0x38, 0x40, 0x7B, 0x38, 0x83, 0xBE, 0x31, 0x6B, 0xBA, 0x44, 0x4F, 0x4F, 0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0A, 0x0E, 0x03, 0xF7, 0xC5, 0xE3, 0x71, 0xBF, 0x18, 0x7F, 0x7F, 0x9E, 0x52, 0x85, 0x6C, 0x2A, 0x2A, 0x8B, 0x3A, 0xE4, 0x4A, 0x67, 0x30, 0x9B, 0x3F, 0x7B, 0x48, 
        0x48, 0x34, 0xA9, 0x92, 0x45, 0x76, 0x35, 0x4C, 0x1F, 0x31, 0x30, 0x34, 0x30, 0x81, 0x9C, 0x39, 0xBF, 0x6D, 0x55, 0x35, 0x3D, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x07, 0x03, 0x09, 0xF3, 0xEC, 0x71, 0x3A, 0x5E, 0xB6, 0x84, 0x39, 0x87, 0x18, 0x6B, 0x6B, 0x2A, 0x18, 0x55, 0x2A, 0x60, 0x60, 0x6E, 0x6E, 0x3F, 0x30, 0x34, 0x34, 
        0xAE, 0x1F, 0xF8, 0x92, 0x45, 0x58, 0x4C, 0x4C, 0x1F, 0xAD, 0x7A, 0x3F, 0x29, 0x29, 0x83, 0x39, 0x89, 0x8A, 0x43, 0x60, 0x3D, 0x3D, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x28, 0x08, 0x1E, 0x3A, 0x71, 0x3A, 0x3A, 0x4A, 0x2A, 0x42, 0x1F, 0x90, 0xF0, 0x57, 0x90, 0x42, 0x3A, 0x42, 0x6F, 0xA0, 0x2A, 0x55, 0x26, 0x97, 0x43, 0x4B, 0x95, 
        0x64, 0x32, 0x44, 0x44, 0x39, 0x31, 0x5F, 0x49, 0x49, 0x7C, 0x7C, 0x7A, 0x49, 0x37, 0x38, 0x80, 0x88, 0xA2, 0x35, 0x57, 0xF2, 0xCB, 0x46, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x1E, 0x02, 0x4C, 0x71, 0x86, 0x55, 0x18, 0x4A, 0x5C, 0x2B, 0x62, 0x35, 0x4C, 0x26, 0xC1, 0x43, 0x18, 0x6F, 0xAF, 0xA0, 0x26, 0x55, 0x26, 0x26, 0x5C, 0x26, 
        0x91, 0x45, 0x41, 0xC4, 0x48, 0x67, 0x51, 0x29, 0x37, 0x37, 0xAE, 0xD6, 0x37, 0x37, 0x79, 0x79, 0x68, 0x18, 0x57, 0x35, 0xC6, 0xC6, 0x28, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x03, 0xAA, 0x8E, 0x18, 0x18, 0x18, 0xB6, 0x5C, 0x43, 0x18, 0x94, 0x72, 0x62, 0x8B, 0x5D, 0x26, 0x26, 0x26, 0xDF, 0x2A, 0x4A, 0x3A, 0x5D, 0x44, 0xA5, 0x65, 0x65, 
        0x2B, 0x26, 0xA3, 0x3E, 0x38, 0x29, 0x30, 0x37, 0x7D, 0x49, 0x37, 0x51, 0x37, 0x37, 0x37, 0x79, 0x29, 0x3F, 0x4B, 0x26, 0x35, 0x90, 0x76, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x03, 0xF6, 0x8E, 0x18, 0x52, 0x85, 0x18, 0x1F, 0xD0, 0x94, 0x2B, 0x72, 0x44, 0x42, 0x97, 0x2B, 0x9F, 0x43, 0x3A, 0x8B, 0x53, 0x2A, 0xC1, 0x72, 0x61, 0x73, 0xDA, 
        0x53, 0xEA, 0x29, 0x68, 0x38, 0x3E, 0x49, 0x49, 0xB3, 0x37, 0x51, 0x51, 0x29, 0x7A, 0x79, 0x7C, 0x7B, 0x48, 0x86, 0x4B, 0x57, 0x8D, 0x17, 0x32, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x91, 0x8E, 0x86, 0x4A, 0x5C, 0x18, 0x2D, 0x67, 0x3E, 0x39, 0x2B, 0x26, 0x2A, 0xAF, 0x43, 0x2B, 0x6A, 0x31, 0x2A, 0x60, 0xA0, 0x2B, 0x89, 0x3E, 0x2D, 0x2D, 
        0x3A, 0x26, 0xB7, 0x34, 0x38, 0x38, 0x7D, 0x29, 0x7D, 0x49, 0x40, 0x51, 0x40, 0x51, 0x37, 0x40, 0x7A, 0x3F, 0x18, 0x2A, 0x8D, 0x90, 0x77, 0x77, 0x07, 0x00, 0x08, 0x19, 0x06, 0x1B, 0x08, 0x23, 0x0D, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0F, 0x59, 0x56, 0x86, 0x53, 0x52, 0x18, 0x6C, 0x54, 0x3E, 0x7E, 0x60, 0x2A, 0x43, 0x43, 0x53, 0x2B, 0x1F, 0x2D, 0x60, 0x4A, 0x3A, 0xE0, 0x34, 0x29, 0x3E, 0x2D, 
        0x4B, 0x2A, 0x2B, 0x96, 0x29, 0x29, 0x49, 0x69, 0x7C, 0x7D, 0x51, 0x3F, 0x38, 0x69, 0xB3, 0x29, 0x67, 0x3F, 0x18, 0x8A, 0x35, 0x35, 0xF9, 0x77, 0x0D, 0x27, 0x0B, 0x0B, 0x02, 0x04, 0x09, 0x09, 0x1C, 0x21, 0x14, 0x07, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x5A, 0x66, 0x2F, 0x55, 0x95, 0x5D, 0xB8, 0x31, 0x2D, 0x31, 0x5F, 0x5C, 0x8B, 0xE6, 0x4B, 0x42, 0x6D, 0x9D, 0x1F, 0x9E, 0x4A, 0x18, 0x1F, 0x84, 0xDC, 0x9A, 0x40, 
        0x2D, 0x2D, 0x1F, 0x9A, 0x29, 0x48, 0x37, 0x29, 0x3E, 0x48, 0x52, 0xA1, 0x7E, 0x48, 0x38, 0x80, 0x7B, 0x30, 0xE5, 0x26, 0x58, 0x45, 0x17, 0x20, 0x08, 0x27, 0x10, 0x10, 0x0B, 0x02, 0x04, 0x2C, 0x21, 0x11, 0x14, 0x07, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x0A, 0x0A, 0x66, 0x35, 0x55, 0x96, 0x52, 0x34, 0x6D, 0x3F, 0x5B, 0x4A, 0x18, 0x4B, 0x94, 0xAD, 0x68, 0x87, 0x85, 0x1F, 0x1F, 0x31, 0x34, 0x39, 0xB2, 0x6E, 0x39, 
        0x29, 0x34, 0x31, 0x18, 0x1F, 0x7E, 0x29, 0x30, 0xA1, 0x5F, 0x2B, 0x4B, 0x7F, 0x29, 0x69, 0x80, 0x3E, 0x2D, 0x4C, 0x26, 0x45, 0x4E, 0x17, 0x08, 0x03, 0x27, 0x12, 0x10, 0x10, 0x10, 0x02, 0x04, 0x08, 0x21, 0x0F, 0x0E, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xAC, 0xAC, 0x0A, 0x0F, 0xF1, 0xD9, 0x95, 0x53, 0x30, 0x39, 0x2D, 0x18, 0x9E, 0x42, 0x1F, 0x1F, 0x68, 0x5D, 0x1F, 0x2D, 0x5B, 0x30, 0x18, 0x8A, 0x2D, 0x2D, 
        0x30, 0x5F, 0x48, 0x7F, 0x9A, 0x3F, 0x98, 0x67, 0x9C, 0x3E, 0x30, 0x31, 0x29, 0x30, 0x40, 0x3F, 0x97, 0x3A, 0x20, 0x20, 0x03, 0x28, 0x46, 0x21, 0x06, 0x12, 0x10, 0x10, 0x10, 0x2C, 0x15, 0x13, 0x05, 0x0D, 0x46, 0x28, 0x07,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x0A, 0x0F, 0x78, 0x45, 0x1F, 0x5D, 0x81, 0x99, 0x9D, 0x9D, 0x18, 0x18, 0x31, 0x18, 0x6F, 0x6F, 0x2D, 0x6E, 0x31, 0x39, 0x34, 0x6A, 0x2D, 0x7E, 
        0x38, 0x5F, 0x89, 0x89, 0x88, 0x54, 0xB1, 0x99, 0x81, 0x99, 0x30, 0x34, 0x5F, 0x30, 0x38, 0x30, 0x3A, 0x57, 0x76, 0x17, 0x28, 0x28, 0x21, 0x46, 0x05, 0x0B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x08, 0x20, 0x22,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x07, 0x07, 0x0A, 0x0A, 0x07, 0x07, 0x07, 0x4F, 0x59, 0x25, 0xA5, 0xBA, 0xE1, 0x18, 0x31, 0x31, 0x42, 0x1F, 0x8A, 0x18, 0x2A, 0xA2, 0x26, 0x26, 0x2B, 0x26, 
        0x42, 0x1F, 0x85, 0x52, 0x52, 0x6D, 0x54, 0x6B, 0x54, 0x31, 0x2B, 0x5C, 0xD5, 0xB9, 0x1B, 0x32, 0x1A, 0x0E, 0x1C, 0x1C, 0x03, 0x09, 0x33, 0x1E, 0x05, 0x05, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x02, 0x32, 0x1C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x07, 0x07, 0x07, 0x07, 0x0F, 0x07, 0x07, 0x5A, 0x0A, 0x78, 0x78, 0x62, 0x65, 0x1F, 0xB7, 0x34, 0x18, 0x1F, 0x87, 0x18, 0x1F, 0x1F, 0x42, 0x2B, 0x26, 0x2B, 0x2B, 
        0x18, 0x5D, 0x18, 0x5E, 0x18, 0x2D, 0x18, 0xBC, 0x5B, 0x34, 0x53, 0x26, 0x44, 0x62, 0x50, 0x32, 0x1A, 0x1A, 0x1C, 0x14, 0x15, 0x2F, 0x09, 0x08, 0x10, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x1E, 0x1C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x15, 0x08, 0xF5, 0x0A, 0x07, 0x07, 0x0A, 0x0A, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0A, 0x0A, 0x0E, 0x0E, 0x2F, 0x4F, 0x3D, 0x63, 0xED, 0xDB, 0x41, 0xB9, 0x41, 0x41, 0x41, 0x41, 
        0x41, 0x41, 0x9F, 0x9F, 0x41, 0xA5, 0x2E, 0x45, 0x15, 0x75, 0x08, 0x08, 0x24, 0x2E, 0x24, 0x08, 0x2C, 0x1E, 0x20, 0x20, 0x1A, 0x1A, 0x33, 0x04, 0x56, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x06, 0x10, 0x32, 0x22,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x15, 0x08, 0x0D, 0x0D, 0x0D, 0x2F, 0x07, 0x07, 0x0A, 0x0A, 0x0A, 0x0A, 0x07, 0x07, 0x07, 0x0A, 0x0E, 0x0E, 0x0E, 0x0E, 0x2F, 0x4F, 0x3D, 0x3D, 0x65, 0x65, 0x61, 0x61, 0x61, 0x61, 0x61, 0x35, 
        0x35, 0x35, 0x44, 0x44, 0xC5, 0xC4, 0x73, 0x02, 0x04, 0x19, 0x0D, 0x06, 0x8F, 0x2E, 0x04, 0x24, 0x1E, 0xC9, 0x59, 0x33, 0x2F, 0x75, 0x59, 0x02, 0x2E, 0x10, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x27, 0x10, 0x1E, 0x22,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x14, 0x08, 0x0D, 0x04, 0x04, 0x0D, 0x0D, 0x08, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x3C, 0x0F, 0x0F, 0x11, 0x11, 0x14, 0x15, 0x09, 0x09, 0x08, 0x08, 0x1B, 0x04, 0x04, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x1D, 0x1D, 0x05, 0x05, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x06, 0x02, 0x73, 0x1B, 0x08, 0x1E, 0x20, 0x1A, 0x1A, 0x15, 0x15, 0x09, 0x02, 0x24, 0x10, 0x27, 0x06, 0x00, 0x00, 0x0A, 0x00, 0x0B, 0x12, 0x0B, 0x33, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x1C, 0x0D, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0A, 0x0A, 0x0A, 0x07, 0x07, 0x07, 0x07, 0x07, 0x3C, 0x07, 0x0F, 0x0F, 0x66, 0x11, 0x14, 0x1C, 0x03, 0x08, 0x08, 0x1B, 0x06, 0x02, 0x8F, 0x02, 0x02, 0x02, 
        0x02, 0x1D, 0x1D, 0x1D, 0x0B, 0x1D, 0x0B, 0x1D, 0x1D, 0x1D, 0x02, 0x06, 0x02, 0x4D, 0x74, 0x08, 0x1E, 0x1E, 0x1A, 0x1A, 0x15, 0x23, 0x1E, 0x02, 0x02, 0x12, 0x13, 0x13, 0x0B, 0x0F, 0x07, 0x12, 0x13, 0x12, 0x04, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x11, 0x23, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x0D, 0x0D, 0x15, 0x0A, 0x0A, 0x0A, 0x07, 0x07, 0x0A, 0x0A, 0x07, 0x0F, 0x07, 0x3C, 0x22, 0x11, 0x03, 0x09, 0x2C, 0x24, 0x2E, 0x06, 0x02, 0x02, 0x02, 0x05, 0x05, 0x05, 
        0x56, 0x0B, 0x10, 0x10, 0x05, 0x27, 0x05, 0x02, 0x1D, 0x02, 0x06, 0x06, 0x06, 0x4D, 0x1B, 0x64, 0x32, 0x20, 0x21, 0x03, 0x03, 0x08, 0x02, 0x08, 0x0C, 0x0C, 0x12, 0x12, 0x13, 0x10, 0x0C, 0x12, 0x0C, 0x02, 0x23, 0x07, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x23, 0x04, 0x06, 0x19, 0x06, 0x06, 0x19, 0x06, 0x06, 0x06, 0x04, 0x08, 0x66, 0x0A, 0x0A, 0x07, 0x3C, 0x0F, 0x0A, 0x0A, 0x0F, 0x3C, 0x0F, 0x11, 0x11, 0x1A, 0x09, 0x2C, 0x04, 0x04, 0x8F, 0x8F, 0x05, 0x04, 0x05, 0x05, 0x05, 
        0x02, 0x8E, 0x02, 0x05, 0x05, 0x19, 0x1D, 0x0B, 0x1D, 0x1D, 0x06, 0x06, 0x02, 0x06, 0x63, 0x08, 0x20, 0x64, 0x21, 0x1C, 0x08, 0x08, 0x0B, 0x06, 0x0C, 0x0C, 0x16, 0x12, 0x0C, 0x16, 0x0C, 0x25, 0x0B, 0x1B, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x09, 0x04, 0x19, 0x19, 0x05, 0x02, 0x02, 0x02, 0x06, 0x06, 0x02, 0x04, 0x04, 0x11, 0x0F, 0x0F, 0x07, 0x0A, 0x07, 0x07, 0x07, 0x07, 0x0A, 0x11, 0x0F, 0x14, 0x1E, 0xC8, 0x08, 0x08, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x02, 0x02, 
        0x05, 0x05, 0x0B, 0xA8, 0x0B, 0x0B, 0x02, 0x02, 0x1D, 0x1D, 0x02, 0x02, 0x06, 0x04, 0x08, 0x36, 0x08, 0x09, 0x08, 0x32, 0x32, 0x2E, 0x1D, 0x02, 0x0C, 0x0C, 0x16, 0x16, 0x0C, 0x16, 0x25, 0xA7, 0x06, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1C, 0x04, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x06, 0x02, 0x04, 0x04, 0x04, 0x15, 0x0F, 0x0F, 0x0A, 0x0A, 0x07, 0x07, 0x3C, 0x07, 0x66, 0x11, 0x14, 0x14, 0xC8, 0x04, 0x0D, 0x0D, 0x0D, 0x06, 0x06, 0x06, 0x58, 0x06, 0x1D, 0x02, 
        0x05, 0x05, 0xA8, 0x19, 0x05, 0x05, 0x1D, 0x1D, 0x02, 0x1D, 0x02, 0x02, 0x06, 0x04, 0x36, 0x08, 0x08, 0x08, 0x08, 0x74, 0x1B, 0x10, 0x02, 0x02, 0x0C, 0x25, 0x3B, 0x16, 0x25, 0x0C, 0xC2, 0x58, 0x02, 0x20, 0x07, 0x00, 0x00,
  0x07, 0x00, 0x0F, 0x0D, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x19, 0x05, 0x04, 0x06, 0x04, 0x04, 0x08, 0x11, 0x0F, 0x0E, 0x0F, 0x0A, 0x0A, 0x0A, 0x0F, 0x0E, 0x11, 0x03, 0x09, 0x08, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xA8, 0x02, 0x02, 
        0x02, 0x0B, 0x0B, 0x0B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x02, 0x02, 0x06, 0x1B, 0x1B, 0x08, 0x08, 0x08, 0x32, 0x63, 0x2E, 0x10, 0x02, 0x02, 0x16, 0x70, 0x25, 0x3B, 0x12, 0x10, 0x02, 0x0C, 0x12, 0x06, 0x07, 0x0A, 0x00,
  0x00, 0x00, 0x11, 0x0D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x19, 0x04, 0x04, 0x0D, 0x08, 0x08, 0x03, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0x14, 0x15, 0x09, 0x0D, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x05, 0x05, 0x05, 0x02, 0x06, 0x1B, 0x1B, 0x1B, 0x63, 0x08, 0x04, 0x1B, 0xC2, 0x10, 0x02, 0x32, 0x12, 0x0C, 0x0C, 0x10, 0x10, 0x12, 0x12, 0x12, 0x13, 0x0B, 0x21, 0x07, 0x00,
  0x00, 0x0A, 0x15, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x19, 0x04, 0x04, 0x04, 0x08, 0x08, 0x23, 0x09, 0x11, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x11, 0x11, 0x03, 0x09, 0x08, 0x08, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x02, 0x02, 
        0x02, 0x0B, 0x1D, 0x0B, 0x02, 0x05, 0x05, 0x05, 0x02, 0x02, 0x02, 0x02, 0x06, 0x06, 0x1B, 0x74, 0x08, 0x63, 0x08, 0x02, 0x0C, 0x10, 0x02, 0x0B, 0x10, 0x12, 0x13, 0x12, 0x0C, 0x0C, 0x0C, 0x12, 0x12, 0x10, 0x08, 0x0A, 0x00,
  0x00, 0x07, 0x36, 0x19, 0x05, 0x05, 0x0B, 0x0B, 0x0B, 0x05, 0x05, 0x05, 0x04, 0x04, 0x0D, 0x2C, 0x08, 0x09, 0x09, 0x03, 0x11, 0x11, 0x11, 0x11, 0x11, 0x03, 0x03, 0x15, 0x09, 0x2C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x05, 0x05, 0x05, 0x05, 0x02, 0x1D, 0x02, 0x1D, 0x02, 0x02, 0x06, 0x1B, 0x06, 0x1B, 0x63, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x12, 0x0C, 0x0C, 0x16, 0x25, 0x16, 0x16, 0x0C, 0x3B, 0x12, 0x12, 0x13, 0x04, 0x0E, 0x00,
  0x07, 0x0A, 0x08, 0x06, 0x19, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04, 0x0D, 0x2C, 0x23, 0x09, 0x09, 0x15, 0x03, 0x03, 0x0E, 0x11, 0x11, 0x2F, 0x03, 0x15, 0x09, 0x08, 0x08, 0x04, 0x0D, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x02, 0x02, 
        0x02, 0x0B, 0x02, 0x0B, 0x02, 0x1D, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xC7, 0x1B, 0x1B, 0x1B, 0x1B, 0x0C, 0x25, 0x3B, 0x0C, 0x16, 0x25, 0x12, 0x16, 0x3B, 0x0C, 0x16, 0x3B, 0x0C, 0x0C, 0x12, 0x0B, 0x06, 0x28, 0x00,
  0x07, 0x07, 0x23, 0x04, 0x05, 0x05, 0x05, 0x0B, 0x05, 0x05, 0x05, 0x04, 0x04, 0x08, 0x08, 0x09, 0x09, 0x15, 0x03, 0x03, 0x15, 0x11, 0x11, 0x11, 0x03, 0x03, 0x15, 0x09, 0x23, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x02, 0x02, 
        0x02, 0x02, 0x0B, 0x02, 0x1D, 0x02, 0x1D, 0x02, 0x1D, 0x02, 0x02, 0x02, 0x4D, 0x06, 0x2E, 0x1B, 0x06, 0x1D, 0x25, 0xEB, 0x25, 0x10, 0x12, 0x13, 0x0C, 0x16, 0x3B, 0x16, 0x25, 0x3B, 0x0C, 0x12, 0x13, 0x0B, 0x04, 0x50, 0x07,
  0x00, 0x07, 0x03, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 0x04, 0x0D, 0x08, 0x09, 0x23, 0x09, 0x03, 0x03, 0x15, 0x03, 0x03, 0x03, 0x2F, 0x03, 0x03, 0x1A, 0x1A, 0x2C, 0x08, 0x24, 0x24, 0x04, 0x04, 0x06, 0x04, 0x06, 0x06, 0x06, 0x02, 0x02, 0x02, 
        0x0B, 0x02, 0x02, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x4D, 0x2E, 0x06, 0x06, 0x4D, 0x02, 0x10, 0x10, 0x10, 0x10, 0x13, 0x13, 0x0C, 0x12, 0x25, 0x16, 0x16, 0x16, 0x0C, 0x12, 0x10, 0x0B, 0x05, 0x08, 0x14, 0x07,
  0x00, 0x07, 0x0A, 0x0D, 0x06, 0x19, 0x05, 0x05, 0x05, 0x05, 0x06, 0x04, 0x08, 0x08, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x03, 0x03, 0x03, 0x15, 0x1A, 0x09, 0x2C, 0x08, 0x08, 0x08, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x02, 0x06, 0x02, 0x02, 
        0x02, 0x02, 0x05, 0x02, 0x1D, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x4D, 0x2E, 0x02, 0x02, 0x0C, 0x10, 0x13, 0x10, 0x13, 0x12, 0x12, 0x0C, 0x3B, 0x3B, 0x0C, 0x16, 0x16, 0x10, 0x10, 0x0B, 0x05, 0x06, 0x03, 0x0E, 0x07,
  0x00, 0x00, 0x0A, 0x21, 0x06, 0x06, 0x05, 0x05, 0x05, 0x06, 0x04, 0x04, 0x0D, 0x08, 0x09, 0x09, 0x15, 0x03, 0x03, 0x03, 0x03, 0x03, 0x15, 0x08, 0x15, 0x03, 0x09, 0x1E, 0x09, 0x08, 0x24, 0x24, 0x1B, 0x04, 0x04, 0x06, 0x04, 0x06, 0x06, 0x05, 0x02, 0x05, 
        0x05, 0x05, 0x0B, 0x05, 0x0B, 0x02, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x2E, 0x02, 0x02, 0x02, 0x16, 0x0C, 0x0C, 0x13, 0x13, 0x12, 0x12, 0x0C, 0x12, 0x16, 0x8C, 0x12, 0x0C, 0x12, 0x12, 0x10, 0x0B, 0x06, 0x04, 0x14, 0x0F, 0x07,
  0x00, 0x00, 0x07, 0x0E, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x08, 0x08, 0x08, 0x23, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x06, 0x04, 0x1A, 0x33, 0x1A, 0x2C, 0x1E, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x02, 0x02, 0x06, 0x02, 
        0x05, 0x02, 0x05, 0x02, 0x06, 0x02, 0x02, 0x06, 0x02, 0x2E, 0x02, 0x02, 0x02, 0x02, 0x25, 0x0C, 0x0C, 0x13, 0x12, 0x13, 0x10, 0x12, 0x12, 0x8C, 0x16, 0x13, 0x12, 0x13, 0x0C, 0x0B, 0x0B, 0x02, 0x06, 0x03, 0x11, 0x11, 0x07,
  0x00, 0x00, 0x07, 0x00, 0x11, 0x04, 0x05, 0x05, 0x19, 0x06, 0x04, 0x04, 0x08, 0x08, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x08, 0x03, 0x09, 0x09, 0x09, 0x2C, 0x1E, 0x08, 0x08, 0x04, 0x1B, 0x06, 0x04, 0x04, 0x02, 0x06, 0x05, 0x05, 
        0x02, 0x05, 0x02, 0x02, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x25, 0x0C, 0x10, 0x56, 0x13, 0x05, 0x10, 0x13, 0x13, 0x12, 0x13, 0x27, 0x13, 0x0B, 0x13, 0x0B, 0x0B, 0x05, 0x04, 0x15, 0x14, 0x1C, 0x0F, 0x00,
  0x00, 0x00, 0x0A, 0x00, 0x07, 0x1C, 0x04, 0x19, 0x05, 0x19, 0x06, 0x04, 0x08, 0x08, 0x08, 0x09, 0x15, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x04, 0x1A, 0x2F, 0x23, 0x2C, 0x09, 0x09, 0x08, 0x08, 0x04, 0x08, 0x04, 0x06, 0x04, 0x06, 0x06, 0x02, 0x02, 
        0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x56, 0x0C, 0x93, 0x13, 0x10, 0x05, 0x05, 0x56, 0x05, 0x0B, 0x10, 0x13, 0x0B, 0x10, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x02, 0x04, 0x03, 0x14, 0x14, 0x14, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x0D, 0x06, 0x19, 0x06, 0x04, 0x2C, 0x08, 0x09, 0x09, 0x21, 0x03, 0x03, 0x03, 0x03, 0x0E, 0x03, 0x28, 0x08, 0x08, 0x03, 0x50, 0x09, 0x08, 0x24, 0x08, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x04, 
        0x06, 0x06, 0x06, 0x02, 0x02, 0x02, 0x02, 0x05, 0x56, 0x0C, 0x82, 0xB0, 0x0C, 0x05, 0x02, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x08, 0x46, 0x03, 0x0F, 0x15, 0x47, 0x07, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x11, 0x23, 0x04, 0x06, 0x19, 0x04, 0x08, 0x09, 0x09, 0x09, 0x21, 0x03, 0x03, 0x17, 0x03, 0x17, 0x17, 0x1A, 0x09, 0x08, 0x09, 0x2F, 0x08, 0x08, 0x04, 0x04, 0x04, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x04, 
        0x06, 0x05, 0x06, 0x05, 0x05, 0x10, 0x13, 0x0C, 0x25, 0xB4, 0xCF, 0x10, 0x05, 0x02, 0x02, 0x02, 0x02, 0x06, 0x02, 0x05, 0x0B, 0x02, 0x19, 0x05, 0x19, 0x05, 0x06, 0x06, 0x09, 0x03, 0x03, 0x0F, 0x23, 0x1C, 0x07, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x0F, 0x15, 0x0D, 0x04, 0x04, 0x04, 0x08, 0x23, 0x21, 0x09, 0x15, 0x03, 0x14, 0x17, 0x0E, 0x03, 0x0E, 0x03, 0x1A, 0x23, 0x08, 0x03, 0x09, 0x04, 0x04, 0x06, 0x06, 0x06, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x0B, 0x10, 0x0C, 0x16, 0x25, 0x82, 0x93, 0x82, 0x16, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x4D, 0x06, 0x06, 0x02, 0x02, 0x06, 0x04, 0x02, 0x05, 0x06, 0x04, 0x1A, 0x20, 0x0E, 0x03, 0x0D, 0x14, 0x22, 0x47, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x07, 0x0A, 0x2F, 0x75, 0x04, 0x04, 0x0D, 0x08, 0x09, 0x09, 0x20, 0x03, 0x17, 0x03, 0x03, 0x0E, 0x03, 0x03, 0x0E, 0x03, 0x03, 0x23, 0x04, 0x09, 0x09, 0x04, 0x16, 0x05, 0x05, 0x27, 0x13, 0x13, 0x16, 0x16, 
        0x25, 0x70, 0xB4, 0x93, 0xCE, 0x70, 0xB0, 0x10, 0x02, 0x02, 0x02, 0x02, 0x58, 0x2E, 0x2E, 0x1B, 0x06, 0x4D, 0x02, 0x06, 0x04, 0x24, 0x06, 0x04, 0x04, 0x09, 0x03, 0x0E, 0x03, 0x0B, 0x0D, 0x09, 0x22, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x0A, 0x07, 0x07, 0x07, 0x1C, 0x23, 0x2C, 0x0D, 0x23, 0x23, 0x15, 0x09, 0x21, 0x03, 0x0E, 0x03, 0x03, 0x17, 0x03, 0x03, 0x03, 0x03, 0x33, 0x1A, 0x09, 0x2C, 0x04, 0x04, 0x06, 0x05, 0x05, 0x13, 0x12, 0x16, 
        0x13, 0x25, 0x16, 0x05, 0x04, 0x04, 0x04, 0x04, 0x08, 0x24, 0x24, 0x08, 0x04, 0x08, 0x08, 0x04, 0x08, 0x06, 0x0D, 0x08, 0x24, 0x04, 0x08, 0x08, 0x03, 0x11, 0x11, 0x14, 0x19, 0x0D, 0x36, 0x47, 0x07, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0A, 0x5A, 0x0A, 0x07, 0x07, 0x07, 0x11, 0x09, 0x09, 0x21, 0x08, 0x09, 0x15, 0x03, 0x03, 0x03, 0x50, 0x17, 0x17, 0x17, 0x03, 0x03, 0x03, 0x2F, 0x33, 0x03, 0x03, 0x1A, 0x2F, 0x2F, 0x1A, 0x4F, 0x78, 0x33, 
        0x1A, 0x1A, 0x1E, 0x1A, 0x1A, 0x1A, 0x1A, 0x09, 0x09, 0x09, 0x2C, 0x09, 0x09, 0x0D, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x24, 0x03, 0x09, 0x0E, 0x0F, 0x15, 0x8C, 0x05, 0x0D, 0x36, 0x22, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x22, 0x11, 0x0A, 0x07, 0x0A, 0x0F, 0x11, 0x09, 0x15, 0x09, 0x21, 0x21, 0x09, 0x03, 0x03, 0x03, 0x17, 0x0E, 0x0E, 0x50, 0x11, 0x03, 0x11, 0x03, 0x11, 0x11, 0x2F, 0x03, 0x03, 0x03, 0x14, 0x03, 
        0x03, 0x03, 0x14, 0x03, 0x15, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x08, 0x20, 0x20, 0x17, 0x1A, 0x50, 0x14, 0x09, 0xA4, 0x27, 0x19, 0x0D, 0xAB, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0A, 0x5A, 0x1C, 0x15, 0x0A, 0x07, 0x07, 0x0A, 0x0E, 0x0E, 0x21, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x17, 0x0E, 0x0E, 0x11, 0x11, 0x11, 0x0E, 0x28, 0x14, 0x0E, 0x28, 0x03, 0x11, 
        0x0E, 0x28, 0x03, 0x03, 0x0E, 0x14, 0x03, 0x33, 0x03, 0x03, 0x33, 0x03, 0x33, 0x20, 0x1E, 0x09, 0x50, 0x1E, 0x20, 0x33, 0x09, 0x09, 0xA4, 0x12, 0x0B, 0x04, 0x21, 0x22, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x22, 0x4F, 0x1C, 0x0D, 0x22, 0x0A, 0x07, 0x07, 0x0A, 0x11, 0x11, 0x14, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x14, 0x03, 0x17, 0x03, 0x28, 0x28, 0x28, 0x28, 0x17, 0x0E, 0x17, 0x17, 
        0x28, 0x28, 0x03, 0x17, 0x46, 0x20, 0x20, 0x03, 0x33, 0x20, 0x20, 0x09, 0x17, 0x03, 0x20, 0x08, 0x08, 0x08, 0x24, 0x1E, 0x70, 0x8C, 0x05, 0x04, 0x23, 0x22, 0x22, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x11, 0x21, 0x0D, 0x19, 0x0A, 0x0A, 0x0A, 0x0F, 0x0F, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x03, 0x03, 0x03, 0x14, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x28, 0x03, 0x20, 
        0x03, 0x17, 0x03, 0x03, 0x20, 0x20, 0x20, 0x17, 0x03, 0x20, 0x1E, 0x08, 0x1B, 0x04, 0x24, 0x1B, 0x04, 0x02, 0x16, 0x12, 0x05, 0x0D, 0x36, 0x1C, 0x22, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x22, 0x22, 0x36, 0x0D, 0x19, 0x19, 0x0A, 0x14, 0x14, 0x0E, 0x14, 0x14, 0x0E, 0x28, 0x33, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x33, 0x17, 0x03, 
        0x3D, 0x20, 0x32, 0x1E, 0x1E, 0x74, 0x24, 0x2E, 0x06, 0x04, 0x04, 0x06, 0x04, 0x08, 0x0D, 0xA4, 0x12, 0x27, 0x19, 0x0D, 0x36, 0x1C, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x14, 0x36, 0x23, 0x19, 0x05, 0x06, 0x14, 0x0E, 0x03, 0x03, 0x46, 0x09, 0x32, 0x1E, 0x1E, 0x1E, 0x08, 0x74, 0x24, 0x24, 0x1B, 0x1B, 0x1B, 
        0x06, 0x06, 0x06, 0x02, 0x02, 0x02, 0x2E, 0x02, 0x02, 0x06, 0x06, 0x0B, 0x3B, 0x16, 0x27, 0x0B, 0x0D, 0x0D, 0x1C, 0xCC, 0xAC, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x22, 0x1C, 0x36, 0x0D, 0x19, 0x27, 0x13, 0x06, 0x23, 0x1E, 0x1E, 0x1E, 0x1E, 0x24, 0x24, 0x04, 0x1B, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x02, 0x02, 0x10, 0x12, 0x3B, 0x3B, 0x16, 0x27, 0x19, 0x19, 0x0D, 0x1C, 0xAB, 0x47, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x0F, 0x14, 0x15, 0x36, 0x04, 0x19, 0x0B, 0x12, 0x16, 0x16, 0x0C, 0x13, 0x10, 0x10, 0x13, 0x10, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x25, 0x82, 0xD4, 0x70, 0x25, 0x16, 0x13, 0x13, 0x05, 0x06, 0x0D, 0x21, 0x14, 0x22, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x07, 0x22, 0x1C, 0x15, 0x36, 0x0D, 0x0D, 0x19, 0x05, 0x0B, 0x27, 0x27, 0x27, 0x13, 0x27, 0x13, 0x27, 
        0x13, 0x27, 0x27, 0x0B, 0x05, 0x19, 0x0D, 0x0D, 0x36, 0x1C, 0x22, 0x22, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x0A, 0x22, 0x22, 0x14, 0x14, 0x1C, 0x21, 0x23, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x0D, 0x08, 0x09, 0x36, 0x1C, 0x1C, 0x14, 0xCC, 0x0F, 0x3C, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x3C, 0x07, 0x3C, 0x47, 0x3C, 0x47, 0x22, 0x47, 
        0x0F, 0x07, 0x47, 0x22, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmlatte_coffee = {
  79, /* XSize */
  58, /* YSize */
  79, /* BytesPerLine */
  8, /* BitsPerPixel */
  aclatte_coffee,  /* Pointer to picture data (indices) */
  &Pallatte_coffee   /* Pointer to palette */
};

/* *** End of file *** */
