/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap converter for emWin V5.16.                           *
*        Compiled Jun  4 2012, 15:48:30                              *
*        (C) 1998 - 2010 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: chocolate_doughnut                                    *
* Dimensions:  90 * 65                                               *
* NumColors:   233                                                   *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR Colorschocolate_doughnut[] = {
     0xFFFFFF,0x000000,0x15193A,0x1C2344
    ,0x232948,0x171C41,0x343955,0x0D1437
    ,0x1B213C,0x030017,0x2B314B,0x79B7F5
    ,0x2B3353,0x050726,0x14142C,0x33384B
    ,0x272D51,0x69A5E9,0x545769,0x23263B
    ,0x44475A,0x474B64,0x67A7F6,0x85BAF7
    ,0x3C4259,0x5797E8,0x73A9EA,0x75AAF4
    ,0x669AE8,0x00000C,0x201B37,0x060D35
    ,0x110D31,0x89C2F8,0x120D29,0x94C7FA
    ,0x4C5167,0x0C112C,0x77B4EB,0x051646
    ,0x312C4C,0x86B6EB,0x374566,0x569AF4
    ,0xA6A7B7,0x274776,0x6896DA,0x6CB1F7
    ,0x000943,0x001556,0x2A4267,0x6B6D7A
    ,0x498CE5,0x88C1EE,0x727584,0x7BA3DA
    ,0x172B56,0x3C414D,0x698BCA,0x5AA1F6
    ,0x6BB0EB,0x838493,0xA4A4AA,0x99B6E4
    ,0xA7CAF4,0x201B44,0x153866,0x423B5D
    ,0x5C6177,0x4988D9,0x5889D7,0x789CD6
    ,0x568DE2,0x81838D,0x83A9E8,0x093775
    ,0x5A5D72,0x6A6C75,0x636579,0x696B82
    ,0x6D7282,0x7B7D8A,0x7595CB,0x8B92A6
    ,0x9B9CAC,0xA8C8E9,0xD1D3DC,0x062756
    ,0x293B64,0x797B85,0x7C8284,0x4C99F5
    ,0x8A8C94,0x8A8D9A,0xB5D4F8,0x150B1B
    ,0x000D53,0x001863,0x3B5679,0x4D505D
    ,0x475375,0x515570,0x72747D,0x567CBA
    ,0x618DD4,0x4D92EC,0x7CC1FC,0x9394A1
    ,0x9195AA,0x84A5D7,0x98B3D6,0xBABBC7
    ,0xB9C7D8,0xC8E5FE,0x0A020D,0x012768
    ,0x08356A,0x18427A,0x51555C,0x555971
    ,0x61636E,0x747A89,0x627CBC,0x7C808C
    ,0x7D8496,0x5695DA,0x68A2DC,0x719DEC
    ,0x8D909B,0x868BA2,0x9A9CA2,0x9DA3B6
    ,0xB2B4BD,0x8DA2C4,0xACB4C7,0xC3CBD6
    ,0xC9CDDB,0x2B323D,0x1F4268,0x504F66
    ,0x5B606B,0x606574,0x65697D,0x6D7178
    ,0x234D81,0x70728E,0x4477CD,0x7788B6
    ,0x3A86E4,0x728DC5,0x6D9AC9,0x5AA2EC
    ,0x858A8C,0x959AAB,0x94A6CA,0x9BC2EC
    ,0xB4CBE5,0xCBCCD4,0xC9D4E7,0x092249
    ,0x152C61,0x002174,0x173D75,0x42434E
    ,0x505A7A,0x656975,0x114288,0x194A92
    ,0x375485,0x455788,0x6E718B,0x757883
    ,0x777A96,0x5575AA,0x5A82BC,0x7288A8
    ,0x5A83C7,0x4D8FF0,0x709DF2,0x848995
    ,0x868C99,0x909297,0x93959C,0x96989F
    ,0x9699A3,0x9598B1,0x9DA0AA,0xADB0B2
    ,0x808FC0,0x8C9DC2,0x94ADDB,0xA9B5D2
    ,0xB0B9D3,0xA9C4DE,0xB7CAFA,0xA8D7FD
    ,0xCCD3DE,0x121E52,0x3B3F61,0x233D77
    ,0x344C75,0x595E7E,0x083C8F,0x064194
    ,0x3D5D92,0x3D6095,0x3B67A9,0x515E80
    ,0x436994,0x58699E,0x647698,0x4371AC
    ,0x4F7BB6,0x6678A9,0x2F6FC6,0x6482B6
    ,0x4C91DF,0x7BA1CC,0x858598,0x8B9292
    ,0x8F9CBA,0x9DA4A3,0xAEB0BC,0x8D9FD0
    ,0x80B0DF,0xBDC1C4,0xB7D4EB,0xC1C2CC
    ,0xC7C7D2,0xC5CBD9,0xC5C9E4,0xC7DCF6
    ,0xE1E4E5
};

static GUI_CONST_STORAGE GUI_LOGPALETTE Palchocolate_doughnut = {
  233,  /* number of entries */
  1,    /* Has transparency */
  &Colorschocolate_doughnut[0]
};

static GUI_CONST_STORAGE unsigned char acchocolate_doughnut[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0xBA, 0x6B, 0xB6, 0x80, 0x3D, 0x5A, 0x5A, 0x98, 0xDB, 0xDD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x6B, 0x5D, 0x7B, 0x36, 0x50, 0x4E, 0x4C, 0x12, 
        0x24, 0x15, 0x15, 0x15, 0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15, 0x12, 0x12, 0x4C, 0x4E, 0x51, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB7, 0x66, 0x33, 0x78, 0x12, 0x12, 0x76, 0x14, 0x14, 0x14, 0x14, 0x39, 0x18, 0x14, 0x0F, 0x39, 0x0F, 
        0x0A, 0x0A, 0x0F, 0x0A, 0x0A, 0x06, 0x0F, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x43, 0x15, 0x0F, 0x18, 0x14, 0x76, 0x76, 0x8F, 0x5C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBA, 0xB4, 0x8F, 0x44, 0x12, 0x12, 0x14, 0x18, 0x14, 0x06, 0x18, 0x06, 0x06, 0x0F, 0x06, 0x0F, 0x0A, 0x04, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x04, 0x04, 0x0A, 0x0A, 0x0C, 0x06, 0x06, 0x06, 0x0A, 0x0A, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x2A, 0x12, 0x12, 0x50, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB5, 0x59, 0x8F, 0x12, 0x63, 0x14, 0x18, 0x18, 0x06, 0x0F, 0x0F, 0x06, 0x0A, 0x0F, 0x0F, 0x0C, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 
        0x04, 0x04, 0x04, 0x04, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x06, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x14, 0x14, 0x12, 0x66, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x36, 0xA5, 0x44, 0x15, 0x14, 0x18, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x10, 0x04, 0x04, 0x04, 0x03, 0x05, 0x04, 0x04, 
        0x03, 0x04, 0x10, 0x0C, 0x04, 0x10, 0x10, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0A, 0x04, 0x04, 0x0A, 0x0A, 0x0A, 0x04, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x18, 0x15, 0x4C, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x36, 0x12, 0x63, 0x0F, 0x39, 0x06, 0x0F, 0x0A, 0x0A, 0x04, 0x0A, 0x04, 0x04, 0x04, 0x03, 0x04, 0x03, 0x03, 0x02, 0x05, 0x02, 0x03, 0x10, 0x10, 
        0x04, 0x10, 0x0C, 0x0C, 0x04, 0x0C, 0x10, 0x0C, 0x0C, 0x0A, 0x04, 0x0A, 0x0A, 0x0A, 0x0A, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x10, 0x06, 0x04, 0x06, 0x14, 0x14, 0x33, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x24, 0x14, 0x06, 0x0F, 0x06, 0x06, 0x0A, 0x0A, 0x04, 0x04, 0x03, 0x03, 0x05, 0x03, 0x02, 0x03, 0x07, 0x05, 0x05, 0x02, 0x02, 0x03, 0x04, 0x10, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x02, 0x04, 0x02, 0x08, 0x02, 0x02, 0x08, 0x02, 0x03, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0F, 0x06, 0x14, 0x12, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5C, 0x63, 0x39, 0x0A, 0x0A, 0x0A, 0x0F, 0x0A, 0x0A, 0x04, 0x04, 0x02, 0x08, 0x08, 0x07, 0x02, 0x02, 0x02, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x03, 0x04, 0x02, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x04, 0x02, 0x02, 0x02, 0x02, 0x05, 0x02, 0x02, 0x04, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0F, 0x06, 0x14, 0x12, 0x59, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0x0F, 0x0F, 0x0A, 0x04, 0x10, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x02, 0x07, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x04, 0x10, 0x03, 0x03, 0x05, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x04, 0x89, 0x0F, 0x78, 0x14, 0x9E, 0x87, 0x06, 0x0F, 0x04, 0x1E, 0x02, 0x02, 0x04, 0x05, 0x03, 0x03, 0x0A, 0x0A, 0x04, 0x04, 0x10, 0x10, 0x0C, 0x10, 0x06, 0x06, 0x14, 0x8D, 0x66, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB6, 0x0F, 0x0F, 0x0A, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x10, 0x03, 0x05, 0x03, 0x02, 0x02, 0x07, 0x07, 0x07, 0x02, 0x02, 0x03, 0x05, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x08, 0x04, 0x18, 0xB9, 0x9E, 0xC4, 0x87, 0x87, 0x56, 0x88, 0x88, 0x88, 0x4F, 0x43, 0x04, 0x1E, 0x02, 0x05, 0x02, 0x05, 0x10, 0x03, 0x03, 0x04, 0x10, 0x10, 0x10, 0x10, 0x10, 0x06, 0x06, 0x14, 0x14, 0x8C, 0x7B, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x07, 0x02, 0x04, 0x04, 0x02, 
        0x0C, 0x0F, 0x65, 0x15, 0x06, 0x04, 0x04, 0x12, 0x06, 0x91, 0x86, 0x88, 0xE5, 0xC4, 0x5D, 0x0F, 0x13, 0x02, 0x02, 0x02, 0x08, 0x03, 0x04, 0x04, 0x04, 0x10, 0x10, 0x10, 0x10, 0x06, 0x06, 0x06, 0x15, 0x24, 0x8E, 0xB3, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, 0x0F, 0x04, 0x04, 0x04, 0x04, 0x03, 0x05, 0x03, 0x03, 0x03, 0x05, 0x05, 0x03, 0x03, 0x03, 0x02, 0x03, 0x03, 0x03, 0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x07, 0x02, 0x08, 
        0x02, 0x24, 0x04, 0x08, 0x08, 0x13, 0x43, 0x6C, 0x24, 0x13, 0x13, 0x13, 0x89, 0x51, 0x2C, 0x7C, 0x70, 0x0F, 0x13, 0x02, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x10, 0x10, 0x10, 0x0A, 0x06, 0x06, 0x06, 0x14, 0x12, 0x36, 0xB4, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0F, 0x0F, 0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x08, 0x02, 0x02, 0x02, 0x07, 0x07, 0x07, 0x05, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x08, 0x02, 0x08, 0x02, 0x02, 0x08, 0x02, 0x08, 0x0E, 0x0E, 0x02, 0x04, 0x02, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x03, 0x04, 0x03, 0x04, 0x04, 0x0A, 0x04, 0x0C, 0x04, 0x0A, 0x0A, 0x06, 0x06, 0x15, 0x4C, 0x5A, 0x82, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x12, 0x0F, 0x0F, 0x04, 0x0C, 0x10, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x07, 0x07, 0x07, 0x02, 0x07, 0x02, 0x07, 0x05, 0x05, 0x02, 0x05, 0x02, 
        0x02, 0x02, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x02, 0x02, 0x02, 0x0D, 0x02, 0x02, 0x04, 0x41, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x10, 0x04, 0x04, 0x0A, 0x0A, 0x04, 0x0A, 0x0A, 0x0F, 0x14, 0x2A, 0x4D, 0x5A, 0xBB, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x12, 0x0A, 0x0A, 0x04, 0x04, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x05, 0x07, 0x07, 0x02, 0x07, 0x02, 0x1E, 0x13, 0x13, 0x78, 0x12, 0x13, 0x0A, 0x04, 
        0x04, 0x13, 0x04, 0x13, 0x04, 0x04, 0x02, 0x02, 0x02, 0x0D, 0x0E, 0x22, 0x0E, 0x0E, 0x28, 0xDA, 0x13, 0x1E, 0x02, 0x05, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x15, 0x4C, 0x3D, 0x2C, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x12, 0x14, 0x0A, 0x04, 0x04, 0x04, 0x04, 0x28, 0x04, 0x10, 0x10, 0x10, 0x04, 0x04, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x05, 0x05, 0x07, 0x07, 0x07, 0x05, 0x02, 0x04, 0x54, 0x6B, 0x36, 0x80, 0x14, 0x0F, 0x1E, 
        0x02, 0x0E, 0x02, 0x02, 0x02, 0x02, 0x1E, 0x25, 0x02, 0x0E, 0x25, 0x0E, 0x09, 0x09, 0x0E, 0x13, 0x1E, 0x02, 0x1E, 0x05, 0x05, 0x03, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x04, 0x04, 0x10, 0x04, 0x06, 0x18, 0x12, 0x51, 
        0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x24, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x10, 0x04, 0x04, 0x0A, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x02, 0x07, 0x02, 0x07, 0x02, 0x02, 0x04, 0x2C, 0x54, 0x81, 0x33, 0x12, 0x15, 0x0F, 0x02, 
        0x02, 0x0D, 0x0E, 0x22, 0x0E, 0x0E, 0x22, 0x0D, 0x25, 0x22, 0x22, 0x0E, 0x0E, 0x25, 0x0E, 0x02, 0x0E, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x10, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x04, 0x0A, 0x06, 0x15, 0x8E, 
        0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xB3, 0x12, 0x63, 0x0A, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x10, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x05, 0x02, 0x02, 0x07, 0x05, 0x08, 0x02, 0x43, 0x51, 0x50, 0x36, 0x14, 0x13, 0x13, 0x25, 0x25, 
        0x0E, 0x0D, 0x0D, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x22, 0x0D, 0x25, 0x25, 0x0E, 0x25, 0x0E, 0x08, 0x07, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x08, 0x18, 0x14, 
        0xA5, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x5C, 0x12, 0x12, 0x18, 0x04, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x10, 0x10, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x02, 0x07, 0x02, 0x02, 0x1E, 0x1E, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x1D, 0x09, 0x1D, 0x1D, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x02, 0x02, 0x04, 0x13, 0x02, 0x13, 0x03, 0x03, 0x03, 0x03, 0x04, 0x38, 0x03, 0x03, 0x03, 0x05, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x08, 0x08, 
        0x0F, 0x12, 0xAB, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB8, 0x66, 0x8C, 0x24, 0x06, 0x08, 0x08, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04, 0x03, 0x03, 0x04, 0x03, 0x04, 0x03, 0x02, 0x02, 0x05, 0x02, 0x13, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x25, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x72, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x09, 0x0E, 0x09, 0x09, 0x09, 0x0D, 0x0E, 0x0D, 0x0E, 0x0E, 0x13, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x03, 0x03, 0x03, 0x02, 0x03, 0x02, 0x02, 0x02, 0x03, 0x07, 0x08, 0x03, 
        0x0A, 0x18, 0x4D, 0x49, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x49, 0x12, 0x12, 0x24, 0x0A, 0x08, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0D, 0x0D, 0x09, 0x0D, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x1D, 0x01, 0x1D, 0x1D, 0x72, 0x5F, 0x5F, 0x22, 0x09, 0x09, 0x0D, 0x0D, 0x0D, 0x0D, 0x13, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x05, 0x05, 0x03, 0x03, 0x02, 0x05, 0x02, 0x02, 0x03, 0x02, 0x9F, 0x03, 0x03, 0x03, 
        0x08, 0x06, 0x12, 0x50, 0x82, 0x00, 0x00,
  0x00, 0x00, 0x98, 0x51, 0x12, 0x44, 0x24, 0x04, 0x08, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x02, 0x05, 0x02, 0x0D, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1D, 0x09, 
        0x09, 0x1D, 0x1D, 0x09, 0x1D, 0x1D, 0x09, 0x1D, 0x1D, 0x5F, 0x72, 0x09, 0x72, 0x09, 0x0D, 0x0D, 0x0D, 0x0D, 0x22, 0x04, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x05, 0x02, 0x02, 0x05, 0x02, 0x05, 0x02, 0x03, 0x05, 0x02, 0x02, 0x02, 0x07, 0x03, 0x05, 0x08, 
        0x04, 0x04, 0x24, 0x50, 0x5C, 0x00, 0x00,
  0x00, 0x00, 0x59, 0x33, 0x12, 0x65, 0x14, 0x08, 0x03, 0x02, 0x08, 0x02, 0x03, 0x03, 0x03, 0x05, 0x05, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x03, 0x03, 0x02, 0x20, 0x0D, 0x0D, 0x09, 0x09, 0x5F, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1D, 0x09, 0x1D, 0x1D, 0x09, 0x09, 0x09, 0x09, 0x0D, 0x0D, 0x0D, 0x05, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x02, 0x03, 0x02, 0x05, 0x05, 0x02, 0x05, 0x07, 0x07, 0x03, 0x27, 0x03, 0x05, 
        0x03, 0x04, 0x24, 0x44, 0x49, 0x00, 0x00,
  0x00, 0x00, 0x4D, 0x4E, 0x12, 0x15, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x02, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C, 0x0C, 0x02, 0x20, 0x02, 0x05, 0x09, 0x09, 0x09, 0x5F, 0x09, 0x09, 0x1D, 
        0x09, 0x32, 0x2A, 0x32, 0x38, 0x03, 0x07, 0x02, 0x0D, 0x09, 0x1D, 0x09, 0x09, 0x09, 0x0D, 0x0D, 0x0D, 0x1F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x07, 0x07, 0x05, 0x27, 0x03, 0x07, 0x03, 
        0x02, 0x03, 0x14, 0x12, 0x59, 0x6B, 0x00,
  0x00, 0x54, 0x33, 0x4F, 0x12, 0x14, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x05, 0x05, 0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x02, 0x02, 0x0E, 0x09, 0x09, 0x09, 0x1D, 0x09, 0x0D, 
        0x58, 0x90, 0x2D, 0xA6, 0x4B, 0x57, 0x57, 0x27, 0x07, 0x25, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x03, 0x05, 0x05, 0x02, 0x05, 0x05, 0x07, 0x07, 0x02, 0x02, 0x07, 0x07, 0x03, 0x05, 0x05, 0x03, 
        0x02, 0x04, 0x06, 0x77, 0x66, 0x3D, 0x00,
  0x00, 0x82, 0x33, 0x12, 0x24, 0x06, 0x04, 0x02, 0x02, 0x02, 0x02, 0x08, 0x02, 0x02, 0x02, 0x03, 0x05, 0x05, 0x05, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x06, 0x06, 0x25, 0x0E, 0x0D, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x32, 0x90, 0x90, 0x4B, 0x4B, 0xA2, 0x42, 0x2D, 0x2D, 0x32, 0x9F, 0x03, 0x0D, 0x09, 0x09, 0x0D, 0x0D, 0x03, 0x03, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x07, 0x07, 0x02, 0x05, 0x02, 0x05, 0x05, 0x07, 0x02, 0x02, 0x02, 0x03, 0x02, 0x05, 
        0x05, 0x04, 0x0F, 0x65, 0x4D, 0x3D, 0x00,
  0x00, 0x53, 0x77, 0x24, 0x18, 0x06, 0x02, 0x08, 0x08, 0x02, 0x08, 0x05, 0x08, 0x03, 0x03, 0x05, 0x05, 0x03, 0x03, 0x03, 0x04, 0x04, 0x03, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x28, 0x04, 0x0A, 0x0C, 0x03, 0x08, 0x0D, 0x0D, 0x09, 0x09, 0x0D, 
        0x62, 0x75, 0x74, 0x4B, 0x4B, 0x73, 0x42, 0x2D, 0x2D, 0x42, 0x8A, 0x38, 0x07, 0x0D, 0x0D, 0x0D, 0x02, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x02, 0x02, 0x05, 0x02, 0x05, 0x02, 0x02, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x02, 0x03, 0x02, 0x03, 0x05, 
        0x02, 0x04, 0x04, 0x65, 0x33, 0x49, 0x3E,
  0x00, 0x6C, 0x12, 0x15, 0x06, 0x0C, 0x08, 0x08, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x05, 0x03, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x03, 0x03, 0x02, 0x03, 0x04, 0x04, 0x0F, 0x28, 0x04, 0x0A, 0x0A, 0x0A, 0x13, 0x02, 0x0D, 0x09, 0x2D, 
        0x62, 0xA2, 0x74, 0x4B, 0x74, 0x42, 0x75, 0x2D, 0x74, 0x2D, 0xA8, 0x32, 0x27, 0x09, 0x09, 0x22, 0x28, 0x13, 0x04, 0x28, 0x04, 0x03, 0x05, 0x02, 0x02, 0x07, 0x05, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x02, 0x07, 0x02, 0x02, 0x08, 0x05, 0x05, 
        0x05, 0x05, 0x06, 0x8B, 0x36, 0xAB, 0xB7,
  0x00, 0x53, 0x64, 0x24, 0x0C, 0x0C, 0x03, 0x04, 0x08, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x02, 0x05, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x03, 0x03, 0x04, 0x09, 0x0C, 0x0C, 0x0C, 0x0C, 0x28, 0x02, 0x0D, 0x02, 0x2A, 
        0x32, 0x8A, 0x32, 0x42, 0x8A, 0x32, 0x58, 0x2A, 0x32, 0x62, 0x2D, 0x32, 0x1F, 0x0D, 0x0D, 0x28, 0x28, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x07, 0x02, 0x02, 0x1F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 0x07, 0x05, 0x08, 0x07, 0x03, 0x02, 
        0x05, 0x04, 0x06, 0x12, 0x8D, 0x79, 0x98,
  0x00, 0x83, 0x63, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x02, 0x08, 0x02, 0x02, 0x02, 0x02, 0x05, 0x03, 0x05, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x03, 0x04, 0x10, 0x06, 0x28, 0x43, 0x06, 0x0D, 
        0x0D, 0x07, 0x57, 0x42, 0x57, 0x0D, 0x09, 0x09, 0x0D, 0x27, 0x2D, 0x27, 0x27, 0x0D, 0x04, 0x28, 0x28, 0x04, 0x04, 0x04, 0x05, 0x05, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x20, 0x05, 0x20, 0x02, 0x1F, 0x02, 0x05, 0x05, 0x05, 0x03, 0x02, 0x05, 0x03, 
        0x02, 0x05, 0x06, 0x15, 0x4E, 0x8D, 0x5A,
  0x00, 0x9A, 0x62, 0x43, 0x06, 0x39, 0x0F, 0x02, 0x08, 0x08, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x03, 0x03, 0x02, 0x05, 0x03, 0x03, 0x05, 0x02, 0x02, 0x03, 0x05, 0x02, 0x03, 0x07, 0x05, 0x04, 0x0A, 0x0C, 0x04, 0x10, 0x04, 0x04, 0x0C, 0x06, 0x06, 0x03, 
        0x25, 0x0D, 0x09, 0x07, 0x03, 0x0D, 0x0D, 0x09, 0x0D, 0x06, 0x2A, 0x0C, 0x0D, 0x0C, 0x06, 0x06, 0x0C, 0x0A, 0x04, 0x04, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x20, 0x05, 0x02, 0x02, 0x02, 0x1F, 0x05, 0x07, 0x02, 0x07, 0x03, 0x02, 0x03, 0x03, 0x07, 
        0x1E, 0x04, 0x14, 0x24, 0x12, 0x4C, 0x79,
  0x00, 0xBD, 0x64, 0x06, 0x43, 0x0F, 0x0F, 0x08, 0x03, 0x07, 0x07, 0x03, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x07, 0x02, 0x05, 0x03, 0x07, 0x03, 0x04, 0x04, 0x0C, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0C, 0x0C, 0x06, 0x06, 
        0x0C, 0x07, 0x0D, 0x0D, 0x0D, 0x02, 0x0C, 0x10, 0x04, 0x1F, 0x0D, 0x07, 0x04, 0x06, 0x06, 0x0C, 0x0A, 0x04, 0x04, 0x08, 0x08, 0x08, 0x02, 0x02, 0x02, 0x05, 0x02, 0x05, 0x02, 0x20, 0x05, 0x1F, 0x02, 0x07, 0x05, 0x03, 0x02, 0x08, 0x08, 0x27, 0x07, 
        0x03, 0x04, 0x15, 0x77, 0x12, 0x12, 0x7C,
  0x00, 0x3F, 0xD1, 0x0C, 0x0C, 0x39, 0x0A, 0x04, 0x08, 0x07, 0x27, 0x02, 0x05, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x02, 0x03, 0x05, 0x05, 0x02, 0x05, 0x02, 0x02, 0x1F, 0x02, 0x05, 0x10, 0x04, 0x04, 0x04, 0x04, 0x0C, 0x0C, 0x04, 0x06, 0x10, 0x06, 0x06, 
        0x06, 0x06, 0x15, 0x06, 0x0D, 0x07, 0x0D, 0x02, 0x06, 0x04, 0x06, 0x2A, 0x06, 0x06, 0x0C, 0x04, 0x10, 0x04, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1F, 0x02, 0x1F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x05, 0x03, 0x03, 0x03, 0x08, 0x02, 
        0x13, 0x04, 0x15, 0x15, 0x8B, 0x12, 0x53,
  0x00, 0xC2, 0x93, 0x2A, 0x18, 0x18, 0x39, 0x0A, 0x08, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x02, 0x05, 0x07, 0x02, 0x05, 0x07, 0x07, 0x05, 0x02, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x28, 0x04, 0x04, 0x04, 0x04, 0x28, 0x04, 0x04, 
        0x28, 0x06, 0x04, 0x06, 0x06, 0x06, 0x18, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x10, 0x04, 0x04, 0x03, 0x05, 0x02, 0x07, 0x05, 0x1F, 0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x02, 0x1F, 0x07, 0x02, 0x02, 0x03, 0x03, 0x04, 0x03, 0x07, 0x07, 0x08, 
        0x04, 0x06, 0x15, 0x15, 0x15, 0x8B, 0xDC,
  0x00, 0xC2, 0x85, 0x93, 0x32, 0x06, 0x18, 0x0A, 0x08, 0x41, 0x02, 0x04, 0x02, 0x08, 0x02, 0x08, 0x02, 0x25, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x05, 0x07, 0x05, 0x04, 0x05, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 0x05, 0x04, 0x03, 0x02, 0x03, 0x03, 
        0x03, 0x02, 0x04, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x03, 0x04, 0x03, 0x05, 0x05, 0x05, 0x02, 0x02, 0x05, 0x05, 0x05, 0x05, 0x02, 0x05, 0x05, 0x02, 0x05, 0x02, 0x07, 0x07, 0x07, 0x07, 0x04, 0x02, 0x04, 0x06, 0x12, 0x15, 0x0C, 0x03, 0x02, 0x04, 
        0x04, 0x06, 0x14, 0x15, 0x2A, 0xD2, 0x70,
  0x00, 0x5E, 0xBE, 0x9A, 0x64, 0x18, 0x18, 0x0A, 0x0A, 0x02, 0x02, 0x41, 0x04, 0x08, 0x04, 0x08, 0x04, 0x02, 0x08, 0x02, 0x03, 0x02, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x10, 0x04, 0x10, 0x05, 0x05, 0x03, 0x05, 0x05, 0x05, 0x05, 0x03, 0x03, 0x05, 0x02, 
        0x03, 0x05, 0x03, 0x05, 0x04, 0x04, 0x02, 0x02, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x02, 0x05, 0x05, 0x05, 0x05, 0x05, 0x10, 0x0C, 0x06, 0x03, 0x03, 0x05, 0x27, 0x02, 0x03, 0x06, 0x0A, 0x14, 0x4F, 0x6C, 0x4C, 0x03, 0x07, 0x02, 0x0C, 
        0x06, 0x06, 0x06, 0x18, 0x2A, 0x85, 0x00,
  0x00, 0x00, 0x70, 0x7F, 0xD4, 0x24, 0x18, 0x0A, 0x0A, 0x41, 0x02, 0x08, 0x03, 0x04, 0x06, 0x65, 0x4E, 0x04, 0x02, 0x02, 0x04, 0x2A, 0xAC, 0x02, 0x02, 0x02, 0x05, 0x04, 0x41, 0x04, 0x02, 0x04, 0x03, 0x03, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x07, 0x02, 0x04, 0x04, 0x04, 0x03, 0x07, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x05, 0x02, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x06, 0x2A, 0x05, 0x03, 0x05, 0x02, 0x03, 0x04, 0x06, 0x15, 0x50, 0x53, 0x5D, 0x14, 0x02, 0x05, 0x10, 0x0C, 
        0x0F, 0x39, 0x06, 0x18, 0xCD, 0x47, 0x00,
  0x00, 0x00, 0xC0, 0x4A, 0x47, 0x15, 0x18, 0x0F, 0x0A, 0x04, 0x02, 0x03, 0x03, 0x06, 0x15, 0x44, 0xAA, 0x44, 0x04, 0x02, 0x02, 0x08, 0xE6, 0x04, 0xA4, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x02, 0x05, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x08, 0x07, 0x02, 0x04, 0x0C, 0x03, 0x05, 0x03, 0x05, 0x04, 0x06, 0x15, 0x4F, 0x99, 0x99, 0x12, 0x0F, 0x05, 0x41, 0x10, 0xC6, 
        0x0A, 0x0F, 0x18, 0x24, 0x52, 0x37, 0x00,
  0x00, 0x00, 0x6F, 0x7F, 0x1C, 0xD5, 0x58, 0x0F, 0xA3, 0x04, 0x02, 0x04, 0x04, 0x0A, 0x18, 0x77, 0x83, 0x8E, 0x13, 0x08, 0x02, 0x02, 0x04, 0x04, 0xC9, 0x0A, 0x04, 0x03, 0x03, 0x02, 0x02, 0x05, 0x07, 0x02, 0x02, 0x07, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x07, 0x07, 0x02, 0x02, 0x05, 0x02, 0x02, 0x02, 0x1F, 0x02, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x08, 0x08, 0x02, 0x03, 0x0A, 0x08, 0x08, 0x13, 0x28, 0x0F, 0x43, 0x4E, 0x4F, 0x14, 0x99, 0x83, 0x50, 0x13, 0x07, 0x03, 0x04, 0x0A, 
        0x0F, 0x18, 0x38, 0x93, 0x6D, 0x3F, 0x00,
  0x00, 0x00, 0x00, 0x1B, 0xB2, 0xBC, 0x64, 0x18, 0x0F, 0x04, 0x02, 0x02, 0x0C, 0x06, 0x18, 0x0F, 0x13, 0x02, 0x0A, 0x06, 0x08, 0x08, 0x02, 0x04, 0x02, 0x2A, 0x24, 0x06, 0x02, 0x7C, 0xC0, 0x10, 0x04, 0x05, 0x03, 0x04, 0x03, 0x02, 0x07, 0x05, 0x02, 0x03, 
        0x07, 0x05, 0x02, 0x02, 0x03, 0x02, 0x05, 0x05, 0x02, 0x02, 0x20, 0x05, 0x20, 0x05, 0x02, 0x02, 0x05, 0x08, 0x04, 0x0C, 0x03, 0x03, 0x03, 0x0C, 0x08, 0x08, 0x04, 0x06, 0x33, 0x3D, 0x3D, 0x2C, 0x3D, 0x79, 0x53, 0x13, 0x08, 0x07, 0x27, 0x0A, 0x04, 
        0x39, 0x0F, 0xA9, 0xBD, 0x6D, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6E, 0x1B, 0x46, 0x62, 0x0C, 0x0F, 0x04, 0x02, 0x05, 0x04, 0xA4, 0x81, 0x4F, 0x36, 0x06, 0x13, 0x08, 0x02, 0x08, 0x04, 0x08, 0x02, 0x02, 0x04, 0x04, 0x2A, 0x04, 0x14, 0x5D, 0xDE, 0x54, 0x49, 0x80, 0x4D, 0x6F, 0x56, 0x14, 0x6F, 
        0x6F, 0x56, 0x6F, 0x84, 0x12, 0x44, 0x15, 0x0F, 0x04, 0x04, 0x03, 0x05, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x04, 0x05, 0x05, 0x05, 0x04, 0x06, 0x7B, 0x49, 0x3E, 0x2C, 0x3E, 0x3E, 0x49, 0x6B, 0x15, 0x13, 0x02, 0x02, 0x02, 0x04, 0x04, 0x0A, 
        0x42, 0xAD, 0x1C, 0x1C, 0x87, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6E, 0x1C, 0x1C, 0xAF, 0x2A, 0x18, 0x0F, 0x04, 0x02, 0x07, 0x03, 0x24, 0xB9, 0x24, 0x7C, 0x0A, 0x08, 0x02, 0x13, 0x02, 0x02, 0x02, 0x02, 0x08, 0x02, 0x13, 0x08, 0x89, 0x13, 0x4D, 0xA3, 0x0F, 0xE3, 0xE4, 0x56, 0x9D, 0x56, 0x56, 
        0x56, 0x2C, 0x9D, 0x9D, 0xBB, 0x6C, 0x12, 0x15, 0x04, 0x15, 0x06, 0x03, 0x04, 0x03, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0xAA, 0x54, 0x2C, 0x3E, 0x3E, 0x3E, 0xB5, 0x3D, 0x8C, 0x13, 0x13, 0x02, 0x02, 0x13, 0x04, 0x0A, 0x0A, 
        0xCC, 0x52, 0x1C, 0xB2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xE8, 0x1A, 0x1C, 0x2E, 0xCE, 0x0C, 0x0C, 0x03, 0x02, 0x07, 0x02, 0x13, 0x15, 0x91, 0x15, 0x15, 0x04, 0x04, 0x08, 0x08, 0x08, 0x08, 0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x13, 0x1E, 0x04, 0x04, 0x06, 0x15, 0x06, 0x2C, 0x4F, 0xAC, 
        0x2C, 0x4E, 0x2C, 0x15, 0x14, 0x04, 0x06, 0x18, 0x04, 0x04, 0x04, 0x04, 0x10, 0x05, 0x02, 0x05, 0x05, 0x02, 0x02, 0x02, 0x02, 0x05, 0x05, 0x14, 0x6C, 0x2C, 0x83, 0x82, 0x3E, 0x5C, 0x3D, 0x33, 0x14, 0x04, 0x02, 0x05, 0x02, 0x02, 0x04, 0x38, 0x2D, 
        0x92, 0x48, 0x7F, 0x4A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x2E, 0x2E, 0xCF, 0x0C, 0x0C, 0x03, 0x03, 0x07, 0x02, 0x02, 0x08, 0x04, 0x0F, 0x04, 0x04, 0x04, 0x02, 0x02, 0x03, 0x02, 0x04, 0x08, 0x03, 0x08, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x02, 0x04, 0x04, 0x04, 0x1E, 0x13, 0x13, 0x08, 0x08, 0x08, 0x02, 0x08, 0x02, 0x03, 0x05, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x04, 0x15, 0x81, 0x91, 0x5C, 0x51, 0x4D, 0x36, 0x7B, 0x04, 0x0F, 0x02, 0x02, 0x1F, 0x05, 0x13, 0x04, 0x2D, 0x7A, 
        0x48, 0x1C, 0x17, 0xC3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC1, 0x1B, 0x1C, 0x1C, 0xA7, 0x42, 0x38, 0x04, 0x08, 0x02, 0x22, 0x02, 0x02, 0x02, 0x13, 0x02, 0x02, 0x03, 0x02, 0x02, 0x2A, 0x03, 0x03, 0x02, 0x03, 0x03, 0x07, 0x02, 0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x08, 0x03, 0x02, 0x04, 0x08, 0x04, 0x04, 0x04, 0x08, 0x02, 0x02, 0x04, 0x02, 0x04, 0x04, 0x02, 0x05, 0x04, 0x05, 0x0F, 0x0F, 0x14, 0x12, 0x36, 0x14, 0x18, 0x12, 0x06, 0x12, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xA0, 0xC7, 0x92, 0x46, 
        0x1C, 0x1C, 0xE1, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x2E, 0x1A, 0xBC, 0xC8, 0x06, 0x0F, 0x04, 0x13, 0x02, 0x0E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x03, 0x02, 0x02, 0x08, 
        0x08, 0x08, 0x02, 0x08, 0x02, 0x04, 0x02, 0x04, 0x02, 0x03, 0x04, 0x03, 0x02, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0F, 0x0F, 0x0F, 0x28, 0x13, 0x0F, 0x04, 0x13, 0x04, 0x02, 0x02, 0x02, 0x0E, 0x02, 0x02, 0x04, 0x64, 0x95, 0x52, 0x1C, 0x1C, 
        0x1B, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x3F, 0x1C, 0x1C, 0x48, 0x1C, 0x46, 0x4B, 0x38, 0x57, 0x04, 0x02, 0x02, 0x0E, 0x0E, 0x1E, 0x02, 0x02, 0x25, 0x0E, 0x02, 0x1E, 0x13, 0x02, 0x08, 0x08, 0x05, 0x02, 0x41, 0x05, 0x02, 0x0D, 0x0D, 0x07, 0x05, 
        0x05, 0x05, 0x05, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x05, 0x03, 0x03, 0x04, 0x08, 0x03, 0x04, 0x04, 0x08, 0x08, 0x08, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0E, 0x02, 0x02, 0x27, 0x38, 0xA7, 0x46, 0xB1, 0x34, 0x1C, 0x7F, 
        0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x19, 0x16, 0x19, 0x1C, 0x1A, 0x68, 0xAD, 0xA0, 0x04, 0x28, 0x1E, 0x1E, 0x22, 0x0E, 0x0D, 0x0E, 0x0D, 0x08, 0x0E, 0x0E, 0x0E, 0x1E, 0x0E, 0x08, 0x02, 0x02, 0x20, 0x41, 0x22, 0x02, 0x0D, 0x02, 0x02, 
        0x20, 0x05, 0x02, 0x02, 0x1E, 0x02, 0x02, 0x05, 0x05, 0x02, 0x02, 0x02, 0x02, 0x05, 0x02, 0x03, 0x08, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x07, 0x0E, 0x08, 0x02, 0x02, 0x02, 0x22, 0x02, 0x04, 0x58, 0xA9, 0x46, 0x2E, 0xB1, 0x2B, 0x1A, 0x1A, 
        0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x2E, 0x1A, 0x3B, 0x3B, 0x16, 0x11, 0x11, 0x1C, 0xD3, 0x73, 0x57, 0x27, 0x03, 0x1F, 0x1F, 0x1F, 0x30, 0x27, 0x1F, 0x1F, 0x02, 0x0E, 0x25, 0x02, 0x02, 0x05, 0x02, 0x20, 0x0E, 0x02, 0x09, 0x0E, 0x07, 
        0x07, 0x02, 0x02, 0x0E, 0x02, 0x0E, 0x0E, 0x02, 0x0E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x02, 0x02, 0x02, 0x08, 0x02, 0x02, 0x02, 0x02, 0x1F, 0x07, 0x1F, 0x07, 0x05, 0x73, 0x75, 0x45, 0x19, 0x19, 0x19, 0x11, 0x11, 0x3F, 0x40, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x1A, 0x19, 0x16, 0x11, 0x0B, 0x1B, 0x16, 0x2E, 0x37, 0xD9, 0xD0, 0x58, 0x38, 0xC5, 0x31, 0xA8, 0x7A, 0x27, 0x1F, 0x20, 0x02, 0x07, 0x0E, 0x02, 0x0D, 0x02, 0x02, 0x0E, 0x0E, 0x0E, 0x02, 0x25, 
        0x07, 0x25, 0x25, 0x0E, 0x0E, 0x02, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x02, 0x0E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x08, 0x02, 0x02, 0x20, 0x02, 0x1F, 0x10, 0x10, 0x58, 0x3A, 0x37, 0x11, 0x1C, 0x16, 0x16, 0x11, 0x1B, 0x40, 0x40, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x1C, 0x1B, 0x1C, 0x16, 0x11, 0x1B, 0x0B, 0x17, 0x0B, 0x1B, 0x1A, 0x11, 0x1C, 0x7D, 0x2E, 0x46, 0x31, 0x30, 0x30, 0x30, 0x0D, 0x02, 0x0E, 0x02, 0x22, 0x02, 0x0D, 0x02, 0x02, 0x20, 0x02, 
        0x02, 0x02, 0x02, 0x1E, 0x02, 0x02, 0x02, 0x1E, 0x02, 0x02, 0x02, 0x1E, 0x02, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0x27, 0x30, 0x60, 0x30, 0x30, 0x73, 0x61, 0xA6, 0x45, 0x19, 0x19, 0x16, 0x0B, 0x1B, 0x1A, 0x1A, 0x3F, 0x40, 0x9C, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x11, 0x16, 0x19, 0x11, 0x16, 0x17, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x0B, 0x1B, 0x1B, 0x47, 0x37, 0x95, 0x2D, 0x06, 0x04, 0x02, 0x02, 0x0E, 0x0E, 0x22, 0x0D, 0x22, 0x02, 0x22, 
        0x20, 0x02, 0x20, 0x20, 0x20, 0x02, 0x22, 0x22, 0x02, 0x22, 0x20, 0x1E, 0x20, 0x02, 0x02, 0x20, 0x20, 0x02, 0x05, 0x04, 0x10, 0x75, 0x67, 0x95, 0x47, 0xDF, 0x4A, 0x1A, 0x1B, 0x2F, 0x0B, 0x0B, 0x6A, 0x0B, 0x0B, 0x17, 0x23, 0x40, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x37, 0x1A, 0x11, 0x0B, 0x1B, 0x1B, 0x16, 0x16, 0x16, 0x16, 0x3C, 0x6A, 0x1A, 0x26, 0x11, 0x11, 0x19, 0x19, 0x48, 0x34, 0x92, 0xCA, 0xA1, 0x61, 0x31, 0x31, 0x30, 0x30, 0x30, 
        0x30, 0x60, 0x31, 0x31, 0x61, 0x31, 0x31, 0x60, 0x31, 0x31, 0x31, 0x60, 0x60, 0x61, 0x61, 0xA1, 0xCB, 0xD6, 0x45, 0x34, 0x2B, 0x34, 0x19, 0x94, 0x5B, 0x97, 0x19, 0x0B, 0x26, 0x6A, 0x21, 0x21, 0x0B, 0x23, 0x23, 0x23, 0x23, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x29, 0x1A, 0x11, 0x1B, 0x17, 0x19, 0x1B, 0x16, 0x16, 0x0B, 0x11, 0x26, 0x0B, 0x1B, 0x0B, 0x16, 0x16, 0x3B, 0x2B, 0x1C, 0x48, 0x2E, 0x2E, 0x3A, 0x96, 0x47, 0x52, 0x3A, 
        0x7A, 0x7A, 0x3A, 0x3A, 0x3A, 0xB0, 0x67, 0x3A, 0x2E, 0x68, 0x68, 0x68, 0x68, 0x48, 0x46, 0x45, 0x46, 0x34, 0x19, 0x2B, 0x69, 0x2B, 0x2B, 0x3B, 0x5B, 0x3B, 0x2F, 0x0B, 0x0B, 0x0B, 0x21, 0x0B, 0x0B, 0x23, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x4A, 0x3F, 0x11, 0x1A, 0x11, 0x11, 0x16, 0x11, 0x16, 0x11, 0x3C, 0x0B, 0x3C, 0x0B, 0x0B, 0x11, 0x11, 0x11, 0x19, 0xD8, 0x19, 0x2B, 0x3B, 0x19, 0x48, 0x45, 0x19, 
        0x45, 0x69, 0x19, 0x7D, 0x7D, 0x94, 0x94, 0x69, 0x34, 0x34, 0x5B, 0x34, 0x69, 0x19, 0x34, 0x19, 0x2B, 0x34, 0x2B, 0x16, 0x3B, 0x19, 0x16, 0x2F, 0x16, 0x11, 0x0B, 0x17, 0x26, 0x17, 0x17, 0x21, 0x23, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x1A, 0x2E, 0x7D, 0x19, 0x11, 0x11, 0x11, 0x3C, 0x11, 0x16, 0x0B, 0x11, 0x0B, 0x1A, 0x0B, 0x2F, 0x11, 0x16, 0x69, 0x19, 0x48, 0x19, 0x45, 0x45, 0x19, 
        0x34, 0x19, 0x3B, 0x3C, 0x2F, 0x5B, 0x5B, 0x5B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x2F, 0x97, 0x16, 0x16, 0x0B, 0x0B, 0x21, 0x17, 0x17, 0x23, 0x21, 0x23, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0x6E, 0x47, 0x37, 0x11, 0x11, 0x1B, 0x0B, 0x1A, 0x11, 0x11, 0x11, 0x16, 0x16, 0x2F, 0x16, 0x2F, 0x97, 0x7E, 0x7E, 0x55, 0x71, 0xE7, 0x9C, 0x96, 
        0x29, 0x0B, 0x21, 0x29, 0x21, 0x0B, 0x17, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x4A, 0x17, 0x23, 0x29, 0x35, 0x29, 0x21, 0x35, 0x9B, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4A, 0x11, 0x19, 0x19, 0x11, 0x1A, 0x17, 0x1B, 0x0B, 0x11, 0x16, 0x19, 0x11, 0x3B, 0x2F, 0x1A, 0x23, 0x71, 0x71, 0x71, 0x71, 0xC3, 
        0xE0, 0x0B, 0x6A, 0x21, 0x21, 0x21, 0x21, 0x0B, 0x21, 0x21, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x21, 0x0B, 0x0B, 0x17, 0x17, 0x17, 0x23, 0x23, 0x35, 0x23, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x47, 0x47, 0x17, 0x17, 0x16, 0x16, 0x11, 0x11, 0x7E, 0x11, 0x2F, 0x2F, 0x26, 0x0B, 0x5E, 0x5E, 0x5E, 0x5E, 0x23, 
        0x29, 0x0B, 0x0B, 0x17, 0x0B, 0x17, 0x21, 0x17, 0x17, 0x0B, 0x0B, 0x26, 0x26, 0x26, 0x26, 0x26, 0x17, 0x35, 0x21, 0x26, 0x35, 0x23, 0x23, 0x23, 0x35, 0x55, 0xC1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x1C, 0x1C, 0x1C, 0x16, 0x1B, 0x1B, 0x0B, 0x0B, 0x11, 0x3C, 0x3C, 0x37, 0x9B, 0x55, 0x55, 0x6E, 0x29, 
        0x29, 0x11, 0x3C, 0x11, 0x11, 0x1A, 0x1A, 0x0B, 0x1A, 0x3C, 0x0B, 0x11, 0x0B, 0x0B, 0x26, 0x29, 0x26, 0x21, 0x35, 0x35, 0x35, 0x17, 0x17, 0x35, 0x9B, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x37, 0x6D, 0x1A, 0x1C, 0x11, 0x1A, 0x16, 0x1B, 0x0B, 0x0B, 0x0B, 0x0B, 0x17, 0x26, 0x0B, 
        0x0B, 0x26, 0x11, 0x0B, 0x11, 0x26, 0x0B, 0x17, 0x0B, 0x26, 0x0B, 0x0B, 0x0B, 0x26, 0x0B, 0x21, 0x17, 0x21, 0x17, 0x23, 0x23, 0x9C, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0x2E, 0x1A, 0x1A, 0x1C, 0x1A, 0x11, 0x11, 0x11, 0x0B, 0x0B, 0x0B, 0x17, 0x21, 
        0x17, 0x6A, 0x0B, 0x0B, 0x2F, 0x29, 0x29, 0x26, 0x17, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x29, 0x17, 0x17, 0x29, 0x29, 0x5E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x53, 0x81, 0xAF, 0x85, 0xBE, 0x3F, 0x6D, 
        0x6D, 0x4A, 0x29, 0x1A, 0x29, 0x17, 0x4A, 0x29, 0x17, 0x6E, 0x3F, 0xBF, 0x9A, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9E, 0x40, 0x3F, 0x52, 
        0xD7, 0xAE, 0xAE, 0x67, 0x67, 0x67, 0x3A, 0xB0, 0x3A, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmchocolate_doughnut = {
  90, /* XSize */
  65, /* YSize */
  90, /* BytesPerLine */
  8, /* BitsPerPixel */
  acchocolate_doughnut,  /* Pointer to picture data (indices) */
  &Palchocolate_doughnut   /* Pointer to palette */
};

/* *** End of file *** */
