/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap converter for emWin V5.16.                           *
*        Compiled Jun  4 2012, 15:48:30                              *
*        (C) 1998 - 2010 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: orangejuice                                           *
* Dimensions:  52 * 49                                               *
* NumColors:   247                                                   *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR Colorsorangejuice[] = {
     0xFFFFFF,0x000000,0x1658F9,0x0558D6
    ,0x1767FA,0x0479E6,0x0768D7,0x1698FB
    ,0x0956F9,0x0867F8,0x1AA5FD,0x0657E8
    ,0x0895FA,0x1974FA,0x28A4FB,0x0687F6
    ,0x2797F8,0x0655C8,0x084AF8,0x1669D7
    ,0x0575DC,0x2567FC,0x0785EA,0x0149B6
    ,0x124DF8,0x35A5FB,0x59B5FC,0x0768E6
    ,0x1488E9,0x024BC7,0x1673DA,0x277AE4
    ,0x235AFD,0x5896F6,0x3787FB,0x55A7FC
    ,0x5CC4FA,0x1454EA,0x27B5FC,0x4CAAFC
    ,0x64A8FB,0x69B3FD,0x1677E3,0x3389EA
    ,0x0647E9,0x134EE7,0x2B87E9,0x4899FB
    ,0x1665E5,0x4689FC,0x88B4D6,0xDADBDC
    ,0xC7F1FF,0x0353BB,0x1858D8,0x3489DA
    ,0x3893F5,0x1BB3FA,0x64C4FD,0xABB8D7
    ,0x86ABF6,0x98CBFB,0xC5E8FE,0x2375D9
    ,0x2466E6,0x3677E4,0x2577FB,0x3895EA
    ,0x659BF6,0xAAC7E5,0x0964CD,0x3577C8
    ,0x1887F7,0x0AA1FF,0x6693D6,0x95C9F4
    ,0x93C9FB,0xD6D8DA,0xC8DAE9,0x0149D3
    ,0x2095EC,0x499BE9,0x5A98E7,0x4CA0E8
    ,0x4CB2FC,0x7CA5E8,0x97C0E0,0xBBC8E7
    ,0xBBF1FF,0xD5D6D8,0xD3DBE4,0xDCDEE0
    ,0xCFE1ED,0xD1E4F2,0x253A80,0x0848A7
    ,0x396ABA,0x013EC1,0x225EDC,0x256BDB
    ,0x367AFC,0x1181DA,0x2A89F7,0x5C9BD4
    ,0x7598CB,0x678AD0,0x518EEE,0x538AFA
    ,0x4EAAF4,0x42ABFE,0x6DACEC,0x72B3FB
    ,0x879BC3,0xA7B9E4,0x8DC9FB,0xA5CCFE
    ,0xA0D1FD,0xCBCED0,0xC0CDE4,0xDDE0E4
    ,0x0D2369,0x00277A,0x22397E,0x43566C
    ,0x16478B,0x274284,0x1254A7,0x2D5AA2
    ,0x285EB9,0x1B61B9,0x0D72BC,0x6A7C96
    ,0x506CA0,0x4479BB,0x115CC6,0x1666CB
    ,0x187DC7,0x286BC6,0x386BC3,0x2771CF
    ,0x3977D9,0x4279C9,0x416CE1,0x5F7BE5
    ,0x2E82D8,0x3C92DE,0x31B9FD,0x4A83C7
    ,0x5997CF,0x4887E9,0x6397EB,0x52A2ED
    ,0x41AAF6,0x46A4FF,0x76A7FB,0x879DD6
    ,0x95A1CA,0x88A5D8,0x96BEDC,0xB1AECC
    ,0x81B8E7,0x89BFE1,0x83BCEC,0xBBC6C6
    ,0xA4C2DD,0xB7C6DC,0x8CC7F8,0x9ACFF5
    ,0x9BD0F6,0xBBD5E5,0xA8CFFF,0xC1C3C5
    ,0xC6CED9,0xC8DAFB,0xD9E1E9,0xD1EAF9
    ,0x1C2F45,0x001D70,0x11236D,0x162F71
    ,0x1F3A7C,0x464361,0x003CA4,0x004185
    ,0x304A86,0x1A5CBD,0x204FA4,0x2F68A6
    ,0x2264B7,0x455E95,0x576192,0x4D6BA9
    ,0x5775A7,0x627EB2,0x335CCF,0x3269DC
    ,0x5D77C1,0x4A66D0,0x506CD6,0x4974E9
    ,0x467DF0,0x7182A8,0x7D89B5,0x4D82D7
    ,0x5784D9,0x4698DC,0x6B8BC8,0x7690DA
    ,0x63A1D5,0x46A6F2,0x4AA3FC,0x47B0FC
    ,0x72B1EC,0x76C0FF,0x8A8A8A,0x939E9E
    ,0x9A9A9A,0x8C9FB5,0x92A0A0,0xACACAC
    ,0xB5B9B9,0xB8B9BB,0x91A7D8,0xABB1CD
    ,0x80B7E6,0x86B9FF,0x91BDFF,0xB1BDE9
    ,0xC1BEDC,0x8DC1EC,0x95C6FB,0x9FD0FC
    ,0xA4C0F4,0xB2C5F5,0xAAD0FF,0xA5D9FF
    ,0xB6DEFF,0xC4CFCF,0xCACCCE,0xCBCEDF
    ,0xCFD3D3,0xCBD3DE,0xCEDCDC,0xD1D1D0
    ,0xD8D8D7,0xD2E8F1,0xD0E2FF
};

static GUI_CONST_STORAGE GUI_LOGPALETTE Palorangejuice = {
  247,  /* number of entries */
  1,    /* Has transparency */
  &Colorsorangejuice[0]
};

static GUI_CONST_STORAGE unsigned char acorangejuice[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x33, 0x59, 0x33, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0xD8, 0xD6, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4D, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0xEE, 0x33, 0xDB, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x4D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x33, 0x4D, 0x59, 0xDD, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x5B, 0x5B, 0x59, 0xAB, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x4D, 0x33, 0xAB, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4D, 0x75, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x77, 0x75, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0xF5, 0x5D, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x75, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xA2, 0x4B, 0xEB, 0x74, 0x74, 0xAA, 0x73, 0x3D, 0x3D, 0xA7, 0x3D, 
        0x3D, 0x3D, 0x4C, 0x4C, 0xA8, 0xA8, 0xA6, 0xA2, 0x5D, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xA0, 0xE5, 0x4B, 0x74, 0xE7, 0x73, 0x73, 0x3D, 0xE6, 0x4B, 0x4B, 
        0x4C, 0x3D, 0x4C, 0x72, 0x4B, 0xA7, 0x4C, 0x72, 0x5C, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x27, 0xD3, 0x54, 0x54, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x24, 0x3A, 
        0x3A, 0x3A, 0x24, 0x24, 0x24, 0x3A, 0x3A, 0x24, 0x4E, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0xD1, 0x98, 0x98, 0x6D, 0x54, 0x54, 0x1A, 0x1A, 0x1A, 0x29, 0x24, 0x24, 
        0x3A, 0x3A, 0x24, 0x24, 0x24, 0x24, 0x24, 0x1A, 0xA9, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x50, 0x50, 0x07, 0x07, 0x07, 0x07, 0x0E, 0x0A, 0x0E, 0x0E, 0x0A, 0x0E, 
        0x26, 0x26, 0x26, 0x26, 0x39, 0x26, 0x92, 0x92, 0x45, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x1C, 0x1C, 0x16, 0x0C, 0x0C, 0x0C, 0x07, 0x07, 0x0A, 0x0A, 0x0A, 0x39, 
        0x0E, 0x26, 0x26, 0x26, 0x39, 0x39, 0x26, 0x26, 0xA4, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x1C, 0x65, 0x1C, 0x1C, 0x0F, 0x0F, 0x0C, 0x0F, 0x07, 0x0C, 0x49, 0x0C, 
        0x49, 0x0C, 0x0A, 0x0A, 0x39, 0x39, 0x26, 0x0A, 0x9E, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x65, 0x65, 0x16, 0x05, 0x16, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C, 0x0C, 0x0C, 
        0x49, 0x49, 0x49, 0x0A, 0x0A, 0x39, 0x0A, 0x0E, 0x9E, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x1E, 0x1E, 0x05, 0x05, 0x05, 0x05, 0x16, 0x0F, 0x0F, 0x48, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x07, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x32, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x14, 0x14, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0C, 0x0C, 0x0C, 0x07, 0x0A, 0x0A, 0x0A, 0x0A, 0x32, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x13, 0x06, 0x06, 0x05, 0x14, 0x05, 0x05, 0x05, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0C, 0x0C, 0x07, 0x0C, 0x07, 0x0A, 0x0A, 0x0A, 0x32, 0x3E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x1E, 0x06, 0x06, 0x14, 0x14, 0x14, 0x14, 0x05, 0x16, 0x16, 0x0F, 0x0F, 
        0x0C, 0x0C, 0x0C, 0x07, 0x0A, 0x0A, 0x07, 0x07, 0x32, 0x3E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9D, 0x46, 0x46, 0x06, 0x14, 0x06, 0x14, 0x14, 0x05, 0x05, 0x05, 0x0F, 0x0F, 
        0x0F, 0x0C, 0x07, 0x07, 0x07, 0x0A, 0x0E, 0x0A, 0x32, 0x3E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x3B, 0xAD, 0xDE, 0x06, 0x06, 0x14, 0x06, 0x06, 0x14, 0x14, 0x14, 0x05, 0x05, 0x0F, 0x0F, 
        0x0C, 0x0C, 0x07, 0x0C, 0x07, 0x0A, 0x0E, 0x0A, 0x32, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE2, 0x44, 0x47, 0x5F, 0x95, 0x44, 0x6F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x21, 0x21, 0x21, 0x6A, 0x31, 0x31, 0x6B, 0x95, 0x1B, 0x03, 0x06, 0x06, 0x06, 0x1B, 0x05, 0x09, 0x05, 0x05, 0x16, 0x16, 
        0x16, 0x07, 0x07, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x32, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x45, 0x70, 0x3C, 0x55, 0x28, 0x96, 0x28, 0x21, 0x44, 0x21, 0x68, 0x68, 0x00, 0x00, 0x00, 0x00, 0x9D, 0x68, 0x52, 0x21, 0x6A, 0x6A, 0x22, 0x22, 0x41, 0x41, 0x03, 0x0B, 0x06, 0x06, 0x06, 0x1B, 0x1B, 0x1B, 0x05, 0x05, 0x16, 0x16, 
        0x1C, 0x07, 0x07, 0x0E, 0x0E, 0x19, 0x0E, 0x0E, 0x32, 0x58,
  0x00, 0x00, 0x00, 0xCC, 0x1B, 0x09, 0x66, 0x22, 0x48, 0x10, 0x10, 0x10, 0x0D, 0x0D, 0x0D, 0x0D, 0x47, 0x6F, 0x21, 0x9A, 0x64, 0x15, 0x31, 0x40, 0x31, 0x31, 0x22, 0x30, 0x30, 0x36, 0x11, 0x11, 0x03, 0x03, 0x14, 0x06, 0x06, 0x05, 0x05, 0x05, 0x16, 0x16, 
        0x1C, 0x07, 0x10, 0x10, 0x19, 0x6D, 0x19, 0x0E, 0xA1, 0x58,
  0x00, 0x00, 0x96, 0x60, 0x0B, 0x09, 0x0D, 0x0D, 0x0D, 0x0D, 0x48, 0x2A, 0x0D, 0x09, 0x0D, 0x0D, 0x29, 0xD5, 0x8C, 0x89, 0x25, 0x15, 0x40, 0x40, 0x25, 0x25, 0x13, 0x22, 0x64, 0x03, 0x11, 0x03, 0x03, 0x06, 0x46, 0x06, 0x14, 0x1B, 0x14, 0x05, 0x16, 0x16, 
        0x07, 0x07, 0x10, 0x0E, 0x19, 0x19, 0x19, 0x10, 0xA1, 0x58,
  0x00, 0x00, 0x11, 0x11, 0x0B, 0x04, 0x04, 0x0D, 0x09, 0x09, 0x09, 0x09, 0x04, 0x04, 0x21, 0x6F, 0x22, 0x22, 0x02, 0x08, 0x2D, 0x02, 0x08, 0x02, 0x02, 0x08, 0x2C, 0x02, 0x36, 0x21, 0x03, 0x36, 0x11, 0x13, 0x13, 0x13, 0x1B, 0x06, 0x05, 0x05, 0x05, 0x1C, 
        0x16, 0x07, 0x07, 0x07, 0x19, 0x19, 0x0E, 0x19, 0x56, 0x34,
  0x00, 0x83, 0x03, 0x03, 0x0B, 0x0D, 0x0D, 0x0D, 0x09, 0x09, 0x09, 0x09, 0x42, 0x2A, 0x28, 0x8C, 0x30, 0x03, 0x08, 0x08, 0x20, 0x20, 0x04, 0x02, 0x02, 0x2C, 0x25, 0x0B, 0x40, 0x40, 0x31, 0x1D, 0x11, 0x11, 0x13, 0x1F, 0x06, 0x1B, 0x14, 0x05, 0x05, 0x48, 
        0x16, 0x16, 0x07, 0x07, 0x19, 0x19, 0x0E, 0x19, 0x56, 0x58,
  0x00, 0x80, 0x03, 0x03, 0x0B, 0x04, 0x0D, 0x0D, 0x09, 0x09, 0x09, 0x04, 0x2E, 0x23, 0x15, 0x15, 0x12, 0x08, 0x02, 0x02, 0x20, 0x20, 0x18, 0x02, 0x02, 0x15, 0x02, 0x12, 0x20, 0x02, 0x21, 0x86, 0x03, 0x36, 0x13, 0x40, 0x14, 0x06, 0x05, 0x2A, 0x05, 0x1C, 
        0x1C, 0x1C, 0x07, 0x07, 0x0E, 0x0E, 0x19, 0x6D, 0x56, 0x34,
  0x8A, 0x80, 0x4F, 0x0B, 0x08, 0x09, 0x04, 0x0D, 0x09, 0x09, 0x1B, 0x0B, 0x38, 0x2F, 0x25, 0x04, 0x08, 0x08, 0x04, 0x02, 0x20, 0x18, 0x18, 0x20, 0x02, 0x2D, 0x02, 0x08, 0x02, 0x02, 0x3F, 0x29, 0x61, 0x03, 0x36, 0x63, 0x06, 0x06, 0x05, 0x05, 0x05, 0x16, 
        0x1C, 0x50, 0x0C, 0x07, 0x10, 0x0E, 0x19, 0x27, 0x56, 0xAF,
  0x13, 0x35, 0x03, 0x03, 0x0B, 0x1B, 0x09, 0x09, 0x09, 0x0B, 0x25, 0x4F, 0x28, 0x41, 0x02, 0x12, 0x02, 0x12, 0x02, 0x02, 0x02, 0x18, 0x2D, 0x2D, 0x02, 0x18, 0x12, 0x12, 0x0B, 0x20, 0x30, 0x1D, 0x41, 0x11, 0x03, 0x30, 0x1E, 0x13, 0x14, 0x1E, 0x2A, 0x1C, 
        0x2E, 0x66, 0x07, 0x10, 0x10, 0x0E, 0x27, 0x1A, 0xA4, 0x00,
  0x11, 0x11, 0x03, 0x03, 0x03, 0x0B, 0x0B, 0x09, 0x09, 0x0B, 0x1D, 0x2D, 0x23, 0x41, 0x02, 0x12, 0x18, 0x18, 0x18, 0x2D, 0x12, 0x12, 0x25, 0x20, 0x18, 0x02, 0x02, 0x12, 0x02, 0x02, 0x03, 0x25, 0x29, 0x35, 0x03, 0x13, 0x1E, 0x1E, 0x1E, 0x2A, 0x1C, 0x1C, 
        0x66, 0x10, 0x07, 0x10, 0x10, 0x10, 0x27, 0x1A, 0x3B, 0x00,
  0x46, 0x11, 0x03, 0x03, 0x03, 0x03, 0x0B, 0x0B, 0x03, 0x4F, 0x61, 0x64, 0x22, 0x25, 0x04, 0x02, 0x02, 0x18, 0x18, 0x20, 0x8F, 0xC2, 0x8E, 0xC7, 0x08, 0x02, 0x15, 0x02, 0x02, 0x2D, 0x2C, 0x2C, 0x28, 0x1D, 0x03, 0x0B, 0x1E, 0x1F, 0x1F, 0x1F, 0x2B, 0x2B, 
        0x22, 0x38, 0x48, 0x10, 0x50, 0x10, 0x27, 0x1A, 0x45, 0x00,
  0x06, 0x11, 0x13, 0x13, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x61, 0x44, 0x15, 0x30, 0x25, 0x0B, 0x18, 0x12, 0x20, 0x20, 0x44, 0x3C, 0x3C, 0x8E, 0x02, 0x02, 0x12, 0x12, 0x15, 0x2D, 0x18, 0x18, 0x2F, 0x17, 0x03, 0x0B, 0x13, 0x3F, 0x1F, 0x1F, 0x2E, 0x2B, 
        0x38, 0x38, 0x07, 0x10, 0x10, 0x0E, 0x27, 0x1A, 0x45, 0x00,
  0x30, 0x06, 0x03, 0x03, 0x06, 0x03, 0x03, 0x03, 0x11, 0x1D, 0x17, 0x2F, 0x09, 0x09, 0x08, 0x08, 0x02, 0x2C, 0x62, 0x62, 0x3C, 0xCF, 0xC6, 0x3C, 0x0B, 0x2C, 0x18, 0x12, 0x12, 0x12, 0x02, 0x02, 0x1F, 0x17, 0x03, 0x0B, 0x13, 0x2A, 0x1F, 0x1F, 0x2B, 0x22, 
        0x2E, 0x2E, 0x10, 0x10, 0x0E, 0x19, 0x27, 0x1A, 0x45, 0x00,
  0x2A, 0x06, 0x06, 0x06, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x1D, 0x35, 0x23, 0x09, 0x1B, 0x08, 0x0B, 0x12, 0x12, 0x36, 0x6B, 0x69, 0xC4, 0x8F, 0xC5, 0x02, 0x02, 0x02, 0x02, 0x12, 0x12, 0x12, 0x20, 0x23, 0x1D, 0x4F, 0x0B, 0x13, 0x1E, 0x1F, 0x41, 0x2E, 0x2B, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x19, 0x23, 0x23, 0x57, 0x00,
  0x89, 0x47, 0x06, 0x06, 0x06, 0x06, 0x03, 0x11, 0x11, 0x1D, 0x17, 0x23, 0x04, 0x1B, 0x08, 0x08, 0x04, 0x15, 0x2C, 0x2D, 0x21, 0x6B, 0xC8, 0xC3, 0x02, 0x02, 0x12, 0x12, 0x08, 0x08, 0x04, 0x15, 0x99, 0x35, 0x03, 0x06, 0x1E, 0x1E, 0x90, 0x2B, 0x2E, 0x2B, 
        0x43, 0x43, 0x43, 0x2F, 0x53, 0x6C, 0x29, 0x29, 0xA5, 0x00,
  0x00, 0x47, 0x06, 0x13, 0x06, 0x11, 0x03, 0x11, 0x11, 0x1D, 0x17, 0x31, 0x42, 0x04, 0x08, 0x08, 0x02, 0x2C, 0x25, 0x15, 0x62, 0x36, 0x31, 0x63, 0x15, 0x18, 0x08, 0x02, 0x08, 0x09, 0x02, 0x0B, 0x38, 0x35, 0x03, 0x30, 0x1E, 0x2A, 0x37, 0x2B, 0x2B, 0x38, 
        0x43, 0x38, 0x27, 0xD2, 0x6C, 0x6C, 0x29, 0x28, 0x3B, 0x00,
  0x00, 0xC9, 0x88, 0x82, 0x13, 0x11, 0x11, 0x1D, 0x17, 0x17, 0x17, 0x1F, 0x2A, 0x2A, 0x08, 0x08, 0x02, 0x02, 0x08, 0x0B, 0x02, 0x02, 0x15, 0x15, 0x02, 0x04, 0x08, 0x08, 0x04, 0x02, 0x2E, 0x2F, 0x8B, 0x87, 0x46, 0x13, 0x37, 0x37, 0x37, 0x91, 0x43, 0x51, 
        0x53, 0x97, 0x28, 0x6E, 0x6E, 0x6E, 0x4A, 0x69, 0xEF, 0x00,
  0x00, 0x00, 0x88, 0x82, 0x11, 0x11, 0x1D, 0x1D, 0x11, 0x17, 0x17, 0x86, 0x2F, 0x1F, 0x04, 0x08, 0x04, 0x2C, 0x0D, 0x04, 0x04, 0x02, 0x15, 0x02, 0x02, 0x04, 0x02, 0x08, 0x08, 0x08, 0x90, 0x27, 0x8B, 0x81, 0x87, 0x1E, 0x37, 0x37, 0x37, 0x91, 0x43, 0x2F, 
        0x53, 0x51, 0x67, 0x52, 0x29, 0x72, 0x4A, 0x4A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xC0, 0xBC, 0x81, 0x35, 0x35, 0x17, 0x17, 0x17, 0x5F, 0x23, 0x22, 0x0D, 0x04, 0x09, 0x04, 0x02, 0x08, 0x15, 0x04, 0x15, 0x04, 0x09, 0x04, 0x0B, 0x15, 0x13, 0x13, 0xCD, 0x53, 0x9F, 0xE4, 0xAC, 0xAE, 0x5A, 0x5A, 0x5C, 0x4E, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0xF6, 0x71, 0x94, 0x67, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x17, 0x17, 0x17, 0x17, 0x5F, 0xB6, 0x13, 0x1A, 0x0B, 0x1B, 0x09, 0x0B, 0x04, 0x02, 0x15, 0x02, 0x04, 0x04, 0x04, 0x08, 0x08, 0x04, 0x22, 0x42, 0x23, 0xB7, 0xB5, 0x9F, 0xAC, 0xF1, 0x5A, 0x5A, 0x5C, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0xAD, 0x9B, 0x67, 0xD4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x7D, 0x5E, 0x5E, 0x7A, 0x5E, 0x7A, 0xB1, 0x9A, 0x23, 0x3F, 0x0D, 0x04, 0x04, 0x0D, 0x04, 0x04, 0x42, 0x42, 0x0D, 0x04, 0x09, 0x04, 0x1F, 0x28, 0x93, 0x7C, 0x7B, 0xD9, 0xA3, 0xED, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0xA6, 0x94, 0x9C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7D, 0xB4, 0xB3, 0x78, 0x78, 0xB2, 0x79, 0x79, 0x2F, 0x29, 0x1B, 0x0D, 0x0D, 0x0D, 0x04, 0x04, 0x42, 0x04, 0x04, 0x04, 0x0D, 0x09, 0x28, 0x21, 0x85, 0xBB, 0x7B, 0xB0, 0xD7, 0xA3, 0xF3, 0xF4, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0xD0, 0x4A, 0x57, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xBF, 0x85, 0x4A, 0x28, 0x51, 0x3F, 0x2E, 0x3F, 0x13, 0x1F, 0x3F, 0x63, 0x2B, 0x97, 0x23, 0x3C, 0x55, 0x9B, 0xCE, 0x84, 0xC1, 0x9C, 0xCA, 0x70, 0x71, 0x76, 0x5C, 0x3E, 0xAF, 
        0x00, 0x00, 0xF2, 0xDA, 0x45, 0x3E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x7F, 0xB9, 0x21, 0x23, 0x29, 0x27, 0x99, 0x1A, 0x29, 0x28, 0x2F, 0x52, 0x51, 0x55, 0x3C, 0x00, 0x00, 0x00, 0xE8, 0x57, 0xE3, 0x71, 0x3B, 0xA5, 0x76, 0xA9, 0x4E, 
        0x00, 0x00, 0x00, 0x00, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBE, 0xBD, 0xB8, 0x7C, 0x7F, 0x47, 0x93, 0x8D, 0x60, 0xBA, 0x8A, 0x69, 0x55, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8D, 0xCB, 0x52, 0x44, 0xE1, 0xAA, 0xEA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmorangejuice = {
  52, /* XSize */
  49, /* YSize */
  52, /* BytesPerLine */
  8, /* BitsPerPixel */
  acorangejuice,  /* Pointer to picture data (indices) */
  &Palorangejuice   /* Pointer to palette */
};

/* *** End of file *** */
