/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap converter for emWin V5.16.                           *
*        Compiled Jun  4 2012, 15:48:30                              *
*        (C) 1998 - 2010 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: glazed_doughnut                                       *
* Dimensions:  61 * 47                                               *
* NumColors:   247                                                   *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*   Palette
The following are the entries of the palette table.
Every entry is a 32-bit value (of which 24 bits are actually used)
the lower   8 bits represent the Red component,
the middle  8 bits represent the Green component,
the highest 8 bits (of the 24 bits used) represent the Blue component
as follows:   0xBBGGRR
*/

static GUI_CONST_STORAGE GUI_COLOR Colorsglazed_doughnut[] = {
     0xFFFFFF,0x000000,0x6787D7,0x3865C7
    ,0x4569C9,0x7797D7,0x355ABA,0x7797E5
    ,0x567AD6,0x4975D5,0x355CC3,0x6589E3
    ,0x5984D9,0x5A85E3,0x738CD8,0x476DD3
    ,0x4873CA,0x6994D8,0x6787CB,0x7AA3D9
    ,0x4665BC,0x2A54B8,0x2B5BC4,0x839CE3
    ,0x5985C8,0x617ED5,0x77A5E6,0xB7C8F9
    ,0x5877C7,0x8AB2E4,0xD7E2F8,0x627CCB
    ,0x819BDC,0x3D74C8,0x3754AA,0x587CE2
    ,0xABC4E8,0x386AD3,0x3B72D3,0x87A7F3
    ,0x3862BC,0x425CB9,0x2B63C6,0x536BCB
    ,0x788BC7,0x7798C9,0x718DE1,0x6A93E7
    ,0x8DB1DA,0x92B3DB,0x84A2E2,0x6A96CE
    ,0x8697CA,0x9CB3DC,0x92AAE3,0x93ABDB
    ,0x8BA5EB,0xB9C5D7,0xCBD2E4,0x314CA6
    ,0x4B80DB,0x94AAEB,0x5B93D8,0x83A3D4
    ,0x93A4DC,0xA3ADD8,0x8BA3E2,0x9CADE3
    ,0x93AAF3,0xA2B4E3,0xBBD2FC,0x253C96
    ,0x264296,0x2948A7,0x8BA3DC,0x90A1D4
    ,0x94B8DC,0x91A4E1,0x90B5E5,0x9AB3E1
    ,0x9CBBE3,0x9CB2F3,0xA1AFE4,0xD2D2E2
    ,0x234BB3,0x79A1CC,0x6992F3,0x79A1F5
    ,0x8295D3,0x839BD3,0x8196D9,0x8A9EDE
    ,0x8CACDC,0xA2B2DB,0x8BAAEC,0xAABAE3
    ,0xA3B3EB,0xAABAEA,0xB3BBE4,0xACC4F7
    ,0xCCD4F3,0xCAD2FB,0xE4E3E3,0x223A8C
    ,0x537ABB,0x506FD7,0x497AE4,0x607FE7
    ,0x5D92E7,0x8BA3D4,0x83A3DC,0x83ABDB
    ,0x99ACDB,0x9DB8DA,0x83ABE2,0xA4BCE4
    ,0xA5BBEA,0xA5B5F1,0xACC1D5,0xBBC5EB
    ,0xC2CDE1,0xDCDDE4,0xCBDAFE,0xD5DDF2
    ,0xDCE1E3,0x1C3896,0x4A76B8,0x2F62D2
    ,0x6A87B4,0x4B83EA,0x8A98B7,0x8B9BD5
    ,0x84AAD5,0x94B2D5,0xA1AED4,0xAAB4DC
    ,0x99ACEB,0x96B9EE,0xACB3E2,0xA8B4E9
    ,0xB2BCEB,0xABBCF2,0xB2C2EA,0xC3C9D6
    ,0xCACDDC,0xC7D4DB,0xDBDCED,0x162A75
    ,0x193487,0x324898,0x445DAE,0x7988B3
    ,0x6FA1D2,0x6EA1E4,0x86A5CD,0x9AA5CD
    ,0x98A7DE,0x9CB5D7,0xB4B9CD,0xA4B3D4
    ,0xA2BADA,0xB5BDDC,0x8BABE1,0x91A6EB
    ,0x9BB2EC,0xA4BAF2,0x9FC0E5,0xBAC3E4
    ,0xB4CDEC,0xC3C4E3,0xCAD1EA,0xD4DBEB
    ,0xC3CCF2,0xC4D5FD,0xDDE4ED,0x14266F
    ,0x243FA0,0x2B52AF,0x2561BF,0x5280BE
    ,0x7684A4,0x789DF4,0xA8B0B9,0x8AADD1
    ,0x9AABD4,0xA6ACCA,0xA5B2C7,0xAAB6D2
    ,0x84A3EA,0x95B3EC,0x91B7FF,0x99B2FD
    ,0xB0B6E1,0xA2BBF9,0xB1BFF4,0xBCC9EB
    ,0xC2C4D3,0xC3C9DE,0xDCDBDD,0xC8C7E5
    ,0xC5CDEC,0xC8CEED,0xC5D1E2,0xD1D6EA
    ,0xC5D2F3,0xC4DCFF,0x000F60,0x2F509F
    ,0x1F4CAD,0x777F95,0x4C62A8,0x637FAB
    ,0x7B828F,0x4E87C9,0x6EA4F0,0x888C95
    ,0x868FAB,0x979BA4,0x9BA3B4,0xA7AABB
    ,0x8896D1,0x909ED9,0xB3B6C7,0xBBBECF
    ,0xA8BCD3,0xACB9DB,0x84B1F1,0x96B1F3
    ,0x9EBAFA,0xC0BFDD,0xBCC9E7,0xCBC9D4
    ,0xD2D2DF,0xD6DADC,0xE3DFDE,0xDEE1DD
    ,0xE2E0DA,0xC9CDE1,0xCFDAE7,0xC6D2EC
    ,0xCCD8E9,0xD8D6E7,0xC1C5F0,0xD3DCF8
    ,0xE1DDE8,0xE1E9F0,0xEAF2F9
};

static GUI_CONST_STORAGE GUI_LOGPALETTE Palglazed_doughnut = {
  247,  /* number of entries */
  1,    /* Has transparency */
  &Colorsglazed_doughnut[0]
};

static GUI_CONST_STORAGE unsigned char acglazed_doughnut[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xE9, 0x53, 0x90, 0x53, 0x90, 0x90, 0x3A, 0xE8, 0x53, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0xF2, 0x8D, 0x8D, 0x51, 0x51, 0x73, 0x61, 0x74, 0x43, 0x88, 0x36, 0x3D, 0x3D, 0x4F, 0x43, 0x5F, 0xC3, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0xC7, 0xE5, 0x62, 0x87, 0x52, 0x9C, 0x4A, 0x42, 0x41, 0xB8, 0x40, 0x4B, 0x4A, 0x4D, 0x17, 0x20, 0x40, 0x37, 0x86, 0x5D, 
        0x9E, 0x9E, 0xE7, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7B, 0xAC, 0x77, 0xC2, 0x61, 0x75, 0x88, 0x51, 0xA3, 0x07, 0x07, 0x2F, 0x07, 0x57, 0x08, 0x2E, 0x2E, 0x02, 0x27, 0x07, 0x07, 0x0B, 0x07, 0x07, 0x07, 
        0x07, 0x17, 0x3D, 0x44, 0x62, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xC5, 0x8F, 0x62, 0x87, 0x43, 0x52, 0x3D, 0x4D, 0x17, 0x05, 0x02, 0x05, 0x02, 0x11, 0x02, 0xB5, 0x02, 0x07, 0x27, 0x0E, 0x2E, 0x0E, 0x02, 0x0C, 0x0C, 0x02, 
        0x0E, 0x02, 0x05, 0x20, 0x9F, 0x86, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x65, 0x1B, 0x75, 0x52, 0x27, 0x38, 0x07, 0x07, 0x07, 0x57, 0x05, 0x05, 0x02, 0x05, 0xBF, 0xBE, 0x86, 0xAD, 0xAC, 0x77, 0x62, 0x41, 0x40, 0x4D, 0x02, 0x02, 0x08, 0x0D, 
        0x0B, 0x02, 0x02, 0x0E, 0x05, 0x17, 0x43, 0x61, 0xCB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC9, 0xA7, 0x8A, 0x41, 0x40, 0x83, 0x05, 0x02, 0x02, 0x0C, 0x02, 0x02, 0x02, 0x02, 0x12, 0x1C, 0x1C, 0x0E, 0x87, 0x86, 0x77, 0x62, 0xC0, 0xB9, 0xC1, 0x4D, 0x02, 0x02, 0x0D, 0x08, 
        0x08, 0x0D, 0x02, 0x2E, 0x0E, 0x0E, 0x4B, 0x40, 0xC5, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x8E, 0x51, 0x4D, 0xB5, 0x07, 0x0B, 0x0B, 0x23, 0x09, 0x0F, 0x09, 0x09, 0x08, 0x0C, 0x09, 0x0F, 0x23, 0x0A, 0x16, 0x03, 0x09, 0x08, 0x0B, 0x0E, 0xBF, 0x38, 0x42, 0x07, 0x02, 0x02, 0x02, 
        0x02, 0x0B, 0x19, 0x0B, 0x19, 0x1C, 0x02, 0x0E, 0xDD, 0x75, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x91, 0x5F, 0x5F, 0x36, 0x5B, 0x07, 0x2E, 0x0B, 0x08, 0x6A, 0x0F, 0x03, 0x25, 0x06, 0x09, 0x04, 0x03, 0x0A, 0x0A, 0x16, 0x0A, 0x16, 0x03, 0x06, 0x28, 0x02, 0x05, 0x20, 0x05, 0x07, 0x05, 0x07, 0x08, 
        0x02, 0x0C, 0x02, 0x0B, 0x08, 0x02, 0x1F, 0x19, 0x34, 0xDC, 0xB9, 0xC9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7B, 0x24, 0x61, 0x3D, 0x38, 0x07, 0x07, 0x56, 0x0B, 0x23, 0x23, 0x69, 0x69, 0x04, 0x14, 0x2B, 0x14, 0x1C, 0x1C, 0x14, 0x06, 0x15, 0x15, 0x0A, 0x06, 0x0A, 0x06, 0x09, 0x09, 0x08, 0x0B, 0x07, 0x07, 0x07, 0x05, 
        0x19, 0x07, 0x0B, 0x0C, 0x0B, 0x02, 0x08, 0x08, 0x02, 0x2E, 0x83, 0x60, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7B, 0x78, 0x8B, 0x45, 0x38, 0x17, 0x2E, 0x07, 0x0B, 0x6B, 0x6B, 0x69, 0x0F, 0x0F, 0x2B, 0x2B, 0x1F, 0x3B, 0x96, 0x14, 0x04, 0x22, 0x15, 0x54, 0x15, 0x15, 0x15, 0x03, 0x0A, 0x09, 0x57, 0x0B, 0x07, 0x02, 0x07, 0x27, 
        0x2F, 0x02, 0x2F, 0x07, 0x0B, 0x08, 0x0B, 0x08, 0x1F, 0x19, 0x2C, 0x34, 0x39, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1B, 0x8A, 0x44, 0x17, 0x07, 0x07, 0x0B, 0x0B, 0x0B, 0x0C, 0x23, 0x08, 0x25, 0x0F, 0x0F, 0x04, 0x08, 0x3B, 0x95, 0x96, 0x22, 0x1C, 0x14, 0x22, 0x15, 0x15, 0x15, 0x16, 0x2A, 0x25, 0x0C, 0x0D, 0x51, 0x3D, 0x61, 0x1B, 
        0x1B, 0x6E, 0x02, 0x02, 0x02, 0x02, 0x08, 0x0B, 0x10, 0x08, 0x0E, 0x0E, 0x4B, 0x8C, 0x92, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0x8A, 0x45, 0x44, 0x5A, 0x0B, 0x02, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D, 0x09, 0x0F, 0x6A, 0x08, 0x0A, 0x06, 0x48, 0x96, 0x67, 0x48, 0x48, 0x14, 0x22, 0xB1, 0xB1, 0x15, 0x16, 0x16, 0x16, 0x09, 0x2F, 0x32, 0xC1, 0x1B, 0x45, 
        0x46, 0x4A, 0x05, 0x07, 0x02, 0x0B, 0x0B, 0x08, 0x08, 0x10, 0x1F, 0x12, 0x34, 0x41, 0x53, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1B, 0x60, 0x44, 0x27, 0x32, 0x05, 0x07, 0x02, 0x0B, 0x0B, 0x0B, 0x0B, 0x23, 0x23, 0x0F, 0x08, 0x08, 0x06, 0x3B, 0x48, 0x47, 0x47, 0x47, 0x95, 0x2B, 0x3B, 0x49, 0x49, 0x54, 0x15, 0x15, 0x15, 0x10, 0x2F, 0x02, 0x27, 0x1B, 0xA4, 
        0x46, 0x4F, 0x0D, 0x0D, 0x0B, 0x0B, 0x0B, 0x08, 0x2B, 0x08, 0x2B, 0x08, 0x0E, 0x17, 0x8A, 0x1B, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xC6, 0x61, 0x45, 0x38, 0x38, 0x5E, 0x5E, 0x07, 0x07, 0x56, 0x0B, 0x0B, 0x0B, 0x0D, 0x08, 0x23, 0x23, 0x23, 0x0F, 0x3B, 0x48, 0x94, 0x94, 0x67, 0x47, 0x47, 0x3B, 0xB0, 0x49, 0x06, 0x49, 0xD0, 0x03, 0x10, 0x10, 0x02, 0xE2, 0x05, 0x37, 
        0x46, 0x1B, 0x0D, 0x0D, 0x0B, 0x02, 0x02, 0x1C, 0x09, 0x04, 0x2B, 0x69, 0x12, 0x0E, 0x41, 0xC0, 0x79, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xA7, 0x51, 0x3D, 0x45, 0x60, 0x39, 0x3A, 0x1B, 0x5F, 0x17, 0x05, 0x07, 0x07, 0x0B, 0x02, 0x08, 0x0C, 0x02, 0x02, 0x14, 0x7D, 0xAF, 0x93, 0x67, 0x67, 0x67, 0x48, 0x7D, 0x47, 0x47, 0x49, 0x06, 0x28, 0x21, 0x09, 0x81, 0x0D, 0x0C, 0x2F, 
        0x07, 0x07, 0x23, 0x0B, 0x0C, 0x10, 0x08, 0x09, 0x0F, 0x04, 0x04, 0x29, 0x1C, 0x02, 0x4B, 0x45, 0x3A, 0x00, 0x00,
  0x00, 0x00, 0x64, 0xA7, 0xE3, 0x20, 0x6D, 0x1B, 0x1E, 0x1E, 0xAD, 0x46, 0x27, 0x07, 0x2E, 0x17, 0x07, 0x0E, 0x0D, 0x0D, 0x02, 0x05, 0x2E, 0x19, 0x93, 0xAF, 0xCE, 0x14, 0x93, 0x94, 0x7D, 0x7D, 0xB0, 0x49, 0x06, 0x0C, 0x09, 0x09, 0x81, 0x26, 0x0D, 0x57, 
        0x32, 0x5E, 0x0D, 0x23, 0x08, 0x09, 0x09, 0x10, 0x09, 0x04, 0x04, 0x04, 0x1C, 0x02, 0x4B, 0x4B, 0x39, 0xAB, 0x00,
  0x00, 0x00, 0x1B, 0x74, 0xBC, 0x07, 0x8D, 0x1B, 0x64, 0x64, 0x7A, 0x65, 0x60, 0x6D, 0x05, 0x07, 0x07, 0x02, 0x07, 0x02, 0x23, 0x0B, 0x17, 0x27, 0x05, 0x1F, 0x12, 0x05, 0x05, 0x2C, 0xD2, 0x95, 0x48, 0x22, 0x28, 0x08, 0x09, 0x26, 0x25, 0x81, 0x07, 0x57, 
        0x27, 0x1A, 0x23, 0x0D, 0x0C, 0x08, 0x09, 0x09, 0x04, 0x04, 0x04, 0x04, 0x1F, 0x02, 0x58, 0x4D, 0xBB, 0xE6, 0x00,
  0x00, 0x00, 0x63, 0x4F, 0x07, 0x07, 0x74, 0x63, 0xAC, 0xA9, 0x8C, 0x77, 0xA5, 0x36, 0x17, 0x17, 0x0B, 0x07, 0x07, 0x0B, 0x09, 0x08, 0x02, 0x05, 0x07, 0x17, 0x42, 0x4A, 0x17, 0xBE, 0xA3, 0x20, 0x14, 0x14, 0x14, 0x7E, 0x26, 0x03, 0x7F, 0x6A, 0x2F, 0x27, 
        0x07, 0x07, 0x0B, 0x6B, 0x09, 0x09, 0x09, 0x04, 0x09, 0x04, 0x28, 0x04, 0x68, 0x1F, 0x34, 0x36, 0x9F, 0xC3, 0x00,
  0x00, 0x91, 0xA5, 0x4A, 0x36, 0x36, 0x5D, 0xB8, 0x43, 0x60, 0x75, 0x44, 0x88, 0x42, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02, 0x19, 0x02, 0x0D, 0x0B, 0x0B, 0x0B, 0x2F, 0x07, 0x27, 0x0E, 0x36, 0x36, 0x38, 0x44, 0x38, 0x17, 0x2F, 0x10, 0x56, 0x56, 0x57, 0x07, 
        0x0D, 0x0C, 0x0D, 0x0C, 0x08, 0x09, 0x04, 0x04, 0x04, 0x04, 0x14, 0x29, 0x1F, 0x02, 0x58, 0x5B, 0x41, 0x8E, 0x3A,
  0x00, 0x91, 0xA5, 0x4A, 0x36, 0xA4, 0x8E, 0x8E, 0x60, 0x40, 0x3D, 0x3D, 0x42, 0x59, 0x07, 0x05, 0x07, 0x05, 0x2E, 0x02, 0x19, 0x19, 0x08, 0x0D, 0x02, 0x0D, 0x11, 0x2F, 0x05, 0x05, 0x83, 0x59, 0x17, 0x38, 0x20, 0x32, 0x0B, 0x02, 0x0D, 0x0D, 0x02, 0x02, 
        0x10, 0x0C, 0x3C, 0x0D, 0x09, 0x04, 0x03, 0x0F, 0x04, 0x06, 0x29, 0x14, 0x1F, 0x0E, 0x58, 0x42, 0x41, 0x87, 0xCB,
  0x00, 0x78, 0x51, 0x17, 0x37, 0x46, 0x66, 0xF5, 0x1E, 0xC8, 0x20, 0x05, 0x02, 0x0B, 0x2E, 0x07, 0x5B, 0x5A, 0x83, 0x34, 0x2C, 0x34, 0x0E, 0x02, 0x19, 0x02, 0x0D, 0x0C, 0x0B, 0x11, 0x0D, 0x0D, 0x0C, 0x0D, 0x02, 0x05, 0x02, 0x0B, 0x6A, 0x0F, 0x09, 0x09, 
        0x6A, 0x09, 0x0D, 0x08, 0x09, 0x0F, 0x04, 0x0A, 0x29, 0x04, 0x14, 0x2B, 0x12, 0x0E, 0x0E, 0x20, 0x5D, 0x45, 0xED,
  0x1E, 0x78, 0x44, 0x5B, 0x4B, 0x1B, 0xF6, 0x1E, 0x1E, 0x1E, 0xE4, 0x32, 0x02, 0x0B, 0x0E, 0x2E, 0x58, 0x5A, 0x43, 0x52, 0x52, 0x52, 0x44, 0x17, 0x19, 0x19, 0x08, 0x08, 0x0C, 0x0C, 0x0D, 0x3C, 0x0C, 0x0C, 0x12, 0x12, 0x0B, 0x0D, 0x09, 0x0F, 0x0F, 0x09, 
        0x03, 0x26, 0x09, 0x09, 0x09, 0x04, 0x03, 0x0A, 0x06, 0x0A, 0x14, 0x1F, 0x12, 0x0E, 0x5A, 0x17, 0x5D, 0x41, 0x90,
  0x1E, 0x78, 0x5E, 0x07, 0x0E, 0x1A, 0x46, 0xCD, 0x5F, 0x7A, 0x63, 0x42, 0x0B, 0x0D, 0x19, 0x6B, 0x19, 0x02, 0x40, 0x52, 0x8C, 0x8B, 0xA9, 0xA9, 0x8B, 0x34, 0x0E, 0x2C, 0x08, 0x08, 0x09, 0x09, 0x08, 0x0F, 0x08, 0x08, 0x09, 0x09, 0x25, 0x25, 0x25, 0x25, 
        0x7F, 0x7F, 0x25, 0x0F, 0x04, 0x03, 0x0A, 0x03, 0x03, 0x04, 0x68, 0x19, 0x02, 0x05, 0x05, 0xBC, 0x5D, 0x70, 0x39,
  0x00, 0xCA, 0x27, 0x17, 0x2F, 0x05, 0x6D, 0x35, 0x9B, 0x35, 0x5E, 0x12, 0x0B, 0x08, 0x08, 0x08, 0x19, 0x19, 0x34, 0x9C, 0x8C, 0xC2, 0xA1, 0xC7, 0x1B, 0x46, 0xA3, 0x75, 0x1C, 0x02, 0x0F, 0x09, 0x0F, 0x04, 0x10, 0x10, 0x04, 0x21, 0x03, 0x0A, 0x03, 0x03, 
        0x2A, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x1C, 0x1C, 0x02, 0x0E, 0x05, 0x38, 0x70, 0x5D, 0x8F,
  0x00, 0xF0, 0x4E, 0x13, 0x56, 0x6C, 0x0D, 0x56, 0x02, 0x02, 0x19, 0x0B, 0x19, 0x02, 0x0F, 0x0F, 0x08, 0x08, 0x08, 0x6B, 0x4D, 0x88, 0x8B, 0x8D, 0x77, 0x65, 0x1B, 0x17, 0x0E, 0x1C, 0x0C, 0x04, 0x04, 0x08, 0x03, 0x03, 0x03, 0x03, 0x04, 0x06, 0x03, 0x04, 
        0x06, 0x06, 0x0A, 0x0A, 0x06, 0x06, 0x03, 0x0A, 0x04, 0x04, 0x12, 0x12, 0x12, 0x05, 0x20, 0x32, 0x9D, 0x5F, 0x00,
  0x3A, 0x7B, 0x89, 0x6F, 0x2F, 0x6C, 0x0D, 0x09, 0x02, 0x02, 0x02, 0x02, 0x0B, 0x08, 0x09, 0x0F, 0x09, 0x0F, 0x04, 0x04, 0x2C, 0x2C, 0x34, 0x9C, 0x62, 0x9B, 0x2C, 0x1F, 0x19, 0x19, 0x08, 0x14, 0x04, 0x04, 0x0A, 0x2A, 0x03, 0x06, 0x06, 0x14, 0x14, 0x14, 
        0x06, 0x06, 0x0A, 0x0A, 0x03, 0x28, 0x0A, 0x03, 0x04, 0x09, 0x1F, 0x02, 0x0E, 0x05, 0x20, 0x17, 0x35, 0x24, 0x00,
  0xAA, 0x64, 0x24, 0x35, 0x1A, 0x11, 0x0D, 0x0B, 0x08, 0x23, 0x09, 0x09, 0x08, 0x0B, 0x08, 0x08, 0x09, 0x0F, 0x04, 0x03, 0x03, 0x03, 0x04, 0x28, 0x04, 0x04, 0x06, 0x2B, 0x14, 0x06, 0x06, 0x28, 0x14, 0x29, 0x0A, 0x0A, 0x06, 0x06, 0x29, 0x29, 0x0A, 0x0A, 
        0x06, 0x06, 0x06, 0x06, 0x14, 0x04, 0x06, 0x0F, 0x1C, 0x08, 0x12, 0x0E, 0x0E, 0x5A, 0x05, 0x42, 0xE1, 0xCC, 0x00,
  0x00, 0x78, 0x63, 0xA6, 0x1A, 0x05, 0x02, 0x0D, 0x0D, 0x08, 0x09, 0x0F, 0x10, 0x10, 0x04, 0x03, 0x04, 0x03, 0x25, 0x03, 0x16, 0x16, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x22, 0x22, 0x49, 0x22, 0x22, 0x22, 0x06, 0x0A, 0x06, 0x04, 0x29, 0x29, 0x15, 0x0A, 
        0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x0E, 0x05, 0x58, 0x5B, 0x20, 0xA4, 0xA1, 0x00, 0x00,
  0x00, 0x7C, 0xA8, 0xA8, 0x89, 0x72, 0x3E, 0x0C, 0x0C, 0x0C, 0x09, 0x09, 0x10, 0x04, 0x03, 0x04, 0x04, 0x04, 0x03, 0x06, 0x06, 0x06, 0x03, 0x03, 0x0A, 0x0A, 0x06, 0x06, 0x06, 0x06, 0x22, 0x22, 0x06, 0x22, 0x15, 0x06, 0x0A, 0x25, 0x29, 0x0A, 0x06, 0x0A, 
        0x15, 0x0A, 0x0A, 0x04, 0x04, 0x2B, 0x04, 0x04, 0x1F, 0x02, 0x05, 0x5A, 0x05, 0x13, 0x37, 0x50, 0xAB, 0x00, 0x00,
  0x00, 0x00, 0x76, 0xA8, 0x1D, 0xBD, 0xD6, 0x6C, 0x0C, 0x0C, 0x09, 0x04, 0x09, 0x03, 0x03, 0x04, 0x0F, 0x04, 0x03, 0x28, 0x03, 0x0A, 0x16, 0x16, 0x0A, 0x16, 0x06, 0x15, 0x3B, 0x3B, 0x22, 0xCF, 0x3B, 0x22, 0x15, 0x0A, 0x03, 0x03, 0x04, 0x0A, 0x06, 0x06, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x2B, 0x69, 0x08, 0x08, 0x1F, 0x0E, 0x58, 0x5B, 0x05, 0x72, 0x4F, 0x63, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x53, 0x37, 0x74, 0x73, 0x31, 0x11, 0x18, 0x3C, 0x09, 0x25, 0x16, 0x28, 0x28, 0x03, 0x03, 0x03, 0x0A, 0x03, 0x16, 0x03, 0x03, 0x06, 0x06, 0x06, 0x06, 0x54, 0x54, 0x15, 0x54, 0x06, 0x06, 0x15, 0x0A, 0x03, 0x0A, 0x0A, 0x29, 0x0A, 0x06, 
        0x06, 0x04, 0x04, 0x2B, 0x1F, 0x02, 0x02, 0x12, 0x12, 0x02, 0x05, 0x17, 0x13, 0x13, 0x39, 0x76, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x70, 0x4F, 0x2D, 0x24, 0x1A, 0x11, 0x6C, 0x3C, 0x26, 0x7F, 0x03, 0x21, 0x03, 0x2A, 0x16, 0x16, 0x03, 0x03, 0x03, 0x06, 0x03, 0xB2, 0x06, 0x06, 0x15, 0x15, 0x54, 0x15, 0x06, 0x06, 0x06, 0x04, 0x0A, 0x03, 0x06, 0x03, 0x29, 0x0A, 
        0x03, 0x03, 0x04, 0x1C, 0x1F, 0x02, 0x11, 0x11, 0x02, 0x05, 0x05, 0x05, 0x6F, 0x1D, 0x76, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xCA, 0x39, 0x4F, 0x6D, 0x89, 0xBD, 0x1A, 0x33, 0x3E, 0x10, 0x26, 0x26, 0x26, 0x03, 0x03, 0x03, 0x03, 0x2A, 0x2A, 0x2A, 0x2A, 0xB2, 0x16, 0x16, 0x0A, 0x0A, 0x16, 0x0A, 0x0A, 0x0A, 0x06, 0x04, 0x03, 0x06, 0x0A, 0x0A, 0x03, 0x06, 
        0x14, 0x04, 0x1F, 0x12, 0x2D, 0x2D, 0x2D, 0x05, 0x2D, 0x05, 0x31, 0x4C, 0x76, 0x39, 0x39, 0x1E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xBA, 0x70, 0x43, 0x20, 0x05, 0x13, 0x1A, 0x11, 0x3E, 0x81, 0x26, 0x21, 0x25, 0x03, 0x26, 0x03, 0x03, 0x21, 0x2A, 0x2A, 0x2A, 0x2A, 0x16, 0x0A, 0x0A, 0x16, 0x0A, 0x03, 0x04, 0x06, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 
        0x10, 0x1C, 0x02, 0x05, 0x2D, 0x55, 0x6E, 0xA2, 0x72, 0x1D, 0x24, 0x50, 0xE0, 0x76, 0x39, 0x1E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x43, 0x32, 0x05, 0x33, 0x13, 0x30, 0xB7, 0x13, 0x13, 0x18, 0x18, 0x10, 0x21, 0x26, 0x26, 0x3C, 0x21, 0x10, 0x21, 0x21, 0x28, 0x03, 0x03, 0x03, 0x03, 0x06, 0x03, 0x28, 0x10, 0x10, 0x03, 0x03, 0x03, 0x10, 0x09, 
        0x18, 0x18, 0x2D, 0x05, 0xB7, 0x37, 0x30, 0x31, 0x31, 0x31, 0x71, 0x71, 0xA1, 0xBA, 0x66, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x2C, 0x5E, 0x05, 0x12, 0x11, 0x9A, 0x4C, 0x4C, 0x30, 0x1A, 0x11, 0x6C, 0x3C, 0x3C, 0x3C, 0x26, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x10, 0x21, 0x03, 0x10, 0x09, 0x08, 0x0C, 0x09, 0x3C, 0x0D, 0x09, 0x0C, 0x0C, 
        0x12, 0x11, 0xA2, 0x4E, 0x70, 0x24, 0x50, 0x31, 0x4C, 0x30, 0x85, 0x85, 0xBB, 0xEF, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x3F, 0x02, 0x11, 0x11, 0x05, 0x6F, 0x89, 0x35, 0x85, 0x55, 0x9B, 0x30, 0x9A, 0x13, 0x13, 0x18, 0x33, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x3E, 0x18, 0x3E, 0x11, 0x33, 0x33, 0x11, 0x55, 0x05, 0x13, 0x3F, 
        0x37, 0x35, 0x35, 0x9D, 0x37, 0x31, 0x36, 0x4E, 0x1D, 0x13, 0x55, 0x55, 0xC4, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEB, 0x46, 0x2D, 0x0C, 0x07, 0x05, 0x11, 0x2D, 0x30, 0x31, 0x31, 0x71, 0x85, 0x30, 0x4C, 0x1D, 0x1D, 0x1A, 0x1A, 0x99, 0x99, 0x1A, 0x99, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x13, 0x1A, 0x1D, 0x72, 0x72, 0x5C, 0xA6, 
        0x24, 0x50, 0xA0, 0xA0, 0x5C, 0x9A, 0x37, 0x40, 0x33, 0xB3, 0x80, 0x2D, 0x53, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x97, 0x11, 0x11, 0x20, 0x20, 0x05, 0x32, 0x13, 0x13, 0x84, 0x13, 0x84, 0x84, 0x50, 0x30, 0x30, 0x4C, 0x1D, 0x1D, 0x4E, 0x50, 0xA6, 0x50, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x73, 
        0x74, 0x73, 0x37, 0x4E, 0x1A, 0x02, 0x12, 0x11, 0x80, 0x80, 0xB6, 0xEE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x80, 0x14, 0x1C, 0x20, 0x4A, 0x13, 0x05, 0x05, 0x33, 0x13, 0x13, 0x3F, 0x84, 0x31, 0x31, 0x30, 0x30, 0x30, 0x1D, 0x73, 0x4F, 0x31, 0x4C, 0x71, 0x9D, 0xA0, 0x9F, 0x71, 0x35, 0x35, 0x35, 
        0x45, 0x35, 0x6D, 0x34, 0x18, 0x18, 0x18, 0x68, 0xD3, 0x63, 0xAE, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xD8, 0x18, 0x02, 0x05, 0x05, 0x3F, 0x05, 0x59, 0x3F, 0x34, 0x59, 0x3F, 0x36, 0x1D, 0x4E, 0x4E, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x6F, 0x13, 0x1A, 0x98, 0x3E, 0x0C, 0x0C, 
        0x18, 0x11, 0x11, 0x18, 0x7E, 0x18, 0xB4, 0x82, 0x66, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF3, 0x64, 0x27, 0x10, 0x68, 0x68, 0x05, 0x59, 0x3F, 0x3F, 0x59, 0x5C, 0x6E, 0x5C, 0x5C, 0x5C, 0x6F, 0x55, 0x11, 0x13, 0x98, 0x98, 0x33, 0x13, 0x33, 0x33, 0x3E, 0xD5, 0x3E, 0x10, 
        0x11, 0x11, 0x7E, 0xB3, 0x7E, 0x1D, 0xCD, 0xCC, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0xD1, 0x2D, 0x2C, 0x05, 0x05, 0x11, 0x05, 0x6E, 0x32, 0x32, 0x32, 0x32, 0x05, 0x20, 0x05, 0x05, 0x05, 0x05, 0x20, 0x11, 0x05, 0x0C, 0x0C, 0x18, 0x18, 
        0xB4, 0x97, 0xD4, 0x3A, 0x00, 0x00, 0xEA, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7B, 0xAD, 0x1B, 0x12, 0x12, 0x18, 0x12, 0x05, 0x13, 0x13, 0x05, 0x05, 0x05, 0x2C, 0x12, 0x33, 0x13, 0xA2, 0x6E, 0x12, 0x12, 0x10, 0x10, 0x18, 0x1C, 
        0x65, 0x7A, 0xAE, 0xAB, 0x00, 0xEC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0x9E, 0xDA, 0x82, 0x82, 0x97, 0x82, 0xDB, 0xDF, 0xDE, 0xC4, 0x8F, 0x8F, 0xD9, 0xD7, 0xB6, 0x7C, 0x00, 0x7C, 
        0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x7A, 0x7A, 0x3A, 0x1E, 0x92, 0x00, 0x92, 0x00, 0x79, 0xAE, 0x7C, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmglazed_doughnut = {
  61, /* XSize */
  47, /* YSize */
  61, /* BytesPerLine */
  8, /* BitsPerPixel */
  acglazed_doughnut,  /* Pointer to picture data (indices) */
  &Palglazed_doughnut   /* Pointer to palette */
};

/* *** End of file *** */
