/*********************************************************************
*                                                                    *
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                                                                    *
**********************************************************************
*                                                                    *
* C-file generated by:                                               *
*                                                                    *
*        GUI_Builder for emWin version 5.14                          *
*        Compiled Jan 12 2012, 10:28:50                              *
*        (c) 2011 Segger Microcontroller GmbH & Co. KG               *
*                                                                    *
**********************************************************************
*                                                                    *
*        Internet: www.segger.com  Support: support@segger.com       *
*                                                                    *
**********************************************************************
*/

// USER START (Optionally insert additional includes)
#include <stdio.h>
#include <string.h>
#include "DIALOG.h"
#include "BlueboardPOS.h"
//AR #include "CLRC663.h"
// USER END



/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

#define ID_WINDOW_0     (GUI_ID_USER + 0x01)
#define ID_BUTTON_0     (GUI_ID_USER + 0x02)
#define ID_BUTTON_1     (GUI_ID_USER + 0x03)
#define ID_BUTTON_2     (GUI_ID_USER + 0x04)
#define ID_BUTTON_3     (GUI_ID_USER + 0x05)
#define ID_BUTTON_4     (GUI_ID_USER + 0x06)
#define ID_BUTTON_5     (GUI_ID_USER + 0x07)
#define ID_BUTTON_6     (GUI_ID_USER + 0x08)
#define ID_BUTTON_7     (GUI_ID_USER + 0x09)
#define ID_BUTTON_8     (GUI_ID_USER + 0x0A)
#define ID_LISTVIEW_0   (GUI_ID_USER + 0x0E)
#define ID_BUTTON_9   (GUI_ID_USER + 0x0B)
#define ID_BUTTON_10   (GUI_ID_USER + 0x0C)
#define ID_TEXT_0   (GUI_ID_USER + 0x0F)
#define ID_BUTTON_11   (GUI_ID_USER + 0x0D)

// USER START (Optionally insert additional defines)
#define ID_IMAGE_0     (GUI_ID_USER + 0x20)
#define ID_IMAGE_1     (GUI_ID_USER + 0x21)

#define BUTTON_BitmapSkin DrawCustomSkin
// USER END

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

// USER START (Optionally insert additional static data)
/*
extern const uint8_t _acImage_0[385078];
extern GUI_CONST_STORAGE GUI_BITMAP bmnxplogo_small;
extern GUI_CONST_STORAGE GUI_BITMAP bmblack_coffee;
extern GUI_CONST_STORAGE GUI_BITMAP bmchocolate_doughnut;
extern GUI_CONST_STORAGE GUI_BITMAP bmmilk;
extern GUI_CONST_STORAGE GUI_BITMAP bmlatte_coffee;
extern GUI_CONST_STORAGE GUI_BITMAP bmglazed_doughnut;
extern GUI_CONST_STORAGE GUI_BITMAP bmorangejuice;
extern GUI_CONST_STORAGE GUI_BITMAP bmnewspaper;
extern GUI_CONST_STORAGE GUI_BITMAP bmdanish;
extern GUI_CONST_STORAGE GUI_BITMAP bmbottledwater;
*/
//#include "Background.cpp"
#include "nxplogo_small.cpp"
#include "black_coffee.cpp"
#include "chocolate_doughnut.cpp"
#include "milk.cpp"
#include "latte_coffee.cpp"
#include "glazed_doughnut.cpp"
#include "orangejuice.cpp"
#include "newspaper.cpp"
#include "danish.cpp"
#include "bottledwater.cpp"
// USER END

/*********************************************************************
*
*       _aDialogCreate
*/
static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { WINDOW_CreateIndirect, "OrderEntry", ID_WINDOW_0, 0, 0, 800, 480, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button3", ID_BUTTON_0, 30, 15, 110, 110, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button4", ID_BUTTON_1, 150, 15, 110, 110, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button5", ID_BUTTON_2, 270, 15, 110, 110, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button6", ID_BUTTON_3, 30, 135, 110, 110, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button7", ID_BUTTON_4, 150, 135, 110, 110, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button8", ID_BUTTON_5, 270, 135, 110, 110, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button9", ID_BUTTON_6, 30, 255, 110, 110, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button10", ID_BUTTON_7, 150, 255, 110, 110, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button11", ID_BUTTON_8, 270, 255, 110, 110, 0, 0, 0 },
  { LISTVIEW_CreateIndirect, "Listview", ID_LISTVIEW_0, 422, 133, 363, 231, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Checkout", ID_BUTTON_9, 430, 400, 216, 65, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Clear", ID_BUTTON_10, 664, 400, 112, 65, 0, 0, 0 },
  { TEXT_CreateIndirect, "Total", ID_TEXT_0, 597, 365, 182, 32, 0, 100, 0 },
  { BUTTON_CreateIndirect, "QueryCard", ID_BUTTON_11, 78, 400, 250, 65, 0, 0, 0 },
  // USER START (Optionally insert additional widgets)
    { IMAGE_CreateIndirect, "Image", ID_IMAGE_0, 508, 7, 193, 112, WM_CF_BGND, IMAGE_CF_AUTOSIZE, 0 },
  { IMAGE_CreateIndirect, "Image", ID_IMAGE_1, 0, 0, 800, 480, WM_CF_BGND, IMAGE_CF_AUTOSIZE, 0 },
  // USER END
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/

// USER START (Optionally insert additional static code)
void displayTotal(WM_HWIN hWin)
{
    WM_HWIN hItem;
    char Total[64], SubTotal[16];
    int total = 0, row, subtotal100, subtotal;

    hItem = WM_GetDialogItem(hWin, ID_LISTVIEW_0);

    for(row = 0; row < (LISTVIEW_GetNumRows(hItem)); row++)
    {
        LISTVIEW_GetItemText(hItem, 3, row, SubTotal, sizeof(SubTotal));
        sscanf(SubTotal, "%d.%02d", &subtotal100, &subtotal);
        total = total + subtotal100 * 100 + subtotal;
    }

    sprintf(Total, "Total $%d.%02d", total / 100, total - total / 100 * 100);
    hItem = WM_GetDialogItem(hWin, ID_TEXT_0);
    TEXT_SetText(hItem, Total);
}

void clearItems(WM_HWIN hWin)
{
    WM_HWIN hItem;

    // add the button text to a new line in the item list
  hItem = WM_GetDialogItem(hWin, ID_LISTVIEW_0);
    LISTVIEW_DeleteAllRows(hItem);
    displayTotal(hWin);
}

void addItem(WM_HWIN hWin, int Id, int price)
{
    WM_HWIN hItem;
    char ButtonText[64], Quantity[16], Price[16], SubTotal[16];
    int row, qnty, subtotal;

    // get the text on the button
    hItem = WM_GetDialogItem(hWin, Id);
    BUTTON_GetText(hItem, ButtonText, sizeof(ButtonText));

    // add the button text to a new line in the item list
    hItem = WM_GetDialogItem(hWin, ID_LISTVIEW_0);
    LISTVIEW_AddRow(hItem, NULL);
    row = LISTVIEW_GetNumRows(hItem) - 1;
    qnty = 1;

    subtotal = qnty * price;
    sprintf(Quantity, "%d", qnty);
    sprintf(Price, "%d.%02d", price / 100, price - price / 100 * 100);
    sprintf(SubTotal, "%d.%02d", subtotal / 100, subtotal - subtotal / 100 * 100);
    LISTVIEW_SetItemText(hItem, 0, row, Quantity);
    LISTVIEW_SetItemText(hItem, 1, row, ButtonText);
    LISTVIEW_SetItemText(hItem, 2, row, Price);
    LISTVIEW_SetItemText(hItem, 3, row, SubTotal);

    displayTotal(hWin);
}

// USER END

/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  WM_HWIN hItem;
  int Id, NCode;
  // USER START (Optionally insert additional variables)
    char SubTotal[16];
    int total = 0, row, subtotal100, subtotal;
    uint32_t status;
  // USER END

  switch (pMsg->MsgId) {
  case WM_INIT_DIALOG:
    //
    // Initialization of 'Button3'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
    BUTTON_SetText(hItem, "Black Coffee");
    BUTTON_SetFont(hItem, GUI_FONT_16B_ASCII);
    //
    // Initialization of 'Button4'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_1);
    BUTTON_SetText(hItem, "Choc. Donut");
    BUTTON_SetFont(hItem, GUI_FONT_16B_ASCII);
    //
    // Initialization of 'Button5'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_2);
    BUTTON_SetText(hItem, "Milk");
    BUTTON_SetFont(hItem, GUI_FONT_16B_ASCII);
    //
    // Initialization of 'Button6'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_3);
    BUTTON_SetText(hItem, "Latte");
    BUTTON_SetFont(hItem, GUI_FONT_16B_ASCII);
    //
    // Initialization of 'Button7'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_4);
    BUTTON_SetText(hItem, "Glazed Donut");
    BUTTON_SetFont(hItem, GUI_FONT_16B_1);
    //
    // Initialization of 'Button8'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_5);
    BUTTON_SetText(hItem, "Orange Juice");
    BUTTON_SetFont(hItem, GUI_FONT_16B_ASCII);
    //
    // Initialization of 'Button9'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_6);
    BUTTON_SetText(hItem, "Newspaper");
    BUTTON_SetFont(hItem, GUI_FONT_16B_ASCII);
    //
    // Initialization of 'Button10'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_7);
    BUTTON_SetText(hItem, "Danish");
    BUTTON_SetFont(hItem, GUI_FONT_16B_ASCII);
    //
    // Initialization of 'Button11'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_8);
    BUTTON_SetText(hItem, "Bottled Water");
    BUTTON_SetFont(hItem, GUI_FONT_16B_ASCII);
    //
    // Initialization of 'Listview'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_LISTVIEW_0);
    LISTVIEW_AddColumn(hItem, 35, "Qnty", GUI_TA_HCENTER | GUI_TA_VCENTER);
    LISTVIEW_AddColumn(hItem, 210, "Description", GUI_TA_HCENTER | GUI_TA_VCENTER);
    LISTVIEW_AddColumn(hItem, 40, "Cost", GUI_TA_HCENTER | GUI_TA_VCENTER);
    LISTVIEW_AddColumn(hItem, 80, "Sub total", GUI_TA_HCENTER | GUI_TA_VCENTER);
    LISTVIEW_SetAutoScrollV(hItem, 1);
    LISTVIEW_SetGridVis(hItem, 1);
    //
    // Initialization of 'Checkout'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_9);
    BUTTON_SetText(hItem, "Checkout");
    BUTTON_SetFont(hItem, GUI_FONT_32B_ASCII);
    //
    // Initialization of 'Clear'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_10);
    BUTTON_SetText(hItem, "Clear");
    BUTTON_SetFont(hItem, GUI_FONT_32B_ASCII);
    //
    // Initialization of 'Total'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_0);
    TEXT_SetTextAlign(hItem, GUI_TA_RIGHT | GUI_TA_VCENTER);
    TEXT_SetFont(hItem, GUI_FONT_20B_ASCII);
    TEXT_SetText(hItem, "Total $0.00");
    //
    // Initialization of 'QueryCard'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_11);
    BUTTON_SetText(hItem, "Query Card");
    BUTTON_SetFont(hItem, GUI_FONT_32B_ASCII);
    // USER START (Optionally insert additional code for further widget initialization)
        //
    // Additional initialization of 'Image'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_IMAGE_0);
      IMAGE_SetBitmap(hItem, &bmnxplogo_small);
    //
    // Additional initialization of 'Image'
    //
        hItem = WM_GetDialogItem(pMsg->hWin, ID_IMAGE_1);
//AR    IMAGE_SetBMP(hItem, _acImage_0, sizeof(_acImage_0));
        //
        // Additional initialization of 'Button3'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
        BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
        BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    //
    // Additional initialization of 'Button4'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_1);
    BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
        BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    //
    // Additional initialization of 'Button5'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_2);
    BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
        BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    //
    // Additional initialization of 'Button6'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_3);
    BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
        BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    //
    // Additional initialization of 'Button7'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_4);
    BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
        BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    //
    // Additional initialization of 'Button8'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_5);
    BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
        BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    //
    // Additional initialization of 'Button9'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_6);
    BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
        BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    //
    // Additional initialization of 'Button10'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_7);
    BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
        BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    //
    // Additional initialization of 'Button11'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_8);
    BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
      BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
    // USER END
    break;
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);
    NCode = pMsg->Data.v;
    switch(Id) {
    case ID_BUTTON_0: // Notifications sent by 'Button3'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 132);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_1: // Notifications sent by 'Button4'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 55);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_2: // Notifications sent by 'Button5'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 110);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_3: // Notifications sent by 'Button6'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 175);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_4: // Notifications sent by 'Button7'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 55);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_5: // Notifications sent by 'Button8'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 180);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_6: // Notifications sent by 'Button9'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 75);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_7: // Notifications sent by 'Button10'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 119);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_8: // Notifications sent by 'Button11'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          addItem(pMsg->hWin, Id, 155);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_LISTVIEW_0: // Notifications sent by 'Listview'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_SEL_CHANGED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_9: // Notifications sent by 'Checkout'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
                RFID_Cancelled = 0;
            ShowWindow(hWinSwipeCard);
#ifndef _WINDOWS
                hItem = WM_GetDialogItem(pMsg->hWin, ID_LISTVIEW_0);
                for(row = 0; row < (LISTVIEW_GetNumRows(hItem)); row++)
                {
                    LISTVIEW_GetItemText(hItem, 3, row, SubTotal, sizeof(SubTotal));
                    sscanf(SubTotal, "%d.%02d", &subtotal100, &subtotal);
                    total = total + subtotal100 * 100 + subtotal;
                }
                do
                {
//AR                    status = MifareExecute(DecCredit_CMD, (uint32_t*)&total);
                    GUI_Delay(250);
                }
                while((status == (2<<16)) && !RFID_Cancelled);
                if(!status)
                    WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Store_OK);
                else if(status & 0x00010000)
                    WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Credit_Low);
                else if(!RFID_Cancelled)
                    WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Error);
#endif
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_10: // Notifications sent by 'Clear'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
          clearItems(pMsg->hWin);
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    case ID_BUTTON_11: // Notifications sent by 'QueryCard'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
                RFID_Cancelled = 0;
                ShowWindow(hWinSwipeCard);
#ifndef _WINDOWS
            do
            {
//AR                status = MifareExecute(GetCredit_CMD, &Credit);
                GUI_Delay(250);
            }
            while((status == (2<<16)) && !RFID_Cancelled);
            if(!status)
                WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Load_OK);
            else if(!RFID_Cancelled)
                WM_SendMessageNoPara(hWinCallBack, WM_USER_RFID_Error);
#endif
        // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
    // USER START (Optionally insert additional code for further Ids)
    // USER END
    }
    break;
  // USER START (Optionally insert additional message handling)
  // USER END
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       CreateOrderEntry
*/
WM_HWIN CreateOrderEntry(void);
WM_HWIN CreateOrderEntry(void) {
  WM_HWIN hWin;

  hWin = GUI_CreateDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), &_cbDialog, WM_HBKWIN, 0, 0);
  return hWin;
}

// USER START (Optionally insert additional public code)
int DrawCustomSkin(const WIDGET_ITEM_DRAW_INFO * pDrawItemInfo) {
  switch (pDrawItemInfo->Cmd) {
  case WIDGET_ITEM_DRAW_BACKGROUND:
    //
    // Default look with bitmap
    //
    BUTTON_DrawSkinFlex(pDrawItemInfo);
        if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_0))
            GUI_DrawBitmap(&bmblack_coffee, 17, 20);
        else if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_1))
            GUI_DrawBitmap(&bmchocolate_doughnut, 9, 17);
        else if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_2))
            GUI_DrawBitmap(&bmmilk, 40, 20);
        else if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_3))
            GUI_DrawBitmap(&bmlatte_coffee, 15, 22);
        else if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_4))
            GUI_DrawBitmap(&bmglazed_doughnut, 25, 25);
        else if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_5))
            GUI_DrawBitmap(&bmorangejuice, 28, 25);
        else if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_6))
            GUI_DrawBitmap(&bmnewspaper, 15, 12);
        else if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_7))
            GUI_DrawBitmap(&bmdanish, 25, 20);
        else if (pDrawItemInfo->hWin == WM_GetDialogItem(WM_GetActiveWindow(), ID_BUTTON_8))
            GUI_DrawBitmap(&bmbottledwater, 42, 20);
    break;
  default:
    //
    // Use the default skinning routine for processing all other commands
    //
    return BUTTON_DrawSkinFlex(pDrawItemInfo);
  }
  return 0;
}

// USER END

/*************************** End of file ****************************/
