
#ifndef EWGUIIMPL_H
#define EWGUIIMPL_H

#include "mbed.h"
#include "EwGui.h"
#include "EwPainter.h"
#include "TouchPanel.h"

class EwGuiImpl : public EwGui {
public:


    EwGuiImpl();

    virtual void* getMemoryBlockAddress();
    virtual uint32_t getMemoryBlockSize();

    virtual uint32_t getDisplayWidth();
    virtual uint32_t getDisplayHeight();

    virtual void* getFrameBufferAddress();

    virtual void getTouchValues(int32_t* x, int32_t* y, int32_t* z);

    void calibrate();


private:

    uint32_t _width;
    uint32_t _height;
    uint32_t _fb;
    uint32_t _mem;
    uint32_t _memSz;
    TouchPanel* _touch;

    void drawCalibPoint(EwPainter &painter, int32_t x, int32_t y);
};

#endif
