
/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "sdram.h"

#include "EwGuiImpl.h"
#include "EwFrameWindow.h"
#include "MyWindow.h"


/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/


/******************************************************************************
 * Local variables
 *****************************************************************************/

static EwGuiImpl* gui = NULL;

/******************************************************************************
 * Local functions
 *****************************************************************************/

static void pollTouch() {
    if (gui == NULL) return;

    gui->execTouch();
}

/******************************************************************************
 * Main function
 *****************************************************************************/

int main (void) {
    Ticker ticker;

    // Frame buffer is put in SDRAM
    if (sdram_init() == 1) {
        printf("Failed to initialize SDRAM\n");
        return 1;
    }

    // instantiate and initialize GUI
    gui = new EwGuiImpl();
    if (gui == NULL) {
        printf("Failed to instantiate EwGuiImpl\n");
        return 1;
    }

    // calibrate touch screen
    gui->calibrate();

    // register a callback that will check for touch events
    ticker.attach(&pollTouch, 0.10);

    // showing how to enable skinning
    BUTTON_SetDefaultSkin   (BUTTON_SKIN_FLEX);
    CHECKBOX_SetDefaultSkin (CHECKBOX_SKIN_FLEX);
    DROPDOWN_SetDefaultSkin (DROPDOWN_SKIN_FLEX);
    FRAMEWIN_SetDefaultSkin (FRAMEWIN_SKIN_FLEX);

    // make sure the desktop has a color so that it is redrawn
    EwWindow::setDesktopColor(EW_BLACK);

    // create a frame window
    EwFrameWindow frameWin(30, 30, gui->getDisplayWidth()-60,
            gui->getDisplayHeight()-60, "Window Title");
    frameWin.setTitleHeight(20);

    // create and associate a custom window with the frame window
    MyWindow myWindow(&frameWin);

    // application loop running the UI and checking for touch events
    while(1) {

        // In this example touch events are checked by interrupt
        // (pollTouch function), but we could also have done it
        // in this while loop
        //gui.execTouch();
        gui->exec();

    }

}
