/* mbed USBHost Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "USBHost.h"
#include "BaseUsbHostDebug.h"
#include "USBEndpoint.h"
#include "BaseUsbHostTest.h"

HCTD* USBEndpoint::get_queue_HCTD(uint32_t millisec)
{
    for(int i = 0; i < 16; i++) {
        osEvent evt = m_queue.get(millisec);
        if (evt.status == osEventMessage) {
            HCTD* td = reinterpret_cast<HCTD*>(evt.value.p);
            TEST_ASSERT(td);
            uint8_t cc = td->ConditionCode();
            if (cc != 0) {
                m_ConditionCode = cc;
                DBG_TD(td);
            }
            return td;
        } else if (evt.status == osOK) {
            continue;
        } else if (evt.status == osEventTimeout) {
            return NULL;
        } else {
            DBG("evt.status: %02x\n", evt.status);
            TEST_ASSERT(evt.status == osEventMessage);
        }
    }
    return NULL;
}


