/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef EM027BS013_H
#define EM027BS013_H

/** An interface to Embedded Artists' ePaper display, EM027BS013
 *
 */
class EM027BS013 {
public:

    /** Create an interface to an Embedded Artistss ePaper display, EM027BS013.
     *
     * The parameters are all for the Serial Expansion Connector (SEC) 
     */
    EM027BS013(PinName sec03_SpiSCK,
               PinName sec04_SpiMOSI,
               PinName sec05_SpiMISO,
               PinName sec06_EpdCS,
               PinName sec07_EpdBusy,
               PinName sec08_EpdBorder,
               PinName sec09_I2cSCL,
               PinName sec10_I2cSDA,
               PinName sec11_FlashCS,
               PinName sec12_EpdReset,
               PinName sec13_EpdPanelOn,
               PinName sec14_EpdDischarge);

    /** Draws the specified image on the display.
     *
     * @param image The image data, must be 264x176 bytes
     */
    void drawImage(uint8_t* image);
    
private:
    /** Initializes the display
     */
    void init(void);

    bool initialized;
};

#endif

