/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "EM027BS013.h"

#include "Pervasive_Displays_small_EPD.h"

/******************************************************************************
 * Global variables
 *****************************************************************************/
 
//PinName SEC01; // GND
//PinName SEC02; // 3v3
PinName SEC03;
PinName SEC04;
PinName SEC05;
PinName SEC06;
PinName SEC07;
PinName SEC08;
PinName SEC09;
PinName SEC10;
PinName SEC11;
PinName SEC12;
PinName SEC13;
PinName SEC14;

/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/

EM027BS013::EM027BS013(PinName sec03_SpiSCK,
                       PinName sec04_SpiMOSI,
                       PinName sec05_SpiMISO,
                       PinName sec06_EpdCS,
                       PinName sec07_EpdBusy,
                       PinName sec08_EpdBorder,
                       PinName sec09_I2cSCL,
                       PinName sec10_I2cSDA,
                       PinName sec11_FlashCS,
                       PinName sec12_EpdReset,
                       PinName sec13_EpdPanelOn,
                       PinName sec14_EpdDischarge)
{
    initialized = false;

    SEC03 = sec03_SpiSCK;
    SEC04 = sec04_SpiMOSI;
    SEC05 = sec05_SpiMISO;
    SEC06 = sec06_EpdCS;
    SEC07 = sec07_EpdBusy;
    SEC08 = sec08_EpdBorder;
    SEC09 = sec09_I2cSCL;
    SEC10 = sec10_I2cSDA;
    SEC11 = sec11_FlashCS;
    SEC12 = sec12_EpdReset;
    SEC13 = sec13_EpdPanelOn;
    SEC14 = sec14_EpdDischarge;
}

void EM027BS013::init(void)
{
    if (!initialized) {
        EPD_display_init();
        initialized = true;
    }
}

void EM027BS013::drawImage(uint8_t * image)
{
    init();
    EPD_display_from_pointer(EPD_270, NULL, image);
}

