#include "mbed.h"
#include "PinDetect.h"
#include "uLCD_4DGL.h"
#define YELLOW 0xFFFF00
uLCD_4DGL uLCD(p9, p10, p11);
DigitalOut myled(LED1);
PinDetect pb1(p18);
PinDetect pb2(p12);
PinDetect pb3(p13);
PinDetect pb4(p14);
PinDetect pb5(p15);
PinDetect pb6(p16);
PinDetect pb7(p17);
// Global column variable
int volatile col_value=0;
//Declaration of function that prints the coin on the board
void print_coin(int column);
//Declaration of function that prints the board on the uLCD
void display_board(void);
//Declaration of function that checks if we have a winner
void check_winner(int, int);
//Declaration of function that outputs the identity of the winner
void display_winner(char);
//Declaration of function that initializes the board - 2D array to a value of x
void init_board(void);
int player=0;
int array_x=0;
int array_y=0;
int row_calc[7]; //holds the no of coins already dropped into a column
int circle_x=0;
int circle_y=0;
char board[6][7];//2D array that stores the status of the board on every move
int count=0;
char check='x';
// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void) 
{
    myled=!myled;
    col_value=1;
}   
// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void) 
{
    myled=!myled;
    col_value=2;
} 
// Callback routine is interrupt activated by a debounced pb3 hit
void pb3_hit_callback (void) 
{
    myled=!myled;
    col_value=3;
} 
// Callback routine is interrupt activated by a debounced pb4 hit
void pb4_hit_callback (void) 
{
    myled=!myled;
    col_value=4;
} 
// Callback routine is interrupt activated by a debounced pb5 hit
void pb5_hit_callback (void) 
{
    myled=!myled;
    col_value=5;
} 
// Callback routine is interrupt activated by a debounced pb6 hit
void pb6_hit_callback (void) 
{
    myled=!myled;
    col_value=6;
} 
// Callback routine is interrupt activated by a debounced pb7 hit
void pb7_hit_callback (void) 
{
    myled=!myled;
    col_value=7;
} 
int main()
{
    uLCD.baudrate(3000000);
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    pb7.mode(PullUp); 
    wait(0.04);
    // Setup Interrupt callback functions for a given pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    pb5.attach_deasserted(&pb5_hit_callback);
    pb6.attach_deasserted(&pb6_hit_callback);
    pb7.attach_deasserted(&pb7_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    pb5.setSampleFrequency();
    pb6.setSampleFrequency();
    pb7.setSampleFrequency();
    init_board();
    display_board();
    
    while(1) 
    {
        print_coin(col_value);       
    }
}
void init_board(void)
{
    for(int i=0;i<6;i++)
    {
        for(int j=0;j<7;j++)
        {
            board[i][j]='x';
        }
    }
}    
void display_board(void)
{
    uLCD.filled_rectangle(0, 0 , 128, 108, BLUE) ;
    for(int j=0; j<6; j++)//This loop will be executed for each row once
    {
        circle_y=9+j*18;
        for(int i=0; i<7; i++) //This loop will be executed 7 times for each row
        {
            circle_x=9+i*18;
            uLCD.filled_circle(circle_x, circle_y , 8, BLACK)  ;
        }
    }
}

void print_coin(int column)
{  
    if(0<column && column<8) 
    {
        circle_x=9+(column-1)*18;
        circle_y=(99-((row_calc[column-1])*18));
        array_x=(5-(row_calc[column-1]));
        array_y=(column-1);
        if(player%2==0)
        {
            uLCD.filled_circle(circle_x, circle_y , 8, RED)  ;
            board[array_x][array_y]='r';//check
        } 
        else 
        {
            uLCD.filled_circle(circle_x, circle_y , 8, YELLOW)  ;
            board[array_x][array_y]='y';//check
        }
        row_calc[column-1]+=1;
        player++;
        check_winner(array_x,array_y);
        wait(5);
    }
}    

void check_winner(int a, int b)
{     
    for(int i=0;i<4;i++)
    {
        if(board[a][i]==board[a][i+1] && board[a][i+1]==board[a][i+2] && board[a][i+2]==board[a][i+3])
        {
            uLCD.locate(0,15);
            if(board[a][i]=='r' || board[a][i]=='y'){
            uLCD.printf("row hit %c%c%c%c",board[a][i],board[a][i+1],board[a][i+2],board[a][i+3] );
            display_winner(board[a][i]);
            while(1)
            {
            }
            }
        }
    }  
    
    
    /* To check if we have 4 similar coins in a particular column*/
    for(int i=0;i<3;i++)
    {
        if(board[i][b]==board[i+1][b] && board[i+1][b]==board[i+2][b] && board[i+2][b]==board[i+3][b])
        {
            uLCD.locate(0,15);
            if(board[i][b]=='r' || board[i][b]=='y'){
            uLCD.printf("col hit %c%c%c%c",board[i][b],board[i+1][b],board[i+2][b]==board[i+3][b] );
            display_winner(board[i][b]);
            while(1)
            {
            }
            }
        }
    }  
    
    //To check if we have 4 similar coins in the forward diagonal   
    int left_bottom_x=a;
    int left_bottom_y=b;
    while(left_bottom_x<5 && left_bottom_y>0)
    {
        left_bottom_x++;
        left_bottom_y--;
    }
    while((((left_bottom_x)-3)>(-1)) && (((left_bottom_y)+3)<7))
    {
        if((board[left_bottom_x][left_bottom_y]==board[left_bottom_x-1][left_bottom_y+1]) && (board[left_bottom_x][left_bottom_y]==board[left_bottom_x-2][left_bottom_y+2]) && (board[left_bottom_x][left_bottom_y]==board[left_bottom_x-3][left_bottom_y+3]) )
        {
            if(board[left_bottom_x][left_bottom_y]=='r'||board[left_bottom_x][left_bottom_y]=='y'){
            display_winner(board[left_bottom_x][left_bottom_y]);
            while(1)
            {
            } 
            }
        }
    left_bottom_x--;
    left_bottom_y++;
    }
    
    
    //To check if we have 4 similar coins in the backward diagonal 
    int right_bottom_x=a;
    int right_bottom_y=b;
    while((right_bottom_x<5) && (right_bottom_y<6))
    {
        right_bottom_x++;
        right_bottom_y++;
    }
  
    while((((right_bottom_x)-3)>(-1)) && (((right_bottom_y)-3)>(-1)))
    {
        if((board[right_bottom_x][right_bottom_y]==board[right_bottom_x-1][right_bottom_y-1]) && (board[right_bottom_x][right_bottom_y]==board[right_bottom_x-2][right_bottom_y-2]) && (board[right_bottom_x][right_bottom_y]==board[right_bottom_x-3][right_bottom_y-3]) )
        {
            uLCD.locate(0,15);
            if(board[right_bottom_x][right_bottom_y]=='r'||board[right_bottom_x][right_bottom_y]=='y'){
            uLCD.printf("bdi hit %c%c%c%c",board[right_bottom_x][right_bottom_y],board[right_bottom_x-1][right_bottom_y-1],board[right_bottom_x-2][right_bottom_y-2],board[right_bottom_x-3][right_bottom_y-3] );
            display_winner(board[right_bottom_x][right_bottom_y]);
            while(1)
            {
            }    
            }
        }
    right_bottom_x--;
    right_bottom_y--;
    }
}    
    
void display_winner(char a)
{
    if(a=='r' || a=='y')
    {
        wait(2);
        uLCD.cls();
        uLCD.locate(4,6); 
        if(a=='r')
        uLCD.printf("RED WINS");
        else
        uLCD.printf("YELLOW WINS");
    }    
}            
    