#include "mbed.h" //Biblioteca de Mbed
#include "HCSR04.h"// Biblioteca del sensor ultrasonico

HCSR04 sensor(PB_6, PB_7); //Declaración del sensor ultrasonico y de los puertos de entrada a trigger y echo

DigitalOut LedVerde(PD_12); //Salidad digitales, led de color verde en la placa 
DigitalOut LedNaranja(PD_13); // Salida digitales, led de color naranja en la placa 
DigitalOut LedAzul(PD_15); // Salidad digital, led de color azul en la placa 
Serial device(PA_2,PA_3); // Comando para declarar los puertos seriales para visiualización en Hercules.

int main() // Declaración de la función proncipal
{  
    device.baud(115200);
    device.printf("Start\n");
    
    while(1) // Condicional establecido para que siempre sea verdadero
    { 
       int d=sensor.distance(1); // comando para un numero largo de bits
       device.printf("Distancia:%d\r\n",d); // comando de impresion para mostrar 
      
       if (d<10) //Condicional para valores menores a 10 se va a encender el led naranja.
       { 
           LedVerde=0;
           LedNaranja=1;
           LedAzul=0;
        device.printf("LedNaranja\n");
           }
        
       else if (d>=11 && d<=19)//Condicional para valores entre 11 y 19 se va a encender el led Verde.
       {
           LedVerde=1;
           LedNaranja=0;
           LedAzul=0;
        device.printf("LedVerde\n");
           }
      
     else //Condicional para valores mayores a 19 se va a encender el led azul.
     {
           LedVerde=0;
           LedNaranja=0;
           LedAzul=1;
        device.printf("LedAzul\n");
    }   
     wait(0.1); 
  }
}
