#include "mbed.h"
#include "SDFileSystem.h"
#include "BMP085.h"
#include "ADXL345_I2C.h"

 
SDFileSystem sd(p5, p6, p7, p8, "sd");

ADXL345_I2C accelerometer(p28, p27);
BMP085 bmp085(p28, p27);

Serial pc(USBTX, USBRX);

AnalogIn ain_CDS(p15);
AnalogIn ain_Humedity(p16);
AnalogIn ain_LM35DZ(p20);


DigitalOut myled(LED1);

int fileio() {
    mkdir("/sd/20014", 0777);
    
    FILE *fp = fopen("/sd/mydir/datalog.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
 
    printf("Goodbye World!\n");
    
    return(0);
}


int main() {
    myled = 1;
    
    pc.baud(115200);
 
    int readings[3] = {0, 0, 0};
    
    pc.printf("Starting ADXL345 test...\n");
    wait(.001);
    pc.printf("Device ID is: 0x%02x\n", accelerometer.getDeviceID());
    wait(.001);
    
    // These are here to test whether any of the initialization fails. It will print the failure
    if (accelerometer.setPowerControl(0x00)){
        pc.printf("didn't intitialize power control\n"); 
        return 0;  
    }
    //Full resolution, +/-16g, 4mg/LSB.
    wait(.001);
     
    if(accelerometer.setDataFormatControl(0x0B)){
        pc.printf("didn't set data format\n");
        return 0;  }
    wait(.001);
    
    //3.2kHz data rate.
    if(accelerometer.setDataRate(ADXL345_3200HZ)){
        pc.printf("didn't set data rate\n");
        return 0;
    }
    wait(.001);

    //Measurement mode.
    
    if(accelerometer.setPowerControl(MeasurementMode)) {
        pc.printf("didn't set the power control to measurement\n"); 
        return 0;
    }
    myled = 0;
    
    while (1) { 
        wait(1.5);
        
        //BOSH BMP085 Barometric pressure,temperature measurement
        accelerometer.getOutput(readings);
        pc.printf("\nBOSH BMP085 --------------------\n");
        pc.printf("  %+4.2f, %+4.2f, %+4.2f\n",
            (float((int16_t)readings[0]+18)/256), 
            (float((int16_t)readings[1]-4 )/256), 
            (float((int16_t)readings[2]+22)/256));
        
        bmp085.update();
        
        //ADXL 345 Acceleration measurement
        pc.printf("ADXL345 ------------------------\n");
        pc.printf("  p:%6.2f hPa / t:%6.2f C\n", bmp085.get_pressure(), bmp085.get_temperature());
        
        //CSDS Ambient light measurement P15 analog-in1
        pc.printf("Ambient light :: %f\n",ain_CDS*100);
        
        //Humidity measurement P16 analog-in2
        pc.printf("Humidity       :: %f\n",ain_Humedity*100);
        
        //LM35DZ Temperature measurement P20 analog-in6
        pc.printf("Temperature    :: %f\n",ain_LM35DZ*100);
        
    }
}