#include "mbed.h"
#include "SRF05.h" 
 
SRF05 US_ip(p36, p35);          // UltraSonic_input = Trigger, Echo  
AnalogIn IR_ip1(p19);           // InfraRed_input_1
AnalogIn IR_ip2(p20);           // InfraRed_input_2

// Testing Purposes
DigitalOut led1(LED1);          // If ultra sense >15cm, led1 ON 
DigitalOut led2(LED2);          // If ultra sense <16cm, led2 ON
DigitalOut led3(LED3);          // If infra_1 sense <10cm, led3 ON
DigitalOut led4(LED4);          // If infra_2 sense <10cm, led2 ON
 
float ultra;
float infra_1;
float infra_2;
 
void Ultrasonic()
 {
    {
    ultra = US_ip.read();

    if(ultra>15)   
        {
            led1=1;
            led2=0;
        }
 
    else if(ultra<16) 
        {
            led1=0;
            led2=1;
         }
    }
}
 
 void Infra_1()
{
    {
    infra_1 = IR_ip1.read();

    if(infra_1<0.4)
        {
            led3=1;
        }
 
    else 
        {
            led3=0;
        }
    }
 }
 
void Infra_2()
{
    {
    infra_2 = IR_ip2.read();
 
    if(infra_2<0.4)
        {
            led3=1;
        }
 
    else 
        {
            led3=0;
        }
    }
 }
 
int main()
    {
        //Initialise all leds to OFF
        led1=0;
        led2=0;
        led3=0;
        led4=0;
        wait(1);
        while(1)
          {
              Ultrasonic();
              Infra_1();
              Infra_2();
           }
    }