
/*
 *    The application works with the BLEController iOS/Android App.
 *    Type something from the Terminal to send
 *    to the BLEController App or vice verse.
 *    Characteristics received from App will print on Terminal.
 */
 
#include "mbed.h"
#include "ble/BLE.h"


#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

#define TXRX_BUF_LEN                     4

BLE  ble;
DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);


// The Nordic UART Service
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};


uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

//static uint8_t rx_buf[TXRX_BUF_LEN];
static uint8_t rx_buf[4] = "a";
static uint8_t rx_len=2;
uint8_t blinklow;
uint8_t blinkperiod;
uint8_t blinkrate;
uint8_t blinkcount;


GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
                                      
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
                                      
GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic};

GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));



void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    pc.printf("Disconnected \r\n");
    pc.printf("Restart advertising \r\n");
    ble.startAdvertising();
}

// Serial Write from BLE Read
void WrittenHandler(const GattWriteCallbackParams *Handler)
{   
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead, index;
    
    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) 
    {
        led1 = !led1;    
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);
        if(bytesRead==0x01) {
            if(txPayload[0] == 0x41){
                pc.printf("Fast \r\n");
                blinkperiod = 5;
            }
            if(txPayload[0] == 0x42){
                pc.printf("Slow \r\n");
                  blinkperiod = 20;
            }
        }       
        pc.printf("BLE received = ");
        for(index=0; index<bytesRead; index++)
        {
            pc.putc(txPayload[index]);        
        }
        pc.printf("\r\n");
    }
}

// BLE Write from Serial read
void uartCB(void)
{   
    while(pc.readable())    
        {
        rx_buf[0] = pc.getc();
        led1 = !led1;  
        ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
        pc.printf("Received sensor data transmitted on BLE ");
        pc.putc(rx_buf[0]);
        pc.printf(" \r\n");
        }
}

//void u//artCB(void)
//    {   
//    while(pc.readable())    
//        {
//        rx_buf[rx_len++] = pc.getc();
//        led1 = !led1;    
//        if(rx_len>=4 || rx_buf[rx_len-1]=='\0' || rx_buf[rx_len-1]=='\n')
//            {
//            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
//            pc.printf("Received sensor data transmitted on BLE ");
//            pc.putc(rx_len);
//            pc.printf("\r\n");
//            rx_len = 0;
//            break;
//            }
//    }
//}

void periodicCallback(void)
{
    blinkcount = blinkcount + 1;
    if(blinkcount >= blinkperiod)
    {
        led1 = 0;
        blinkcount = 0;
        pc.printf("Blinked\r\n");
    }
    else if(blinkcount > 1)
    {
        led1 = 1;
    }
    else
    {
        led1 = 0;
    }
    
}

int main(void)
{
    led1 = 0;
    blinkcount = 0;
    blinkperiod = 20;
    Ticker ticker;
    ticker.attach(periodicCallback, 0.1); // blink LED every second
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(WrittenHandler);  
    
    pc.baud(9600);
    pc.printf("IoT Init \r\n");
    
    pc.attach( uartCB , pc.RxIrq);
   // setup advertising 
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)"YSU_bluetooth", sizeof("YSU_bluetooth") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    // 100ms; in multiples of 0.625ms. 
    ble.setAdvertisingInterval(160);

    ble.addService(uartService);
    
    ble.startAdvertising(); 
    pc.printf("Advertising Started \r\n");
    
    while(1)
    {
        ble.waitForEvent(); 
    }
}