#include "mbed.h"
#include "EthernetInterface.h"
 
#define MBED_DEV_IP       "172.16.3.100"
#define MBED_DEV_MASK     "255.255.0.0"
#define MBED_DEV_GW       "172.16.0.254"
#define ECHO_SERVER_PORT   5000

Serial PC(USBTX,USBRX);
 
int main (void) {
    EthernetInterface eth;
    PC.baud(9600);
    PC.printf("K64F is alive!!!\r\n");
    eth.init(MBED_DEV_IP, MBED_DEV_MASK, MBED_DEV_GW); //Assign a device ip, mask and gateway
    eth.connect();
    PC.printf("IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) {
        PC.printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 5000); // Timeout after (5)s
        
        PC.printf("Connection from: %s\r\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
}