/*
 * Servo.h - libreria para el manejo del servo cp90
 * El control se hace enviando la posicion deseada del servo, en angulos (de 0 a 180°)
 * o el valor int entre 0 y 255
 * El valor en angulo se ve afectado por el valor seteado de calibración mientras
 * que el valor entero no, sino que es proporcional entre el duty cicle maximo
 * y el minimo
 * @Author Patricio Silva
 * @Date 13/10/2019
 */
 #ifndef SERVO_H
 #define SERVO_H
 
#include "mbed.h"

typedef struct{
    PwmOut *pinPWM;
    uint16_t period_us;
    uint16_t min_pulse_width_us;
    uint16_t max_pulse_width_us;
    uint8_t currentPos;  //en grados
    uint16_t currentPulseWidth; //pulsewidth actualmente seteado, en us
    uint8_t pwm90;
    // Para movimiento a una velocidad determinada
    uint16_t speed;  // Velocidad a la que debe moverse, en RPM
    bool moving; // True si se está procesando un movimiento con velocidad que no ha terminado
    uint8_t initPos; // Posicion desde la que se empezó a mover a velocidad controlada
    uint8_t finalPos; // Posicion que debe alcanzar, intento alcanzar currentPos = finalPos
    uint32_t startMov; // Momento en que se empezo a mover el servo hacia finalPos
}_Servo;


/*
 * Inicializa el pin en el que se conecta el servo y lo mueve a la posicion 90°
 */
void setup(_Servo *s, PwmOut *pin);

/*
 * Setea la posición del servo a la posicion pos entre 0° y 180°
 */
void setPos(_Servo *s, uint8_t pos);

/*
* Setea la posición del servo a la posicion pos entre 0° y 180°, avanzando a la velocidad s indicada en rpm (1rpm = 6gr/seg)
*/
void setPos(_Servo *s, uint8_t pos, uint16_t speed);

/*
 * Llamar repetidamente. Se encarga de mover el servo a la velocidad configurada
 * retorna true cuando se alcanzó la posición
 */
bool inPos(_Servo *s);

/*
 * Aplica el valor de duty cicle PWM entre 0 (0%) y 255 (100%)
 */
void setRaw(_Servo *s, uint8_t raw);

/*
 * Calibra el servo, el valor pasado por parametro será el duty cicle del PWD para 90° (de 0 a 255)
 */
void calibrate(_Servo *s, uint8_t p);

/*
 * Setea periodo, microseguros
 */
void setPeriod_us(_Servo *s, uint16_t us);

/*
 * Setea minimo ancho de pulso, microseguros
 */
void setMinPulseWidth_us(_Servo *s, uint16_t us);

/*
 * Setea maximo periodo, microseguros
 */
void setMaxPulseWidth_us(_Servo *s, uint16_t us);

#endif   // SERVO_H