 /*
 * Sensor.h - libreria para el manejo del sensor ultrasonico hcsr04 y optico tcrt5000
 * Son  muy diferentes, mantengo todo en el mismo archivo solo para complicarlo inecesariamente
 * NO se controla de que tipo es cada sensor al momento de llamar a las funciones
 * setup con un solo pin analogico de entrada es para el tcrt5000, si es digital de entrada es para los sensores de horquilla
 * setup dos pin es para el ultrasonico, uno digital de salida y el otro digital de entrada
 * @Author Patricio Silva
 * @Date 14/10/2019
 */ 
#ifndef SENSOR_H
#define SENSOR_H

#include "mbed.h"

typedef struct{
    DigitalOut *pinTrigger;
    DigitalIn *pinEcho;
    AnalogIn *pinA;
    volatile uint32_t ctime; // un contador de tiempo generico
    volatile uint32_t dtime; // otro contador de tiempo generico o contador de pulsos para Lm393
    // etapa de una prueba de sensor ultrasonico
    // 0: inactivo
    // 1: enviando trigger
    // 2: Esperando respuesta en pinEcho
    // 3: HIGH en pinHecho, midiendo tamaño del pulso
    uint8_t stage;
    volatile uint16_t slot_count;
    volatile uint16_t dist_count;
    uint8_t slots;
    uint8_t perim;  // Perimetro de la rueda, en mm
    uint16_t rpm;
}_Sensor;

void setup(_Sensor *s, AnalogIn *pin); // Sensor tcrt5000: pin analogico.
void setup(_Sensor *s, DigitalIn *pin, uint8_t c, uint8_t p);  //Sensor de Horquilla Lm393: pin digital
void setup(_Sensor *s, DigitalOut *pint, DigitalIn *pine); //Sensor hcsr04, pines digitales

////////////  Sensor ultrasonico

/*
 * Funcion desatendida, inicia un ciclo de deteccion de distancia con el sensor ultrasonico y devuelve el control
 */
bool init(_Sensor *s);

/*
* Limpia un pedido de medición desatendido
*/
void reset(_Sensor *s);

/*
 * isReady retorna la distancia en cm detectada en el sensor ultrasonico, 0 si no se tiene aún la respuesta.
 * La efectividad depende de llamar a esta funcion al menos cada 5us., la respuesta será siempre aproximada
 * Para mejor resolucion (distancas menores a 5cm) se utiliza ping, que no devuelve el control sin una respuesta
 * No creo que sea neceario manejarlo con interrupciones
 */
uint16_t isReady(_Sensor *s);

/*
 * Mide la distancia en milimetros con el sensor ultrasonico, no devuelve el control hasta no tener la respuesta o llegar al timeout
 * mide una distancia maxima max, por lo tanto espera un maximo de (max*5.8us + 20us)
 */
uint16_t ping(_Sensor *s, uint16_t max);

////////////  Sensor optico
/*
 * Retorna el valor del sensor optico
 */
uint16_t getValue(_Sensor *s);

////////////  Sensor optico de horquilla

/*
 * retorna la cantidad de milisegundos que separaron al inicio de los dos ultimos pulsos high
 */
uint32_t getMs(_Sensor *s);


/*
 * retorna las rpm medidas con el sensor
 */
uint16_t getRpm(_Sensor *s);

/*
 * Empieza a medir una distancia desde el punto actual
 */
void distanceStart(_Sensor *s);

/*
 * Retorna la distancia medida, se supone que todos los slot fueron en el mismo sentido
 */
uint16_t getDistance(_Sensor *s);

/*
 * Le indica al objeto que el pin está en alto, lo manejo con interrupciones
 */
void notify(_Sensor *s);

#endif  //SENSOR_H