#include "Pserial.h"



// fingerprint del header, como constante ("UNER00:")
const uint8_t header[] = {0x55, 0x4E, 0x45, 0x52, 0x00, 0x00, 0x3A};



/*
 * Inicializa el objeto
 */
void serialSetup(_Pserial *s, Serial *p){
    s->RX.indexR=0;
    s->RX.indexW=0;
    s->RX.stage=0;
    s->RX.cmd=false;
    s->TX.indexR=0;
    s->TX.indexW=0;
    s->TX.empty=true;
    // Calculo el checksum del header
    s->TX.chksumHeader = header[0];
    for (uint8_t i = 1 ; i < 4 ; i++){
        s->TX.chksumHeader ^= header[i];
    }
    s->port = p;
}





// Carga al buffer lo recibido por puerto serie
void serialReceive(_Pserial *s){
  while (s->port->readable() && (uint8_t)(s->RX.indexW+1) != s->RX.indexR){
    s->RX.buf[s->RX.indexW++] = s->port->getc();;
  }
}



/* Escribe en el puerto serie los datos del buffer
 * en cualquier escribo solo de a 1 byte por llamada
 */
void serialSubmit(_Pserial *s){
    if(s->TX.indexR!=s->TX.indexW){
      s->port->putc(s->TX.buf[s->TX.indexR++]);
    }
  s->TX.empty = (s->TX.indexR==s->TX.indexW);
}



/*  Busca si hay un frame en el buffer que esté correcto y verifica el checksum
 *  Si hay un header mueve el indice s->RX.cmdIndex a la posicion donde comienza el comando
 *  y setea a true el flag s->RX.cmd. Mueve s->RX.indexR a esa posición para liberar el espacio
 *  ocupado por el header
 */
void serialGetFrame(_Pserial *s){
  uint8_t index;
  
  // No logré completar el comando dentro de la ventana de tiempo, considero vacio el buffer de entrada
  if(s->RX.stage > 0 && s->RX.cmdTime+RXCMDTIME < us_ticker_read()){
    s->RX.indexR = s->RX.indexW;
    s->RX.stage = 0;
    return;
  }

  // mientras hay bytes disponibles en el buffer, proceso desde donde quedé
  index = s->RX.indexR+s->RX.stage;
  while (index != s->RX.indexW){
    switch (s->RX.stage){
      case 0:
          s->RX.cmdTime = us_ticker_read();
      case 1:
      case 2:
      case 3:{
          if(s->RX.buf[index] == header[s->RX.stage]){
            s->RX.stage++;
            index++;
          }else{ // No coincide con un header, descarto hasta acá y empiezo de nuevo en el proximo ciclo
            s->RX.indexR +=s->RX.stage;
            s->RX.stage=0;
            return;
          }
          break;
      }
      case 4:{
          s->RX.payloadSize = s->RX.buf[index];
          s->RX.stage++;
          index++;
          break;
      }
      case 5:{
          s->RX.payloadSize += s->RX.buf[index]*256;
          s->RX.stage++;
          index++;
          break;
      }
      case 6:{
          if (s->RX.buf[index] == header[s->RX.stage]){ // Llego al separador ":", marco la posicion sigiente como cmdIndex
            s->RX.stage++;
            index++;
          }else{
            s->RX.indexR += 3; // Continuo desde la direccion de tamaño del payload
            s->RX.stage = 0;
            return;
          }
          break;
      }
      case 7:{
          // empiezo a incrementar index hasta alcanzar el fin de trama (s->RX.indexR+s->RX.payloadSize+7)
          // No avanzo si aún hay un comando por ejecutar
          if(!s->RX.cmd && index == (uint8_t)(s->RX.indexR+s->RX.payloadSize+6)){ // alcance la posicion del checksum
            // Calculo checksum y comparo
            s->RX.chksum = s->RX.buf[s->RX.indexR];
            for (uint16_t i = 1 ; i < s->RX.payloadSize+6 ; i++){
              s->RX.chksum ^= s->RX.buf[(uint8_t)(s->RX.indexR+i)];
             }
            if(s->RX.buf[(uint8_t)(s->RX.indexR+s->RX.payloadSize+6)] == s->RX.chksum){
              s->RX.cmd = true;
              s->RX.cmdIndex = s->RX.indexR+7;
              s->RX.indexR = s->RX.cmdIndex;
              s->TX.cmdTime = us_ticker_read(); // marca de tiempo para responder el comando
              s->RX.stage = 0;
              return;
            }else{
              s->RX.indexR += 3; // checksum incorrecto, continuo procesando desde la direccion de tamaño del payload
              s->RX.stage = 0;
            }
            return;
          }else{
            index++;
          }
          break;
      }
      default:{
          s->RX.stage = 0;
          return;
      }
    }
  }
}


 
/*
 * Escribe en el buffer de salida un frame con un tamaño de comando+payload+checksum = s
 * retorna true cuando termina de escribir, falso si no hay suficiente espacio (y restablece los indices)
 */
bool serialEnqueueHeader(_Pserial *s, uint16_t h){
  uint8_t index = s->TX.indexW;
  // Inicializo chechsum
  s->TX.chksum = s->TX.chksumHeader;

  // escribo la cabecera
  for (uint8_t i = 0 ; i < 4 ; i++){
      if(s->TX.indexR != s->TX.indexW || s->TX.empty){
        s->TX.buf[s->TX.indexW++] = header[i];
      }else{
        s->TX.indexW = index;
        return false;
      }
  }
  // Escribo el tamaño
  if(s->TX.indexR != s->TX.indexW || s->TX.empty){
    s->TX.buf[s->TX.indexW++] = (uint8_t)h;
    s->TX.chksum ^= (uint8_t)h;
  }else{
    s->TX.indexW = index;
    return false;
  }
  if(s->TX.indexR != s->TX.indexW || s->TX.empty){
    s->TX.buf[s->TX.indexW++] = (uint8_t)(h/256);
    s->TX.chksum ^= (uint8_t)(h/256);
  }else{
    s->TX.indexW = index;
    return false;
  }
  // escribo el separador
  if(s->TX.indexR != s->TX.indexW || s->TX.empty){
    s->TX.buf[s->TX.indexW++] = header[6];
    s->TX.chksum ^= header[6];
  }else{
    s->TX.indexW = index;
    return false;
  }
  return true;
}

// Escribe el byte en el buffer de salida, retorna falso si no hay lugar suficiente para hacerlo
bool serialEnqueueData(_Pserial *s, uint8_t d){
  if(s->TX.indexR != s->TX.indexW || s->TX.empty){
    s->TX.buf[s->TX.indexW++] = d;
    s->TX.chksum ^= d;
    return true;
  }else{
    s->TX.indexW--;
    return false;
  }
}

// Encola el checksum
bool serialEnqueueChksum(_Pserial *s){
  return serialEnqueueData(s, s->TX.chksum);
}


/* 
 * Borra el comando actual para que getFrame pueda recibir el siguiente
 * Necesario por cada overflow de us_ticker_read()
 */
void serialCmdClean(_Pserial *s){
    s->RX.cmd = false;
    s->RX.cmdTime = 0;
    s->RX.indexR = s->RX.cmdIndex+s->RX.payloadSize;
    s->TX.cmdTime = 0;
}

// Devuelve todo lo que recibe, una llamada vacia el buffer de entrada
void serialGoBack(_Pserial *s){
    while(s->RX.indexR!=s->RX.indexW){
        s->port->putc(s->RX.buf[s->RX.indexR++]);
    }
}