/*
 * Motor.h - libreria para el manejo de los motores
 * pinPWM es el pin que controla la velocidad
 * Segun el controlador puede utilizar uno o dos pines digitales para indicar la salida
 * Si se define 1 es para el contolador L9110, donde la direccion la da la diferencia de
 * polaridad entre el pin A y el pwm
 * Si se definen los dos es para el contolador L298 la direccion la da la diferencia 
 * de polaridad entre A y B, pwm solo indica la velocidad
 * @Author Patricio Silva
 * @Date 31/10/2019
 */
 #ifndef MOTOR_H
 #define MOTOR_H

#include "mbed.h"
#include "Sensor.h"

typedef struct{
    PwmOut *pinPWM;
    DigitalOut *pinDirA;
    DigitalOut *pinDirB;
    uint16_t currRpm;  //rpm Solicitadas
    uint32_t startOn;
    uint32_t timeOut;
    uint32_t lastPID; // Ultimo vez que ajusté por PID
    float dutyCicle;  //dutyCicle aplicado al pin pwm
    bool dirForward;  // true si se mueve hacia adelante
    _Sensor *sensor;   // Sensor para el control de rpm
    int16_t currError; // Paramteros PID
    float proportional;
    float integrative;
    float derivative;
}_Motor;


/*
 * Inicializa los pn para un controlador L9110
 */
void setup(_Motor *m, _Sensor *s, PwmOut *pin, DigitalOut *pa);

/*
 * Inicializa los pn para un controlador L298
 */
void setup(_Motor *m, _Sensor *s, PwmOut *pin, DigitalOut *pa, DigitalOut *pb);

/*
 * Mueve el motor hacia adelante a la velocidad indicada (0: minima 1: maxima)
 */
void goForward(_Motor *m, uint16_t rpm, uint32_t t);

/*
 * Mueve el motor hacia atras, a velocidad indicada
 */
void goBackward(_Motor *m, uint16_t rpm, uint32_t t);

/*
 * Detiene el motor
 */
void stop(_Motor *m);

/*
 * Setea el periodo del pin pwm en us 
 */
void setPeriod_us(_Motor *m, uint16_t p);

/*
 * Retorna el duty Cicle pwm adecuado para las rpm, segun la tabla
 */
float lookupDC(uint16_t rpm);

/*
 * Retorna true cuando el motor finalizó su avance
 */
bool isReady(_Motor *m);

/*
 * Setea un movimiento del motor sin control de velocidades
 */
void setRaw(_Motor *m, float dc, bool fw);

#endif // MOTOR_H