/*
 * Motor.h - libreria para el manejo de los motores
 * @Author Patricio Silva
 * @Date 31/10/2019
 */

#include "Motor.h"


/*
 * Inicializa los pn para un controlador L9110
 */
void setup(_Motor *m, _Sensor *s, PwmOut *pin, DigitalOut *pa){
    m->pinPWM = pin;
    m->pinDirA = pa;
    m->pinDirB = NULL;
    m->sensor = s;
    m->timeOut = 0;
    m->pinDirA->write(0);
    m->pinPWM->period_us(1000);
    m->pinPWM->write(0); //Duty cilcle
}

/*
 * Inicializa los pn para un controlador L298
 */
void setup(_Motor *m, _Sensor *s, PwmOut *pin, DigitalOut *pa, DigitalOut *pb){
    m->pinPWM = pin;
    m->pinDirA = pa;
    m->pinDirB = pb;
    m->sensor = s;
    m->timeOut = 0;
    m->pinDirA->write(0);
    m->pinDirB->write(0);
    m->pinPWM->period_us(1000);
    m->pinPWM->write(0);
}


void goForward(_Motor *m, uint16_t rpm, uint32_t t){
    m->dirForward = true;
    m->currRpm = rpm;
    m->timeOut = t;
    m->lastPID = 0;
    m->startOn = us_ticker_read()/1000;
    m->dutyCicle = lookupDC(rpm);
    m->pinDirA->write(1);
    m->pinPWM->write(m->dutyCicle);
    if(m->pinDirB != NULL){
        m->pinDirB->write(0);
    }
}

void goBackward(_Motor *m, uint16_t rpm, uint32_t t){
    m->dirForward = false;
    m->dutyCicle = lookupDC(rpm);
    m->currRpm = rpm;
    m->timeOut = t;
    m->lastPID = 0;
    m->startOn = us_ticker_read()/1000;
    m->pinDirA->write(0);
    if(m->pinDirB != NULL){
        m->pinDirB->write(1);
        m->pinPWM->write(m->dutyCicle);
    }else{
        m->pinPWM->write(1-m->dutyCicle);
    }
}

void stop(_Motor *m){
    m->dutyCicle = 0;
    m->currRpm = 0;
    m->timeOut = 0;
    m->pinDirA->write(0);
    m->pinPWM->write(0);
    if(m->pinDirB != NULL)
        m->pinDirB->write(0);
}

void setPeriod_us(_Motor *m, uint16_t p){
    m->pinPWM->period_us(p);
}

float lookupDC(uint16_t rpm){
    return 0.3;
}


// Kp = 0.001, Kd = 0.005 y Ki = 0.005 - el error es en RPM, por eso son valores K tan pqueños ya qu eajustan un dutyCicle entre 0 y 1
bool isReady(_Motor *m){
    // chequeo si ya teng que parar
    if(m->startOn + m->timeOut > (us_ticker_read()/1000)){
        stop(m);
        return true;
    }
    
    //Ajusto la velocidad, el intervalo es proporcional a las rpm y la cantidad de slots del encoder, usando
    // como intervalo el tiempo en que deberia haber contado al menos un slot
    if((us_ticker_read()/1000) > m->lastPID + (2*(60000/(m->sensor->slots*m->currRpm)))){  // 60000/(m->sensor->slots*m->currRpm) = cantidad de ms que tarda en contarse un slot a las rpm dadas
        m->lastPID = us_ticker_read()/1000;
        int16_t error = m->currRpm - getRpm(m->sensor); // Error actual
        m->proportional = error*0.001;
        if(error > 1 || error < -1){  // No aplico integrative a errores pequeños
            m->integrative = (float)0.0005*(m->integrative + error);
        }
        m->derivative = 0.0001*(error - m->currError);
        m->currError = error;
        if(m->dutyCicle + m->proportional + m->integrative + m->derivative > 1)
            m->dutyCicle  = 1;
        else if(m->dutyCicle + m->proportional + m->integrative + m->derivative < 0)
            m->dutyCicle  = 0;
        else
            m->dutyCicle = m->dutyCicle + m->proportional + m->integrative + m->derivative;
        m->pinPWM->write(m->dutyCicle);
    }
    return false;
}


void setRaw(_Motor *m, float dc, bool fw){
    m->currRpm = 0;
    m->dutyCicle = dc;
    if(fw){
        m->pinDirA->write(0);
        m->pinPWM->write(dc);
        if(m->pinDirB != NULL){
            m->pinDirB->write(1);
        }
    }else{
        m->pinDirA->write(1);
        if(m->pinDirB != NULL){
            m->pinDirB->write(0);
            m->pinPWM->write(dc);
        }else{
            m->pinPWM->write(1-dc);
        }
    }
}