/*
fire colors
EBC137  E38C2D  DB4C2C  771E10  48110C
*/


#include "mbed.h"
#include "WS2812.h"

//#define LED_RGB     D4

#define LED_RGB1     D1
#define LED_RGB2     D2
#define LED_RGB3     D3
#define LED_RGB4     D4
#define LED_RGB5     D5
#define LED_RGB6     D6




const int N=200;

WS2812 RGB1(LED_RGB1, N);
WS2812 RGB2(LED_RGB2, N);
WS2812 RGB3(LED_RGB3, N);
WS2812 RGB4(LED_RGB4, N);
WS2812 RGB5(LED_RGB5, N);
WS2812 RGB6(LED_RGB6, N);


uint32_t colors[N];
uint32_t firecolors[6]={0x000000,0xEBC137,0xE38C2D,0xDB4C2C,0x771E10,0x48110C};
uint32_t galaxycolors[5]={0x0E0C03,0x0E0802,0x0D0402,0x070101,0x040100};//{0x111111,0x111111,0x111111,0x111111,0x111111};//{0x003a65,0x009085,0xffffff,0x960088,0x000000};

DigitalOut myled(LED1);


int main() {
    for(int i=0;i<N;i++){
        colors[i]=rand();
    }
    for(int i=0;i<N;i++){
        colors[i]=galaxycolors[rand()%5];
    }
        
    while(1) {
        myled = 1; // LED is ON
        wait(0.1); // 200 ms
        myled = 0; // LED is OFF
        wait(0.1); // 1 sec
        
        
        colors[N-1]=colors[N-2]+0x010101;
        for(int i=0;i<N;i++){
            if((rand()%8)==6){
                colors[i]= galaxycolors[rand()%5];
            }
        }
        
        RGB1.sendColors(colors);      
        RGB2.sendColors(colors);
        RGB3.sendColors(colors);
        RGB4.sendColors(colors);
        RGB5.sendColors(colors);
        RGB6.sendColors(colors);
        

    }
}
