#ifndef WS2812_H
#define WS2812_H
#include "mbed.h"

class WS2812
{
  public:
  
  uint8_t Red;
  uint8_t Green;
  uint8_t Blue;
  
  WS2812(PinName pin, int qty);
  ~WS2812();
  void writeColor(uint32_t RGB);
  void send1Color(uint32_t RGB);
  void sendColors(uint32_t * ColorBuffer);
  void sendReset();
  
  private:
  int LED_Qty;
  PinName dataPin;
  DigitalOut dataOut;
  
  void writeByte(uint8_t data);
  void send0();
  void send1();
};

#endif