#include "mbed.h"
#include <cctype>
#include "att160826.h"

I2C *myi2c;

att160826_data_t strip_data[2];
att160826_data_t last_data[2];
ATT160826 *strips[4];


// comment out the following line if color is not supported on the terminal
#define USE_COLOR
#ifdef USE_COLOR
 #define BLK "\033[30m"
 #define RED "\033[31m"
 #define GRN "\033[32m"
 #define YEL "\033[33m"
 #define BLU "\033[34m"
 #define MAG "\033[35m"
 #define CYN "\033[36m"
 #define WHT "\033[37m"
 #define DEF "\033[39m"
#else
 #define BLK
 #define RED
 #define GRN
 #define YEL
 #define BLU
 #define MAG
 #define CYN
 #define WHT
 #define DEF
#endif


Serial         pc(USBTX, USBRX);

DigitalOut led_green(LED_GREEN);
DigitalOut led_red(LED_RED);
DigitalOut led_blue(LED_BLUE);


bool toggleLed = false;



//********************************************************************************************************************************************
//* Set the RGB LED's Color
//* LED Color 0=Off to 7=White.  3 bits represent BGR (bit0=Red, bit1=Green, bit2=Blue) 
//********************************************************************************************************************************************
void SetLedColor(unsigned char ucColor)
{

    led_red = !(ucColor & 0x1); //bit 0
    led_green = !(ucColor & 0x2); //bit 1
    led_blue = !(ucColor & 0x4); //bit 2

} //SetLedColor() 





void scanStrip(int id)
{
    ATT160826&  strip = *strips[id];
    att160826_data_t *data = &strip_data[id];
    bool ok = strip.scan(data);
     
    if(ok)
    {  
        printf("%d : ",id);
        for (int i = 0; i < SENSORS_PER_STRIP;i++) { 
                  
            if (strip_data[id].sensor[i].present) {
                printf(" [%3d %3d %3d] ", strip_data[id].sensor[i].sample.prox,
                strip_data[id].sensor[i].sample.als_vis,
                strip_data[id].sensor[i].sample.als_ir);
            } else {
                printf(" %3s", "---");
            }
        }
    }
    else
        printf("scan of strip %d failed",id);
    printf("\r\n");
}


int main() {
 
    pc.baud(115200);
 
    myi2c = new I2C(PTC11, PTC10); 
    myi2c->frequency(100000);
    ATT160826 strip0 (myi2c, 0 );
    ATT160826 strip1 (myi2c, 1 );
    ATT160826 strip2 (myi2c, 2 );
    ATT160826 strip3 (myi2c, 3 );
    strips[0] = &strip0;
    strips[1] = &strip1;
    strips[2] = &strip2;
    strips[3] = &strip3;
    
    pc.printf(GRN "I2c init \n\r");
    
    while(1) {
       
        toggleLed = !toggleLed;
        if(toggleLed)
            SetLedColor(0x2); //green 
        else    
            SetLedColor(0); //off    
            
        scanStrip(0);  
       // scanStrip(1); 
       // scanStrip(2); 
      //  scanStrip(3);         
    
        
        wait(1); 
    } //forever loop
}
