#include "mbed.h"
#include <cctype>
#include "SerialBuffered.h"
#include "config_me.h"
#include "Wnc.h"

extern SerialBuffered mdm;
Wnc wnc;
int seqNum =0;
int msgLen = 10;


// comment out the following line if color is not supported on the terminal
#define USE_COLOR
#ifdef USE_COLOR
 #define BLK "\033[30m"
 #define RED "\033[31m"
 #define GRN "\033[32m"
 #define YEL "\033[33m"
 #define BLU "\033[34m"
 #define MAG "\033[35m"
 #define CYN "\033[36m"
 #define WHT "\033[37m"
 #define DEF "\033[39m"
#else
 #define BLK
 #define RED
 #define GRN
 #define YEL
 #define BLU
 #define MAG
 #define CYN
 #define WHT
 #define DEF
#endif

#define MDM_DBG_OFF                             0
#define MDM_DBG_AT_CMDS                         (1 << 0)



int mdm_dbgmask = MDM_DBG_OFF;

Serial         pc(USBTX, USBRX);

DigitalOut led_green(LED_GREEN);
DigitalOut led_red(LED_RED);
DigitalOut led_blue(LED_BLUE);





//DigitalIn   slot1(PTB3,PullUp);
//DigitalIn   slot2(PTB10,PullUp);
//DigitalIn   slot3(PTB11,PullUp);

DigitalIn   sw2(SW2);


#define TOUPPER(a) (a) //toupper(a)


#define MDM_OK                                  0
#define MDM_ERR_TIMEOUT                         -1

#define MAX_AT_RSP_LEN                          255

bool toggleLed = false;



//********************************************************************************************************************************************
//* Set the RGB LED's Color
//* LED Color 0=Off to 7=White.  3 bits represent BGR (bit0=Red, bit1=Green, bit2=Blue) 
//********************************************************************************************************************************************
void SetLedColor(unsigned char ucColor)
{

    //Note that when an LED is on, you write a 0 to it:
    led_red = !(ucColor & 0x1); //bit 0
    led_green = !(ucColor & 0x2); //bit 1
    led_blue = !(ucColor & 0x4); //bit 2

} //SetLedColor() 


void system_reset()
{
    printf(RED "\n\rSystem resetting..." DEF "\n");
    NVIC_SystemReset();
}
 
void GenerateTestString(char * modem_string,int len)
{           
    seqNum++;
    char data[len+1];
    for(int i = 0;i<len;i++)
        data[i] = 'b';
    data[len] = 0;
    sprintf(modem_string, "%s", data);
}

int main() {

    pc.baud(115200);
   
    // Set LED to RED until init finishes
    SetLedColor(0x1);

    pc.printf(BLU "Hello World\r\n\n\r");

    // Initialize the modem
    printf(GRN "Modem initializing... will take up to 60 seconds" DEF "\r\n");
    if(!wnc.init()) 
    {
        pc.printf(RED "Modem initialization failed!" DEF "\n");
        system_reset();
    }
          
    char* iccid = wnc.getIccid();
    printf(GRN "ICCID = %s" DEF "\r\n",iccid);
    

           
    //Software init
    if(!wnc.startInternet())
        system_reset();
    
    char* ip = wnc.resolveDn(MY_SERVER_URL);
    if(strlen(ip) == 0)
    {
       printf(RED "Failed to resolve IP for %s" DEF "\r\n",MY_SERVER_URL); 
    }
    else
        printf(GRN "IP = %s" DEF "\r\n",ip);

    // Set LED BLUE for partial init
    SetLedColor(0x4);
 
    char modem_string[512];                
    
    while(true)
    {   
        toggleLed = !toggleLed;
        if(toggleLed)
            SetLedColor(0x2); //green 
        else    
            SetLedColor(0); //off 
            
        if(sw2 == 0)
        {      
            GenerateTestString(modem_string,msgLen);
            printf(BLU "Sending to modem : %s" DEF "\r\n", modem_string);
                      
            if(wnc.connect(ip,MY_PORT)) // shelf
            {
                if(wnc.writeSocket(modem_string))
                {       
                    char* mydata;
                    int tries = 8;
                    while(tries > 0) // wait for reply
                    {
                        tries--;
                        mydata = wnc.readSocket();
                        if (strlen(mydata) > 0)
                            break;
                 
                        wait(0.5);
                    }
            
                    if (strlen(mydata) > 0)
                    {                                 
                        SetLedColor(0x2); // green
                        printf(BLU "Read back : [%s]" DEF "\r\n", mydata);
                        sscanf(mydata,"LEN=%d",&msgLen);
                    }
                }
                wnc.disconnect();
            }
            else // failed to connect reset
            {
                SetLedColor(0x1); //red
                system_reset(); 
            }   
        }
        wait(0.2); 
    } //forever loop
}
