#include "mbed.h"
#include <cctype>
#include "SerialBuffered.h"
#include "HTS221.h"
#include "config_me.h"
#include "sensors.h"
#include "Proximity.h"
#include "Wnc.h"

#include "hardware.h"
#include "att160826.h"

extern SerialBuffered mdm;
Wnc wnc;

I2C i2c(PTC11, PTC10);    //SDA, SCL -- define the I2C pins being used
I2C *myi2c;

#define PROXIMITYON 1

#if PROXIMITYON == 1
att160826_data_t strip_data[2];
att160826_data_t last_data[2];
ATT160826 *strips[2];
#elif PROXIMITYON == 2
Proximity proximityStrip[2];
#endif

// comment out the following line if color is not supported on the terminal
#define USE_COLOR
#ifdef USE_COLOR
 #define BLK "\033[30m"
 #define RED "\033[31m"
 #define GRN "\033[32m"
 #define YEL "\033[33m"
 #define BLU "\033[34m"
 #define MAG "\033[35m"
 #define CYN "\033[36m"
 #define WHT "\033[37m"
 #define DEF "\033[39m"
#else
 #define BLK
 #define RED
 #define GRN
 #define YEL
 #define BLU
 #define MAG
 #define CYN
 #define WHT
 #define DEF
#endif

#define MDM_DBG_OFF                             0
#define MDM_DBG_AT_CMDS                         (1 << 0)







int mdm_dbgmask = MDM_DBG_OFF;

Serial         pc(USBTX, USBRX);

DigitalOut led_green(LED_GREEN);
DigitalOut led_red(LED_RED);
DigitalOut led_blue(LED_BLUE);





DigitalIn   slot1(PTB3,PullUp);
DigitalIn   slot2(PTB10,PullUp);
DigitalIn   slot3(PTB11,PullUp);

DigitalIn   sw2(SW2);

int lastSlot1;
int lastSlot2;
int lastSlot3;
char *iccid;
#define TOUPPER(a) (a) //toupper(a)


#define MDM_OK                                  0
#define MDM_ERR_TIMEOUT                         -1

#define MAX_AT_RSP_LEN                          255

bool toggleLed = false;
int seqNum;


//********************************************************************************************************************************************
//* Set the RGB LED's Color
//* LED Color 0=Off to 7=White.  3 bits represent BGR (bit0=Red, bit1=Green, bit2=Blue) 
//********************************************************************************************************************************************
void SetLedColor(unsigned char ucColor)
{
    if(wnc.isPowerSaveOn()) 
    {
        led_red = !0;
        led_green = !0;
        led_blue = !(ucColor & 0x4);
    }
    else
    {
        //Note that when an LED is on, you write a 0 to it:
        led_red = !(ucColor & 0x1); //bit 0
        led_green = !(ucColor & 0x2); //bit 1
        led_blue = !(ucColor & 0x4); //bit 2
    }
} //SetLedColor() 


void system_reset()
{
    //wnc.passthrough();
    printf(RED "\n\rSystem resetting..." DEF "\n");
    NVIC_SystemReset();
}


#define CTOF(x)  ((x)*1.8+32)

//********************************************************************************************************************************************
//* Create string with sensor readings that can be sent to flow as an HTTP get
//********************************************************************************************************************************************
K64F_Sensors_t  SENSOR_DATA =
{
    .Temperature        = "0",
    .Humidity           = "0",
    .AccelX             = "0",
    .AccelY             = "0",
    .AccelZ             = "0",
    .MagnetometerX      = "0",
    .MagnetometerY      = "0",
    .MagnetometerZ      = "0",
    .AmbientLightVis    = "0",
    .AmbientLightIr     = "0",
    .UVindex            = "0",
    .Proximity          = "0",
    .Temperature_Si7020 = "0",
    .Humidity_Si7020    = "0"
};



void GenerateModemString(char * modem_string,int sensor,int strip)
{
    switch(sensor)
    {
#if PROXIMITYON == 1

        case PROXIMITY_ONLY:
        {
            if(strip == -1)
            {
                seqNum++;
                sprintf(modem_string, "GET %s%s?ver=cat1&strip=%d&serial=%s&seq=%d&psm=%d&T=%d&t=%d %s%s\r\n\r\n", FLOW_BASE_URL, "/shelf", strip, iccid, seqNum, wnc.isPowerSaveOn(),wnc.gett3412Timer(),wnc.gett3324Timer(),FLOW_URL_TYPE, MY_SERVER_URL);
                break;
            }
            int stripIndex = 0;
            if(strip == 3)
                stripIndex = 1;
            char data[256];
            int i=0;
            int index = 0;
            index += sprintf(&data[index],"[");
            for (i=1; i<SENSORS_PER_STRIP; i++)
            {
                short  p = last_data[stripIndex].sensor[i].sample.prox;
                short l = last_data[stripIndex].sensor[i].sample.als_vis;
                short r = last_data[stripIndex].sensor[i].sample.als_ir;
                if(i<SENSORS_PER_STRIP-1)
                    index += snprintf(&data[index], 128, "{\"s\":%d,\"p\":%d,\"l\":%d,\"r\":%d},", i,p,l,r);
                else
                    index += snprintf(&data[index], 128, "{\"s\":%d,\"p\":%d,\"l\":%d,\"r\":%d}]", i,p,l,r);

            } 
            

            seqNum++;
            sprintf(modem_string, "GET %s%s?ver=cat1&strip=%d&serial=%s&seq=%d&psm=%d&T=%d&t=%d&data=%s %s%s\r\n\r\n", FLOW_BASE_URL, "/shelf", strip, iccid, seqNum, wnc.isPowerSaveOn(),wnc.gett3412Timer(),wnc.gett3324Timer(), data,  FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
#elif PROXIMITYON == 2
        case PROXIMITY_ONLY:
        {

            char* data0 = proximityStrip[0].getDataStr();
            char* data1 = proximityStrip[1].getDataStr();
            seqNum++;
            sprintf(modem_string, "GET %s%s?serial=%s&seq=%d&data=%s&data1=%s %s%s\r\n\r\n", FLOW_BASE_URL, "/shelf", iccid, seqNum, data0,data1,  FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
#endif
        case SWITCH_ONLY:
        {
            char data[32];
            sprintf(data,"[{\"p\":%d},{\"p\":%d},{\"p\":%d}]",lastSlot1*26,lastSlot2*26,lastSlot3*26);
            seqNum++;
            sprintf(modem_string, "GET %s%s?serial=%s&seq=%d&data=%s %s%s\r\n\r\n", FLOW_BASE_URL, "/car", iccid, seqNum, data,  FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
        case TEMP_HUMIDITY_ONLY:
        {
            sprintf(modem_string, "GET %s%s?serial=%s&temp=%s&humidity=%s %s%s\r\n\r\n", FLOW_BASE_URL, FLOW_INPUT_NAME, FLOW_DEVICE_NAME, SENSOR_DATA.Temperature, SENSOR_DATA.Humidity, FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
        case TEMP_HUMIDITY_ACCELEROMETER:
        {
            sprintf(modem_string, "GET %s%s?serial=%s&temp=%s&humidity=%s&accelX=%s&accelY=%s&accelZ=%s %s%s\r\n\r\n", FLOW_BASE_URL, FLOW_INPUT_NAME, FLOW_DEVICE_NAME, SENSOR_DATA.Temperature, SENSOR_DATA.Humidity, SENSOR_DATA.AccelX,SENSOR_DATA.AccelY,SENSOR_DATA.AccelZ, FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
        case TEMP_HUMIDITY_ACCELEROMETER_PMODSENSORS:
        {
            sprintf(modem_string, "GET %s%s?serial=%s&temp=%s&humidity=%s&accelX=%s&accelY=%s&accelZ=%s&proximity=%s&light_uv=%s&light_vis=%s&light_ir=%s %s%s\r\n\r\n", FLOW_BASE_URL, FLOW_INPUT_NAME, FLOW_DEVICE_NAME, SENSOR_DATA.Temperature, SENSOR_DATA.Humidity, SENSOR_DATA.AccelX,SENSOR_DATA.AccelY,SENSOR_DATA.AccelZ, SENSOR_DATA.Proximity, SENSOR_DATA.UVindex, SENSOR_DATA.AmbientLightVis, SENSOR_DATA.AmbientLightIr, FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
        default:
        {
            sprintf(modem_string, "Invalid sensor selected\r\n\r\n");
            break;
        }
    } //switch(iSensorsToReport)
} //GenerateModemString        
            
            
//********************************************************************************************************************************************
//* Process JSON response messages
//********************************************************************************************************************************************
bool extract_reply(char* search_field, char* found_string)
{
    char* beginquote;
    char* endquote;
    beginquote = strstr(search_field, "\r\n\r\n"); //start of data
    endquote = strchr(search_field, '\0');
    if (beginquote != 0)
    {
        uint16_t ifoundlen;
        if (endquote != 0)
        {
            ifoundlen = (uint16_t) (endquote - beginquote) + 1;
            strncpy(found_string, beginquote, ifoundlen );
            found_string[ifoundlen] = 0; //null terminate
            return true;
        }
    }

    return false;

} //extract_reply


void parse_reply(char* reply)
{
    char *tokens[5];
    int index = 0;
    tokens[index++] = strtok(reply," ");  
    while( index < 5 ) 
    {    
      char* token = strtok(NULL, " ");
      if(token == NULL) break;
      tokens[index++] = token;
    }
    if(strcmp("PSM",tokens[1]) == 0)
    {

        int t3412 = atoi(tokens[3]);
        int t3324 = atoi(tokens[4]);
        pc.printf("t3412 %d t3324 %d\r\n",t3412,t3324);
        // setTauTimer(t3412);
        //setActivityTimer(t3324);
        
        if(strcmp("true",tokens[2]) == 0)
        {
            pc.printf("PSM ON\r\n");
            wnc.setPowerSave(true,t3412,t3324);
        }
        else
        {
            pc.printf("PSM OFF\r\n");
            wnc.setPowerSave(false,t3412,t3324);
        }
    }        
}

bool checkSlots()
{
    bool changed = false;
    int s1 = !slot1;
    int s2 = !slot2;
    int s3 = !slot3;
    if(lastSlot1 != s1 || lastSlot2 != s2 ||lastSlot3 != s3)
    {
        pc.printf("slot 1 %d\r\n",s1);
        pc.printf("slot 2 %d\r\n",s2);
        pc.printf("slot 3 %d\r\n",s3);
        changed = true;
    }
    lastSlot1 = s1;
    lastSlot2 = s2;
    lastSlot3 = s3;
    return changed;
}
#if PROXIMITYON == 1 
bool scanStrip(int id)
{
    bool stripChanged = false;
    ATT160826&  strip = *strips[id];
    att160826_data_t *data = &strip_data[id];
    bool ok = strip.scan(data);
     
    if(ok)
    {  
       // printf("%d\r\n",id);
        for (int i = 1; i < SENSORS_PER_STRIP;i++) { // ignore first sensor it is blocked
         
          /*  
            if (strip_data[id].sensor[i].present) {
                printf(" %3d", strip_data[id].sensor[i].sample.prox);
            } else {
                printf(" %3s", "---");
            }
            */
            if (strip_data[id].sensor[i].present) {
                
                if (abs(last_data[id].sensor[i].sample.prox - strip_data[id].sensor[i].sample.prox) > 50)
                {
                    stripChanged = true; 
                    last_data[id].sensor[i].sample.prox = strip_data[id].sensor[i].sample.prox;
                    last_data[id].sensor[i].sample.als_vis = strip_data[id].sensor[i].sample.als_vis;
                    last_data[id].sensor[i].sample.als_ir = strip_data[id].sensor[i].sample.als_ir;   
                }

            }
        }
        // printf("\r\n");
    }
    else
        printf("scan of strip %d failed",id);
    return stripChanged;
}
#endif

int main() {

    int i;

    HTS221 hts221;
    pc.baud(115200);
   
    void hts221_init(void);

    // Set LED to RED until init finishes
    SetLedColor(0x1);

    pc.printf(BLU "Hello World from AT&T Shape!\r\n\n\r");
    pc.printf(GRN "Initialize the HTS221\n\r");

    i = hts221.begin();  
    if( i ) 
        pc.printf(BLU "HTS221 Detected! (0x%02X)\n\r",i);
    else
        pc.printf(RED "HTS221 NOT DETECTED!!\n\r");

    printf("Temp  is: %0.2f F \n\r",CTOF(hts221.readTemperature()));
    printf("Humid is: %02d %%\n\r",hts221.readHumidity());


    // Initialize the modem
    printf(GRN "Modem initializing... will take up to 60 seconds" DEF "\r\n");
    if(!wnc.init()) 
    {
        pc.printf(RED "Modem initialization failed!" DEF "\n");
        system_reset();
    }
       
    
    iccid = wnc.getIccid();
    printf(GRN "ICCID = %s" DEF "\r\n",iccid);
    

           
    //Software init
    if(!wnc.startInternet())
        system_reset();
    
    char* ip = wnc.resolveDn(MY_SERVER_URL);
    if(strlen(ip) == 0)
    {
       printf(RED "Failed to resolve IP for %s" DEF "\r\n",MY_SERVER_URL); 
    }
    else
        printf(GRN "IP = %s" DEF "\r\n",ip);

    // Set LED BLUE for partial init
    SetLedColor(0x4);
 
    wnc.setPowerSave(true,wnc.gett3412Timer(),wnc.gett3324Timer());
 
#if PROXIMITYON == 1 
    bool stripChanged[2];
    myi2c = new I2C(PTE25, PTE24); 
    //myi2c = new I2C(PTC11, PTC10); 
    myi2c->frequency(100000);
    ATT160826 strip0 (myi2c, 0);
    ATT160826 strip1 (myi2c, 3);
    strips[0] = &strip0;
    strips[1] = &strip1;
    
#elif PROXIMITYON == 2

    myi2c = new I2C(PTE25, PTE24); 
    
    myi2c->frequency(100000);
    Proximity strip0;
    Proximity strip1;
    proximityStrip[0] = strip0;
    proximityStrip[1] = strip1;
    proximityStrip[0].init(myi2c, 0x70); 
    proximityStrip[1].init(myi2c, 0x73);
    proximityStrip[0].on(); 
    proximityStrip[1].on(); 
     
#endif

    int count = 5*120;
    // Send and receive data perpetually
    while(1) {
       
        wnc.checkPassthrough();
        //sprintf(SENSOR_DATA.Temperature, "%0.2f", CTOF(hts221.readTemperature()));
        //sprintf(SENSOR_DATA.Humidity, "%02d", hts221.readHumidity());
        // read_sensors(); //read available external sensors from a PMOD and the on-board motion sensor
        toggleLed = !toggleLed;
        if(toggleLed)
            SetLedColor(0x2); //green 
        else    
            SetLedColor(0); //off   

#if PROXIMITYON == 1            
    
     if(stripChanged[0] == false)
        stripChanged[0] = scanStrip(0);
     if(stripChanged[1] == false)
        stripChanged[1] = scanStrip(1); 
     
#elif PROXIMITYON == 2

    printf("scan %d\r\n",count);
    bool stripChanged = false;
    proximityStrip[0].scan();
    printf("scan0 done %d\r\n",count);
    proximityStrip[1].scan();
    printf("scan1 done %d\r\n",count);
    stripChanged |= proximityStrip[0].changed(50);
    printf("scan0 change %d\r\n",stripChanged);
    stripChanged |= proximityStrip[1].changed(50);
    printf("scan1 change %d\r\n",stripChanged);
    
#else
        bool slotsChanged = checkSlots();
#endif

     char modem_string[512];                
        
#if PROXIMITYON == 1 
           
        if(count >= 5*30)
        {
            stripChanged[0] = true;
            stripChanged[1] = true;
        }
    
        if(sw2 == 0)
        {
            stripChanged[0] = true;
            stripChanged[1] = true;
        }             
        if(stripChanged[0] || stripChanged[1])

        
#elif PROXIMITYON == 2
        if(count >= 5*60 || stripChanged )
#else
        if(count >= 5*60 || slotsChanged)
#endif
        {
            if(wnc.isPowerSaveOn())
            {
                wnc.wakeFromPowerSave();
                //wnc.ping("108.244.165.22");
            }
            count = 0;
            SetLedColor(0x04); //blue
                

            
#if PROXIMITYON == 1
        if(stripChanged[0])
        {
            GenerateModemString(&modem_string[0],PROXIMITY_ONLY,0);
            stripChanged[0] = false;
        }
        else if (stripChanged[1])
        {
            GenerateModemString(&modem_string[0],PROXIMITY_ONLY,3);
            stripChanged[1] = false;
        }
        else
            GenerateModemString(&modem_string[0],PROXIMITY_ONLY,-1);
#elif PROXIMITYON == 2
            GenerateModemString(&modem_string[0],PROXIMITY_ONLY,0);
#else
            GenerateModemString(&modem_string[0],SWITCH_ONLY,0);
#endif
  
            printf(BLU "Sending to modem : %s" DEF "\r\n", modem_string);

            //if(wnc.connect("108.244.165.22",5005)) // node-red
            
            
            if(wnc.connect(ip,MY_PORT)) // shelf
            //if(wnc.connect("52.33.231.251",80)) // car
            {
                if(wnc.writeSocket(modem_string))
                {
           
                    char* mydata;
                    int tries = 8;
                    while(tries > 0) // wait for reply
                    {
                        tries--;
                        mydata = wnc.readSocket();
                        if (strlen(mydata) > 0)
                            break;
                 
                        wait(0.5);
                    }
            
                    if (strlen(mydata) > 0)
                    {   
                                
                        SetLedColor(0x2); // green
                        //only copy on sucessful send

                        printf(BLU "Read back : [%s]" DEF "\r\n", mydata);
                        char datareply[512];
                        if (extract_reply(mydata, datareply))
                        {
                            printf(GRN "JSON : %s" DEF "\r\n", datareply);
                            parse_reply(datareply);
                        }
                        SetLedColor(0); // off             
                    }
                    else // no reply reset
                    {
                        SetLedColor(0x1); //red
                        system_reset();                 
                    } 
                }
                wnc.disconnect();
            }
            else // failed to connect reset
            {
                SetLedColor(0x1); //red
                system_reset(); 
            }
            if(wnc.isPowerSaveOn())
                wnc.resumePowerSave();   
        }
        count++;
        wait(0.2); 
    } //forever loop
}
