#ifndef Proximity_
#define Proximity_


#define PROXIMITYADDRESS  0x39
#define NUM_PROXIMIY_SENSORS 5

#define C25ma 0x00
#define C50ma 0x01
#define C100m1 0x02
#define C200ma 0x03
    
#define GainAls1Ir1 (0x00<<2)
#define GainAls2Ir1 (0x04<<2)
#define GainAls2Ir2 (0x05<<2)
#define GainAls64Ir64 (0x0A<<2)
#define GainAls128Ir64 (0x0D<<2)
#define GainAls128Ir128 (0x0F<<2)
    
#define Als0Ps0 0x00
#define Als0Ps10 0x01
#define Als0Ps40 0x02
#define Als0Ps100 0x03    
#define Als0Ps400 0x04
    
#define Als100Ps0 0x05
#define Als100Ps100 0x06
#define Als100Ps400 0x07
    
#define Als401Ps0 0x08
#define Als401Ps100 0x09
#define Als400Ps0 0x0A   
#define Als400Ps400 0x0B
    
#define Als50Ps50 0x0C


class Proximity {
private:
I2C *proximityi2c;
short proximityData [NUM_PROXIMIY_SENSORS][3];
short lastProximityData [NUM_PROXIMIY_SENSORS][3];
char dataStr[NUM_PROXIMIY_SENSORS*32];
char muxAddress;
public:
    Proximity(void);
    void init(I2C *i2c, char mAddress);
    void write_reg(char address,char reg, char cmd);
    void write(char address, char cmd);
    unsigned char read_reg(char address,char reg);
    void off();
    void on();
    void scan();
    bool changed(short delta);
    short getProximity(int sensor);
    short getAmbientLight(int sensor);
    short getIR(int sensor);
    char* getDataStr();
};

#endif