#include "mbed.h"
#include <cctype>
#include <string>
#include "SerialBuffered.h"
#include "HTS221.h"
#include "config_me.h"
#include "sensors.h"
#include "Proximity.h"
#include "Wnc.h"

#include "hardware.h"

extern SerialBuffered mdm;
Wnc wnc;

I2C i2c(PTC11, PTC10);    //SDA, SCL -- define the I2C pins being used

#define PROXIMITYON 1

#if PROXIMITYON == 1
Proximity proximityStrip;
#endif

// comment out the following line if color is not supported on the terminal
#define USE_COLOR
#ifdef USE_COLOR
 #define BLK "\033[30m"
 #define RED "\033[31m"
 #define GRN "\033[32m"
 #define YEL "\033[33m"
 #define BLU "\033[34m"
 #define MAG "\033[35m"
 #define CYN "\033[36m"
 #define WHT "\033[37m"
 #define DEF "\033[39m"
#else
 #define BLK
 #define RED
 #define GRN
 #define YEL
 #define BLU
 #define MAG
 #define CYN
 #define WHT
 #define DEF
#endif

#define MDM_DBG_OFF                             0
#define MDM_DBG_AT_CMDS                         (1 << 0)

#define MUXADDRESS 0x70
#define PROXIMITYADDRESS  0x39




int mdm_dbgmask = MDM_DBG_OFF;

Serial         pc(USBTX, USBRX);

DigitalOut led_green(LED_GREEN);
DigitalOut led_red(LED_RED);
DigitalOut led_blue(LED_BLUE);




DigitalIn   slot1(PTB3,PullUp);
DigitalIn   slot2(PTB10,PullUp);
DigitalIn   slot3(PTB11,PullUp);

int lastSlot1;
int lastSlot2;
int lastSlot3;
char *iccid;
#define TOUPPER(a) (a) //toupper(a)


#define MDM_OK                                  0
#define MDM_ERR_TIMEOUT                         -1

#define MAX_AT_RSP_LEN                          255

bool proximityChange = false;

bool toggleLed = false;
int seqNum;


//********************************************************************************************************************************************
//* Set the RGB LED's Color
//* LED Color 0=Off to 7=White.  3 bits represent BGR (bit0=Red, bit1=Green, bit2=Blue) 
//********************************************************************************************************************************************
void SetLedColor(unsigned char ucColor)
{
    if(wnc.isPowerSaveOn()) 
    {
        led_red = !0;
        led_green = !0;
        led_blue = !(ucColor & 0x4);
    }
    else
    {
        //Note that when an LED is on, you write a 0 to it:
        led_red = !(ucColor & 0x1); //bit 0
        led_green = !(ucColor & 0x2); //bit 1
        led_blue = !(ucColor & 0x4); //bit 2
    }
} //SetLedColor() 


void system_reset()
{
    printf(RED "\n\rSystem resetting..." DEF "\n");
    NVIC_SystemReset();
}

// These are built on the fly
string MyServerIpAddress;
string MySocketData;

// These are to be built on the fly
string my_temp;
string my_humidity;

#define CTOF(x)  ((x)*1.8+32)

//********************************************************************************************************************************************
//* Create string with sensor readings that can be sent to flow as an HTTP get
//********************************************************************************************************************************************
K64F_Sensors_t  SENSOR_DATA =
{
    .Temperature        = "0",
    .Humidity           = "0",
    .AccelX             = "0",
    .AccelY             = "0",
    .AccelZ             = "0",
    .MagnetometerX      = "0",
    .MagnetometerY      = "0",
    .MagnetometerZ      = "0",
    .AmbientLightVis    = "0",
    .AmbientLightIr     = "0",
    .UVindex            = "0",
    .Proximity          = "0",
    .Temperature_Si7020 = "0",
    .Humidity_Si7020    = "0"
};

void GenerateModemString(char * modem_string,int sensor)
{
    switch(sensor)
    {
#if PROXIMITYON == 1
        case PROXIMITY_ONLY:
        {

            char* data = proximityStrip.getDataStr();
            seqNum++;
            sprintf(modem_string, "GET %s%s?serial=%s&seq=%d&data=%s %s%s\r\n\r\n", FLOW_BASE_URL, "/shelf", iccid, seqNum, data,  FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
#endif
        case SWITCH_ONLY:
        {
            char data[32];
            sprintf(data,"[{\"p\":%d},{\"p\":%d},{\"p\":%d}]",lastSlot1*26,lastSlot2*26,lastSlot3*26);
            seqNum++;
            sprintf(modem_string, "GET %s%s?serial=%s&seq=%d&data=%s %s%s\r\n\r\n", FLOW_BASE_URL, "/car", iccid, seqNum, data,  FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
        case TEMP_HUMIDITY_ONLY:
        {
            sprintf(modem_string, "GET %s%s?serial=%s&temp=%s&humidity=%s %s%s\r\n\r\n", FLOW_BASE_URL, FLOW_INPUT_NAME, FLOW_DEVICE_NAME, SENSOR_DATA.Temperature, SENSOR_DATA.Humidity, FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
        case TEMP_HUMIDITY_ACCELEROMETER:
        {
            sprintf(modem_string, "GET %s%s?serial=%s&temp=%s&humidity=%s&accelX=%s&accelY=%s&accelZ=%s %s%s\r\n\r\n", FLOW_BASE_URL, FLOW_INPUT_NAME, FLOW_DEVICE_NAME, SENSOR_DATA.Temperature, SENSOR_DATA.Humidity, SENSOR_DATA.AccelX,SENSOR_DATA.AccelY,SENSOR_DATA.AccelZ, FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
        case TEMP_HUMIDITY_ACCELEROMETER_PMODSENSORS:
        {
            sprintf(modem_string, "GET %s%s?serial=%s&temp=%s&humidity=%s&accelX=%s&accelY=%s&accelZ=%s&proximity=%s&light_uv=%s&light_vis=%s&light_ir=%s %s%s\r\n\r\n", FLOW_BASE_URL, FLOW_INPUT_NAME, FLOW_DEVICE_NAME, SENSOR_DATA.Temperature, SENSOR_DATA.Humidity, SENSOR_DATA.AccelX,SENSOR_DATA.AccelY,SENSOR_DATA.AccelZ, SENSOR_DATA.Proximity, SENSOR_DATA.UVindex, SENSOR_DATA.AmbientLightVis, SENSOR_DATA.AmbientLightIr, FLOW_URL_TYPE, MY_SERVER_URL);
            break;
        }
        default:
        {
            sprintf(modem_string, "Invalid sensor selected\r\n\r\n");
            break;
        }
    } //switch(iSensorsToReport)
} //GenerateModemString        
            
            
//********************************************************************************************************************************************
//* Process JSON response messages
//********************************************************************************************************************************************
bool extract_reply(char* search_field, char* found_string)
{
    char* beginquote;
    char* endquote;
    beginquote = strstr(search_field, "\r\n\r\n"); //start of data
    endquote = strchr(search_field, '\0');
    if (beginquote != 0)
    {
        uint16_t ifoundlen;
        if (endquote != 0)
        {
            ifoundlen = (uint16_t) (endquote - beginquote) + 1;
            strncpy(found_string, beginquote, ifoundlen );
            found_string[ifoundlen] = 0; //null terminate
            return true;
        }
    }

    return false;

} //extract_reply


void parse_reply(char* reply)
{
    char *tokens[5];
    int index = 0;
    tokens[index++] = strtok(reply," ");  
    while( index < 5 ) 
    {    
      char* token = strtok(NULL, " ");
      if(token == NULL) break;
      tokens[index++] = token;
    }
    if(strcmp("PSM",tokens[1]) == 0)
    {

        int t3412 = atoi(tokens[3]);
        int t3324 = atoi(tokens[4]);
        pc.printf("t3412 %d t3324 %d\r\n",t3412,t3324);
        // setTauTimer(t3412);
        //setActivityTimer(t3324);
        
        if(strcmp("true",tokens[2]) == 0)
        {
            pc.printf("PSM ON\r\n");
            wnc.setPowerSave(true,t3412,t3324);
        }
        else
        {
            pc.printf("PSM OFF\r\n");
            wnc.setPowerSave(false,t3412,t3324);
        }
    }        
}

bool checkSlots()
{
    bool changed = false;
    int s1 = !slot1;
    int s2 = !slot2;
    int s3 = !slot3;
    if(lastSlot1 != s1 || lastSlot2 != s2 ||lastSlot3 != s3)
    {
        pc.printf("slot 1 %d\r\n",s1);
        pc.printf("slot 2 %d\r\n",s2);
        pc.printf("slot 3 %d\r\n",s3);
        changed = true;
    }
    lastSlot1 = s1;
    lastSlot2 = s2;
    lastSlot3 = s3;
    return changed;
}

int main() {

    int i;

    HTS221 hts221;
    pc.baud(115200);
   
    void hts221_init(void);

    // Set LED to RED until init finishes
    SetLedColor(0x1);

    pc.printf(BLU "Hello World from AT&T Shape!\r\n\n\r");
    pc.printf(GRN "Initialize the HTS221\n\r");

    i = hts221.begin();  
    if( i ) 
        pc.printf(BLU "HTS221 Detected! (0x%02X)\n\r",i);
    else
        pc.printf(RED "HTS221 NOT DETECTED!!\n\r");

    printf("Temp  is: %0.2f F \n\r",CTOF(hts221.readTemperature()));
    printf("Humid is: %02d %%\n\r",hts221.readHumidity());


    // Initialize the modem
    printf(GRN "Modem initializing... will take up to 60 seconds" DEF "\r\n");
    do {
        i=wnc.init();
        if (!i) {
            pc.printf(RED "Modem initialization failed!" DEF "\n");
        }
    } while (!i);
    
   // wnc.setIn();
    wnc.send("AT+CPSMS=0",WNC_WAIT_TIME_MS);

    wnc.toggleWake();   
        
    
    iccid = wnc.getIccid();
    printf(GRN "ICCID = %s" DEF "\r\n",iccid);
           
    //Software init
    wnc.startInternet();
    //wnc.ping("108.244.165.22");

    // Set LED BLUE for partial init
    SetLedColor(0x4);
    
    wnc.setPowerSave(false,12*60*60,20);
 
#if PROXIMITYON == 1  
    proximityStrip.init();  
    proximityStrip.on();        
#endif

    int count = 0;
    // Send and receive data perpetually
    while(1) {
       
        wnc.checkPassthrough();
        //sprintf(SENSOR_DATA.Temperature, "%0.2f", CTOF(hts221.readTemperature()));
        //sprintf(SENSOR_DATA.Humidity, "%02d", hts221.readHumidity());
        // read_sensors(); //read available external sensors from a PMOD and the on-board motion sensor
        toggleLed = !toggleLed;
        if(toggleLed)
            SetLedColor(0x2); //green 
        else    
            SetLedColor(0); //off   

#if PROXIMITYON == 1            
        proximityStrip.scan();
#else
        bool slotsChanged = checkSlots();
#endif
                
        
#if PROXIMITYON == 1            
        if(count >= 5*60 || proximityStrip.changed(50))
#else
        if(count >= 5*60 || slotsChanged)
#endif
        {
            if(wnc.isPowerSaveOn())
            {
                wnc.wakeFromPowerSave();
                //wnc.ping("108.244.165.22");
            }
            count = 0;
            SetLedColor(0x04); //blue
                
            char modem_string[512];
            
#if PROXIMITYON == 1
            GenerateModemString(&modem_string[0],PROXIMITY_ONLY);
#else
            GenerateModemString(&modem_string[0],SWITCH_ONLY);
#endif
  
            printf(BLU "Sending to modem : %s" DEF "\r\n", modem_string);

            if(wnc.connect("108.244.165.22",5005))
            {
                char * reply = wnc.writeSocket(modem_string);
           
                char* mydata;
                int tries = 4;
                while(tries > 0) // wait for reply
                {
                    tries--;
                    mydata = wnc.readSocket();
                    if (strlen(mydata) > 0)
                        break;
                 
                    wait(0.2);
                }
            
                if (strlen(mydata) > 0)
                {   
                                
                    SetLedColor(0x2); // green
                    //only copy on sucessful send

                    printf(BLU "Read back : %s" DEF "\r\n", mydata);
                    char datareply[512];
                    if (extract_reply(mydata, datareply))
                    {
                        printf(GRN "JSON : %s" DEF "\r\n", datareply);
                        parse_reply(datareply);
                    }
                    SetLedColor(0); // off             
                }
                else // no reply reset
                {
                    SetLedColor(0x1); //red
                    system_reset();                 
                } 
                wnc.disconnect();
            }
            else // failed to connect reset
            {
                SetLedColor(0x1); //red
                system_reset(); 
            }
            if(wnc.isPowerSaveOn())
                wnc.resumePowerSave();   
        }
        count++;
        wait(0.2); 
    } //forever loop
}
