#include "mbed.h"
#include "Proximity.h"

I2C *proximityi2c;
short proximityData [NUM_PROXIMIY_SENSORS][3];
short lastProximityData [NUM_PROXIMIY_SENSORS][3];
char dataStr[NUM_PROXIMIY_SENSORS*32];

Proximity::Proximity(void)
{


}

void Proximity::init(void)
{
    proximityi2c = new I2C(PTE25, PTE24);
    proximityi2c->frequency(400000);
}

void Proximity::write_reg(char address,char reg, char cmd)
{
    char txbuffer [2];
    txbuffer[0] = reg;
    txbuffer[1] = cmd;

    proximityi2c->write(address<<1, txbuffer, 2,false );

} 

void Proximity::write(char address, char cmd)
{
    char txbuffer [1];
    txbuffer[0] = cmd;

    proximityi2c->write(address<<1, txbuffer, 1,false );

}  

unsigned char Proximity::read_reg(char address,char reg)
{
    char txbuffer [1];
    char rxbuffer [1];
    rxbuffer[0] = 0;
    txbuffer[0] = reg;
    proximityi2c->write(address<<1, txbuffer, 1,false );
    proximityi2c->read(address<<1, rxbuffer, 1 );
    return (unsigned char)rxbuffer[0];
}
void Proximity::off()
{
    for(int sensor = 0;sensor<NUM_PROXIMIY_SENSORS;sensor++)
    {
        write(MUXADDRESS,1<<sensor); 
        write_reg(PROXIMITYADDRESS,0x41,0x00);
    }
}

void Proximity::on()
{  
    for(int sensor = 0;sensor<NUM_PROXIMIY_SENSORS;sensor++)
    {

        lastProximityData[sensor][0] = 1000;
        write(MUXADDRESS,1<<sensor); 
        write_reg(PROXIMITYADDRESS,0x41,Als400Ps400); // initiate ALS: and PS
        write_reg(PROXIMITYADDRESS,0x42,GainAls64Ir64|C25ma); // set ALS_VIS=ALS_IR GAIN = 64 current 25ma
    }
    wait(0.5);
}
       
void Proximity::scan()
{  
    for(int sensor = 0;sensor<NUM_PROXIMIY_SENSORS;sensor++)
    {
        write(MUXADDRESS,1<<sensor);
        //proximity_sensor_on(sensor);
        unsigned char prox_lsb = read_reg(PROXIMITYADDRESS,0x44);
        unsigned char prox_msb = read_reg(PROXIMITYADDRESS,0x45);
        unsigned char ALS_lsb = read_reg(PROXIMITYADDRESS,0x46);
        unsigned char ALS_msb = read_reg(PROXIMITYADDRESS,0x47);
        unsigned char IR_lsb = read_reg(PROXIMITYADDRESS,0x48);
        unsigned char IR_msb = read_reg(PROXIMITYADDRESS,0x49);
    
        short proximity = prox_msb*256+prox_lsb;
        short ALS = ALS_msb*256+ALS_lsb;
        short IR = IR_msb*256+IR_lsb;
        proximityData[sensor][0] = proximity;
        proximityData[sensor][1] = ALS;
        proximityData[sensor][2] = IR;
        //proximity_sensor_off(sensor);
        //pc.printf(GRN "Sensor %d = %d, %d, %d\n\r",sensor,proximity,ALS,IR);
    }

}

bool Proximity::changed(short delta)
{
    for(int sensor = 0;sensor<NUM_PROXIMIY_SENSORS;sensor++)
    {
        if(abs(proximityData[sensor][0] - lastProximityData[sensor][0]) > delta)
        {
            return true;
        }
    }

    return false;
}   

short Proximity::getProximity(int sensor)
{
    return proximityData[sensor][0];
}
short Proximity::getAmbientLight(int sensor)
{
    return proximityData[sensor][1];
}
short Proximity::getIR(int sensor)
{
    return proximityData[sensor][2];
}

char* Proximity::getDataStr()
{
    int i=0;
    int index = 0;
    index += sprintf(&dataStr[index],"[");
    for (i=0; i<NUM_PROXIMIY_SENSORS; i++)
    {
        if(i<NUM_PROXIMIY_SENSORS-1)
            index += snprintf(&dataStr[index], 128, "{\"s\":%d,\"p\":%d,\"l\":%d,\"r\":%d},", i,proximityData[i][0],proximityData[i][1],proximityData[i][2]);
        else
            index += snprintf(&dataStr[index], 128, "{\"s\":%d,\"p\":%d,\"l\":%d,\"r\":%d}]", i,proximityData[i][0],proximityData[i][1],proximityData[i][2]);
        lastProximityData[i][0] = proximityData[i][0];
        lastProximityData[i][1] = proximityData[i][1];
        lastProximityData[i][2] = proximityData[i][2];
    } 
    return dataStr;
}
    
    


