
#ifndef Wnc_
#define Wnc_

#define WNC_WAIT_TIME_MS 500


extern void SetLedColor(unsigned char ucColor);


class Wnc {
public:
    Wnc(void);
    int init(void);
    bool isModemResponding();

    char* read(int timeout_ms);
    char* send(const char *cmd, int timeout_ms);
    
    
    void setPowerSave(bool on,int t3412,int t3324);
    void resumePowerSave();
    bool isPowerSaveOn();
    void wakeFromPowerSave();
    
    char* getIccid();
    void startInternet();
    bool connect(char* ip, int port);
    void disconnect();
    char* writeSocket(const char * s);
    char* readSocket();
    char* ping(char* ip);
    void setIn();
    void passthrough();
    void checkPassthrough();
    void toggleWake();
    
private:
    int secToTau(int time);
    int secToActivity(int time);
    int hex_to_int(char c);
    int hex_to_ascii(char h, char l);
    int indexOf(char* str, char c);
    char* encode(int value, char* result, int base);
};

#endif