#include "mbed.h"
//the library "TextLCD.h" was slightly altered to work with the GDM2004D LCD
#include "TextLCD.h"

//the object "lcd" is initialized to act as a TextLCD with 20x4 characters
TextLCD lcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4);

int main() {
    //each line of the LCD can be accessed directly using the .locate(column, line) function
    lcd.locate(0,0);
    lcd.printf("12345678901234567890");
    lcd.locate(0,1);
    lcd.printf("UVWXYZabcdefghijklmn");    
    lcd.locate(0,2);    
    lcd.printf("ABCDEFGHIJKLMNOPQRST");
    lcd.locate(0,3);
    lcd.printf("12345678901234567890");    
    wait(2);
    
    //the LCD is cleared using function .cls()
    lcd.cls();
    //a "\n" in a text string causes a line feed
    lcd.printf("HELLO WORLD\n");
    //if the end of a line is reached, the text is written to the next line automatically
    lcd.printf("Testbed for mbed\nLCD example softwarewith altered library");
    
    //the endless loop keeps mbed in low power mode
    while(1)
    {
    __WFI();
    }
}
