#include <mbed.h>

#ifndef TFT_h
#define TFT_h

void            CtrlOutput      (void);
void            PinOutput       (void);
void            PinInput        (void);
void            PinLow          (void);
void            PinHigh         (void);
void            PushData        (unsigned char data);
unsigned char   GetData         (void);
void            SendCommand     (unsigned char command);
void            SendData        (unsigned int data);
unsigned int    ReadRegister    (unsigned int reg);
void            Init            (void);
void            SetPixel        (unsigned int posX, unsigned int posY, unsigned int color);
void            SetXY           (unsigned int posX, unsigned int posY);
void            SetOrientation  (unsigned char layout);
void            SetDirection    (unsigned char dir);
void            ClearScreen     (unsigned int color);

extern unsigned char DispDir;

/* TFT HW DEFINITIONS */
#define TFTRESX     240
#define TFTRESY     320
#define LEFT2RIGHT  0
#define DOWN2UP     1
#define RIGHT2LEFT  2
#define UP2DOWN     3

/* COLOR DEFINITIONS */
#define RED         0xf800
#define GREEN       0x7e00
#define BLUE        0x001f
#define BLACK       0x0000
#define YELLOW      0xffe0
#define WHITE       0xffff
#define CYAN        0x07ff    
#define BRIGHT_RED  0xf810    
#define GRAY1       0x8410  
#define GRAY2       0x4208  


#endif

