/*###########################################################
  Interface library and example program for 
  Seeed Studio's TFT Touch Shield
  
  ---
  
  !DESOLDERING OF TESTBED PARTS NEEDED!
  To use the touch input, desolder C3 and R34
  This disables the analogue trimmer R36!
  
  ---
  (C) 2012 Stefan Guenther
  Elektronikladen | ELMICRO
  ########################################################### */

#include "mbed.h"
#include "shortcuts.h"
#include "TFT.h"
#include "2d_draw.h"
#include "touch.h"


/* ===================================================================
    routine:    IntToChars
    purpose:    Converts integer value into char array with 
                selectable number base                
    parameters: <*buffer>       pointer to character array
                <value>         integer value to convert
                <spaceonbuffer> max nr. of characters in buffer
                <countbase>     e.g. 16->HEX formatted string
                                      2->BIN formatted string
                                     10->DEC formatted string
    date:       2007-05-07
    author:     Phantomix
                http://www.roboternetz.de/community/archive/index.php
                /t-26986.html?s=c3edf0ef1df246f02c67dfa7f316a03f        
  -------------------------------------------------------------------*/
void IntToChars (char* buffer, int value, int spaceonbuffer, int countbase)
{
    int workvalue = value;
    int i;
    int valuetowrite;
    int  end_i = 0;

    if (value < 0)
    {
        workvalue = -value;
        end_i = 1;
        buffer[0] = '-';
    }

    for (i = spaceonbuffer - 1; i >= end_i; i--)
    {
        valuetowrite = (workvalue % countbase);
        if (workvalue == 0)
        {
            if (i == (spaceonbuffer - 1))
            {
                buffer[i] = 48;                        // ASCII 0
            } else {
                buffer[i] = 32;                        // ASCII SPACE
            }
        } else {
            if (valuetowrite > 9)
            {
                buffer[i] = valuetowrite + 55;        // ASCII A-Z
            } else {
                buffer[i] = valuetowrite + 48;        // ASCII of that character
            }
        };
        workvalue = (workvalue - valuetowrite) / countbase;
    }
}



int main() {

    unsigned int x, y, z;
    unsigned int X1, X2, Y1, Y2;
    unsigned int x_old = 0;
    unsigned int y_old = 0;
    
    char charX[] = "1111";        //dummy init values
    char charY[] = "2222";
    char charZ[] = "2222";    

    Init();                     //prepare mbed's I/Os for use with TFT Touch Shield
    TouchInit();                //prepare ADC inputs for touch input
    
    
    /* CALIBRATE TOUCH SCREEN */
    /* Alignment of touch input sensor with TFT display 
       using 2 touch inputs from opposite edges of screen
       (10% distance to each borders)*/
    
    DrawString("CALIBRATION SEQUENCE", 30, 140, 1, YELLOW);
    DrawString("Please tap the circles!", 10, 150, 1, YELLOW);   
    DrawCircle(24, 32, 10, WHITE);                  //draw circle 10% right and 10% down from
                                                    //upper left corner    
    int ret = 0;    
    do                                              //repeat until touch is recognized
    {
        ret = GetRawTouch(&x, &y, &z);        
    }   while(ret == 0);    
        
    IntToChars(charX, x, 4, 10);                    //convert raw touch input coordinates
    IntToChars(charY, y, 4, 10);                    //into character string for verbose
    IntToChars(charZ, z, 4, 10);                    //display

    DrawCircle(24, 32, 10, BLACK);                  //let first circle disappear
    X1 = x;                                         //save coordinates of first touch
    Y1 = y;
    wait(1);                                    
                        
    DrawString(charX, 10, 17, 1, RED);              //output read values
    DrawString(charY, 10, 32, 1, RED);
    DrawString(charZ, 10, 47, 1, RED);          
    
    DrawCircle(216, 288, 10, WHITE);                //display next circle, 90% right and 90% down
                                                    //from upper left corner
    ret=0;
    do                                              //do the same for second touch point
    {
        ret=GetRawTouch(&x, &y, &z);
    }   while(ret == 0);    
    
            
    IntToChars(charX, x, 4, 10);
    IntToChars(charY, y, 4, 10);            
    IntToChars(charZ, z, 4, 10);                                    

    DrawCircle(216, 288, 10, BLACK); 
    X2 = x;
    Y2 = y;
    wait(1);
    
    DrawString(charX, 200,273, 1, RED);
    DrawString(charY, 200,288, 1, RED);
    DrawString(charZ, 200,303, 1, RED);                
    
    TFTData.Xmin = (9 * X1 - X2) / 8;                       //start calculation of scale and alignment values
    TFTData.Xmax = (9 * X2 - X1) / 8;                       //and save them into TFT parameter structure
    TFTData.Ymin = (9 * Y1 - Y2) / 8;                       //this structure should be saved into non-volatile
    TFTData.Ymax = (9 * Y2 - Y1) / 8;                       //(e.g. mbed's on-board 2MB flash chip)
    
    TFTData.Xscale = ( (TFTData.Xmax - TFTData.Xmin) * 1000 ) / TFTData.XRes;
    TFTData.Xscale = ( (TFTData.Ymax - TFTData.Ymin) * 1000 ) / TFTData.YRes;    
    
    DrawString("Please tap the circles!", 10, 150, 1, BLACK);
    DrawString("COMPLETED", 30, 150, 1, YELLOW);    
    wait(1);
    
    ClearScreen(BLACK);
    wait(0.3);
    
    DrawString("DEMO MODE", 30, 140, 1, YELLOW);
    DrawString("Touch the screen...", 10, 150, 1, YELLOW);    
    
    
    while(1) 
    {
    wait_ms(1);                
        
        if(GetPoint(&x, &y)==1)                     //check if touch appears
        {        
            DrawCircle(x_old, y_old, 15, BLACK);    //clear last touch indicator circle
            DrawString("DEMO MODE", 30, 140, 1, YELLOW);
            DrawString("Touch the screen...", 10, 150, 1, YELLOW);
            DrawCircle(x, y, 15, YELLOW);           //set new indicator circle
            
            x_old=x;                                //rescue current touch values for next cycle
            y_old=y;            
        } 
    }
}


