#include "mbed.h"
#include "fm25w256.h"

Serial pc(USBTX, USBRX);

int main() 
{
    unsigned char cRX[16];
    unsigned char cTX[16];
    int x;
    
    for(x=0; x<16; x++) cRX[x]=0;
    for(x=0; x<16; x++) cTX[x]=0;
    
    FM25W_SSP1_Init();
  
    pc.printf("\nOut of reset, memory contained:\n");
    FM25W_ReadBlock(0,cRX,16);                          //read 16 bytes
    for(x=0; x<16; x++) pc.printf("%02X ", cRX[x]);     //display them
    
    FM25W_WriteBlock(0, cTX, 16);                       //clear memory addresses
    
    for(x=0; x<16; x++) cTX[x]=x;                       //prepare sample bytes
    
    pc.printf("\nMemory 'before' contains:\n");
    FM25W_ReadBlock(0,cRX,16);                          //read 16 bytes
    for(x=0; x<16; x++) pc.printf("%02X ", cRX[x]);     //display them
    
    pc.printf("\nWriting data to memory...");
    FM25W_WriteBlock(0,cTX,16);                         //write 16 bytes
    
    for(x=0; x<16; x++) cRX[x]=0;                       //clear RX buffer
    
    pc.printf("\nReading data from memory...");
    FM25W_ReadBlock(0,cRX,16);                          //read 16 bytes
    
    pc.printf("\nMemory 'after' contains:\n");
    for(x=0; x<16; x++) pc.printf("%02X ", cRX[x]);     //display bytes
    

    while(1) 
    {

    }
}
