#include "mbed.h"

//Shortcuts
#define SSL1        LPC_GPIO0->FIOSET = BIT6
#define SSL0        LPC_GPIO0->FIOCLR = BIT6

// Aliases for code readability
#define BIT31       0x80000000
#define BIT30       0x40000000
#define BIT29       0x20000000
#define BIT28       0x10000000
#define BIT27       0x08000000
#define BIT26       0x04000000
#define BIT25       0x02000000
#define BIT24       0x01000000
#define BIT23       0x00800000
#define BIT22       0x00400000
#define BIT21       0x00200000
#define BIT20       0x00100000
#define BIT19       0x00080000
#define BIT18       0x00040000
#define BIT17       0x00020000
#define BIT16       0x00010000
#define BIT15       0x00008000
#define BIT14       0x00004000
#define BIT13       0x00002000
#define BIT12       0x00001000
#define BIT11       0x00000800
#define BIT10       0x00000400
#define BIT9        0x00000200
#define BIT8        0x00000100
#define BIT7        0x00000080
#define BIT6        0x00000040
#define BIT5        0x00000020
#define BIT4        0x00000010
#define BIT3        0x00000008
#define BIT2        0x00000004
#define BIT1        0x00000002
#define BIT0        0x00000001

// FeRAM command defines
#define WREN        0x06    // Write enable
#define WRITE       0x02    // Write command
#define READ        0x03    // Read command
#define RDSR        0x05    // Read Status Register


void            FM25W_SSP1_Init (void);
unsigned char   FM25W_ReadByte  (unsigned int iAddress);
void            FM25W_WriteByte (unsigned int iAddress, unsigned char cByte);
void            FM25W_WriteBlock(unsigned int iAddress, unsigned char *ptrBlock, unsigned int iCount);
void            FM25W_ReadBlock (unsigned int iAddress, unsigned char *ptrBlock, unsigned int iCount);
